/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.encryption.Serializer;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSerializer
implements Serializer {
    protected Canonicalizer canon;

    public void setCanonicalizer(Canonicalizer canon) {
        this.canon = canon;
    }

    public String serialize(Element element) throws Exception {
        return this.canonSerialize(element);
    }

    public String serialize(NodeList content) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.canon.setWriter(baos);
        this.canon.notReset();
        for (int i = 0; i < content.getLength(); ++i) {
            this.canon.canonicalizeSubtree(content.item(i));
        }
        String ret = baos.toString("UTF-8");
        baos.reset();
        return ret;
    }

    public String canonSerialize(Node node) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.canon.setWriter(baos);
        this.canon.notReset();
        this.canon.canonicalizeSubtree(node);
        String ret = baos.toString("UTF-8");
        baos.reset();
        return ret;
    }

    public abstract Node deserialize(String var1, Node var2) throws XMLEncryptionException;

    protected static String createContext(String source, Node ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><dummy");
        HashMap<String, String> storedNamespaces = new HashMap<String, String>();
        for (Node wk = ctx; wk != null; wk = wk.getParentNode()) {
            NamedNodeMap atts = wk.getAttributes();
            if (atts == null) continue;
            for (int i = 0; i < atts.getLength(); ++i) {
                Node att = atts.item(i);
                String nodeName = att.getNodeName();
                if (!nodeName.equals("xmlns") && !nodeName.startsWith("xmlns:") || storedNamespaces.containsKey(att.getNodeName())) continue;
                sb.append(" " + nodeName + "=\"" + att.getNodeValue() + "\"");
                storedNamespaces.put(nodeName, att.getNodeValue());
            }
        }
        sb.append(">" + source + "</dummy>");
        return sb.toString();
    }
}

