/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.optionalcontent;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.rendering.RenderDestination;

public class PDOptionalContentGroup
extends PDPropertyList {
    public PDOptionalContentGroup(String name) {
        this.dict.setItem(COSName.TYPE, (COSBase)COSName.OCG);
        this.setName(name);
    }

    public PDOptionalContentGroup(COSDictionary dict) {
        super(dict);
        COSBase cb = dict.getDictionaryObject(COSName.TYPE);
        if (cb != null && !cb.equals(COSName.OCG)) {
            throw new IllegalArgumentException("Provided dictionary is not of type '" + COSName.OCG + "'");
        }
    }

    public String getName() {
        return this.dict.getString(COSName.NAME);
    }

    public final void setName(String name) {
        this.dict.setString(COSName.NAME, name);
    }

    public RenderState getRenderState(RenderDestination destination) {
        COSName state = null;
        COSDictionary usage = this.dict.getCOSDictionary(COSName.USAGE);
        if (usage != null) {
            if (RenderDestination.PRINT == destination) {
                COSDictionary print = usage.getCOSDictionary(COSName.PRINT);
                state = print == null ? null : print.getCOSName(COSName.PRINT_STATE);
            } else if (RenderDestination.VIEW == destination) {
                COSDictionary view = usage.getCOSDictionary(COSName.VIEW);
                COSName cOSName = state = view == null ? null : view.getCOSName(COSName.VIEW_STATE);
            }
            if (state == null) {
                COSDictionary export = usage.getCOSDictionary(COSName.EXPORT);
                state = export == null ? null : export.getCOSName(COSName.EXPORT_STATE);
            }
        }
        return state == null ? null : RenderState.valueOf(state);
    }

    public String toString() {
        return super.toString() + " (" + this.getName() + ")";
    }

    public static enum RenderState {
        ON(COSName.ON),
        OFF(COSName.OFF);

        private final COSName name;

        private RenderState(COSName value) {
            this.name = value;
        }

        public static RenderState valueOf(COSName state) {
            if (state == null) {
                return null;
            }
            return RenderState.valueOf(state.getName().toUpperCase());
        }

        public COSName getName() {
            return this.name;
        }
    }
}

