/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.spatial.util.DBFReaderJGeom;
import oracle.spatial.util.ShapefileFeatureJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;

public class SampleShapefileToJGeomFeature {
    private static String m_host;
    private static String m_port;
    private static String m_sid;
    private static String m_user;
    private static String m_password;
    private static String m_tableName;
    private static String m_shapefileName;
    private static String m_idName;
    private static int m_srid;
    private static String m_geom;
    private static String min_x;
    private static String min_y;
    private static String max_x;
    private static String max_y;
    private static String m_tolerance;
    private static String mg_tolerance;
    private static int m_start_id;
    private static int m_commit_interval;
    private static int m_println_interval;
    private static String dimArray;
    private static String dimArrayMig;
    private static boolean defaultX;
    private static boolean defaultY;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string = "The following key/value is missing: ";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        if (stringArray.length <= 1) {
            System.err.println("USAGE: java -cp [ORACLE_HOME]/jdbc/lib/ojdbc14.jar;./sdoutl.jar;./sdoapi.jar SampleShapefileToJGeomFeature -h db_host -p db_port -s db_sid -u db_username -d db_password -t db_table -f shapefile_name [-i table_id_column_name][-r srid][-g db_geometry_column][-x max_x,min_x][-y max_y,min_y][-o tolerance]");
            System.out.println("Usage explanation (parameters used):");
            System.out.println("<-h>: Host machine with existing Oracle database");
            System.out.println("<-p>: Host machine's port with existing Oracle database (e.g. 1521)");
            System.out.println("<-s>: Host machine's SID with existing Oracle database");
            System.out.println("<-u>: Database user");
            System.out.println("<-d>: Database user's password");
            System.out.println("<-t>: Table name for the result");
            System.out.println("<-f>: File name of an input Shapefile (without extension)");
            System.out.println("[-i]: Column name for unique numeric ID; if required");
            System.out.println("[-r]: Valid Oracle SRID for coordinate system; use 0 if unknown");
            System.out.println("[-g]: Preferred or valid SDO_GEOMETRY column name");
            System.out.println("[-x]: Bounds for the X dimension; use -180,180 if unknown");
            System.out.println("[-y]: Bounds for the Y dimension; use -90,90 if unknown");
            System.out.println("[-o]: Load tolerance fields (x and y) in metadata, if not specified, tolerance fields are 0.05");
            System.out.println("[-a]: Append shapefile data to an existing table");
            System.out.println("[-n]: Start ID for column specified in -i parameter");
            System.out.println("[-c]: Commit interval. Default, commits every 1000 conversions and at the end of a run");
            System.out.println("[-v]: Println interval. Default, displays every 10 conversions.");
            System.exit(1);
        } else {
            for (int i = 0; stringArray.length > i; ++i) {
                vector.add(i, stringArray[i]);
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                try {
                    String string2 = (String)object.nextElement();
                    if (string2.equals("-a")) {
                        bl = true;
                        continue;
                    }
                    String string3 = (String)object.nextElement();
                    if (string2 == null || string3 == null) continue;
                    hashMap.put(string2, string3);
                }
                catch (Exception exception) {
                    System.out.println("One of your key-value pairs failed.  Please try again");
                    System.exit(1);
                }
            }
        }
        if (hashMap.containsKey("-h")) {
            System.out.println("host: " + (String)hashMap.get("-h"));
            m_host = (String)hashMap.get("-h");
        } else {
            System.out.println(string + "-h db_host");
            System.exit(1);
        }
        if (hashMap.containsKey("-p")) {
            System.out.println("port: " + (String)hashMap.get("-p"));
            m_port = (String)hashMap.get("-p");
        } else {
            System.out.println(string + "-p db_port");
            System.exit(1);
        }
        if (hashMap.containsKey("-s")) {
            System.out.println("sid: " + (String)hashMap.get("-s"));
            m_sid = (String)hashMap.get("-s");
        } else {
            System.out.println(string + "-s db_sid");
            System.exit(1);
        }
        if (hashMap.containsKey("-u")) {
            System.out.println("db_username: " + (String)hashMap.get("-u"));
            m_user = (String)hashMap.get("-u");
        } else {
            System.out.println(string + "-u db_username");
            System.exit(1);
        }
        if (hashMap.containsKey("-d")) {
            System.out.println("db_password: " + (String)hashMap.get("-d"));
            m_password = (String)hashMap.get("-d");
        } else {
            System.out.println(string + "-d password");
            System.exit(1);
        }
        if (hashMap.containsKey("-t")) {
            System.out.println("db_tablename: " + (String)hashMap.get("-t"));
            m_tableName = (String)hashMap.get("-t");
        } else {
            System.out.println(string + "-t tablename");
            System.exit(1);
        }
        if (hashMap.containsKey("-f")) {
            System.out.println("shapefile_name: " + (String)hashMap.get("-f"));
            m_shapefileName = (String)hashMap.get("-f");
        } else {
            System.out.println(string + "-f shapefile_name");
            System.exit(1);
        }
        if (hashMap.containsKey("-i")) {
            System.out.println("table_id_column_name: " + (String)hashMap.get("-i"));
            m_idName = (String)hashMap.get("-i");
        }
        if (hashMap.containsKey("-r")) {
            System.out.println("SRID: " + (String)hashMap.get("-r"));
            m_srid = Integer.parseInt((String)hashMap.get("-r"));
        }
        if (hashMap.containsKey("-g")) {
            System.out.println("db_geometry_column: " + (String)hashMap.get("-g"));
            m_geom = (String)hashMap.get("-g");
        }
        if (hashMap.containsKey("-x")) {
            System.out.println("X: " + (String)hashMap.get("-x"));
            object = new StringTokenizer((String)hashMap.get("-x"), ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                min_x = ((StringTokenizer)object).nextToken();
                max_x = ((StringTokenizer)object).nextToken();
                defaultX = false;
            }
        }
        if (hashMap.containsKey("-y")) {
            System.out.println("Y: " + (String)hashMap.get("-y"));
            object = new StringTokenizer((String)hashMap.get("-y"), ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                min_y = ((StringTokenizer)object).nextToken();
                max_y = ((StringTokenizer)object).nextToken();
                defaultY = false;
            }
        }
        if (hashMap.containsKey("-o")) {
            System.out.println("tolerance: " + (String)hashMap.get("-o"));
            m_tolerance = (String)hashMap.get("-o");
        }
        if (hashMap.containsKey("-n")) {
            System.out.println("start_id: " + (String)hashMap.get("-n"));
            m_start_id = Integer.parseInt((String)hashMap.get("-n"));
        }
        if (hashMap.containsKey("-c")) {
            System.out.println("commit_interval: " + (String)hashMap.get("-c"));
            m_commit_interval = Integer.parseInt((String)hashMap.get("-c"));
        }
        if (hashMap.containsKey("-v")) {
            System.out.println("println_interval: " + (String)hashMap.get("-v"));
            m_println_interval = Integer.parseInt((String)hashMap.get("-v"));
        }
        System.out.println("Connecting to Oracle10g using...");
        System.out.println(m_host + ", " + m_port + ", " + m_sid + ", " + m_user + ", " + m_password + ", " + m_tableName + ", " + m_shapefileName + ", " + m_idName + ", " + m_srid);
        object = "jdbc:oracle:thin:@ " + m_host + ":" + m_port + ":" + m_sid;
        OracleConnection oracleConnection = null;
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            oracleConnection = (OracleConnection)DriverManager.getConnection((String)object, m_user, m_password);
            oracleConnection.setAutoCommit(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DBFReaderJGeom dBFReaderJGeom = new DBFReaderJGeom(m_shapefileName);
        ShapefileReaderJGeom shapefileReaderJGeom = new ShapefileReaderJGeom(m_shapefileName);
        ShapefileFeatureJGeom shapefileFeatureJGeom = new ShapefileFeatureJGeom();
        int n = shapefileReaderJGeom.getShpFileType();
        double d = shapefileReaderJGeom.getMinMeasure();
        double d2 = shapefileReaderJGeom.getMaxMeasure();
        if (d2 <= -1.0E39) {
            d2 = Double.NaN;
        }
        double d3 = shapefileReaderJGeom.getMinZ();
        double d4 = shapefileReaderJGeom.getMaxZ();
        if (defaultX) {
            if (!ShapefileFeatureJGeom.isGeodetic(oracleConnection, m_srid)) {
                min_x = String.valueOf(shapefileReaderJGeom.getMinX());
                max_x = String.valueOf(shapefileReaderJGeom.getMaxX());
            }
        }
        if (defaultY) {
            if (!ShapefileFeatureJGeom.isGeodetic(oracleConnection, m_srid)) {
                min_y = String.valueOf(shapefileReaderJGeom.getMinY());
                max_y = String.valueOf(shapefileReaderJGeom.getMaxY());
            }
        }
        int n2 = ShapefileReaderJGeom.getShpDims(n, d2);
        dimArray = ShapefileFeatureJGeom.getDimArray(n2, m_tolerance, min_x, max_x, min_y, max_y, d3, d4, d, d2);
        dimArrayMig = ShapefileFeatureJGeom.getDimArray(n2, mg_tolerance, min_x, max_x, min_y, max_y, d3, d4, d, d2);
        if (!bl) {
            ShapefileFeatureJGeom.prepareTableForData(oracleConnection, dBFReaderJGeom, m_tableName, m_idName, m_geom, m_srid, dimArray);
        } else {
            System.out.println("Appending to existing table\n");
        }
        ShapefileFeatureJGeom.insertFeatures(oracleConnection, dBFReaderJGeom, shapefileReaderJGeom, m_tableName, m_idName, m_start_id, m_commit_interval, m_println_interval, m_srid, dimArrayMig);
        dBFReaderJGeom.closeDBF();
        shapefileReaderJGeom.closeShapefile();
        oracleConnection.close();
    }

    static {
        m_idName = null;
        m_srid = 0;
        m_geom = "geometry";
        min_x = "-180";
        min_y = "-90";
        max_x = "180";
        max_y = "90";
        m_tolerance = "0.05";
        mg_tolerance = "0.000000005";
        m_start_id = 1;
        m_commit_interval = -1;
        m_println_interval = 10;
        dimArray = null;
        dimArrayMig = null;
        defaultX = true;
        defaultY = true;
    }
}

