/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.test;

import java.io.IOException;
import java.net.UnknownHostException;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;

public class MultiThreadedTrapReceiver
implements CommandResponder {
    private MultiThreadedMessageDispatcher dispatcher;
    private Snmp snmp = null;
    private Address listenAddress;
    private ThreadPool threadPool;
    private int n = 0;
    private long start = -1L;

    private void init() throws UnknownHostException, IOException {
        this.threadPool = ThreadPool.create("Trap", 2);
        this.dispatcher = new MultiThreadedMessageDispatcher(this.threadPool, new MessageDispatcherImpl());
        this.listenAddress = GenericAddress.parse(System.getProperty("snmp4j.listenAddress", "udp:0.0.0.0/162"));
        AbstractTransportMapping transport = this.listenAddress instanceof UdpAddress ? new DefaultUdpTransportMapping((UdpAddress)this.listenAddress) : new DefaultTcpTransportMapping((TcpAddress)this.listenAddress);
        this.snmp = new Snmp(this.dispatcher, transport);
        this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv1());
        this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv2c());
        this.snmp.getMessageDispatcher().addMessageProcessingModel(new MPv3());
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel(usm);
        this.snmp.listen();
    }

    public void run() {
        try {
            this.init();
            this.snmp.addCommandResponder(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MultiThreadedTrapReceiver multithreadedtrapreceiver = new MultiThreadedTrapReceiver();
        multithreadedtrapreceiver.run();
    }

    @Override
    public void processPdu(CommandResponderEvent event) {
        if (this.start < 0L) {
            this.start = System.currentTimeMillis() - 1L;
        }
        ++this.n;
        if (this.n % 100 == 1) {
            System.out.println("Processed " + (double)this.n / (double)(System.currentTimeMillis() - this.start) * 1000.0 + "/s, total=" + this.n);
        }
    }
}

