/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail;

import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.EventQueue;
import jakarta.mail.Folder;
import jakarta.mail.MailLogger;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Provider;
import jakarta.mail.Service;
import jakarta.mail.Store;
import jakarta.mail.StreamLoader;
import jakarta.mail.Transport;
import jakarta.mail.URLName;
import jakarta.mail.util.LineInputStream;
import jakarta.mail.util.StreamProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public final class Session {
    private static final String DEFAULT_PROVIDER = "com.sun.mail.util.DefaultProvider";
    private final StreamProvider streamProvider;
    private final Properties props;
    private final Authenticator authenticator;
    private final Hashtable<URLName, PasswordAuthentication> authTable = new Hashtable();
    private boolean debug = false;
    private PrintStream out;
    private MailLogger logger;
    private final List<Provider> providers = new ArrayList<Provider>();
    private final Map<String, Provider> providersByProtocol = new HashMap<String, Provider>();
    private final Map<String, Provider> providersByClassName = new HashMap<String, Provider>();
    private final Properties addressMap = new Properties();
    private final EventQueue q;
    private static Session defaultSession = null;
    private static final String confDir;

    private Session(Properties props, Authenticator authenticator) {
        this.props = props;
        this.authenticator = authenticator;
        this.streamProvider = StreamProvider.provider();
        if (Boolean.parseBoolean(props.getProperty("mail.debug"))) {
            this.debug = true;
        }
        this.initLogger();
        this.logger.log(Level.CONFIG, "Jakarta Mail version {0}", (Object)"2.1.3");
        Class<?> cl = authenticator != null ? authenticator.getClass() : this.streamProvider.getClass();
        this.loadProviders(cl);
        this.loadAddressMap(cl);
        this.q = new EventQueue((Executor)props.get("mail.event.executor"));
    }

    public StreamProvider getStreamProvider() {
        return this.streamProvider;
    }

    private final synchronized void initLogger() {
        this.logger = new MailLogger(this.getClass(), "DEBUG", this.debug, this.getDebugOut());
    }

    public static Session getInstance(Properties props, Authenticator authenticator) {
        return new Session(props, authenticator);
    }

    public static Session getInstance(Properties props) {
        return new Session(props, null);
    }

    public static synchronized Session getDefaultInstance(Properties props, Authenticator authenticator) {
        if (defaultSession == null) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkSetFactory();
            }
            defaultSession = new Session(props, authenticator);
        } else if (Session.defaultSession.authenticator != authenticator && (Session.defaultSession.authenticator == null || authenticator == null || Session.defaultSession.authenticator.getClass().getClassLoader() != authenticator.getClass().getClassLoader())) {
            throw new SecurityException("Access to default session denied");
        }
        return defaultSession;
    }

    public static Session getDefaultInstance(Properties props) {
        return Session.getDefaultInstance(props, null);
    }

    public synchronized void setDebug(boolean debug) {
        this.debug = debug;
        this.initLogger();
        this.logger.log(Level.CONFIG, "setDebug: Jakarta Mail version {0}", (Object)"2.1.3");
    }

    public synchronized boolean getDebug() {
        return this.debug;
    }

    public synchronized void setDebugOut(PrintStream out) {
        this.out = out;
        this.initLogger();
    }

    public synchronized PrintStream getDebugOut() {
        if (this.out == null) {
            return System.out;
        }
        return this.out;
    }

    public synchronized Provider[] getProviders() {
        Provider[] _providers = new Provider[this.providers.size()];
        this.providers.toArray(_providers);
        return _providers;
    }

    public synchronized Provider getProvider(String protocol) throws NoSuchProviderException {
        if (protocol == null || protocol.length() == 0) {
            throw new NoSuchProviderException("Invalid protocol: null");
        }
        Provider _provider = null;
        String _className = this.props.getProperty("mail." + protocol + ".class");
        if (_className != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("mail." + protocol + ".class property exists and points to " + _className);
            }
            _provider = this.providersByClassName.get(_className);
        }
        if (_provider != null) {
            return _provider;
        }
        _provider = this.providersByProtocol.get(protocol);
        if (_provider == null) {
            throw new NoSuchProviderException("No provider for " + protocol);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("getProvider() returning " + _provider);
        }
        return _provider;
    }

    public synchronized void setProvider(Provider provider) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("Can't set null provider");
        }
        this.providersByProtocol.put(provider.getProtocol(), provider);
        this.providersByClassName.put(provider.getClassName(), provider);
        this.props.put("mail." + provider.getProtocol() + ".class", provider.getClassName());
    }

    public Store getStore() throws NoSuchProviderException {
        return this.getStore(this.getProperty("mail.store.protocol"));
    }

    public Store getStore(String protocol) throws NoSuchProviderException {
        return this.getStore(new URLName(protocol, null, -1, null, null, null));
    }

    public Store getStore(URLName url) throws NoSuchProviderException {
        String protocol = url.getProtocol();
        Provider p = this.getProvider(protocol);
        return this.getStore(p, url);
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        return this.getStore(provider, null);
    }

    private Store getStore(Provider provider, URLName url) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.STORE) {
            throw new NoSuchProviderException("invalid provider");
        }
        return this.getService(provider, url, Store.class);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        Store store = this.getStore(url);
        store.connect();
        return store.getFolder(url);
    }

    public Transport getTransport() throws NoSuchProviderException {
        String prot = this.getProperty("mail.transport.protocol");
        if (prot != null) {
            return this.getTransport(prot);
        }
        prot = (String)this.addressMap.get("rfc822");
        if (prot != null) {
            return this.getTransport(prot);
        }
        return this.getTransport("smtp");
    }

    public Transport getTransport(String protocol) throws NoSuchProviderException {
        return this.getTransport(new URLName(protocol, null, -1, null, null, null));
    }

    public Transport getTransport(URLName url) throws NoSuchProviderException {
        String protocol = url.getProtocol();
        Provider p = this.getProvider(protocol);
        return this.getTransport(p, url);
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return this.getTransport(provider, null);
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String transportProtocol = this.getProperty("mail.transport.protocol." + address.getType());
        if (transportProtocol != null) {
            return this.getTransport(transportProtocol);
        }
        transportProtocol = (String)this.addressMap.get(address.getType());
        if (transportProtocol != null) {
            return this.getTransport(transportProtocol);
        }
        throw new NoSuchProviderException("No provider for Address type: " + address.getType());
    }

    private Transport getTransport(Provider provider, URLName url) throws NoSuchProviderException {
        if (provider == null || provider.getType() != Provider.Type.TRANSPORT) {
            throw new NoSuchProviderException("invalid provider");
        }
        return this.getService(provider, url, Transport.class);
    }

    private <T extends Service> T getService(Provider provider, URLName url, Class<T> type) throws NoSuchProviderException {
        if (provider == null) {
            throw new NoSuchProviderException("null");
        }
        if (url == null) {
            url = new URLName(provider.getProtocol(), null, -1, null, null, null);
        }
        Class<?> acl = this.authenticator != null ? this.authenticator.getClass() : this.streamProvider.getClass();
        Class<T> serviceClass = null;
        for (ClassLoader l : Session.getClassLoaders(Thread.class, provider.getClass(), acl, this.streamProvider.getClass(), this.getClass(), System.class)) {
            try {
                serviceClass = Class.forName(provider.getClassName(), false, l).asSubclass(type);
                break;
            }
            catch (ClassCastException | ClassNotFoundException exception) {
            }
        }
        if (serviceClass == null) {
            try {
                serviceClass = Class.forName(provider.getClassName()).asSubclass(type);
            }
            catch (Exception ex) {
                this.logger.log(Level.FINE, "Exception loading provider", ex);
                throw new NoSuchProviderException(provider.getProtocol());
            }
        }
        try {
            Class[] c = new Class[]{Session.class, URLName.class};
            Constructor<T> cons = serviceClass.getConstructor(c);
            Object[] o = new Object[]{this, url};
            return (T)((Service)type.cast(cons.newInstance(o)));
        }
        catch (Exception ex) {
            this.logger.log(Level.FINE, "Exception loading provider", ex);
            throw new NoSuchProviderException(provider.getProtocol());
        }
    }

    public void setPasswordAuthentication(URLName url, PasswordAuthentication pw) {
        if (pw == null) {
            this.authTable.remove(url);
        } else {
            this.authTable.put(url, pw);
        }
    }

    public PasswordAuthentication getPasswordAuthentication(URLName url) {
        return this.authTable.get(url);
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress addr, int port, String protocol, String prompt, String defaultUserName) {
        if (this.authenticator != null) {
            return this.authenticator.requestPasswordAuthentication(addr, port, protocol, prompt, defaultUserName);
        }
        return null;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    static boolean containsDefaultProvider(Provider provider) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = provider.getClass().getDeclaredAnnotations()) {
            Class<? extends Annotation> type = annotation.annotationType();
            if (type == null || !DEFAULT_PROVIDER.equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    private void loadProviders(Class<?> cl) {
        StreamLoader loader = new StreamLoader(){

            @Override
            public void load(InputStream is) throws IOException {
                Session.this.loadProvidersFromStream(is);
            }
        };
        try {
            if (confDir != null) {
                this.loadFile(confDir + "javamail.providers", loader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader[] loaders = Session.getClassLoaders(cl, Thread.class, System.class);
        ClassLoader gcl = loaders.length != 0 ? loaders[0] : Session.getContextClassLoader();
        ServiceLoader<Provider> sl = ServiceLoader.load(Provider.class, gcl);
        for (Provider provider : sl) {
            if (Session.containsDefaultProvider(provider)) continue;
            this.addProvider(provider);
        }
        Iterator<Provider> iter = this.lookupUsingHk2ServiceLoader(Provider.class, gcl);
        while (iter.hasNext()) {
            Provider provider = iter.next();
            if (Session.containsDefaultProvider(provider)) continue;
            this.addProvider(provider);
        }
        this.loadAllResources("META-INF/javamail.providers", cl, loader);
        this.loadResource("/META-INF/javamail.default.providers", cl, loader, false);
        sl = ServiceLoader.load(Provider.class, gcl);
        for (Provider p3 : sl) {
            if (!Session.containsDefaultProvider(p3)) continue;
            this.addProvider(p3);
        }
        iter = this.lookupUsingHk2ServiceLoader(Provider.class, gcl);
        while (iter.hasNext()) {
            Provider provider = iter.next();
            if (!Session.containsDefaultProvider(provider)) continue;
            this.addProvider(provider);
        }
        if (this.providers.isEmpty()) {
            this.logger.config("failed to load any providers, using defaults");
            this.addProvider(new Provider(Provider.Type.STORE, "imap", "org.eclipse.angus.mail.imap.IMAPStore", "Oracle", "2.1.3"));
            this.addProvider(new Provider(Provider.Type.STORE, "imaps", "org.eclipse.angus.mail.imap.IMAPSSLStore", "Oracle", "2.1.3"));
            this.addProvider(new Provider(Provider.Type.STORE, "pop3", "org.eclipse.angus.mail.pop3.POP3Store", "Oracle", "2.1.3"));
            this.addProvider(new Provider(Provider.Type.STORE, "pop3s", "org.eclipse.angus.mail.pop3.POP3SSLStore", "Oracle", "2.1.3"));
            this.addProvider(new Provider(Provider.Type.TRANSPORT, "smtp", "org.eclipse.angus.mail.smtp.SMTPTransport", "Oracle", "2.1.3"));
            this.addProvider(new Provider(Provider.Type.TRANSPORT, "smtps", "org.eclipse.angus.mail.smtp.SMTPSSLTransport", "Oracle", "2.1.3"));
        }
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Tables of loaded providers");
            this.logger.config("Providers Listed By Class Name: " + this.providersByClassName);
            this.logger.config("Providers Listed By Protocol: " + this.providersByProtocol);
        }
    }

    private void loadProvidersFromStream(InputStream is) throws IOException {
        if (is != null) {
            String currLine;
            LineInputStream lis = this.streamProvider.inputLineStream(is, false);
            while ((currLine = lis.readLine()) != null) {
                if (currLine.startsWith("#") || currLine.trim().length() == 0) continue;
                Provider.Type type = null;
                String protocol = null;
                String className = null;
                String vendor = null;
                String version = null;
                StringTokenizer tuples = new StringTokenizer(currLine, ";");
                while (tuples.hasMoreTokens()) {
                    String currTuple = tuples.nextToken().trim();
                    int sep = currTuple.indexOf("=");
                    if (currTuple.startsWith("protocol=")) {
                        protocol = currTuple.substring(sep + 1);
                        continue;
                    }
                    if (currTuple.startsWith("type=")) {
                        String strType = currTuple.substring(sep + 1);
                        if (strType.equalsIgnoreCase("store")) {
                            type = Provider.Type.STORE;
                            continue;
                        }
                        if (!strType.equalsIgnoreCase("transport")) continue;
                        type = Provider.Type.TRANSPORT;
                        continue;
                    }
                    if (currTuple.startsWith("class=")) {
                        className = currTuple.substring(sep + 1);
                        continue;
                    }
                    if (currTuple.startsWith("vendor=")) {
                        vendor = currTuple.substring(sep + 1);
                        continue;
                    }
                    if (!currTuple.startsWith("version=")) continue;
                    version = currTuple.substring(sep + 1);
                }
                if (type == null || protocol == null || className == null || protocol.length() == 0 || className.length() == 0) {
                    this.logger.log(Level.CONFIG, "Bad provider entry: {0}", (Object)currLine);
                    continue;
                }
                Provider provider = new Provider(type, protocol, className, vendor, version);
                this.addProvider(provider);
            }
        }
    }

    public synchronized void addProvider(Provider provider) {
        this.providers.add(provider);
        this.providersByClassName.put(provider.getClassName(), provider);
        if (!this.providersByProtocol.containsKey(provider.getProtocol())) {
            this.providersByProtocol.put(provider.getProtocol(), provider);
        }
    }

    private void loadAddressMap(Class<?> cl) {
        StreamLoader loader = new StreamLoader(){

            @Override
            public void load(InputStream is) throws IOException {
                Session.this.addressMap.load(is);
            }
        };
        this.loadResource("/META-INF/javamail.default.address.map", cl, loader, true);
        this.loadAllResources("META-INF/javamail.address.map", cl, loader);
        try {
            if (confDir != null) {
                this.loadFile(confDir + "javamail.address.map", loader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.addressMap.isEmpty()) {
            this.logger.config("failed to load address map, using defaults");
            this.addressMap.put("rfc822", "smtp");
        }
    }

    public synchronized void setProtocolForAddress(String addresstype, String protocol) {
        if (protocol == null) {
            this.addressMap.remove(addresstype);
        } else {
            this.addressMap.put(addresstype, protocol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(String name, StreamLoader loader) {
        InputStream clis = null;
        try {
            clis = new BufferedInputStream(new FileInputStream(name));
            loader.load(clis);
            this.logger.log(Level.CONFIG, "successfully loaded file: {0}", (Object)name);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException | SecurityException e) {
            if (this.logger.isLoggable(Level.CONFIG)) {
                this.logger.log(Level.CONFIG, "not loading file: " + name, e);
            }
        }
        finally {
            try {
                if (clis != null) {
                    clis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResource(String name, Class<?> cl, StreamLoader loader, boolean expected) {
        InputStream clis = null;
        try {
            clis = Session.getResourceAsStream(cl, name);
            if (clis != null) {
                loader.load(clis);
                this.logger.log(Level.CONFIG, "successfully loaded resource: {0}", (Object)name);
            } else if (expected) {
                this.logger.log(Level.WARNING, "expected resource not found: {0}", (Object)name);
            }
        }
        catch (IOException | SecurityException e) {
            this.logger.log(Level.CONFIG, "Exception loading resource", e);
        }
        finally {
            try {
                if (clis != null) {
                    clis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources(String name, Class<?> cl, StreamLoader loader) {
        boolean anyLoaded;
        block22: {
            anyLoaded = false;
            try {
                URL[] urls;
                ClassLoader cld = null;
                cld = Session.getContextClassLoader();
                if (cld == null) {
                    cld = cl.getClassLoader();
                }
                if ((urls = cld != null ? Session.getResources(cld, name) : Session.getSystemResources(name)) == null) break block22;
                for (int i = 0; i < urls.length; ++i) {
                    URL url = urls[i];
                    InputStream clis = null;
                    this.logger.log(Level.CONFIG, "URL {0}", (Object)url);
                    try {
                        clis = Session.openStream(url);
                        if (clis != null) {
                            loader.load(clis);
                            anyLoaded = true;
                            this.logger.log(Level.CONFIG, "successfully loaded resource: {0}", (Object)url);
                            continue;
                        }
                        this.logger.log(Level.CONFIG, "not loading resource: {0}", (Object)url);
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        continue;
                    }
                    catch (IOException | SecurityException ioex) {
                        this.logger.log(Level.CONFIG, "Exception loading resource", ioex);
                        continue;
                    }
                    finally {
                        try {
                            if (clis != null) {
                                clis.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.CONFIG, "Exception loading resource", ex);
            }
        }
        if (!anyLoaded) {
            this.loadResource("/" + name, cl, loader, false);
        }
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    private static ClassLoader[] getClassLoaders(final Class<?> ... classes) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader[]>(){

            @Override
            public ClassLoader[] run() {
                ClassLoader[] loaders = new ClassLoader[classes.length];
                int w = 0;
                for (Class k : classes) {
                    ClassLoader cl = null;
                    if (k == Thread.class) {
                        try {
                            cl = Thread.currentThread().getContextClassLoader();
                        }
                        catch (SecurityException securityException) {}
                    } else if (k == System.class) {
                        try {
                            cl = ClassLoader.getSystemClassLoader();
                        }
                        catch (SecurityException securityException) {}
                    } else {
                        try {
                            cl = k.getClassLoader();
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    if (cl == null) continue;
                    loaders[w++] = cl;
                }
                if (loaders.length != w) {
                    loaders = Arrays.copyOf(loaders, w);
                }
                return loaders;
            }
        });
    }

    private static InputStream getResourceAsStream(final Class<?> c, final String name) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    try {
                        return c.getResourceAsStream(name);
                    }
                    catch (RuntimeException e) {
                        IOException ioex = new IOException("ClassLoader.getResourceAsStream failed");
                        ioex.initCause(e);
                        throw ioex;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static URL[] getResources(final ClassLoader cl, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL[]>(){

            @Override
            public URL[] run() {
                URL[] ret = null;
                try {
                    ArrayList<URL> v = Collections.list(cl.getResources(name));
                    if (!v.isEmpty()) {
                        ret = new URL[v.size()];
                        v.toArray(ret);
                    }
                }
                catch (IOException | SecurityException exception) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    private static URL[] getSystemResources(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL[]>(){

            @Override
            public URL[] run() {
                URL[] ret = null;
                try {
                    ArrayList<URL> v = Collections.list(ClassLoader.getSystemResources(name));
                    if (!v.isEmpty()) {
                        ret = new URL[v.size()];
                        v.toArray(ret);
                    }
                }
                catch (IOException | SecurityException exception) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    private static InputStream openStream(final URL url) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return url.openStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    EventQueue getEventQueue() {
        return this.q;
    }

    private static Class<?>[] getHk2ServiceLoaderTargets(Class<?> factoryClass) {
        ClassLoader[] loaders = Session.getClassLoaders(Thread.class, factoryClass, System.class);
        Class[] classes = new Class[loaders.length];
        int w = 0;
        for (ClassLoader loader : loaders) {
            if (loader == null) continue;
            try {
                classes[w++] = Class.forName("org.glassfish.hk2.osgiresourcelocator.ServiceLoader", false, loader);
            }
            catch (Exception | LinkageError throwable) {
                // empty catch block
            }
        }
        if (classes.length != w) {
            classes = Arrays.copyOf(classes, w);
        }
        return classes;
    }

    private <T> Iterator<T> lookupUsingHk2ServiceLoader(Class<T> factoryId, ClassLoader loader) {
        for (Class<?> target : Session.getHk2ServiceLoaderTargets(factoryId)) {
            try {
                Class<?> serviceClass = Class.forName(factoryId.getName(), false, loader);
                Class[] args = new Class[]{serviceClass};
                Method m = target.getMethod("lookupProviderInstances", Class.class);
                Iterable result = (Iterable)m.invoke(null, (Object[])args);
                if (result == null) continue;
                return result.iterator();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.emptyIterator();
    }

    static {
        String dir = null;
        try {
            dir = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String home = System.getProperty("java.home");
                    String newdir = home + File.separator + "conf";
                    File conf = new File(newdir);
                    if (conf.exists()) {
                        return newdir + File.separator;
                    }
                    return home + File.separator + "lib" + File.separator;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        confDir = dir;
    }
}

