/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf.streams;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hdgf.chunks.ChunkFactory;
import org.apache.poi.hdgf.pointers.Pointer;
import org.apache.poi.hdgf.pointers.PointerFactory;
import org.apache.poi.hdgf.streams.ChunkStream;
import org.apache.poi.hdgf.streams.Stream;
import org.apache.poi.hdgf.streams.StreamStore;

public class PointerContainingStream
extends Stream {
    private static final Logger LOG = LogManager.getLogger(PointerContainingStream.class);
    private static final int MAX_CHILDREN_NESTING = 500;
    private final Pointer[] childPointers;
    private Stream[] childStreams;
    private final ChunkFactory chunkFactory;
    private final PointerFactory pointerFactory;

    protected PointerContainingStream(Pointer pointer, StreamStore store, ChunkFactory chunkFactory, PointerFactory pointerFactory) {
        super(pointer, store);
        this.chunkFactory = chunkFactory;
        this.pointerFactory = pointerFactory;
        this.childPointers = pointerFactory.createContainerPointers(pointer, store.getContents());
    }

    protected Pointer[] getChildPointers() {
        return this.childPointers;
    }

    public Stream[] getPointedToStreams() {
        return this.childStreams;
    }

    public void findChildren(byte[] documentData) {
        this.findChildren(documentData, 0);
    }

    private void findChildren(byte[] documentData, int nesting) {
        if (nesting > 500) {
            LOG.warn("Encountered too deep nesting, cannot fully process stream  with more than 500 nested children. Some data could not be parsed.");
            return;
        }
        this.childStreams = new Stream[this.childPointers.length];
        for (int i = 0; i < this.childPointers.length; ++i) {
            Stream child;
            Pointer ptr = this.childPointers[i];
            this.childStreams[i] = Stream.createStream(ptr, documentData, this.chunkFactory, this.pointerFactory);
            if (this.childStreams[i] instanceof ChunkStream) {
                child = (ChunkStream)this.childStreams[i];
                ((ChunkStream)child).findChunks();
            }
            if (!(this.childStreams[i] instanceof PointerContainingStream)) continue;
            child = (PointerContainingStream)this.childStreams[i];
            ((PointerContainingStream)child).findChildren(documentData, nesting + 1);
        }
    }
}

