/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

public class BigEndian {
    public static short getShort(byte[] buf, int offset) {
        return (short)(buf[offset] << 8 | buf[offset + 1] & 0xFF);
    }

    public static int getInt(byte[] buf, int offset) {
        byte a = buf[offset];
        byte b = buf[offset + 1];
        byte c = buf[offset + 2];
        byte d = buf[offset + 3];
        return a << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
    }

    public static long getLong(byte[] buf, int offset) {
        byte a = buf[offset];
        byte b = buf[offset + 1];
        byte c = buf[offset + 2];
        byte d = buf[offset + 3];
        byte e = buf[offset + 4];
        byte f = buf[offset + 5];
        byte g = buf[offset + 6];
        byte h = buf[offset + 7];
        return (long)(a & 0xFF) << 56 | (long)(b & 0xFF) << 48 | (long)(c & 0xFF) << 40 | (long)(d & 0xFF) << 32 | (long)(e & 0xFF) << 24 | (long)(f & 0xFF) << 16 | (long)(g & 0xFF) << 8 | (long)(h & 0xFF);
    }

    public static float getFloat(byte[] buf, int offset) {
        return Float.intBitsToFloat(BigEndian.getInt(buf, offset));
    }

    public static double getDouble(byte[] buf, int offset) {
        return Double.longBitsToDouble(BigEndian.getLong(buf, offset));
    }

    public static void setShort(short val, byte[] buf, int offset) {
        buf[offset++] = (byte)(val >> 8 & 0xFF);
        buf[offset++] = (byte)(val >> 0 & 0xFF);
    }

    public static void setInteger(int val, byte[] buf, int offset) {
        BigEndian.setShort((short)(val >> 16), buf, offset + 0);
        BigEndian.setShort((short)(val >> 0), buf, offset + 2);
    }

    public static void setLong(long val, byte[] buf, int offset) {
        BigEndian.setInteger((int)(val >> 32), buf, offset + 0);
        BigEndian.setInteger((int)(val >> 0), buf, offset + 4);
    }
}

