/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

import inform.adt.TimeInfo;
import inform.adt.TimeZoneHost;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTime {
    private static TimeZone tz = TimeZone.getDefault();
    private double time;
    public static final int MSECS_PER_DAY = 86400000;
    public static final long L_MSECS_PER_DAY = 86400000L;
    public static final double F_MSECS_PER_DAY = 8.64E7;
    private static final double F_01_01_1970_MSECS = 2.2091616E12;
    private static final int DATE_DELTA = 693594;
    public static final double ONE_SECOND = 1.1574074074074073E-5;
    private static final int[] DAYS_SINCE_YEAR = new int[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] DAYS_IN_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int JANURARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;

    public DateTime() {
    }

    public DateTime(double time) {
        this.time = time;
    }

    public static synchronized void setTimeZone(TimeZone tz) {
        if (tz != null) {
            DateTime.tz = tz;
        }
    }

    public static int serverZoneOffset() {
        return tz.getRawOffset();
    }

    public double value() {
        return this.time;
    }

    public static double create(int year, int month, int day) {
        int ym1 = year - 1;
        double result = ym1 * 365 + ym1 / 4 - ym1 / 100 + ym1 / 400 + DAYS_SINCE_YEAR[month] + day - 693594;
        if (month > 2 && DateTime.isLeapYear(year)) {
            return result + 1.0;
        }
        return result;
    }

    public static double currentDateTime() {
        return DateTime.fromUnixTime(System.currentTimeMillis());
    }

    public static int serverTimeZoneOffset(TimeZoneHost timeZoneHost) {
        return timeZoneHost != null ? tz.getRawOffset() - timeZoneHost.getTimeZoneOffset() : 0;
    }

    public static boolean isServerTimeZoneHost(TimeZoneHost timeZoneHost) {
        return timeZoneHost == null || timeZoneHost.getTimeZoneOffset() == tz.getRawOffset();
    }

    public static double currentDate() {
        return Math.floor(DateTime.currentDateTime());
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int daysInMonth(int month, int year) {
        int days = DAYS_IN_MONTH[month];
        if (month == 2 && DateTime.isLeapYear(year)) {
            return days + 1;
        }
        return days;
    }

    public long toUnixTime() {
        return DateTime.toUnixTime(this.time);
    }

    public static long toMillis(double time) {
        return (long)(time * 8.64E7 + 0.5);
    }

    public static double fromMillis(long time) {
        return (double)time / 8.64E7;
    }

    public static long toUnixTime(double time) {
        return DateTime.toCalendar(time).getTimeInMillis();
    }

    public static long toUnixTimeRoundSec(double time) {
        long seconds = DateTime.toCalendar(time).getTimeInMillis() / 1000L;
        return seconds * 1000L;
    }

    public Timestamp toSqlTime() {
        return new Timestamp(this.toUnixTime());
    }

    public static Timestamp toSqlTime(double time) {
        return new Timestamp(DateTime.toUnixTime(time));
    }

    public static double createDateTime(int year, int month, int day, int hour, int minute, int second, int mseconds) {
        double date = DateTime.create(year, month, day);
        if (date < 0.0) {
            return date - ((double)hour * 3600000.0 + (double)minute * 60000.0 + (double)second * 1000.0 + (double)mseconds) / 8.64E7;
        }
        return date + ((double)hour * 3600000.0 + (double)minute * 60000.0 + (double)second * 1000.0 + (double)mseconds) / 8.64E7;
    }

    public static double fromUnixTime(long utcUnixTime) {
        if (utcUnixTime == 0L) {
            return 0.0;
        }
        if (utcUnixTime > -12219292800000L) {
            long localUnixTime = utcUnixTime + (long)tz.getOffset(utcUnixTime);
            return ((double)localUnixTime + 2.2091616E12) / 8.64E7;
        }
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.setTimeInMillis(utcUnixTime);
        return DateTime.createDateTime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
    }

    public static double fromString(String s) throws ParseException {
        return DateTime.fromUnixTime(DateFormat.getDateInstance(3).parse(s).getTime());
    }

    public static String unixTimeToReadableString(long time) {
        if (time == 0L) {
            return "0";
        }
        return DateTime.toStr(DateTime.fromUnixTime(time), true, true);
    }

    private static String toStr(double dt, boolean optimal, boolean millis) {
        int ms;
        int ss;
        int mm;
        int hh;
        int d;
        int m;
        int y;
        int t = (int)dt + 693594;
        if (t <= 0) {
            Calendar c = DateTime.toCalendar(dt);
            y = c.get(1);
            m = c.get(2);
            d = c.get(5) + 1;
            hh = c.get(11);
            mm = c.get(12);
            ss = c.get(13);
            ms = millis ? c.get(14) : 0;
        } else {
            TimeInfo ti = new TimeInfo();
            DateTime.toTimeInfo(dt, ti);
            y = ti.year;
            m = ti.month;
            d = ti.day;
            hh = ti.hour;
            mm = ti.minute;
            ss = ti.second;
            int n = ms = millis ? ti.mseconds : 0;
        }
        if (optimal && (hh | mm | ss | ms) == 0) {
            return String.format("%04d.%02d.%02d", y, m, d);
        }
        if (millis && (!optimal || ms != 0)) {
            return String.format("%04d.%02d.%02d %02d:%02d:%02d.%03d", y, m, d, hh, mm, ss, ms);
        }
        return String.format("%04d.%02d.%02d %02d:%02d:%02d", y, m, d, hh, mm, ss);
    }

    public static String toText(double dt) {
        int ss;
        int mm;
        int hh;
        int d;
        int m;
        int y;
        int t = (int)dt + 693594;
        if (t <= 0) {
            Calendar c = DateTime.toCalendar(dt);
            y = c.get(1);
            m = c.get(2);
            d = c.get(5) + 1;
            hh = c.get(11);
            mm = c.get(12);
            ss = c.get(13);
        } else {
            TimeInfo ti = new TimeInfo();
            DateTime.toTimeInfo(dt, ti);
            y = ti.year;
            m = ti.month;
            d = ti.day;
            hh = ti.hour;
            mm = ti.minute;
            ss = ti.second;
        }
        if ((hh | mm | ss) == 0) {
            return String.format("%02d.%02d.%04d", d, m, y);
        }
        return String.format("%02d.%02d.%04d %02d:%02d:%02d", d, m, y, hh, mm, ss);
    }

    public static String toString(double dateValue) {
        return DateTime.toStr(dateValue, false, false);
    }

    public static String toString(long time) {
        return DateTime.toStr(DateTime.fromUnixTime(time), false, false);
    }

    public static String toLogString(double dateValue) {
        return DateTime.toStr(dateValue, true, true);
    }

    public static Calendar toCalendar(double time) {
        GregorianCalendar cal = new GregorianCalendar(1899, 11, 30, 0, 0, 0);
        ((Calendar)cal).add(5, (int)time);
        ((Calendar)cal).add(14, (int)Math.round(8.64E7 * (time - (double)((int)time))));
        return cal;
    }

    public static void toTimeInfo(double time, TimeInfo info) {
        int T;
        info.clear();
        int D1 = 365;
        int D4 = 1461;
        int D100 = 36524;
        int D400 = 146097;
        int totalDays = (int)time;
        int timePart = (int)(Math.abs(time - (double)totalDays) * 8.64E7 + 0.5);
        if (timePart >= 86400000) {
            ++totalDays;
            timePart = 0;
        }
        if ((T = totalDays + 693594) <= 0) {
            Calendar cal = DateTime.toCalendar(time);
            info.year = cal.get(1);
            info.month = cal.get(2) + 1;
            info.day = cal.get(5);
            info.hour = cal.get(11);
            info.minute = cal.get(12);
            info.second = cal.get(13);
            info.mseconds = cal.get(14);
            return;
        }
        --T;
        int Y = 1;
        while (T >= 146097) {
            T -= 146097;
            Y += 400;
        }
        int I = T / 36524;
        int D = T % 36524;
        if (I == 4) {
            --I;
            D += 36524;
        }
        Y += I * 100;
        I = D / 1461;
        Y += I * 4;
        I = (D %= 1461) / 365;
        D %= 365;
        if (I == 4) {
            --I;
            D += 365;
        }
        Y += I;
        int M = 1;
        while (D >= (I = DateTime.daysInMonth(M, Y))) {
            D -= I;
            ++M;
        }
        info.year = Y;
        info.month = M;
        info.day = D + 1;
        int minCount = timePart / 60000;
        int msecCount = timePart % 60000;
        info.hour = minCount / 60;
        info.minute = minCount % 60;
        info.second = msecCount / 1000;
        info.mseconds = msecCount % 1000;
    }

    public static double toServerTime(double dateTime, TimeZoneHost timeZoneHost) {
        if (timeZoneHost == null) {
            return dateTime;
        }
        int offset = tz.getRawOffset() - timeZoneHost.getTimeZoneOffset();
        if (offset == 0) {
            return dateTime;
        }
        return DateTime.fromMillis(DateTime.toMillis(dateTime) + (long)offset);
    }

    public static double fromServerTime(double dateTime, TimeZoneHost timeZoneHost) {
        if (timeZoneHost == null) {
            return dateTime;
        }
        int offset = timeZoneHost.getTimeZoneOffset() - tz.getRawOffset();
        if (offset == 0) {
            return dateTime;
        }
        return DateTime.fromMillis(DateTime.toMillis(dateTime) + (long)offset);
    }
}

