/*
 * Decompiled with CFR 0.152.
 */
package inform.adt;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class IO {
    private static void transfer(InputStream from, OutputStream to, byte[] buffer) throws IOException {
        int l;
        while ((l = from.read(buffer)) >= 0) {
            to.write(buffer, 0, l);
        }
    }

    public static void transfer(InputStream from, OutputStream to) throws IOException {
        IO.transfer(from, to, new byte[4096]);
    }

    public static byte[] readFully(InputStream in, byte[] data, int offset, int length) throws IOException {
        int count;
        for (int loffs = 0; loffs < length; loffs += count) {
            count = in.read(data, offset + loffs, length - loffs);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return data;
    }

    public static void readToEnd(Reader reader, StringBuilder output) throws IOException {
        int l;
        char[] buff = new char[4096];
        while ((l = reader.read(buff)) >= 0) {
            output.append(buff, 0, l);
        }
    }

    public static void readAvailable(InputStream input, ByteArrayOutputStream output) throws IOException {
        int l;
        byte[] buff = new byte[4096];
        while ((l = input.available()) > 0) {
            l = input.read(buff, 0, Math.min(buff.length, l));
            output.write(buff, 0, l);
        }
    }
}

