/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

abstract class AbstractHashedCollection {
    private static final double LOAD_FACTOR = 0.75;
    protected int size;
    protected int capacity;
    protected int treshold;
    protected int mask;

    public AbstractHashedCollection() {
        this.capacity(16);
    }

    public int size() {
        return this.size;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    protected void rehashIfNeed() {
        if (this.size > this.treshold) {
            this.capacity(this.capacity * 2);
            this.rehash();
        }
    }

    protected abstract void rehash();

    private void capacity(int capacity) {
        this.capacity = capacity;
        this.treshold = (int)((double)capacity * 0.75);
        this.mask = capacity - 1;
    }

    protected int hashTableLength() {
        return this.capacity;
    }

    public String toString() {
        int rl;
        StringBuilder result = new StringBuilder();
        result.append('{');
        int cnt = 0;
        if (this.toString_appendZero(result)) {
            result.append(',');
            ++cnt;
        }
        int len = this.hashTableLength();
        for (int i = 0; i < len; ++i) {
            if (cnt == 32) {
                result.append("...");
                break;
            }
            if (!this.toString_appendItem(i, result)) continue;
            ++cnt;
            result.append(',');
        }
        if (result.charAt((rl = result.length()) - 1) == ',') {
            result.setLength(rl - 1);
        }
        result.append('}');
        return result.toString();
    }

    protected abstract boolean toString_appendZero(StringBuilder var1);

    protected abstract boolean toString_appendItem(int var1, StringBuilder var2);
}

