/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.collections;

import inform.adt.collections.AbstractSet;
import inform.adt.collections.Hashing;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoubleDoubleMap
extends AbstractSet
implements Iterable<Cursor> {
    private double zerov;
    private double[] keys;
    private double[] vals;
    private double lc;

    public DoubleDoubleMap() {
        int len = this.capacity << 1;
        this.keys = new double[len];
        this.vals = new double[len];
    }

    @Override
    public void clear() {
        super.clear();
        int len = this.keys.length;
        for (int i = 0; i < len; ++i) {
            this.keys[i] = 0.0;
        }
    }

    public void put(double k, double v) {
        if (this.zero(k)) {
            this.zerov = v;
            this.addZero();
            return;
        }
        this.rehashIfNeed();
        if (this.place(k, v)) {
            ++this.size;
        }
    }

    public boolean contains(double k) {
        double e;
        if (this.zero(k)) {
            this.lc = this.zerov;
            return this.zero;
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while (!this.zero(e = this.keys[i])) {
            if (this.equals(e, k)) {
                this.lc = this.vals[i];
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    public double get(double k, double defaultValue) {
        double e;
        if (this.zero(k)) {
            return this.zerov;
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while (!this.zero(e = this.keys[i])) {
            if (this.equals(e, k)) {
                return this.vals[i];
            }
            i = i + 1 & m;
        }
        return defaultValue;
    }

    public double lget() {
        return this.lc;
    }

    public boolean remove(double k) {
        double e;
        if (this.zero(k)) {
            return this.remZero();
        }
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while (!this.zero(e = this.keys[i])) {
            if (this.equals(e, k)) {
                this.deleteAt(i);
                return true;
            }
            i = i + 1 & m;
        }
        return false;
    }

    @Override
    public Iterator<Cursor> iterator() {
        return new Iterator<Cursor>(){
            final Cursor cursor = new Cursor();
            final int keysLen;
            boolean has;
            int idx;
            {
                this.keysLen = DoubleDoubleMap.this.keys.length;
                this.has = DoubleDoubleMap.this.zero;
                this.cursor.value = DoubleDoubleMap.this.zerov;
            }

            @Override
            public final boolean hasNext() {
                while (!this.has && this.idx < this.keysLen) {
                    this.cursor.key = DoubleDoubleMap.this.keys[this.idx];
                    this.has = !DoubleDoubleMap.this.zero(this.cursor.key);
                    if (this.has) {
                        this.cursor.value = DoubleDoubleMap.this.vals[this.idx];
                    }
                    ++this.idx;
                }
                return this.has;
            }

            @Override
            public final Cursor next() {
                if (this.idx > this.keysLen) {
                    throw new NoSuchElementException();
                }
                this.has = false;
                return this.cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private boolean place(double k, double v) {
        double e;
        int m = this.keys.length - 1;
        int i = (this.hash(k) & this.mask) << 1;
        while (!this.zero(e = this.keys[i])) {
            if (this.equals(e, k)) {
                this.vals[i] = v;
                return false;
            }
            i = i + 1 & m;
        }
        this.keys[i] = k;
        this.vals[i] = v;
        return true;
    }

    @Override
    protected void rehash() {
        double[] ok = this.keys;
        double[] ov = this.vals;
        int newLen = this.capacity << 1;
        this.keys = new double[newLen];
        this.vals = new double[newLen];
        for (int i = ok.length - 1; i >= 0; --i) {
            double k = ok[i];
            if (this.zero(k)) continue;
            this.place(k, ov[i]);
        }
    }

    protected final void deleteAt(int index) {
        double k;
        assert (!this.zero(this.keys[index]));
        this.keys[index] = 0.0;
        --this.size;
        int m = this.keys.length - 1;
        int i = index + 1 & m;
        while (!this.zero(k = this.keys[i])) {
            double v = this.vals[i];
            this.keys[i] = 0.0;
            this.place(k, v);
            i = i + 1 & m;
        }
    }

    private boolean zero(double k) {
        return k == 0.0;
    }

    protected int hash(double k) {
        return Hashing.hash(k);
    }

    protected boolean equals(double a, double b) {
        return Hashing.equals(a, b);
    }

    @Override
    protected final boolean toString_appendZero(StringBuilder out) {
        if (!this.zero) {
            return false;
        }
        out.append(0.0).append(':').append(this.zerov);
        return true;
    }

    @Override
    protected final boolean toString_appendItem(int index, StringBuilder out) {
        double k = this.keys[index];
        if (this.zero(k)) {
            return false;
        }
        out.append(k).append(':').append(this.vals[index]);
        return true;
    }

    public int fillFactor() {
        int f = 0;
        int m = 0;
        for (double k : this.keys) {
            if (!this.zero(k)) {
                ++f;
                continue;
            }
            if (m < f) {
                m = f;
            }
            f = 0;
        }
        if (m < f) {
            m = f;
        }
        return m;
    }

    public static class Cursor {
        public double key;
        public double value;

        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

