/*
 * Decompiled with CFR 0.152.
 */
package inform.adt.taggedio;

import inform.adt.DateTime;
import inform.adt.LittleEndian;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.AbstractTaggedReader;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedReaderSizeOverflowException;
import inform.adt.taggedio.TaggedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class TaggedReader
implements AbstractTaggedReader {
    private int currentTag;
    private int currentSize;
    private boolean isTagReady;
    private boolean reuseCurrent;
    private static final String INVALID_FORMAT_MSG = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u043e\u0442\u043e\u043a\u0430";
    private static final String INVALID_TAG_MSG = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u044d\u0433";
    private static final String INVALID_TAG_SIZE_MSG = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0442\u044d\u0433\u0430";
    private static final String UNEXPECTED_EOF_MSG = "\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043d\u0435\u0446 \u0434\u0430\u043d\u043d\u044b\u0445";
    private LittleEndianDataInputStream stream;
    private final int maxPossibleTagSize;

    public TaggedReader(InputStream dataStream) {
        this.stream = new LittleEndianDataInputStream(dataStream);
        int tmpMaxPossibleTagSize = Integer.MAX_VALUE;
        if (dataStream instanceof ByteArrayInputStream) {
            try {
                tmpMaxPossibleTagSize = Math.max(dataStream.available() - 1, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.maxPossibleTagSize = tmpMaxPossibleTagSize;
    }

    public TaggedReader(InputStream dataStream, int dataSize) {
        assert (dataSize >= 0) : "tagged data size couldn't be less than zero";
        this.stream = new LittleEndianDataInputStream(dataStream);
        this.maxPossibleTagSize = dataSize;
    }

    public TaggedReader(byte[] content) {
        this.stream = new LittleEndianDataInputStream(new ByteArrayInputStream(content));
        this.maxPossibleTagSize = Math.max(content.length - 1, 0);
    }

    public static boolean containsTag(int tag, byte[] data) {
        if (data == null) {
            return false;
        }
        if (data.length < 2) {
            return false;
        }
        int d0 = data[0] & 0xFF;
        if (d0 == tag) {
            return true;
        }
        if (d0 == 255 && data.length >= 6) {
            int d1 = data[1] & 0xFF;
            return d1 == tag;
        }
        return false;
    }

    public static boolean containsSignature(byte[] data) {
        if (data == null) {
            return false;
        }
        if (!TaggedReader.containsTag(201, data)) {
            return false;
        }
        if (data.length < 8) {
            return false;
        }
        return data[2] == 116 && data[3] == 105 && data[4] == 111 && data[5] == 0 && data[6] == 1 && data[7] == 0;
    }

    public static boolean containsNumber(double number, byte[] data) throws IOException, TaggedReaderException {
        if (data == null) {
            return false;
        }
        TaggedReader reader = new TaggedReader(new ByteArrayInputStream(data), data.length);
        block4: while (reader.getNextTag() != 0) {
            double[] numbers;
            if (reader.getCurrentTag() == 202) {
                if (!TaggedReader.containsNumber(number, reader.getRaw())) continue;
                return true;
            }
            switch (reader.getCurrentTagSize()) {
                case 4: {
                    if (!(number <= 2.147483647E9) || number != (double)reader.getInt()) continue block4;
                    return true;
                }
                case 8: {
                    if (number != reader.getDouble()) continue block4;
                    return true;
                }
            }
            if (reader.getCurrentTagSize() % 8 != 0) continue;
            for (double d : numbers = LittleEndian.toDoubleArray(reader.getRaw())) {
                if (d != number) continue;
                return true;
            }
        }
        return false;
    }

    public boolean next() throws IOException {
        return this.getNextTag() != 0;
    }

    public int getNextTag() throws IOException {
        if (this.reuseCurrent) {
            this.reuseCurrent = false;
            return this.currentTag;
        }
        if (this.isTagReady) {
            this.skip();
        }
        this.isTagReady = true;
        int tag = this.stream.read();
        if (tag == -1) {
            this.currentSize = 0;
            this.currentTag = 0;
            return this.currentTag;
        }
        if (tag != 255) {
            this.currentSize = this.stream.readUnsignedByte();
        } else {
            tag = this.stream.readUnsignedByte();
            this.currentSize = this.stream.readInt();
            if (this.currentSize < 0) {
                int badSize = this.currentSize;
                int badTag = this.currentTag;
                this.currentSize = 0;
                this.currentTag = 0;
                throw new TaggedReaderSizeOverflowException(badTag, badSize);
            }
        }
        if (this.currentSize > this.maxPossibleTagSize) {
            int badSize = this.currentSize;
            int badTag = this.currentTag;
            this.currentSize = 0;
            this.currentTag = 0;
            throw new TaggedReaderSizeOverflowException(badTag, badSize, this.maxPossibleTagSize);
        }
        this.currentTag = tag;
        return this.currentTag;
    }

    public void skipNextTag() throws IOException {
        int tag = this.getNextTag();
        if (tag == 0) {
            this.currentSize = 0;
        }
    }

    public void takeNextTag() throws IOException {
        if (this.getNextTag() == 0) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
    }

    @Override
    public int getCurrentTag() {
        return this.currentTag;
    }

    @Override
    public int getCurrentTagSize() {
        return this.currentSize;
    }

    public void skip() throws IOException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        this.stream.skipBytes(this.currentSize);
        this.readed();
    }

    public void tagback() {
        assert (this.isTagReady);
        this.reuseCurrent = true;
    }

    public static void throwInvalidFormat() throws TaggedReaderException {
        throw new TaggedReaderException(INVALID_FORMAT_MSG);
    }

    public static void throwInvalidTag() throws TaggedReaderException {
        throw new TaggedReaderException(INVALID_TAG_MSG);
    }

    public static void throwInvalidTagSize() throws TaggedReaderException {
        throw new TaggedReaderException(INVALID_TAG_SIZE_MSG);
    }

    @Override
    public void getSignature() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != 201 || this.currentSize != 6) {
            TaggedReader.throwInvalidFormat();
        }
        this.stream.skipBytes(6);
        this.readed();
    }

    @Override
    public void getRaw(byte[] data, int data_size) throws IOException, TaggedReaderException {
        int bytes_readen;
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentSize != data_size) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, data_size);
        }
        if ((bytes_readen = this.read(data, data_size)) < this.currentSize) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
        this.readed();
    }

    public void get(int tag, byte[] data, int data_size) throws IOException, TaggedReaderException {
        int bytes_readen;
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        if (this.currentSize != data_size) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, data_size);
        }
        if ((bytes_readen = this.read(data, this.currentSize)) < this.currentSize) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
        this.readed();
    }

    public static void throwInvalidTagSize(int tag, int tagSize, int needTagSize) {
        String msg = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u0442\u044d\u0433\u0430 tag:" + tag + " size:" + tagSize + " needSize:" + needTagSize;
        throw new TaggedReaderException(msg);
    }

    @Override
    public void checkCurrentTag(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
    }

    @Override
    public void checkCurrentTag(int tag, int tagSize) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        if (this.currentSize != tagSize) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, tagSize);
        }
    }

    public void get(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(String.format("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u044d\u0433: %d \u0432\u043c\u0435\u0441\u0442\u043e %d", this.currentTag, tag));
        }
        if (this.currentSize != 0) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 0);
        }
        this.readed();
    }

    @Override
    public boolean getBoolean() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        this.readed();
        switch (this.currentSize) {
            case 0: {
                return true;
            }
            case 1: {
                return this.stream.readByte() != 0;
            }
        }
        TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 1);
        return false;
    }

    @Override
    public boolean getBooleanDef(boolean def) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        this.readed();
        switch (this.currentSize) {
            case 0: {
                return def;
            }
            case 1: {
                return this.stream.readByte() != 0;
            }
        }
        TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 1);
        return false;
    }

    public boolean getBoolean(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        this.readed();
        switch (this.currentSize) {
            case 0: {
                return true;
            }
            case 1: {
                return this.stream.readByte() != 0;
            }
        }
        TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 1);
        return false;
    }

    public byte getByte(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        if (this.currentSize != 1) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 1);
        }
        byte val = this.stream.readByte();
        this.readed();
        return val;
    }

    @Override
    public byte getByte() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentSize != 1) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 1);
        }
        byte val = this.stream.readByte();
        this.readed();
        return val;
    }

    public short getShort() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentSize != 2) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 2);
        }
        short val = this.stream.readShort();
        this.readed();
        return val;
    }

    public int getInt(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        if (this.currentSize != 4) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 4);
        }
        int val = this.stream.readInt();
        this.readed();
        return val;
    }

    @Override
    public int getInt() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentSize != 4) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 4);
        }
        int val = this.stream.readInt();
        this.readed();
        return val;
    }

    public void skipInt() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentSize != 4) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 4);
        }
        this.stream.skipBytes(this.currentSize);
        this.readed();
    }

    @Override
    public long getUnsignedInt() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentSize != 4) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 4);
        }
        long val = this.stream.readUnsignedInt();
        this.readed();
        return val;
    }

    public long getLong() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentSize != 8) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 8);
        }
        long val = this.stream.readLong();
        this.readed();
        return val;
    }

    public double getDouble(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        if (this.currentSize != 8) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 8);
        }
        double val = this.stream.readDouble();
        this.readed();
        return val;
    }

    @Override
    public double getDouble() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentSize != 8) {
            TaggedReader.throwInvalidTagSize(this.currentTag, this.currentSize, 8);
        }
        double val = this.stream.readDouble();
        this.readed();
        return val;
    }

    public double getNodeID() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        this.skip();
        return this.getDouble(151);
    }

    public int getFieldID() throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        this.skip();
        return this.getInt(163);
    }

    public Date getDate(int tag, TimeZoneHost timeZoneHost) throws IOException, TaggedReaderException {
        double dateTimeVal = this.getDouble(tag);
        return new Date(DateTime.toUnixTime(dateTimeVal + (double)DateTime.serverTimeZoneOffset(timeZoneHost)));
    }

    public Date getDate(TimeZoneHost timeZoneHost) throws IOException, TaggedReaderException {
        double dateTimeVal = this.getDouble();
        return new Date(DateTime.toUnixTime(dateTimeVal + (double)DateTime.serverTimeZoneOffset(timeZoneHost)));
    }

    public String getAnsi(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        return this.getAnsi();
    }

    @Override
    public String getAnsi() throws IOException, TaggedReaderException {
        byte[] data;
        int bytesRead;
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if ((bytesRead = this.read(data = new byte[this.currentSize], this.currentSize)) != this.currentSize) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
        String val = new String(data, TaggedWriter.ANSI);
        this.readed();
        return val;
    }

    @Override
    public String getString() throws IOException, TaggedReaderException {
        byte[] data;
        int bytesRead;
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if ((bytesRead = this.read(data = new byte[this.currentSize])) != this.currentSize) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
        String val = bytesRead > 2 && data[0] == 7 && data[1] == 11 ? new String(data, 2, bytesRead - 2, TaggedWriter.UTF8) : new String(data, TaggedWriter.ANSI);
        this.readed();
        return val;
    }

    public String getString(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        byte[] data = new byte[this.currentSize];
        int bytesRead = this.read(data);
        if (bytesRead != this.currentSize) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
        String val = bytesRead > 2 && data[0] == 7 && data[1] == 11 ? new String(data, 2, bytesRead - 2, TaggedWriter.UTF8) : new String(data, TaggedWriter.ANSI);
        this.readed();
        return val;
    }

    public String getUnicode(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        byte[] data = new byte[this.currentSize];
        int bytesRead = this.read(data);
        if (bytesRead < this.currentSize) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
        String val = new String(data, TaggedWriter.UTF16LE);
        this.readed();
        return val;
    }

    @Override
    public String getUnicode() throws IOException, TaggedReaderException {
        byte[] data;
        int bytesRead;
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if ((bytesRead = this.read(data = new byte[this.currentSize])) < this.currentSize) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
        int size = this.currentSize;
        if (size > 1 && data[size - 1] == 0 && data[size - 2] == 0) {
            size -= 2;
        }
        String val = new String(data, 0, size, TaggedWriter.UTF16LE);
        this.readed();
        return val;
    }

    public InputStream getSubStream() throws IOException, TaggedReaderException {
        return new ByteArrayInputStream(this.getSubStreamData());
    }

    public TaggedReader getSubStreamReader() throws IOException, TaggedReaderException {
        return new TaggedReader(this.getSubStream());
    }

    public byte[] getSubStreamData() throws IOException, TaggedReaderException {
        if (this.getNextTag() != 202) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        byte[] subStreamData = new byte[this.currentSize];
        this.getRaw(subStreamData, this.currentSize);
        return subStreamData;
    }

    @Override
    public byte[] getRaw() throws IOException, TaggedReaderException {
        byte[] data;
        int bytesRead;
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if ((bytesRead = this.read(data = new byte[this.currentSize])) < this.currentSize) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
        this.readed();
        return data;
    }

    public byte[] getRaw(int tag) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        if (this.currentTag != tag) {
            throw new TaggedReaderException(INVALID_TAG_MSG);
        }
        byte[] data = new byte[this.currentSize];
        int bytesRead = this.read(data);
        if (bytesRead < this.currentSize) {
            throw new TaggedReaderException(UNEXPECTED_EOF_MSG);
        }
        this.readed();
        return data;
    }

    @Override
    public InputStream getStream() throws IOException, TaggedReaderException {
        return new ByteArrayInputStream(this.getRaw());
    }

    @Override
    public TaggedReader getStreamReader() throws IOException, TaggedReaderException {
        return new TaggedReader(this.getStream());
    }

    public InputStream getStream(int tag) throws IOException, TaggedReaderException {
        return new ByteArrayInputStream(this.getRaw(tag));
    }

    public TaggedReader getStreamReader(int tag) throws IOException, TaggedReaderException {
        return new TaggedReader(this.getStream(tag));
    }

    public void reset(InputStream dataStream) {
        this.stream = new LittleEndianDataInputStream(dataStream);
    }

    protected int read(byte[] data) throws IOException {
        int left;
        int l = 0;
        for (left = data.length; left > 0 && (l = this.stream.read(data, data.length - left, left)) >= 0; left -= l) {
        }
        return data.length - left;
    }

    protected int read(byte[] data, int length) throws IOException {
        int left;
        int l = 0;
        for (left = length; left > 0 && (l = this.stream.read(data, data.length - left, left)) >= 0; left -= l) {
        }
        return data.length - left;
    }

    @Override
    public void transferTag(TaggedWriter writer) throws IOException, TaggedReaderException {
        if (!this.isTagReady) {
            this.takeNextTag();
        }
        writer.putRaw(this.currentTag, this.getRaw());
    }

    private void readed() {
        this.isTagReady = false;
        this.reuseCurrent = false;
    }
}

