/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.agent.Core;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PhaThread
extends Thread {
    public static void daemonize(Runnable runnable) {
        new PhaThread(runnable, Type.DAEMON).start();
    }

    public static ExecutorService newFixedThreadPool(int coreThreads, int maxThreads, String name) {
        return new ThreadPoolExecutor(maxThreads, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), PhaThread.createFactory(name));
    }

    public static ThreadFactory createFactory(final String name) {
        return new ThreadFactory(){
            private final AtomicInteger idGen = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new PhaThread(r, name + "-" + this.idGen.incrementAndGet(), Type.THREAD);
            }
        };
    }

    public PhaThread(String name, Type type) {
        super(name);
        this.setDaemon(type == Type.DAEMON);
    }

    public PhaThread(Runnable runnable, String name, Type type) {
        super(runnable, name);
        this.setDaemon(type == Type.DAEMON);
    }

    public PhaThread(Runnable runnable, Type type) {
        this(runnable, runnable.getClass().getSimpleName(), type);
    }

    @Override
    public synchronized void start() {
        super.start();
        Core.setCurrentThreadName(this.getName());
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        catch (Throwable e) {
            Core.logger.error("Oops! Uncatched error:", e);
        }
    }

    public static void dumpStackTrace(StringBuilder out, StackTraceElement ... stackTrace) {
        for (StackTraceElement e : stackTrace) {
            out.append(e).append('\n');
        }
    }

    public static void dumpStackTrace(StringBuilder out, Thread thread) {
        out.append("Thread \"").append(thread.getName()).append("\" callstack:\n");
        for (StackTraceElement e : thread.getStackTrace()) {
            out.append('\t').append(e).append('\n');
        }
    }

    public static enum Type {
        THREAD,
        DAEMON;

    }
}

