/*
 * Decompiled with CFR 0.152.
 */
package inform.agent;

import inform.adt.InformException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Vfs {
    private static final String NFS_UNMOUNT_MARKER = ".nomedia";
    private static final Pattern MOUNT_POINT0 = Pattern.compile(".*[/\\\\](\\w+):.*");
    private static final Pattern MOUNT_POINT1 = Pattern.compile("(\\w+):.*");
    private static final Pattern ABSOLUTE_FILE = Pattern.compile("/?\\w+:.*");
    private final Collection<MountPoint> mountPoints = new ArrayList<MountPoint>();

    public Collection<MountPoint> getMountPoints() {
        return this.mountPoints;
    }

    public void addMountPoint(String name, String path) {
        this.mountPoints.add(new MountPoint(name, path));
    }

    public void addMountPoint(String name, String path, String rootPath) {
        this.mountPoints.add(new MountPoint(name, path, rootPath));
    }

    public void checkPath(String path) throws MalformedURLException {
        if (!ABSOLUTE_FILE.matcher(path).matches()) {
            throw new IllegalArgumentException("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0430\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 \"" + path + "\"");
        }
        HashSet<String> mpNames = new HashSet<String>();
        for (MountPoint mp : this.mountPoints) {
            mpNames.add(mp.getName());
        }
        Matcher m = MOUNT_POINT0.matcher(path);
        while (m.find()) {
            if (mpNames.contains(m.group(1))) continue;
            throw new MalformedURLException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0442\u043e\u0447\u043a\u0430 \"" + m.group(1) + ":\"");
        }
        m = MOUNT_POINT1.matcher(path);
        while (m.find()) {
            if (mpNames.contains(m.group(1))) continue;
            throw new MalformedURLException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0442\u043e\u0447\u043a\u0430 \"" + m.group(1) + ":\"");
        }
    }

    public String resolvePath(String path) {
        for (MountPoint mp : this.mountPoints) {
            path = mp.resolve(path);
        }
        return path;
    }

    public boolean hasMountPoint(String point) {
        for (MountPoint mp : this.mountPoints) {
            if (!mp.getName().equals(point)) continue;
            return true;
        }
        return false;
    }

    public URL resolve(URL url) throws MalformedURLException {
        if ("file".equals(url.getProtocol())) {
            String file = url.getFile();
            this.checkPath(file);
            String _file = this.resolvePath(file);
            if (!file.equals(_file)) {
                return new URL(url.getProtocol(), url.getHost(), _file);
            }
        }
        return url;
    }

    public File resolve(File file) throws MalformedURLException {
        String _path;
        String path = file.getPath();
        if (!path.equals(_path = this.strictResolvePath(path))) {
            return new File(_path);
        }
        return file;
    }

    public String strictResolvePath(String path) throws MalformedURLException {
        this.checkPath(path);
        return this.resolvePath(path);
    }

    public String[] getMountNames() {
        String[] names = new String[this.mountPoints.size()];
        int index = 0;
        for (MountPoint p : this.mountPoints) {
            names[index++] = p.getName();
        }
        return names;
    }

    public void checkNFSMounted(String mountPoint) {
        for (MountPoint mp : this.mountPoints) {
            if (!mp.name.equals(mountPoint) || mp.rootPath == null) continue;
            if (!new File(mp.rootPath, NFS_UNMOUNT_MARKER).exists()) break;
            String message = "\u0424\u0430\u0439\u043b\u043e\u0432\u043e\u0435 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e, \u0444\u0430\u0439\u043b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d. \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u043f\u043e\u0437\u0436\u0435 \u0438\u043b\u0438 \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443.";
            String detail = "\u0414\u043b\u044f \u043c\u0435\u0441\u0442\u0430 \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0431\u043b\u043e\u0431-\u0444\u0430\u0439\u043b\u0430 blobfs." + mountPoint + "=" + mp.rootPath + " \u043d\u0435\u0442 \u0441\u043c\u043e\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0439 \u0441\u0435\u0442\u0435\u0432\u043e\u0439 \u0444\u0430\u0439\u043b\u043e\u0432\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.";
            throw new InformException(message).detail(detail);
        }
    }

    public static class MountPoint {
        private final String name;
        private final String replacement;
        private final String rootPath;
        private final Pattern pattern;

        public MountPoint(String name, String path) {
            this(name, path, null);
        }

        public MountPoint(String name, String path, String rootPath) {
            this.name = name;
            this.replacement = Matcher.quoteReplacement((String)(path.endsWith("/") ? path : path + "/"));
            this.rootPath = rootPath == null ? null : Matcher.quoteReplacement((String)(rootPath.endsWith("/") ? rootPath : rootPath + "/"));
            this.pattern = Pattern.compile(name + ":", 2);
        }

        public String getName() {
            return this.name;
        }

        public String resolve(String path) {
            return this.pattern.matcher(path).replaceFirst(this.replacement);
        }

        public boolean matches(String path) {
            return this.pattern.matcher(path).matches();
        }

        public String getRootPath() {
            return this.rootPath;
        }
    }
}

