/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.am;

import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.RequestFactory;
import inform.common.Empty;
import java.io.ByteArrayInputStream;
import java.util.Arrays;

public abstract class AMRequest {
    protected final int request;
    protected final int flags;
    private byte[] requestContent = Empty.byteArray;

    public static byte[] JNI_execute(byte[] packetContent) throws Throwable {
        Core.logger.info("preparing AM request");
        try {
            LittleEndianDataInputStream in = new LittleEndianDataInputStream(new ByteArrayInputStream(packetContent));
            int headerSize = in.readInt();
            int magic = in.readInt();
            int requestType = in.readInt();
            int flags = in.readInt();
            int clientCount = in.readInt();
            int contentItemCount = in.readInt();
            int contentSize = in.readInt();
            Core.logger.info("executing AM request(type:{},flags:{})", (Object)requestType, (Object)flags);
            AMRequest request = RequestFactory.createAMRequest(requestType, flags);
            if (contentSize != 0) {
                request.setRequestContent(Arrays.copyOfRange(packetContent, headerSize, packetContent.length));
            }
            try {
                byte[] result = request.run();
                Core.logger.info("AM request(type:{},flags:{}) completed", (Object)requestType, (Object)flags);
                return result;
            }
            catch (Throwable e) {
                Core.logger.error("AM request failed", e);
                return Empty.byteArray;
            }
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
            throw ex;
        }
    }

    public AMRequest(int request, int flags) {
        this.request = request;
        this.flags = flags;
    }

    public abstract byte[] run() throws Throwable;

    public TaggedReader createContentReader() {
        return new TaggedReader(this.requestContent);
    }

    public byte[] getRequestContent() {
        return this.requestContent;
    }

    public void setRequestContent(byte[] requestContent) {
        this.requestContent = requestContent;
    }
}

