/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.barcode.MatrixToImageConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.EnumMap;
import javax.imageio.ImageIO;

public class BarcodeRequest
extends Request {
    public static final int TAG_BARCODE_FORMAT = 1;
    public static final int TAG_BARCODE_STRING = 2;
    public static final int TAG_BARCODE_IMAGE_FORMAT = 3;
    public static final int TAG_BARCODE_WIDTH = 4;
    public static final int TAG_BARCODE_HEIGHT = 5;
    public static final int TAG_BARCODE_STREAM = 6;
    public static final int TAG_BARCODE_ORIENTATION = 7;
    public static final int TAG_BARCODE_SYMB_VISIBLE = 8;

    public BarcodeRequest(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader reqReader = this.createRequestContentReader();
        byte[] Content2 = this.getBarcode(reqReader);
        if (Content2 != null) {
            this.sendResult(Content2);
        } else {
            this.sendResult();
        }
    }

    private byte[] getBarcode(TaggedReader reqReader) throws InformException, IOException, TaggedReaderException, Exception {
        int Format2 = -1;
        String str = "";
        int width = 0;
        int height = 0;
        String ImageFormat = "BMP";
        int Orientation = 0;
        boolean symbVisible = false;
        while (reqReader.next()) {
            switch (reqReader.getCurrentTag()) {
                case 1: {
                    Format2 = reqReader.getInt();
                    break;
                }
                case 2: {
                    str = reqReader.getString();
                    break;
                }
                case 4: {
                    width = reqReader.getInt();
                    break;
                }
                case 5: {
                    height = reqReader.getInt();
                    break;
                }
                case 3: {
                    ImageFormat = reqReader.getString();
                    break;
                }
                case 7: {
                    Orientation = reqReader.getInt();
                    break;
                }
                case 8: {
                    symbVisible = true;
                }
            }
        }
        if (symbVisible && (Format2 == 10 || Format2 == 11)) {
            symbVisible = false;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(out);
        BarcodeRequest.drawBarCode(writer, Format2, str, width, height, ImageFormat, Orientation, symbVisible);
        return out.toByteArray();
    }

    public static byte[] drawBarCode(TaggedWriter writer, int Format2, String str, int width, int height, String ImageFormat, int Orientation, boolean symbVisible) throws Exception {
        return BarcodeRequest.drawBarCode(writer, Format2, str, width, height, ImageFormat, Orientation, symbVisible, false, 0xFFFFFF, 10);
    }

    public static byte[] drawBarCode(TaggedWriter writer, int Format2, String str, int width, int height, String ImageFormat, int Orientation, boolean symbVisible, boolean borderVisible, int bgColor, int borderWidthDesired) throws Exception {
        int symbHeight = 0;
        int fontSize = 10;
        int offset = 0;
        int gapCount = 0;
        int borderWidth = borderVisible ? borderWidthDesired : 0;
        int orgWidth = width;
        int orgHeight = height;
        width -= borderWidth * 2;
        height -= borderWidth * 2;
        int r = bgColor >> 16 & 0xFF;
        int g = bgColor >> 8 & 0xFF;
        int b = bgColor & 0xFF;
        bgColor = r | g << 8 | b << 16;
        switch (Format2) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                symbHeight = 50;
                fontSize = 36;
                break;
            }
            default: {
                symbVisible = false;
            }
        }
        int w = 0;
        int h = 0;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (!str.equals("") && Format2 >= 0 && Format2 < BarcodeFormat.values().length && width > 0 && height > 0 && !ImageFormat.equals("")) {
            BarcodeFormat bFormat = BarcodeFormat.values()[Format2];
            MultiFormatWriter barcodeWriter = new MultiFormatWriter();
            EnumMap<EncodeHintType, String> hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF8");
            BitMatrix matrix = Orientation == 2 || Orientation == 3 ? barcodeWriter.encode(str, bFormat, height, width, hints) : barcodeWriter.encode(str, bFormat, width, height, hints);
            int mw = matrix.getWidth();
            int mh = matrix.getHeight();
            if (Orientation == 2 || Orientation == 3) {
                w = mh;
                h = mw;
            } else {
                w = mw;
                h = mh;
            }
            MatrixToImageConfig config = new MatrixToImageConfig(0, bgColor);
            BufferedImage image = new BufferedImage(w, h, config.getBufferedImageColorModel());
            int onColor = config.getPixelOnColor();
            int offColor = config.getPixelOffColor();
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    int mx = 0;
                    int my = 0;
                    switch (Orientation) {
                        case 1: {
                            mx = w - 1 - x;
                            my = y;
                            break;
                        }
                        case 2: {
                            mx = y;
                            my = w - 1 - x;
                            break;
                        }
                        case 3: {
                            mx = h - 1 - y;
                            my = x;
                            break;
                        }
                        default: {
                            mx = x;
                            my = y;
                        }
                    }
                    boolean matrixBool = false;
                    if (mx >= 0 && mx < mw && my >= 0 && my < mh) {
                        matrixBool = matrix.get(mx, my);
                    }
                    image.setRGB(x, y, matrixBool ? onColor : offColor);
                }
            }
            if (symbVisible) {
                Graphics2D gsi;
                BufferedImage symbImg;
                int firstPos = 0;
                int lastPos = 0;
                for (int x = 0; x < mw; ++x) {
                    if (firstPos == 0 && matrix.get(x, 0)) {
                        firstPos = x;
                    }
                    if (!matrix.get(x, 0)) continue;
                    lastPos = x;
                }
                offset = firstPos;
                if (Orientation == 2 || Orientation == 3) {
                    symbImg = new BufferedImage(symbHeight, mw, config.getBufferedImageColorModel());
                    gsi = symbImg.createGraphics();
                    gsi.setColor(new Color(offColor));
                    gsi.fillRect(0, 0, symbHeight, mw);
                } else {
                    symbImg = new BufferedImage(mw, symbHeight, config.getBufferedImageColorModel());
                    gsi = symbImg.createGraphics();
                    gsi.setColor(new Color(offColor));
                    gsi.fillRect(0, 0, mw, symbHeight);
                }
                gsi.setColor(new Color(0));
                Font font = new Font("Times New Roman", 0, fontSize);
                gsi.setFont(font);
                FontMetrics fm = gsi.getFontMetrics();
                int strWidth = fm.stringWidth(str);
                int gapWidth = fm.stringWidth(" ");
                int strLength = str.length();
                gapCount = Math.round((lastPos - firstPos - strWidth) / ((strLength - 1) * gapWidth));
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < strLength; ++i) {
                    sb.append(str.charAt(i));
                    if (i >= strLength - 1) continue;
                    for (int j = 0; j < gapCount; ++j) {
                        sb.append(" ");
                    }
                }
                if (Orientation == 2 || Orientation == 3) {
                    AffineTransform fontAT = new AffineTransform();
                    if (Orientation == 2) {
                        fontAT.quadrantRotate(1);
                    } else {
                        fontAT.quadrantRotate(3);
                    }
                    font = font.deriveFont(fontAT);
                    gsi.setFont(font);
                    if (Orientation == 2) {
                        gsi.drawString(sb.toString(), symbHeight - Math.round(fontSize), offset);
                    } else {
                        gsi.drawString(sb.toString(), Math.round(fontSize), mw - offset);
                    }
                } else {
                    gsi.drawString(sb.toString(), offset, Math.round(fontSize));
                }
                gsi.dispose();
                Graphics2D g2 = image.createGraphics();
                if (Orientation != 2 && Orientation != 3) {
                    g2.drawImage((Image)symbImg, 0, h - symbHeight, null);
                } else if (Orientation == 2) {
                    g2.drawImage((Image)symbImg, 0, 0, null);
                } else {
                    g2.drawImage((Image)symbImg, w - symbHeight, 0, null);
                }
                g2.dispose();
            }
            if (borderVisible) {
                BufferedImage bordImg = new BufferedImage(orgWidth, orgHeight, config.getBufferedImageColorModel());
                Graphics2D gbi = bordImg.createGraphics();
                gbi.setColor(new Color(offColor));
                gbi.fillRect(0, 0, orgWidth, orgHeight);
                gbi.drawImage((Image)image, borderWidth, borderWidth, null);
                gbi.dispose();
                ImageIO.write((RenderedImage)bordImg, ImageFormat, stream);
            } else {
                ImageIO.write((RenderedImage)image, ImageFormat, stream);
            }
        }
        if (writer != null) {
            writer.putInt32(4, w);
            writer.putInt32(5, h);
            writer.putRaw(6, stream.toByteArray());
            writer.flush();
        }
        return stream.toByteArray();
    }
}

