/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.Row;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.util.List;

public class BatchInsertEngine {
    protected final AbstractConnectionManager connectionManager;
    protected final DatabaseConnection database;

    public BatchInsertEngine(AbstractConnectionManager connectionManager, DatabaseConnection database) {
        this.connectionManager = connectionManager;
        this.database = database;
    }

    public void batchInsert(SSContext context, Datasource ds, double modifierUserId, double sessionId, double ownerId, double effectiveUserId, DatabaseConnection tableDatabase) throws SQLException, Exception {
        List<Row> rows = ds.getInsertedRows();
        if (rows != null && !rows.isEmpty()) {
            Row r = rows.get(0);
            TableDescriptor tableDescriptor = r.getTableDescriptor();
            TableDataAudit audit = this.database.getTableDataAudit();
            if (audit == null) {
                audit = new TableDataAudit(context, this.database, modifierUserId, effectiveUserId, 0.0, 0.0, sessionId);
                audit.setBatchMode(true);
            }
            audit.setOwnerId(ownerId);
            AbstractConnectionManager.SaveParams saveParams = new AbstractConnectionManager.SaveParams();
            saveParams.databaseConnection = this.database;
            saveParams.table = tableDescriptor;
            saveParams.audit = audit;
            PreparedStatement stmt = ds.getBatchInsertStatement();
            if (stmt == null || stmt.isClosed()) {
                DatabaseCaps caps = this.database.getDescriptor().getDatabaseType().caps();
                stmt = this.connectionManager.createInsertStatement(tableDescriptor.getFields().iterator(), tableDescriptor, this.database, caps, null);
                ds.setBatchInsertStatement(stmt);
            }
            for (Row row : rows) {
                if (tableDescriptor.getValueGeneratorCount() > 0) {
                    this.connectionManager.initAutoValueGeneratorFields(tableDescriptor, row, modifierUserId, effectiveUserId);
                }
                if (tableDescriptor.getKind() == TableDescriptor.Kind.INTERNAL) {
                    stmt.setDouble(1, row.getId());
                    this.connectionManager.assignParameters(context, 2, stmt, row, tableDescriptor.getFields().iterator(), saveParams);
                } else {
                    this.connectionManager.assignParameters(context, 1, stmt, row, tableDescriptor.getFields().iterator(), saveParams);
                }
                stmt.addBatch();
                audit.registrateAllFieldsRow(row);
            }
            stmt.executeBatch(context);
            rows.clear();
            audit.flush();
        }
    }
}

