/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.BatchInsertEngine;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.postgresql.CopyManagerStatement;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.files.BFS;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.List;
import org.postgresql.copy.CopyManager;

public class BatchInsertEnginePGSQL
extends BatchInsertEngine {
    private static final String SQL_COLUMNS = "SELECT column_name FROM information_schema.columns WHERE LOWER(table_schema) = LOWER(?) AND LOWER(table_name) = LOWER(?) ORDER BY ordinal_position";
    private static final String MESSAGE_BAD_TABLE_STRUCTURE_EXCEPTION = "\u041d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u043b\u0435\u0439  \u0438 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u043a\u043e\u043b\u043e\u043d\u043e\u043a \u0432 \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b %s";
    private static final String NULL_VALUE = "\\N";
    private static final String DLM = "\t";
    private final CopyManager cpManager;
    private static final char[][] OCTAL_VALUES = new char[256][5];

    public BatchInsertEnginePGSQL(AbstractConnectionManager connectionManager, DatabaseConnection database, CopyManager cpManager) {
        super(connectionManager, database);
        this.cpManager = cpManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchInsert(SSContext context, Datasource ds, double modifierUserID, double sessionId, double ownerId, double effectiveUserId, DatabaseConnection tableDatabase) throws SQLException, Exception {
        TableDescriptor tableDescriptor = ds.getTableDescriptor();
        int[] fieldsOrder = this.getFieldsOrderFromDatabase(context, tableDescriptor, tableDatabase);
        if (fieldsOrder == null) {
            super.batchInsert(context, ds, modifierUserID, sessionId, ownerId, effectiveUserId, tableDatabase);
            return;
        }
        List<Row> rows = ds.getInsertedRows();
        if (rows != null && !rows.isEmpty()) {
            ServerSideHost ssHost = this.connectionManager.getSSHost();
            TableDataAudit audit = tableDatabase.getTableDataAudit();
            if (audit == null) {
                audit = new TableDataAudit(context, tableDatabase, modifierUserID, effectiveUserId, 0.0, 0.0, sessionId);
                audit.setBatchMode(true);
            }
            audit.setOwnerId(ownerId);
            AbstractConnectionManager.SaveParams saveParams = new AbstractConnectionManager.SaveParams();
            saveParams.databaseConnection = tableDatabase;
            saveParams.table = tableDescriptor;
            saveParams.audit = audit;
            String sql = String.format("copy %s from STDIN", tableDatabase.getDescriptor().getTableRawName(tableDescriptor.getRawName()));
            StringBuilder sb = new StringBuilder();
            for (Row r : rows) {
                String dlm = "";
                for (int i = 0; i < fieldsOrder.length; ++i) {
                    sb.append(dlm);
                    FieldDescriptor fd = tableDescriptor.getFieldDescriptor(fieldsOrder[i]);
                    if (fd == null) {
                        throw new NullPointerException("fd is null");
                    }
                    if (!fd.isPrimaryKey() && r.getNullFlag(fd.getIndex())) {
                        if (fd.getType() == DataType.FILE) {
                            if (saveParams.bfs == null) {
                                saveParams.bfs = new BFS();
                            }
                            saveParams.bfs.delete(context, this.database.connection(), saveParams.table, fd, r.getId());
                            if (saveParams.modify) {
                                saveParams.audit.registrateSetNull(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId());
                            } else {
                                saveParams.audit.registrateSetNull(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId());
                            }
                        }
                        sb.append(NULL_VALUE);
                    } else {
                        switch (fd.getType()) {
                            case BOOLEAN: {
                                sb.append(r.getNumeric(fd.getIndex()) == 0.0 ? (char)'f' : 't');
                                break;
                            }
                            case DATE_TIME: {
                                sb.append(DateTime.toSqlTime(r.getNumeric(fd.getIndex())));
                                break;
                            }
                            case DIRECTORY: 
                            case FLOAT: 
                            case INTERVAL: 
                            case METATREE_NODE: {
                                sb.append(r.getNumeric(fd.getIndex()));
                                break;
                            }
                            case PRIMARY_KEY: {
                                sb.append(r.getId());
                                break;
                            }
                            case INTEGER: {
                                sb.append((int)r.getNumeric(fd.getIndex()));
                                break;
                            }
                            case BIG_NUMBER: 
                            case STRING: 
                            case UNICODE: {
                                this.addWrappedValue(sb, (String)r.getComplex(fd.getIndex()));
                                break;
                            }
                            case BLOB: {
                                byte[] blobData = null;
                                Object blobValue = r.getComplex(fd.getIndex());
                                if (fd.blobRawType == FieldDescriptor.BlobRawType.TEXT || fd.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) {
                                    this.addWrappedValue(sb, ValueCaster.toString(blobValue));
                                    break;
                                }
                                if (blobValue instanceof BinaryObject) {
                                    blobData = ((BinaryObject)blobValue).toByteArray();
                                } else if (blobValue instanceof String) {
                                    blobData = ((String)blobValue).getBytes(TaggedWriter.ANSI);
                                }
                                this.addWrappedValue(sb, blobData);
                                break;
                            }
                            case FILE: {
                                String fieldValue;
                                Object value;
                                BFS.checkBlobFSField(saveParams.table, fd);
                                if (saveParams.bfs == null) {
                                    saveParams.bfs = new BFS();
                                }
                                if ((value = r.getComplex(fd.getIndex())) == null) {
                                    saveParams.bfs.delete(context, this.database.connection(), saveParams.table, fd, r.getId());
                                    sb.append(NULL_VALUE);
                                    if (saveParams.modify) {
                                        saveParams.audit.registrateSetNull(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId());
                                        break;
                                    }
                                    saveParams.audit.registrateSetNull(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId());
                                    break;
                                }
                                if (value instanceof BinaryObject) {
                                    String blobPoint;
                                    byte[] blob = ((BinaryObject)value).toByteArray();
                                    try {
                                        blobPoint = saveParams.modify ? saveParams.bfs.modify(context, this.database.connection(), r.getId(), saveParams.table, fd, blob) : saveParams.bfs.insert(saveParams.table.getNodeId(), fd, r.getId(), blob);
                                    }
                                    catch (IOException e) {
                                        throw InformException.wrap(e);
                                    }
                                    this.addWrappedValue(sb, blobPoint);
                                    if (saveParams.modify) {
                                        saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId(), blobPoint);
                                        break;
                                    }
                                    saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId(), blobPoint);
                                    break;
                                }
                                if (value instanceof String) {
                                    String blobPoint;
                                    String text = (String)value;
                                    byte[] blob = text.getBytes(TaggedWriter.ANSI);
                                    try {
                                        blobPoint = saveParams.modify ? saveParams.bfs.modify(context, this.database.connection(), r.getId(), saveParams.table, fd, blob) : saveParams.bfs.insert(saveParams.table.getNodeId(), fd, r.getId(), blob);
                                    }
                                    catch (IOException e) {
                                        throw InformException.wrap(e);
                                    }
                                    this.addWrappedValue(sb, blobPoint);
                                    if (saveParams.modify) {
                                        saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId(), blobPoint);
                                        break;
                                    }
                                    saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId(), blobPoint);
                                    break;
                                }
                                assert (value instanceof BFS.BlobDigest);
                                BFS.BlobDigest blobDigest = (BFS.BlobDigest)value;
                                try {
                                    fieldValue = saveParams.bfs.upload(context, ssHost, saveParams.databaseConnection, saveParams.modify, r.getId(), saveParams.table, fd, blobDigest.digest);
                                }
                                catch (IOException e) {
                                    throw InformException.wrap(e);
                                }
                                this.addWrappedValue(sb, fieldValue);
                                if (saveParams.modify) {
                                    saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.MODIFY, fd.getId(), fieldValue);
                                    break;
                                }
                                saveParams.audit.registrateSetString(saveParams.table, r.getId(), AuditModification.APPEND, fd.getId(), fieldValue);
                                break;
                            }
                            case GEOMETRY: {
                                throw new InformException("\u0422\u0438\u043f GEOMETRY \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f COPY");
                            }
                        }
                    }
                    dlm = DLM;
                }
                sb.append("\n");
                audit.registrateAllFieldsRow(r);
            }
            StringReader reader = new StringReader(sb.toString());
            try (CopyManagerStatement stmt = new CopyManagerStatement(this.database, this.cpManager, sql);){
                stmt.executeCopy(context, reader);
            }
            rows.clear();
            audit.flush();
        }
    }

    /*
     * Exception decompiling
     */
    private int[] getFieldsOrderFromDatabase(SSContext context, TableDescriptor td, DatabaseConnection tableDatabase) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addWrappedValue(StringBuilder sb, String data) {
        if (data == null) {
            sb.append(NULL_VALUE);
        } else {
            block9: for (char c : data.toCharArray()) {
                switch (c) {
                    case '\b': {
                        sb.append("\\b");
                        continue block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block9;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block9;
                    }
                    case '\u000b': {
                        sb.append("\\v");
                        continue block9;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block9;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block9;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
        }
    }

    private void addWrappedValue(StringBuilder sb, byte[] data) {
        if (data == null) {
            sb.append(NULL_VALUE);
        } else {
            for (byte b : data) {
                sb.append(OCTAL_VALUES[b & 0xFF]);
            }
        }
    }

    static {
        for (int ii = 0; ii < 256; ++ii) {
            BatchInsertEnginePGSQL.OCTAL_VALUES[ii] = String.format("\\\\%03o", ii).toCharArray();
        }
    }
}

