/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.InformException;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.DataRow;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.SortingField;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.filters.RowFilter;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;

public class ForwardOnlyRowset
extends Rowset {
    PreparedStatement statement;
    private ResultSet queryResult;
    private ResultSetMetaData metadata;
    private FieldDescriptor[] columnsMap;

    public ForwardOnlyRowset(SSContext ssContext, AbstractConnectionManager dbManager, TableDescriptor table, PreparedStatement statement, int blobReceiving, boolean hasPrimaryKey, boolean internStrings) throws InformException, SQLException {
        super(ssContext, dbManager, table, blobReceiving, internStrings);
        this.statement = statement;
        this.queryResult = statement.executeQuery(ssContext);
        this.queryResult.usedForForwardOnlyRowsets();
        this.metadata = this.queryResult.getMetaData();
        this.columnsMap = ForwardOnlyRowset.getColumnsMap(this.metadata, table);
        this.hasRecordIdField = ForwardOnlyRowset.determineHasRecordIdField(table, this.queryResult, hasPrimaryKey);
    }

    public ForwardOnlyRowset(SSContext ssContext, AbstractConnectionManager dbManager, TableDescriptor table, int blobReceiving, boolean internStrings) throws InformException {
        super(ssContext, dbManager, table, blobReceiving, internStrings);
        this.statement = null;
        this.queryResult = null;
        this.metadata = null;
    }

    @Override
    public void appendRow(double rowId) throws InformException {
        this.curRow = new DataRow(this, this.table, rowId, true, false);
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
    }

    @Override
    public void compact() {
    }

    @Override
    public void close() throws InformException {
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
            }
            this.queryResult = null;
            if (this.statement != null) {
                this.statement.close();
            }
            this.statement = null;
        }
        catch (SQLException ex) {
            throw InformException.wrap(ex);
        }
        super.close();
    }

    @Override
    public boolean next() throws InformException {
        try {
            if (this.queryResult == null) {
                this.curRow = null;
                return false;
            }
            ++this.curRowIndex;
            if (!this.queryResult.next()) {
                this.curRow = null;
                this.queryResult.close();
                this.queryResult = null;
                this.statement.close();
                this.statement = null;
                return false;
            }
            this.curRow = this.createRowFromQueryResult(this.queryResult, this.columnsMap);
            if (this.profile != null) {
                this.profile.incRecordCount();
            }
            return true;
        }
        catch (IOException | SQLException ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    public boolean prev() throws InformException {
        throw new UnsupportedOperationException("\u0414\u0432\u0438\u0436\u0435\u043d\u0438\u0435 \u043d\u0430\u0437\u0430\u0434 \u0432 \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430\u0445 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Reset() \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432");
    }

    @Override
    public void filter(RowFilter filter) {
        throw new UnsupportedOperationException("\u0424\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u044f \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public void clearFilter() {
        throw new UnsupportedOperationException("\u0424\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u044f \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public int getRecordIndex() {
        return this.curRowIndex;
    }

    @Override
    public void setRecordIndex(int index) {
        throw new UnsupportedOperationException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043a \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u0443 \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public boolean locate(RowFilter ... args) {
        throw new UnsupportedOperationException("locate() \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430\u0445.");
    }

    @Override
    public void editRow(double rowId) throws InformException {
        this.curRow = new DataRow(this, this.table, rowId, false, false);
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
    }

    @Override
    public void reuseRow() {
        if (this.curRow == null) {
            throw new UnsupportedOperationException("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u0438.");
        }
        this.curRow.reuse(this.table);
    }

    @Override
    public boolean setRecord(double rowId) {
        throw new UnsupportedOperationException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043a \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u0443 \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public void setRecord(Row record) {
        throw new UnsupportedOperationException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043a \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u0443 \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public void sort(Collection<SortingField> sorting) throws InformException {
        throw new UnsupportedOperationException("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }
}

