/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.InformException;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.SortDirection;
import inform.agent.db.SortField;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.types.DataType;
import inform.agent.scripts.Directory;
import java.util.ArrayList;
import java.util.Comparator;

public class SortingField
implements Comparator<Row> {
    private final FieldDescriptor field;
    private final int fieldIndex;
    private final boolean fieldNumeric;
    private final SortDirection direction;
    private final boolean nullIsLeast;
    private ArrayList<DirectorySorting> fieldPath = null;
    public final boolean stringField;

    public SortingField(FieldDescriptor descriptor, SortDirection direction, DatabaseCaps caps, int nullSortKind) {
        this.field = descriptor;
        this.fieldIndex = this.field.getIndex();
        DataType ft = this.field.getType();
        this.fieldNumeric = ft.isNumeric();
        this.direction = direction;
        this.nullIsLeast = caps.isNullFirst(nullSortKind);
        this.stringField = ft == DataType.STRING || ft == DataType.UNICODE;
    }

    public SortingField(TableDescriptor tableDescriptor, int nullSortKind, FieldDescriptor fieldDescriptor, SortDirection direction, int[] fieldPath) throws InformException {
        this.field = fieldDescriptor;
        this.fieldIndex = fieldDescriptor.getIndex();
        DataType ft = this.field.getType();
        this.fieldNumeric = ft.isNumeric();
        this.direction = direction;
        this.nullIsLeast = tableDescriptor.getDatabaseDescriptor().getDatabaseType().caps().isNullFirst(nullSortKind);
        boolean bl = this.stringField = ft == DataType.STRING || ft == DataType.UNICODE;
        if (fieldPath != null && fieldPath.length > 1) {
            this.fieldPath = new ArrayList();
            FieldDescriptor referenceField = fieldDescriptor;
            this.fieldPath.add(new DirectorySorting(tableDescriptor, fieldDescriptor));
            for (int index = 1; index < fieldPath.length; ++index) {
                int id = fieldPath[index];
                TableDescriptor referenceTable = TableDescriptor.get(referenceField.getReferenceId());
                referenceField = referenceTable.getFieldDescriptor(id);
                this.fieldPath.add(new DirectorySorting(referenceTable, referenceField));
            }
        }
    }

    public void transferTo(SqlGenerator generator) {
        SortField sf = generator.addSortField();
        this.transferTo(sf);
    }

    public void transferTo(SortField sf) {
        sf.setAscending(this.direction == SortDirection.ASCENDING);
        if (this.fieldPath != null && !this.fieldPath.isEmpty()) {
            sf.addField(this.fieldPath.get((int)(this.fieldPath.size() - 1)).field.id);
            for (int i = this.fieldPath.size() - 1; i > 0; --i) {
                DirectorySorting d = this.fieldPath.get(i);
                DirectorySorting p = this.fieldPath.get(i - 1);
                sf.addField(d.table.getNodeId(), p.field.getId());
            }
        } else {
            sf.addField(this.field.getId());
        }
    }

    public FieldDescriptor getField() {
        return this.field;
    }

    public SortDirection getDirection() {
        return this.direction;
    }

    private int compareObjects(Object o1, Object o2) {
        return ((Comparable)o1).compareTo(o2);
    }

    @Override
    public int compare(Row r1, Row r2) {
        int result;
        if (this.field.getId() == -1) {
            return Double.compare(r1.getId(), r2.getId());
        }
        boolean n1 = r1.getNullFlag(this.fieldIndex);
        boolean n2 = r2.getNullFlag(this.fieldIndex);
        if (n1 || n2) {
            if (n1 && n2) {
                return 0;
            }
            result = n1 ? (this.nullIsLeast ? -1 : 1) : (this.nullIsLeast ? 1 : -1);
        } else if (this.fieldNumeric) {
            result = Double.compare(r1.getNumeric(this.fieldIndex), r2.getNumeric(this.fieldIndex));
        } else if (this.stringField && this.field.isRightPadded()) {
            String s1 = r1.getComplex(this.fieldIndex).toString();
            String s2 = r2.getComplex(this.fieldIndex).toString();
            result = s1.length() - s2.length();
            if (result == 0) {
                result = s1.compareTo(s2);
            }
        } else {
            result = this.compareObjects(r1.getComplex(this.fieldIndex), r2.getComplex(this.fieldIndex));
        }
        if (this.direction == SortDirection.DESCENDING) {
            return -result;
        }
        return result;
    }

    private static class DirectorySorting {
        final TableDescriptor table;
        final FieldDescriptor field;
        Directory directory = null;
        RowsetAccessor rowset = null;

        DirectorySorting(TableDescriptor table, FieldDescriptor field) {
            this.table = table;
            this.field = field;
        }
    }
}

