/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.IntegerList;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableLinkList;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.TableDirectoryDependencis;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableDescriptor {
    public static final int HISTORY_COMMENT_LENGTH = 512;
    public static final int USER_AGENT_LENGTH = 512;
    private static final byte[] EMPTY_CONTENT = new byte[0];
    public static final int TAG_FIELD_ID = 10;
    public static final int TAG_FIELD_IDENT = 19;
    public static final int TAG_FIELD_RAW_NAME = 11;
    public static final int TAG_FIELD_TYPE = 12;
    public static final int TAG_FIELD_NAME = 13;
    public static final int TAG_FIELD_SIZE = 14;
    public static final int TAG_TBL_REFERENCE_ID = 16;
    public static final int TAG_TBL_REF_FIELD_ID = 17;
    public static final int TAG_TBL_FIELD_NOT_NULL = 26;
    public static final int TAG_TBL_FIELD_USE_FOR_PARAMS = 38;
    public static final int TAG_TBL_FIELD_RAW_BLOB_TYPE = 39;
    public static final int TAG_FIELD_KIND = 40;
    public static final int TAG_TBL_FIELD_MULTILOOKUP_INFO = 41;
    public static final int TAG_TBL_LOOKUP_REF_FIELD_ID = 1;
    public static final int TAG_TBL_LOOKUP_DISPLAY_FIELD_ID = 3;
    public static final int TAG_PRIMARY_KEY_RAW_NAME = 42;
    public static final int TAG_PRIMARY_KEY_TYPE = 43;
    public static final int TAG_TBL_FIELD_BLOBFS = 44;
    public static final int TAG_TBL_FIELD_BLOBFS_TYPE = 46;
    public static final int TAG_EXTERNAL_STRUCTURE_MANAGED = 48;
    public static final int TAG_TBL_FIELD_IS_PRIMARY_KEY = 55;
    public static final int TAG_FIELD_IS_ALTERNATIVE_KEY = 56;
    public static final int TAG_TBL_FIELD_VALUE_GENERATOR = 58;
    public static final int TAG_TBL_SEARCH_CONDITION = 61;
    public static final int TAG_TBL_PERIODIC_STORAGE = 62;
    public static final int TAG_TBL_PERIODIC_FIELD = 63;
    public static final int TAG_TBL_FIELD_FOREIGN_KEY = 64;
    public static final int TAG_TBL_FIELD_FOREIGN_KEY_CASCADE_DELETE = 65;
    public static final int TAG_TBL_FIELD_DONT_CHECK_REFERENCES = 66;
    public static final int TAG_TBL_FIELD_MULTIPLEWRITEPROTECTION = 67;
    public static final int TAG_TBL_FIELD_MWP_LABEL = 68;
    public static final int TAG_TBL_FIELD_PRECISION = 69;
    public static final int TAG_TBL_DATABASE_ID = 20;
    public static final int TAG_TBL_FORMAT = 21;
    public static final int TAG_TBL_TABLE_RAW_NAME = 23;
    public static final int TAG_TBL_SORT_RIGHT = 24;
    public static final int TAG_TABLE_KIND = 27;
    public static final int TAG_IGNORE_DELETE_ELEMENTS = 29;
    public static final int TAG_IGNORE_REF_INTEGRETY = 30;
    public static final int TAG_TBL_AUDIT_DISABLED = 34;
    public static final int TAG_TBL_PRIMARY_KEY_RAW_NAME = 42;
    public static final int TAG_TBL_LINKS = 45;
    public static final int TAG_TBL_INDEXES = 47;
    public static final int TAG_TBL_AUDIT_TYPE = 60;
    public static final int TAG_TBL_FIELD_VALUE_GENERATOR_NAME = 71;
    public static final int TAG_TBL_FIELD_VALUE_GENERATOR_FIELD = 72;
    public static final int TAG_TBL_FIELD_INTERVAL_STORE_FORMAT = 73;
    public static final int TAG_TBL_FIELD_NOT_ZERO = 74;
    public static final int TAG_TBL_FIELD_VALUE_GENERATOR_OPTIONS = 75;
    public static final int TAG_TBL_FIELD_DETAIL_AUDIT = 76;
    public static final int TAG_TBL_FIELD_DELETE_AUDIT = 77;
    public static final int TAG_TBL_AUDIT_SAVE_PREV = 78;
    public static final int TAG_TBL_FIELD_FOREIGN_KEY_RAW_NAME = 80;
    public static final int TAG_TBL_FIELD_FLOAT_RAW_FORMAT = 81;
    public static final int TAG_TBL_FIELD_DEF_VALUE_NUMBER = 82;
    public static final int TAG_TBL_FIELD_DEF_VALUE_STRING = 83;
    public static final int TAG_TBL_FIELD_POSTGRESQL_REVIEW = 84;
    public static final int TAG_TBL_FIELD_TEXT_EXTRACTION = 85;
    public static final int TAG_TBL_FIELD_TEXT_EXTRACTION_FIELD_ID = 1;
    private double dbId;
    private String rawName;
    private String nodeName = null;
    private List<FieldDescriptor> fields;
    private double nodeId;
    private Kind kind;
    private AuditType auditType;
    private boolean auditSavePrev;
    private final ArrayList<FieldDescriptor> primaryKeyFields = new ArrayList();
    private FieldDescriptor recordIdField;
    private HashMap<String, FieldDescriptor> fieldsByRawName = new HashMap();
    private int valueGeneratorCount;
    private TableLinkList linkList = null;
    private byte[] dataLinksContent = null;
    private DoubleHash<PeriodicTableStorage> periodicTableStorages = null;
    private ArrayList<PeriodicTableStorage> periodicTableStorageList = null;
    private boolean checkReferringIntegrity = true;
    private boolean cascadeDeleteElements = true;
    private boolean hasMultipleWriteProtection = false;
    private int mwpAllFieldsLabel = 0;
    private boolean externalStructureManaged;
    private byte[] rawSearchConditions;
    private List<IndexDescriptor> indexes = new ArrayList<IndexDescriptor>();
    private boolean hasComplexFields;
    private boolean hasLobs;
    private boolean hasBlobFile = false;
    private boolean hasDeleteDataAudit = false;
    private int alternativeKeyCount = 0;
    private static TableDescriptor systemMtdTree;
    private static TableDescriptor systemMtdTreeLog;
    private static TableDescriptor systemMtdConfNodes;
    private static TableDescriptor systemMtdConf;
    private static TableDescriptor systemMtdAgents;
    private static TableDescriptor systemMtdLocks;
    private static TableDescriptor systemMtdTickets;
    private static TableDescriptor systemMtdPersistentSessions;
    private String logNodeId = null;

    public DatabaseDescriptor getDatabaseDescriptor() {
        if (this.dbId == 2.0) {
            return DatabaseDescriptor.getMetabase();
        }
        Node node = MtdEngine.getValidNode(this.dbId);
        if (!(node instanceof DatabaseNode)) {
            MtdEngine.throwError(this.dbId, " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0443\u0437\u043b\u043e\u043c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f");
        }
        return ((DatabaseNode)MtdEngine.getValidNode(this.dbId)).getDescriptor();
    }

    public DatabaseDescriptor getDbDescIfExists() {
        if (this.dbId == 2.0) {
            return DatabaseDescriptor.getMetabase();
        }
        if (this.dbId == 0.0) {
            return null;
        }
        Node node = MtdEngine.getNode(this.dbId);
        if (node == null) {
            return null;
        }
        if (!(node instanceof DatabaseNode)) {
            return null;
        }
        return ((DatabaseNode)node).getDescriptor();
    }

    public static TableDescriptor get(double nodeId) {
        Node node = MtdEngine.getNode(nodeId);
        if (node == null) {
            MtdEngine.throwDetailError("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", nodeId);
        }
        if (!(node instanceof TableNode)) {
            if (nodeId == 0.0) {
                MtdEngine.throwDetailError("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", nodeId);
            }
            MtdEngine.throwDetailError("\u0423\u0437\u0435\u043b \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0435\u0439", nodeId);
        }
        return ((TableNode)node).getDescriptor();
    }

    public static TableDescriptor getIfExists(double nodeId) {
        Node node = MtdEngine.getNode(nodeId);
        if (node == null) {
            return null;
        }
        if (!(node instanceof TableNode)) {
            return null;
        }
        return ((TableNode)node).getDescriptor();
    }

    public TableDescriptor(double nodeId, boolean fullLoad) {
        this(nodeId, MtdEngine.getNodeContent(nodeId), fullLoad);
    }

    public TableDescriptor(double nodeId, byte[] content) {
        this(nodeId, content, true);
    }

    public TableDescriptor(double nodeId, byte[] content, boolean fullLoad) {
        this.fields = new ArrayList<FieldDescriptor>();
        this.nodeId = nodeId;
        this.valueGeneratorCount = 0;
        try {
            this.load(new TaggedReader(new ByteArrayInputStream(content == null ? EMPTY_CONTENT : content)), fullLoad);
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
    }

    public TableDescriptor(String rawName, Kind kind) {
        this.fields = new ArrayList<FieldDescriptor>();
        this.rawName = rawName;
        this.kind = kind;
        this.dbId = 2.0;
    }

    public TableDescriptor(String rawName, Kind kind, FieldDescriptor[] fields) {
        this(rawName, kind);
        this.fields = Arrays.asList(fields);
    }

    public void addIndex(IndexDescriptor index) {
        this.indexes.add(index);
    }

    private static IndexDescriptor getIndexDescriptorByParseErrorMsg(String msg) {
        String idxName = "";
        String idxFields = "";
        Pattern oraReg = Pattern.compile("ORA-00001: UNIQUE CONSTRAINT \\((\\w+.\\w+)\\)", 8);
        Pattern pgSqlReg = Pattern.compile("DUPLICATE KEY VALUE VIOLATES UNIQUE CONSTRAINT \"(\\w+)\"\\s+DETAIL: KEY \\(([\\w,\\s]+)\\)", 8);
        Pattern h2Reg = Pattern.compile("UNIQUE INDEX OR PRIMARY KEY VIOLATION:\\s+\"([A-Z0-9_.\\s]+) ON \\w+.\\w+\\(([\\w,\\s]+)\\)", 8);
        Matcher m = pgSqlReg.matcher(msg);
        if (m.find(0)) {
            idxName = m.group(1);
            idxFields = m.group(2);
        } else {
            m = oraReg.matcher(msg);
            if (m.find(0)) {
                idxName = m.group(1);
            } else {
                m = h2Reg.matcher(msg);
                if (m.find(0)) {
                    idxName = m.group(1);
                    idxFields = m.group(2);
                }
            }
        }
        if (idxName.isEmpty()) {
            return null;
        }
        if (idxFields.isEmpty()) {
            return new IndexDescriptor(-1, idxName, new FieldDescriptor[0]);
        }
        String[] strFields = idxFields.split(", ");
        FieldDescriptor[] fdList = new FieldDescriptor[strFields.length];
        for (int i = 0; i < strFields.length; ++i) {
            fdList[i] = new FieldDescriptor(i, i, strFields[i], strFields[i], 0.0);
        }
        return new IndexDescriptor(-1, idxName, fdList);
    }

    public IndexDescriptor extractIndexFromMessage(String msg) {
        if (msg == null) {
            return null;
        }
        msg = msg.toUpperCase();
        IndexDescriptor findedIndex = null;
        String findedName = null;
        for (IndexDescriptor index : this.indexes) {
            String indexName;
            if (Strings.isVoid(index.rawName) || !msg.contains(indexName = index.rawName.toUpperCase()) || findedName != null && findedName.length() >= indexName.length()) continue;
            findedIndex = index;
            findedName = indexName;
        }
        if (findedIndex == null) {
            findedIndex = TableDescriptor.getIndexDescriptorByParseErrorMsg(msg);
        }
        return findedIndex;
    }

    public double[] getReferences(ServerSideHost ssHost) throws SQLException, IOException, TaggedReaderException {
        return TableDirectoryDependencis.getReferencesToTable(this.nodeId, ssHost);
    }

    public boolean isRealTable() {
        if (this.kind != Kind.INTERNAL && this.kind != Kind.EXTERNAL) {
            return false;
        }
        if (this.dbId == 0.0) {
            return false;
        }
        return this.rawName != null && !this.rawName.isEmpty();
    }

    public boolean isOperableTable() {
        return this.isRealTable() && !this.primaryKeyFields.isEmpty();
    }

    public boolean isViewable() {
        if (this.kind != Kind.INTERNAL && this.kind != Kind.EXTERNAL) {
            return false;
        }
        if (this.dbId == 0.0) {
            return false;
        }
        if (this.rawName == null || this.rawName.isEmpty()) {
            return false;
        }
        return false;
    }

    public boolean isHasClusteredIndex() {
        for (IndexDescriptor id : this.indexes) {
            if (!id.isClustered()) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckReferringIntegrity() {
        return this.checkReferringIntegrity;
    }

    public boolean isCascadeDeleteElements() {
        return this.cascadeDeleteElements;
    }

    public FieldDescriptor getFieldDescriptor(int fieldId) {
        if (fieldId == -1) {
            return this.recordIdField;
        }
        for (FieldDescriptor f : this.fields) {
            if (f.getId() != fieldId) continue;
            return f;
        }
        return null;
    }

    public FieldDescriptor getValidFieldDescriptor(int fieldId, String msg) {
        FieldDescriptor field = this.getFieldDescriptor(fieldId);
        if (field == null) {
            StringBuilder detailing = new StringBuilder();
            detailing.append("[\u0442\u0430\u0431\u043b\u0438\u0446\u0430: ").append(this.toString()).append(" id \u043f\u043e\u043b\u044f: ").append(fieldId).append(']');
            if (msg == null) {
                msg = "\u041f\u043e\u043b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e";
            }
            throw new InformException(msg).detail(detailing.toString());
        }
        return field;
    }

    public IndexDescriptor getIndexDescriptor(int idxId) {
        for (IndexDescriptor id : this.indexes) {
            if (id.getId() != idxId) continue;
            return id;
        }
        return null;
    }

    public FieldDescriptor getExistingFieldDescriptor(int fieldId) {
        FieldDescriptor field = this.getFieldDescriptor(fieldId);
        if (field != null) {
            return field;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("\u041f\u043e\u043b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e [\u0442\u0430\u0431\u043b\u0438\u0446\u0430: ").append(this.toString()).append(" id \u043f\u043e\u043b\u044f: ").append(fieldId).append(']');
        throw new InformException(msg.toString());
    }

    public void checkFieldExists(int fieldId) {
        FieldDescriptor field = this.getFieldDescriptor(fieldId);
        if (field != null) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("\u041f\u043e\u043b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e [\u0442\u0430\u0431\u043b\u0438\u0446\u0430: ").append(this.toString()).append(" id \u043f\u043e\u043b\u044f: ").append(fieldId).append(']');
        throw new InformException(msg.toString());
    }

    public boolean isHasBlobFile() {
        return this.hasBlobFile;
    }

    private FieldDescriptor.PeriodicFieldStorage loadPeriodicFieldStorage(TaggedReader in) throws IOException {
        boolean TAG_TBL_PERIODIC_FIELD_MAP_TABLE = true;
        int TAG_TBL_PERIODIC_FIELD_MAP_FIELD = 2;
        double tableId = 0.0;
        int fieldId = 0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    tableId = in.getNodeID();
                    break;
                }
                case 2: {
                    fieldId = in.getInt();
                }
            }
        }
        if (tableId != 0.0 && fieldId != 0) {
            return new FieldDescriptor.PeriodicFieldStorage(fieldId, tableId);
        }
        return null;
    }

    private PeriodicTableStorage loadPeriodicTableStorage(TaggedReader in) throws IOException {
        boolean TAG_TBL_PERIODIC_ITEM_TABLE = true;
        int TAG_TBL_PERIODIC_ITEM_FIELD_REFERENCE = 2;
        int TAG_TBL_PERIODIC_ITEM_FIELD_BEGIN_DATE = 3;
        int TAG_TBL_PERIODIC_ITEM_FIELD_END_DATA = 4;
        double tableId = 0.0;
        int ref = 0;
        int beg = 0;
        int end = 0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    tableId = in.getNodeID();
                    break;
                }
                case 2: {
                    ref = in.getInt();
                    break;
                }
                case 3: {
                    beg = in.getInt();
                    break;
                }
                case 4: {
                    end = in.getInt();
                }
            }
        }
        if (tableId == 0.0 || ref == 0 || beg == 0 || end == 0) {
            return null;
        }
        return new PeriodicTableStorage(tableId, ref, beg, end);
    }

    private void loadPeriodicTableStorages(TaggedReader in) throws IOException {
        boolean TAG_TBL_PERIODIC_ITEM = true;
        this.periodicTableStorageList = null;
        this.periodicTableStorages = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    in.skip();
                    PeriodicTableStorage p = this.loadPeriodicTableStorage(in.getSubStreamReader());
                    if (p == null) break;
                    if (this.periodicTableStorages == null) {
                        this.periodicTableStorages = new DoubleHash();
                    }
                    this.periodicTableStorages.add(p);
                    if (this.periodicTableStorageList == null) {
                        this.periodicTableStorageList = new ArrayList();
                    }
                    this.periodicTableStorageList.add(p);
                }
            }
        }
    }

    private IntegerSet loadTextExtractionFields(TaggedReader in) throws IOException {
        IntegerSet fieldIDs = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    if (fieldIDs == null) {
                        fieldIDs = new IntegerSet();
                    }
                    fieldIDs.add(in.getInt());
                }
            }
        }
        return fieldIDs;
    }

    /*
     * WARNING - void declaration
     */
    private void load(TaggedReader in, boolean fullLoad) throws IOException, TaggedReaderException {
        boolean bl;
        int i;
        int fieldValueGeneratorType = 0;
        double TempDbl = 0.0;
        FieldDescriptor fieldDescriptor = new FieldDescriptor(-1);
        String primaryKeyName = null;
        this.kind = Kind.INTERNAL;
        this.auditSavePrev = false;
        block90: while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 10: {
                    if (fieldDescriptor != null) {
                        fieldDescriptor.setValueGeneratorType(fieldValueGeneratorType);
                    }
                    fieldValueGeneratorType = 0;
                    fieldDescriptor = new FieldDescriptor(this.fields.size());
                    this.fields.add(fieldDescriptor);
                    fieldDescriptor.id = in.getInt();
                    break;
                }
                case 19: {
                    fieldDescriptor.ident = in.getAnsi();
                    break;
                }
                case 12: {
                    fieldDescriptor.type = DataType.getDataTypeById(in.getInt());
                    if (fieldDescriptor.type != DataType.BIG_NUMBER) break;
                    fieldDescriptor.size = 100;
                    break;
                }
                case 11: {
                    fieldDescriptor.rawName = in.getAnsi();
                    if (fieldDescriptor.getIndex() < 0) break;
                    this.fieldsByRawName.put(fieldDescriptor.rawName, fieldDescriptor);
                    break;
                }
                case 55: {
                    fieldDescriptor.isPrimaryKey = true;
                    break;
                }
                case 56: {
                    fieldDescriptor.isAlternative = true;
                    ++this.alternativeKeyCount;
                    break;
                }
                case 40: {
                    fieldDescriptor.kind = in.getInt();
                    break;
                }
                case 41: {
                    void var9_8;
                    Iterator<FieldDescriptor> r = in.getSubStreamReader();
                    Object var9_9 = null;
                    while (((TaggedReader)((Object)r)).next()) {
                        switch (((TaggedReader)((Object)r)).getCurrentTag()) {
                            case 1: {
                                if (var9_8 != null) {
                                    fieldDescriptor.multiLookupFields.add(new FieldDescriptor.LookupField(var9_8.toArray()));
                                    var9_8.clear();
                                } else {
                                    fieldDescriptor.multiLookupFields = new ArrayList<FieldDescriptor.LookupField>(2);
                                    IntegerList integerList = new IntegerList(2);
                                }
                                var9_8.add(((TaggedReader)((Object)r)).getInt());
                                break;
                            }
                            case 3: {
                                assert (var9_8 != null);
                                int fid = ((TaggedReader)((Object)r)).getInt();
                                if (fid == var9_8.get(var9_8.size() - 1)) break;
                                var9_8.add(fid);
                            }
                        }
                    }
                    if (var9_8 == null) break;
                    fieldDescriptor.multiLookupFields.add(new FieldDescriptor.LookupField(var9_8.toArray()));
                    break;
                }
                case 16: {
                    in.skip();
                    fieldDescriptor.referenceId = in.getDouble(151);
                    break;
                }
                case 17: {
                    fieldDescriptor.refFieldId = in.getInt();
                    break;
                }
                case 26: {
                    in.skip();
                    fieldDescriptor.nullable = false;
                    break;
                }
                case 13: {
                    fieldDescriptor.caption = in.getAnsi();
                    break;
                }
                case 14: {
                    fieldDescriptor.size = in.getInt();
                    break;
                }
                case 58: {
                    fieldValueGeneratorType = in.getInt();
                    break;
                }
                case 72: {
                    fieldDescriptor.valueGeneratorField = in.getInt();
                    break;
                }
                case 71: {
                    fieldDescriptor.valueGeneratorName = in.getAnsi();
                    break;
                }
                case 75: {
                    fieldDescriptor.valueGeneratorOptions = in.getInt();
                    break;
                }
                case 76: {
                    fieldDescriptor.detailAudit = true;
                    break;
                }
                case 77: {
                    this.hasDeleteDataAudit = true;
                    fieldDescriptor.deleteDataAudit = true;
                    break;
                }
                case 44: {
                    fieldDescriptor.blobFS = in.getString();
                    this.hasBlobFile = true;
                    break;
                }
                case 46: {
                    fieldDescriptor.blobFSType = in.getInt();
                    break;
                }
                case 42: {
                    primaryKeyName = in.getAnsi();
                    break;
                }
                case 20: {
                    this.dbId = in.getNodeID();
                    break;
                }
                case 23: {
                    this.rawName = in.getAnsi();
                    break;
                }
                case 27: {
                    this.kind = Kind.getById(in.getInt());
                    break;
                }
                case 34: {
                    this.auditType = AuditType.NONE;
                    break;
                }
                case 60: {
                    this.auditType = AuditType.getById(in.getInt());
                    break;
                }
                case 78: {
                    this.auditSavePrev = true;
                    break;
                }
                case 45: {
                    if (!fullLoad) break;
                    in.skip();
                    this.dataLinksContent = in.getSubStreamData();
                    break;
                }
                case 47: {
                    if (in.getNextTag() != 202) break;
                    TaggedReader stream = in.getStreamReader();
                    IndexDescriptor index = null;
                    while (stream.getNextTag() != 0) {
                        switch (stream.getCurrentTag()) {
                            case 1: {
                                index = new IndexDescriptor(stream.getInt());
                                this.indexes.add(index);
                                break;
                            }
                            case 2: {
                                index.name = stream.getAnsi();
                                break;
                            }
                            case 3: {
                                int idx = stream.getInt();
                                FieldDescriptor fd = this.getFieldDescriptor(idx);
                                index.fields.add(fd);
                                break;
                            }
                            case 4: {
                                index.unique = true;
                                break;
                            }
                            case 20: {
                                index.strongUnique = true;
                                break;
                            }
                            case 5: {
                                index.rawName = stream.getAnsi();
                                break;
                            }
                            case 6: {
                                index.uniqueErrorMsg = stream.getAnsi();
                                break;
                            }
                            case 7: {
                                index.clustered = true;
                                break;
                            }
                            case 8: {
                                index.compressedFieldsCount = stream.getInt();
                                break;
                            }
                            case 9: {
                                index.bitmap = true;
                                break;
                            }
                            case 10: {
                                index.Dim1Min = TempDbl = stream.getDouble();
                                index.SDOType = true;
                                break;
                            }
                            case 11: {
                                index.Dim1Max = TempDbl = stream.getDouble();
                                index.SDOType = true;
                                break;
                            }
                            case 12: {
                                index.Dim2Min = TempDbl = stream.getDouble();
                                index.SDOType = true;
                                break;
                            }
                            case 13: {
                                index.Dim2Max = TempDbl = stream.getDouble();
                                index.SDOType = true;
                                break;
                            }
                            case 14: {
                                index.DimTolerance = TempDbl = stream.getDouble();
                                index.SDOType = true;
                                break;
                            }
                            case 16: {
                                index.databaseMask = stream.getInt();
                                break;
                            }
                            case 18: {
                                index.method = IndexDescriptor.Method.toMethod(stream.getInt());
                                break;
                            }
                            case 21: {
                                index.useTGRM = true;
                                break;
                            }
                            case 19: {
                                ArrayList<IndexDescriptor.ConditionItemLoaded> loaded = new ArrayList<IndexDescriptor.ConditionItemLoaded>();
                                TaggedReader s = stream.getSubStreamReader();
                                IndexDescriptor.ConditionItemLoaded item = null;
                                while (s.next()) {
                                    block78 : switch (s.getCurrentTag()) {
                                        case 1: {
                                            item = null;
                                            FieldDescriptor field = this.getFieldDescriptor(s.getInt());
                                            if (field == null) break;
                                            item = new IndexDescriptor.ConditionItemLoaded();
                                            item.field = field;
                                            loaded.add(item);
                                            break;
                                        }
                                        case 2: {
                                            if (item == null) break;
                                            item.value = s.getString();
                                            break;
                                        }
                                        case 3: {
                                            if (item == null) break;
                                            switch (s.getInt()) {
                                                case 1: {
                                                    item.isNull = true;
                                                    break block78;
                                                }
                                                case 2: {
                                                    item.isNotNull = true;
                                                }
                                            }
                                        }
                                    }
                                }
                                if (loaded.isEmpty()) break;
                                Collections.sort(loaded);
                                ArrayList<IndexDescriptor.ConditionItem> condition = new ArrayList<IndexDescriptor.ConditionItem>();
                                IndexDescriptor.ConditionItem cc = new IndexDescriptor.ConditionItem((IndexDescriptor.ConditionItemLoaded)loaded.get(0));
                                condition.add(cc);
                                for (int i2 = 1; i2 < loaded.size(); ++i2) {
                                    IndexDescriptor.ConditionItemLoaded c = (IndexDescriptor.ConditionItemLoaded)loaded.get(i2);
                                    if (c.field.getId() == cc.fieldId) {
                                        if (c.isNull) {
                                            cc.isNull = true;
                                            continue;
                                        }
                                        if (c.isNotNull) {
                                            cc.isNotNull = true;
                                            continue;
                                        }
                                        cc.values.add(c.value);
                                        continue;
                                    }
                                    Collections.sort(cc.values);
                                    cc = new IndexDescriptor.ConditionItem(c);
                                    condition.add(cc);
                                }
                                Collections.sort(cc.values);
                                DatabaseDescriptor databaseDescriptor = this.getDatabaseDescriptor();
                                DatabaseCaps caps = databaseDescriptor.getDatabaseType().caps();
                                StringBuilder sb = new StringBuilder();
                                for (int i3 = 0; i3 < condition.size(); ++i3) {
                                    cc = (IndexDescriptor.ConditionItem)condition.get(i3);
                                    cc.toSql(caps, sb);
                                }
                                index.condition = sb.toString();
                            }
                        }
                    }
                    continue block90;
                }
                case 61: {
                    in.skip();
                    this.rawSearchConditions = in.getRaw();
                    break;
                }
                case 62: {
                    in.skip();
                    this.loadPeriodicTableStorages(in.getSubStreamReader());
                    break;
                }
                case 63: {
                    in.skip();
                    fieldDescriptor.periodicStorage = this.loadPeriodicFieldStorage(in.getSubStreamReader());
                    break;
                }
                case 66: {
                    fieldDescriptor.dontCheckRefs = true;
                    break;
                }
                case 21: {
                    fieldDescriptor.format = in.getInt();
                    break;
                }
                case 24: {
                    fieldDescriptor.isRightPadded = true;
                    break;
                }
                case 29: {
                    this.cascadeDeleteElements = false;
                    break;
                }
                case 30: {
                    this.checkReferringIntegrity = false;
                    break;
                }
                case 48: {
                    this.externalStructureManaged = true;
                    break;
                }
                case 67: {
                    int mwp = in.getInt();
                    fieldDescriptor.multipleWriteProtection = FieldDescriptor.MultipleWriteProtection.get(mwp);
                    break;
                }
                case 68: {
                    fieldDescriptor.mwpLabel = in.getInt();
                    break;
                }
                case 38: {
                    fieldDescriptor.usedForParams = true;
                    break;
                }
                case 39: {
                    int brt = in.getInt();
                    fieldDescriptor.blobRawType = FieldDescriptor.BlobRawType.get(brt);
                    break;
                }
                case 69: {
                    fieldDescriptor.precision = in.getInt();
                    break;
                }
                case 64: {
                    fieldDescriptor.isForeignKey = true;
                    break;
                }
                case 80: {
                    fieldDescriptor.foreignKeyRawName = in.getAnsi();
                    break;
                }
                case 81: {
                    fieldDescriptor.isRecordIdPresentation = in.getInt() == 1;
                    break;
                }
                case 82: {
                    fieldDescriptor.numberDefValue = in.getDouble();
                    fieldDescriptor.hasDefValue = true;
                    break;
                }
                case 83: {
                    fieldDescriptor.stringDefValue = in.getString();
                    fieldDescriptor.hasDefValue = true;
                    break;
                }
                case 84: {
                    int pgreview = in.getInt();
                    fieldDescriptor.postgreSQLReviewType = FieldDescriptor.PostgreSQLReviewType.get(pgreview);
                    break;
                }
                case 85: {
                    in.skip();
                    fieldDescriptor.textExtractionFields = this.loadTextExtractionFields(in.getStreamReader());
                }
            }
        }
        if (fieldDescriptor != null) {
            fieldDescriptor.setValueGeneratorType(fieldValueGeneratorType);
        }
        this.valueGeneratorCount = 0;
        this.hasMultipleWriteProtection = false;
        for (FieldDescriptor fieldDescriptor2 : this.fields) {
            if (fieldDescriptor2.getAutoValueGenerator() != FieldDescriptor.AutoValueGenerator.NONE) {
                ++this.valueGeneratorCount;
            }
            if (fieldDescriptor2.multipleWriteProtection != FieldDescriptor.MultipleWriteProtection.None) {
                if (fieldDescriptor2.isPrimaryKey()) {
                    FieldDescriptor.MultipleWriteProtection cfr_ignored_0 = fieldDescriptor.multipleWriteProtection;
                    fieldDescriptor2.multipleWriteProtection = FieldDescriptor.MultipleWriteProtection.None;
                } else {
                    switch (fieldDescriptor2.getType()) {
                        case INTEGER: 
                        case FLOAT: 
                        case DATE_TIME: 
                        case INTERVAL: {
                            this.hasMultipleWriteProtection = true;
                            if (fieldDescriptor2.multipleWriteProtection != FieldDescriptor.MultipleWriteProtection.AllFields) break;
                            this.mwpAllFieldsLabel = fieldDescriptor2.id;
                            break;
                        }
                        default: {
                            fieldDescriptor2.multipleWriteProtection = FieldDescriptor.MultipleWriteProtection.None;
                        }
                    }
                }
            }
            if (fieldDescriptor2.textExtractionFields == null) continue;
            for (Cursor.Integer c : fieldDescriptor2.textExtractionFields) {
                FieldDescriptor extractionField = this.getExistingFieldDescriptor(c.value);
                extractionField.autoFill = true;
            }
        }
        if (this.kind == Kind.INTERNAL) {
            this.primaryKeyFields.add(FieldDescriptor.getInternalPrimaryKeyField());
        } else {
            this.hasDeleteDataAudit = false;
            for (FieldDescriptor fieldDescriptor3 : this.fields) {
                if (fieldDescriptor3.getRawName().equalsIgnoreCase(primaryKeyName)) {
                    fieldDescriptor3.isPrimaryKey = true;
                }
                if (!fieldDescriptor3.isPrimaryKey()) continue;
                this.primaryKeyFields.add(fieldDescriptor3);
            }
        }
        DataType pkt = this.primaryKeyFields.size() > 0 ? this.primaryKeyFields.get(0).getType() : DataType.NONE;
        this.recordIdField = this.primaryKeyFields.size() != 1 || !this.isValidPrimaryKeyType(pkt) ? null : this.primaryKeyFields.get(0);
        for (IndexDescriptor id : this.indexes) {
            for (int i4 = 0; i4 < id.fields.size(); ++i4) {
                if (id.fields.get(i4) != null) continue;
                id.fields.set(i4, this.recordIdField);
            }
            id.lockFields();
        }
        this.hasComplexFields = false;
        this.hasLobs = false;
        boolean bl2 = false;
        IntegerSet[] fieldsSet = new IntegerSet[this.fields.size()];
        for (i = 0; i < fieldsSet.length; ++i) {
            FieldDescriptor blobField;
            FieldDescriptor f = this.fields.get(i);
            if (f.getAutoValueGenerator() == FieldDescriptor.AutoValueGenerator.BLOBSIZE && (blobField = this.getFieldDescriptor(f.valueGeneratorField)) != null) {
                int idx = blobField.getIndex();
                if (fieldsSet[idx] == null) {
                    fieldsSet[idx] = new IntegerSet();
                }
                fieldsSet[idx].add(f.id);
                bl = true;
            }
            if (f.getType() == DataType.BLOB) {
                this.hasLobs = true;
            }
            if (f.getType().isNumeric() && f.getType() != DataType.BIG_NUMBER) continue;
            this.hasComplexFields = true;
        }
        if (bl) {
            for (i = 0; i < fieldsSet.length; ++i) {
                if (fieldsSet[i] == null) continue;
                this.fields.get((int)i).blobSizeFields = fieldsSet[i].toArray();
            }
        }
        this.fields = Collections.unmodifiableList(this.fields);
        this.indexes = Collections.unmodifiableList(this.indexes);
    }

    private boolean isValidPrimaryKeyType(DataType t) {
        return t == DataType.INTEGER || t == DataType.BOOLEAN || t == DataType.DIRECTORY || t == DataType.FLOAT || t == DataType.METATREE_NODE || t == DataType.PRIMARY_KEY;
    }

    public double getDbId() {
        return this.dbId;
    }

    public boolean urawnamed() {
        return this.rawName == null || this.rawName.isEmpty();
    }

    public String getRawName() {
        return this.rawName;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public List<IndexDescriptor> getIndexes() {
        return this.indexes;
    }

    public double getNodeId() {
        return this.nodeId;
    }

    public AuditType getAuditType() {
        return this.auditType;
    }

    public boolean isAuditSavePrev() {
        return this.auditSavePrev;
    }

    public Kind getKind() {
        return this.kind;
    }

    public FieldDescriptor getRecordIdField() {
        return this.recordIdField;
    }

    public final void throwTableError(String error) {
        StringBuilder msg = new StringBuilder();
        msg.append(error).append(" \u0442\u0430\u0431\u043b\u0438\u0446\u0430 ").append(this.getCaption()).append(" [").append(NumberConverter.doubleToString(this.nodeId)).append("]");
        throw new InformException(msg.toString());
    }

    public FieldDescriptor getValidRecordIdField() {
        if (this.recordIdField == null) {
            if (this.primaryKeyFields.size() > 1) {
                this.throwTableError("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0441 \u0441\u043e\u0441\u0442\u0430\u0432\u043d\u044b\u043c \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u043c \u043a\u043b\u044e\u0447\u043e\u043c");
            } else {
                this.throwTableError("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
            }
        }
        return this.recordIdField;
    }

    public FieldDescriptor getField(String rawName) {
        FieldDescriptor r = this.fieldsByRawName.get(rawName);
        if (r == null) {
            for (FieldDescriptor d : this.fields) {
                if (!d.rawName.equalsIgnoreCase(rawName)) continue;
                return d;
            }
            if (this.recordIdField != null && this.recordIdField.rawName.equalsIgnoreCase(rawName)) {
                return this.recordIdField;
            }
        }
        return r;
    }

    public boolean getHasAutoSetValues() {
        return this.valueGeneratorCount != 0;
    }

    public int getValueGeneratorCount() {
        return this.valueGeneratorCount;
    }

    public TableLinkList getLinkList() throws IOException, TaggedReaderException {
        if (this.linkList == null) {
            this.linkList = new TableLinkList(this.dataLinksContent);
            this.dataLinksContent = null;
        }
        return this.linkList;
    }

    public boolean isHasPeriodicStorage() {
        return this.periodicTableStorages != null;
    }

    public DoubleHash<PeriodicTableStorage> getPeriodicTableStorages() {
        return this.periodicTableStorages;
    }

    public ArrayList<PeriodicTableStorage> getPeriodicTableStorageList() {
        return this.periodicTableStorageList;
    }

    public boolean isHasMultipleWriteProtection() {
        return this.hasMultipleWriteProtection;
    }

    public int getMwpAllFieldsLabel() {
        return this.mwpAllFieldsLabel;
    }

    public String getCaption() {
        if (this.nodeName == null) {
            this.nodeName = MtdEngine.getNodeName(this.nodeId);
            if (this.nodeName == null) {
                this.nodeName = this.rawName;
            }
        }
        return this.nodeName;
    }

    public int getAlternativeKeyCount() {
        return this.alternativeKeyCount;
    }

    public boolean isExternalStructureManaged() {
        return this.externalStructureManaged;
    }

    public boolean isSystemTableName() {
        if (Strings.isVoid(this.rawName)) {
            return false;
        }
        if (this.rawName.equalsIgnoreCase("PHX_CHANGELOG")) {
            return true;
        }
        if (this.rawName.equalsIgnoreCase("PHX_CHANGELOG_VAL")) {
            return true;
        }
        if (this.rawName.equalsIgnoreCase("PHX_CHANGELOG_BLOB")) {
            return true;
        }
        if (this.rawName.equalsIgnoreCase("MTD_TREE")) {
            return true;
        }
        if (this.rawName.equalsIgnoreCase("MTD_TREE_LOG")) {
            return true;
        }
        if (this.rawName.equalsIgnoreCase("MTD_CONF_NODES")) {
            return true;
        }
        if (this.rawName.equalsIgnoreCase("MTD_CONF")) {
            return true;
        }
        return this.rawName.equalsIgnoreCase("PHX_CHANGELOG_TRANS");
    }

    public byte[] getRawSearchConditions() {
        return this.rawSearchConditions;
    }

    public String getSqlForView() {
        if (this.kind != Kind.VIEW) {
            throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 SQL \u0442\u0435\u043a\u0441\u0442\u0430 \u0434\u043b\u044f \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f");
        }
        StringBuilder sql = new StringBuilder("CREATE VIEW ");
        sql.append(this.getRawName()).append(" AS\r\n");
        SqlGenerator sqlGen = new SqlGenerator(null, Core.serverTimeZoneHost);
        sqlGen.setTableId(this.nodeId);
        sqlGen.setSearchContent(this.rawSearchConditions);
        sqlGen.setInlineParams(true);
        try {
            GeneratedSql gSql = sqlGen.getGeneratedSql(SqlGenerator.extractSearchGenerationMethod(this.rawSearchConditions), -500);
            if (gSql.isHasError()) {
                throw new InformException(gSql.getError()).detail(gSql.getErrorDetailing());
            }
            sql.append(gSql.getSqlText());
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
        return sql.toString();
    }

    public ArrayList<FieldDescriptor> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public static TableDescriptor getSystemMtdTree() {
        TableDescriptor result = systemMtdTree;
        if (result == null) {
            result = new TableDescriptor("MTD_TREE", Kind.INTERNAL);
            FieldDescriptor FD_PARENT_ID = new FieldDescriptor(0, "PARENT_ID", DataType.METATREE_NODE, 0, true);
            FieldDescriptor FD_APP_TIME = new FieldDescriptor(1, "APP_TIME", DataType.DATE_TIME, 0, true);
            FieldDescriptor FD_APP_ID = new FieldDescriptor(2, "APP_ID", DataType.DIRECTORY, 0, true);
            result.fields.add(FD_PARENT_ID);
            result.fields.add(new FieldDescriptor(3, "NODE_TYPE", DataType.INTEGER, 0, true));
            result.fields.add(new FieldDescriptor(4, "NODE_NAME", DataType.STRING, 512, true));
            result.fields.add(new FieldDescriptor(5, "IDENT_NAME", DataType.STRING, 512, true));
            result.fields.add(new FieldDescriptor(6, "NODE_DESCRIPTION", DataType.STRING, 512, true));
            result.fields.add(new FieldDescriptor(7, "OWNER_ID", DataType.METATREE_NODE, 0, true));
            result.fields.add(new FieldDescriptor(8, "ORDER_NO", DataType.INTEGER, 0, true));
            result.fields.add(new FieldDescriptor(9, "CREATION_TIME", DataType.DATE_TIME, 0, true));
            result.fields.add(new FieldDescriptor(10, "MOD_ATTRS_TIME", DataType.DATE_TIME, 0, true));
            result.fields.add(new FieldDescriptor(11, "MOD_CONTENT_TIME", DataType.DATE_TIME, 0, true));
            result.fields.add(new FieldDescriptor(12, "MOD_USER_ID", DataType.METATREE_NODE, 0, true));
            result.fields.add(new FieldDescriptor(13, "ATTRS_B64", DataType.STRING, 4000, true));
            result.fields.add(FD_APP_TIME);
            result.fields.add(FD_APP_ID);
            result.fields.add(new FieldDescriptor(14, "SESSION_ID", DataType.DIRECTORY, 0, true));
            result.fields.add(new FieldDescriptor(15, "RAW_CONTENT", DataType.BLOB, 0, true));
            result.fields.add(new FieldDescriptor(19, "DSL_CONTENT", FieldDescriptor.BlobRawType.TEXT, true));
            result.fields.add(new FieldDescriptor(16, "CNT_ATTR_B64", DataType.STRING, 4000, true));
            result.fields.add(new FieldDescriptor(17, "REPL_ID", DataType.DIRECTORY, 0, true));
            result.fields.add(new FieldDescriptor(18, "REPL_NODE_ID", DataType.METATREE_NODE, 0, true));
            IndexDescriptor index = new IndexDescriptor(0);
            index.rawName = result.getRawName() + "_IDX";
            index.fields.add(FD_APP_ID);
            index.fields.add(FD_APP_TIME);
            index.lockFields();
            result.indexes.add(index);
            index = new IndexDescriptor(1);
            index.rawName = result.getRawName() + "_IDX2";
            index.fields.add(FD_PARENT_ID);
            index.lockFields();
            result.indexes.add(index);
            systemMtdTree = result;
        }
        return result;
    }

    public static TableDescriptor getSystemMtdTreeLog() {
        TableDescriptor result = systemMtdTreeLog;
        if (result == null) {
            result = new TableDescriptor("MTD_TREE_LOG", Kind.INTERNAL);
            FieldDescriptor FD_OP_TIME = new FieldDescriptor(0, "OP_TIME", DataType.DATE_TIME, 0, true);
            FieldDescriptor FD_NODE_ID = new FieldDescriptor(1, "NODE_ID", DataType.METATREE_NODE, 0, true);
            FieldDescriptor FD_PARENT_ID = new FieldDescriptor(2, "PARENT_ID", DataType.METATREE_NODE, 0, true);
            FieldDescriptor FD_NODE_TYPE = new FieldDescriptor(3, "NODE_TYPE", DataType.INTEGER, 0, true);
            result.fields.add(new FieldDescriptor(4, "OP_CODE", DataType.INTEGER, 0, true));
            result.fields.add(FD_OP_TIME);
            result.fields.add(new FieldDescriptor(5, "USER_ID", DataType.METATREE_NODE, 0, true));
            result.fields.add(FD_NODE_ID);
            result.fields.add(FD_PARENT_ID);
            result.fields.add(FD_NODE_TYPE);
            result.fields.add(new FieldDescriptor(6, "NODE_NAME", DataType.STRING, 512, true));
            result.fields.add(new FieldDescriptor(7, "IDENT_NAME", DataType.STRING, 512, true));
            result.fields.add(new FieldDescriptor(8, "NODE_DESCRIPTION", DataType.STRING, 512, true));
            result.fields.add(new FieldDescriptor(9, "OWNER_ID", DataType.METATREE_NODE, 0, true));
            result.fields.add(new FieldDescriptor(10, "ORDER_NO", DataType.INTEGER, 0, true));
            result.fields.add(new FieldDescriptor(11, "CREATION_TIME", DataType.DATE_TIME, 0, true));
            result.fields.add(new FieldDescriptor(12, "MOD_ATTRS_TIME", DataType.DATE_TIME, 0, true));
            result.fields.add(new FieldDescriptor(13, "MOD_CONTENT_TIME", DataType.DATE_TIME, 0, true));
            result.fields.add(new FieldDescriptor(14, "MOD_USER_ID", DataType.METATREE_NODE, 0, true));
            result.fields.add(new FieldDescriptor(15, "ATTRS_B64", DataType.STRING, 4000, true));
            result.fields.add(new FieldDescriptor(16, "SESSION_ID", DataType.DIRECTORY, 0, true));
            result.fields.add(new FieldDescriptor(17, "ENTRY_COMMENT", DataType.STRING, 512, true));
            result.fields.add(new FieldDescriptor(18, "RAW_CONTENT", DataType.BLOB, 0, true));
            result.fields.add(new FieldDescriptor(21, "DSL_CONTENT", FieldDescriptor.BlobRawType.TEXT, true));
            result.fields.add(new FieldDescriptor(19, "REPL_ID", DataType.DIRECTORY, 0, true));
            result.fields.add(new FieldDescriptor(20, "REPL_NODE_ID", DataType.METATREE_NODE, 0, true));
            IndexDescriptor index = new IndexDescriptor(0);
            index.rawName = result.getRawName() + "_IDX1";
            index.fields.add(FD_NODE_ID);
            index.fields.add(FD_OP_TIME);
            index.lockFields();
            result.indexes.add(index);
            index = new IndexDescriptor(1);
            index.rawName = result.getRawName() + "_IDX2";
            index.fields.add(FD_NODE_TYPE);
            index.fields.add(FD_NODE_ID);
            index.fields.add(FD_OP_TIME);
            index.lockFields();
            result.indexes.add(index);
            index = new IndexDescriptor(2);
            index.rawName = result.getRawName() + "_IDX3";
            index.fields.add(FD_OP_TIME);
            index.lockFields();
            result.indexes.add(index);
            systemMtdTreeLog = result;
        }
        return result;
    }

    public static TableDescriptor getSystemMtdConfNodes() {
        TableDescriptor result = systemMtdConfNodes;
        if (result == null) {
            result = new TableDescriptor("MTD_CONF_NODES", Kind.INTERNAL);
            FieldDescriptor fieldUser = new FieldDescriptor(0, "CONF_USER", DataType.METATREE_NODE, 0, true);
            FieldDescriptor fieldName = new FieldDescriptor(1, "CONF_NAME", DataType.STRING, 512, true);
            FieldDescriptor fieldContent = new FieldDescriptor(2, "CONF_CONTENT", DataType.BLOB, 0, true);
            result.fields.add(fieldUser);
            result.fields.add(fieldName);
            result.fields.add(fieldContent);
            IndexDescriptor index = new IndexDescriptor(0);
            index.rawName = result.getRawName() + "_IDX1";
            index.fields.add(fieldUser);
            index.lockFields();
            result.indexes.add(index);
            systemMtdConfNodes = result;
        }
        return result;
    }

    public static TableDescriptor getSystemMtdConf() {
        TableDescriptor result = systemMtdConf;
        if (result == null) {
            result = new TableDescriptor("MTD_CONF", Kind.INTERNAL);
            FieldDescriptor fieldUser = new FieldDescriptor(0, "CONF_USER", DataType.METATREE_NODE, 0, true);
            FieldDescriptor fieldNode = new FieldDescriptor(1, "NODE_ID", DataType.METATREE_NODE, 0, true);
            FieldDescriptor fieldType = new FieldDescriptor(2, "CONF_TYPE", DataType.INTEGER, 0, true);
            FieldDescriptor fieldContent = new FieldDescriptor(3, "CONF_CONTENT", DataType.BLOB, 0, true);
            result.fields.add(fieldUser);
            result.fields.add(fieldNode);
            result.fields.add(fieldType);
            result.fields.add(fieldContent);
            IndexDescriptor index = new IndexDescriptor(0);
            index.rawName = result.getRawName() + "_IDX1";
            index.fields.add(fieldUser);
            index.fields.add(fieldNode);
            index.fields.add(fieldType);
            index.lockFields();
            result.indexes.add(index);
            systemMtdConf = result;
        }
        return result;
    }

    public static TableDescriptor getSystemMtdAgents() {
        TableDescriptor result = systemMtdAgents;
        if (result == null) {
            result = new TableDescriptor("MTD_AGENTS", Kind.INTERNAL);
            FieldDescriptor fieldServerID = new FieldDescriptor(0, "SERVER_ID", DataType.STRING, 128, true);
            FieldDescriptor fieldAgentID = new FieldDescriptor(1, "AGENT_ID", DataType.STRING, 128, true);
            FieldDescriptor fieldAgentName = new FieldDescriptor(2, "AGENT_NAME", DataType.STRING, 512, true);
            FieldDescriptor fieldFieldHostName = new FieldDescriptor(3, "HOST_NAME", DataType.STRING, 512, true);
            FieldDescriptor fieldFieldAgentPID = new FieldDescriptor(4, "PID", DataType.FLOAT, 0, true);
            fieldFieldAgentPID.setRecordIdPresentation(true);
            FieldDescriptor fieldWorkerID = new FieldDescriptor(5, "WORKER_ID", DataType.FLOAT, 0, true);
            fieldWorkerID.setRecordIdPresentation(true);
            FieldDescriptor fieldVersion = new FieldDescriptor(6, "AGENT_VERSION", DataType.STRING, 20, true);
            FieldDescriptor fieldConnected = new FieldDescriptor(7, "CONNECTED", DataType.DATE_TIME, 0, false);
            FieldDescriptor fieldActivity = new FieldDescriptor(8, "ACTIVITY", DataType.DATE_TIME, 0, false);
            result.fields.add(fieldServerID);
            result.fields.add(fieldAgentID);
            result.fields.add(fieldAgentName);
            result.fields.add(fieldFieldHostName);
            result.fields.add(fieldFieldAgentPID);
            result.fields.add(fieldWorkerID);
            result.fields.add(fieldVersion);
            result.fields.add(fieldConnected);
            result.fields.add(fieldActivity);
            systemMtdAgents = result;
        }
        return result;
    }

    public static TableDescriptor getSystemMtdLocks() {
        TableDescriptor result = systemMtdLocks;
        if (result == null) {
            result = new TableDescriptor("MTD_LOCKS", Kind.INTERNAL);
            FieldDescriptor fieldAppID = new FieldDescriptor(0, "APP_ID", DataType.FLOAT, 0, false);
            fieldAppID.setRecordIdPresentation(true);
            FieldDescriptor fieldLockType = new FieldDescriptor(0, "LOCK_TYPE", DataType.FLOAT, 0, false);
            fieldLockType.setRecordIdPresentation(true);
            FieldDescriptor fieldNodeID = new FieldDescriptor(0, "NODE_ID", DataType.FLOAT, 0, false);
            fieldNodeID.setRecordIdPresentation(true);
            FieldDescriptor fieldRecordID = new FieldDescriptor(1, "RECORD_ID", DataType.FLOAT, 0, false);
            fieldRecordID.setRecordIdPresentation(true);
            FieldDescriptor fieldUserID = new FieldDescriptor(2, "USER_ID", DataType.METATREE_NODE, 0, false);
            fieldUserID.setRecordIdPresentation(true);
            FieldDescriptor fieldSessionID = new FieldDescriptor(3, "SESSION_ID", DataType.FLOAT, 0, true);
            fieldSessionID.setRecordIdPresentation(true);
            FieldDescriptor fieldCreated = new FieldDescriptor(4, "CREATION_TIME", DataType.DATE_TIME, 0, false);
            result.fields.add(fieldAppID);
            result.fields.add(fieldLockType);
            result.fields.add(fieldNodeID);
            result.fields.add(fieldRecordID);
            result.fields.add(fieldUserID);
            result.fields.add(fieldSessionID);
            result.fields.add(fieldCreated);
            IndexDescriptor index = new IndexDescriptor(0);
            index.rawName = result.getRawName() + "_IDX1";
            index.fields.add(fieldLockType);
            index.fields.add(fieldNodeID);
            index.fields.add(fieldRecordID);
            index.lockFields();
            index.setUnique(true);
            result.indexes.add(index);
            systemMtdLocks = result;
        }
        return result;
    }

    public static TableDescriptor getSystemMtdTickets() {
        TableDescriptor result = systemMtdTickets;
        if (result == null) {
            result = new TableDescriptor("MTD_TICKETS", Kind.INTERNAL);
            FieldDescriptor fieldIPAddress = new FieldDescriptor(0, "IP_ADDRESS", DataType.STRING, 15, false);
            FieldDescriptor fieldOpCode = new FieldDescriptor(1, "OP_CODE", DataType.INTEGER, 0, false);
            FieldDescriptor fieldNodeID = new FieldDescriptor(2, "NODE_ID", DataType.METATREE_NODE, 0, false);
            FieldDescriptor fieldUserID = new FieldDescriptor(3, "USER_ID", DataType.METATREE_NODE, 0, false);
            FieldDescriptor fieldSessionID = new FieldDescriptor(4, "SESSION_ID", DataType.FLOAT, 0, true);
            FieldDescriptor fieldCreated = new FieldDescriptor(5, "CREATION_TIME", DataType.DATE_TIME, 0, false);
            FieldDescriptor fieldKey = new FieldDescriptor(6, "KEY", DataType.STRING, 32, false);
            result.fields.add(fieldIPAddress);
            result.fields.add(fieldOpCode);
            result.fields.add(fieldNodeID);
            result.fields.add(fieldUserID);
            result.fields.add(fieldSessionID);
            result.fields.add(fieldCreated);
            result.fields.add(fieldKey);
            systemMtdTickets = result;
        }
        return result;
    }

    public static TableDescriptor getSystemMtdPersistentSessions() {
        TableDescriptor result = systemMtdPersistentSessions;
        if (result != null) {
            return result;
        }
        result = new TableDescriptor("MTD_PERSISTENT_SESSIONS", Kind.INTERNAL);
        int indx = 0;
        FieldDescriptor fieldUser = new FieldDescriptor(indx++, "USER_ID", DataType.METATREE_NODE, 0, false);
        FieldDescriptor fieldHash1 = new FieldDescriptor(indx++, "HASH1", DataType.BLOB, 0, false);
        FieldDescriptor fieldCreationTime = new FieldDescriptor(indx++, "CREATION_TIME", DataType.DATE_TIME, 0, false);
        FieldDescriptor fieldLastLoginTime = new FieldDescriptor(indx++, "LAST_LOGIN_TIME", DataType.DATE_TIME, 0, false);
        FieldDescriptor fieldLastUserAgent = new FieldDescriptor(indx++, "LAST_USER_AGENT", DataType.STRING, 512, true);
        result.fields.add(fieldUser);
        result.fields.add(fieldHash1);
        result.fields.add(fieldCreationTime);
        result.fields.add(fieldLastLoginTime);
        result.fields.add(fieldLastUserAgent);
        indx = 0;
        IndexDescriptor index = new IndexDescriptor(indx++);
        index.rawName = result.getRawName() + "_IDX" + indx;
        index.fields.add(fieldUser);
        index.lockFields();
        result.indexes.add(index);
        systemMtdPersistentSessions = result;
        return result;
    }

    public String toString() {
        if (this.nodeId == 0.0) {
            return this.rawName;
        }
        String idStr = NumberConverter.doubleToString(this.nodeId);
        try {
            String caption = this.getCaption();
            return caption + " [" + idStr + "]";
        }
        catch (Throwable e) {
            Core.logger.error("TableDescriptor.toString [" + idStr + "]", e);
            return "? [" + idStr + "]";
        }
    }

    public String getLogNodeId() {
        if (this.logNodeId == null) {
            this.logNodeId = NumberConverter.doubleToString(this.nodeId);
        }
        return this.logNodeId;
    }

    public boolean hasStandartPrimaryKey() {
        return this.kind == Kind.INTERNAL || this.kind == Kind.EXTERNAL && this.primaryKeyFields.size() == 1 && this.primaryKeyFields.get((int)0).type == DataType.FLOAT;
    }

    public boolean hasComplexFields() {
        return this.hasComplexFields;
    }

    public boolean hasLobs() {
        return this.hasLobs;
    }

    public boolean hasDeleteDataAudit() {
        return this.hasDeleteDataAudit;
    }

    public void checkTableLinks() {
        if (Ini.EnableCascadingDeleteCheck) {
            DatabaseDescriptor d = this.getDbDescIfExists();
            if (d == null) {
                return;
            }
            double rootDbId = d.getEffectiveDatabaseId();
            try {
                this.getLinkList();
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
            for (LinkDescriptor link : this.linkList.getLinks()) {
                double linkDbId;
                TableDescriptor linkTable;
                if (!link.isRowsOwnership() || (linkTable = TableDescriptor.getIfExists(link.getTable())) == null || (d = linkTable.getDbDescIfExists()) == null || rootDbId == (linkDbId = d.getEffectiveDatabaseId())) continue;
                StringBuilder msg = new StringBuilder();
                msg.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0432\u044f\u0437\u0438 \"").append(link.getCaption()).append("\" \u0442\u0430\u0431\u043b\u0438\u0446\u044b ");
                MtdEngine.appendNodeNameForLog(msg, this.nodeId);
                msg.append(":\n \u043a\u0430\u0441\u043a\u0430\u0434\u043d\u043e\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u043b\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u0438\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u044b");
                throw new InformException(msg.toString());
            }
        }
    }

    public static class PeriodicTableStorage
    implements DoubleHash.Entry {
        public final double tableId;
        public final int referenceFieldId;
        public final int beginFieldId;
        public final int endFieldId;

        public PeriodicTableStorage(double tableId, int referenceFieldId, int beginFieldId, int endFieldId) {
            this.tableId = tableId;
            this.referenceFieldId = referenceFieldId;
            this.beginFieldId = beginFieldId;
            this.endFieldId = endFieldId;
        }

        @Override
        public double key() {
            return this.tableId;
        }
    }

    public static enum AuditType {
        NONE(0),
        ACTIONS(1),
        ACTIONS_AND_DATA(2);

        private int typeId;

        private AuditType(int typeId) {
            this.typeId = typeId;
        }

        public static AuditType getById(int typeId) {
            for (AuditType a : AuditType.values()) {
                if (a.typeId != typeId) continue;
                return a;
            }
            throw new InformException(String.format("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0432\u0438\u0434 \u0430\u0443\u0434\u0438\u0442\u0430 %d", typeId));
        }
    }

    public static enum Kind {
        INTERNAL(0, 0),
        EXTERNAL(1, 3),
        VIRTUAL(2, 2),
        VIEW(3, 1);

        private int kindId;
        private int subType;

        private Kind(int kindId, int subType) {
            this.kindId = kindId;
            this.subType = subType;
        }

        public static Kind getById(int kindId) {
            for (Kind k : Kind.values()) {
                if (k.kindId != kindId) continue;
                return k;
            }
            throw new InformException(String.format("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0432\u0438\u0434 \u0442\u0430\u0431\u043b\u0438\u0446\u044b %d", kindId));
        }

        public int toInt() {
            return this.kindId;
        }

        public int getSubType() {
            return this.subType;
        }
    }
}

