/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.commit;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerList;
import inform.adt.taggedio.TaggedReader;
import inform.agent.CancelRequestException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.ClosableResult;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.LinkField;
import inform.agent.db.PhenixLinks;
import inform.agent.db.ReplicationData;
import inform.agent.db.TableDescriptor;
import inform.agent.db.TableLinkList;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.DeleteEngineException;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.ProcessingTableRowList;
import inform.agent.db.utils.SqlCommand;
import inform.agent.db.utils.SqlCommandBatch;
import inform.agent.db.utils.SqlExecutor;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.files.BFS;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.TableDirectoryDependencis;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.net.Security;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

public class DeleteEngine {
    private static final int MSG_LENGTH_LIMIT = 32768;
    private final ProcessingTableRowList rowList;
    private final ProcessingTableRowList processedRows;
    private ProcessingTableRowList checkingRows;
    private double userNodeId;
    private AccountNode userNode;
    private boolean disableChecking;
    private boolean disableRelatedDelete;
    private final AbstractConnectionManager connectionManager;
    private TableDataAudit auditWriter;
    private final ReplicationData changeNotifier;
    private final ServerSideHost ssHost;
    private PhenixLinks.HasElements hasElements = null;
    private BFS blobfs = null;
    private String checkReferencesMessage = null;
    private final DoubleSet missingNodes = new DoubleSet();
    private boolean cancelThrowed;
    private SSContext ssContext;
    private double permissionsCheck_forTable;
    private boolean permissionsCheck_accessDenied;
    private TableDescriptor lastTableDescriptor;
    private boolean logDeletingRecords = false;
    private DoubleHash<ViolationReferringIntegrityTable> vri;
    private int vriCount = 0;

    public DeleteEngine(SSContext context, AbstractConnectionManager databaseManager, ReplicationData changeNotifier, double userNodeId, ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.rowList = new ProcessingTableRowList();
        this.processedRows = new ProcessingTableRowList();
        this.userNodeId = userNodeId;
        this.userNode = MtdEngine.getAccountNode(userNodeId);
        this.disableChecking = false;
        this.disableRelatedDelete = false;
        this.connectionManager = databaseManager;
        this.auditWriter = null;
        this.changeNotifier = changeNotifier;
        this.ssContext = context;
    }

    public void setContext(SSContext context) {
        this.ssContext = context;
    }

    public void setAuditWriter(TableDataAudit auditWriter) {
        this.auditWriter = auditWriter;
    }

    public void setBlobfs(BFS blobfs) {
        this.blobfs = blobfs;
    }

    public void setLogDeletingRecords(boolean logDeletingRecords) {
        this.logDeletingRecords = logDeletingRecords;
    }

    public void deleteRow(double tableNodeId, byte[] pkValues) throws SQLException, IOException {
        this.idle();
        if (this.userNode == null && !this.needDelete(tableNodeId, pkValues)) {
            return;
        }
        this.checkPermissions(tableNodeId);
        this.rowList.add(tableNodeId, pkValues);
    }

    public void deleteRow(double tableNodeId, double rowId) throws InformException, SQLException {
        this.idle();
        if (this.userNode == null && !this.needDelete(tableNodeId, rowId)) {
            return;
        }
        this.checkPermissions(tableNodeId);
        if (this.rowList.add(tableNodeId, rowId)) {
            TableDescriptor tableInfo;
            if (this.lastTableDescriptor != null && this.lastTableDescriptor.getNodeId() == tableNodeId) {
                tableInfo = this.lastTableDescriptor;
            } else {
                try {
                    this.lastTableDescriptor = tableInfo = TableDescriptor.get(tableNodeId);
                }
                catch (Throwable ex) {
                    Core.logger.error(null, ex);
                    return;
                }
            }
            if (tableInfo.isCascadeDeleteElements()) {
                this.enumElements(tableInfo, rowId);
            }
        }
    }

    public void applyDelete() throws SQLException, InformException {
        if (this.rowList.isEmpty()) {
            return;
        }
        this.checkingRows = new ProcessingTableRowList();
        if (!this.disableRelatedDelete) {
            for (ProcessingTableRowList.TableRows tr : this.rowList.hash) {
                this.processRelatedRows(TableDescriptor.get(tr.tableNodeId), tr.toArray());
            }
        }
        this.checkAllReferringIntegrity();
        try {
            this.processDelete();
        }
        catch (InformException | SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw InformException.wrap(e);
        }
        this.rowList.clear();
        this.processedRows.clear();
    }

    public void applyReplica() throws SQLException {
        SqlCommandBatch command;
        DatabaseConnection db;
        Object rows;
        TableDescriptor tableInfo;
        double[] tables;
        if (this.checkingRows == null) {
            this.checkingRows = new ProcessingTableRowList();
        }
        if (this.rowList.hasTables()) {
            for (double tableId : tables = this.rowList.getTables()) {
                int n;
                try {
                    tableInfo = TableDescriptor.get(tableId);
                }
                catch (Throwable ex) {
                    Core.logger.error(null, ex);
                    continue;
                }
                if (tableInfo.getRecordIdField() == null) {
                    throw new DeleteEngineException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 " + tableInfo.toString() + " \u043e\u0442\u0441\u0443\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
                }
                this.idle();
                this.checkPermissions(tableId);
                rows = this.rowList.getRows(tableId);
                if (rows == null || ((double[])rows).length == 0) continue;
                this.checkingRows.addAll(tableInfo.getNodeId(), (double[])rows);
                db = this.connectionManager.getConnection(tableInfo.getDbId(), "DeleteEngine::applyReplica");
                command = new SqlCommandBatch();
                SqlStringBuilder sqlStringBuilder = new SqlStringBuilder();
                sqlStringBuilder.append("delete from ").appendFull(tableInfo).append(" where ").append(tableInfo.getRecordIdField().getRawName()).append("=?");
                command.setSql(sqlStringBuilder.toString(), 1);
                Object object = rows;
                int n2 = ((double[])object).length;
                for (n = 0; n < n2; ++n) {
                    double rowId = object[n];
                    if (this.blobfs != null) {
                        this.blobfs.delete(this.ssContext, db, tableInfo, rowId);
                    }
                    command.addBatch(db, this.ssContext);
                    command.getParameters().setDouble(0, rowId);
                    if (this.changeNotifier == null) continue;
                    this.changeNotifier.add(tableId, 2, rowId, null);
                }
                this.idle();
                command.execute(db, this.ssContext);
                this.idle();
                if (!this.logDeletingRecords || !Ini.TraceSql && ((double[])rows).length >= 4096) continue;
                StringBuilder log = null;
                Object object2 = rows;
                n = ((double[])object2).length;
                for (int rowId = 0; rowId < n; ++rowId) {
                    double rowId2 = object2[rowId];
                    if (log == null) {
                        log = new StringBuilder();
                    } else {
                        log.append(", ");
                    }
                    log.append(NumberConverter.doubleToString(rowId2));
                }
                Core.logger.info("Delete records from table [{}]: { {} }", (Object)NumberConverter.doubleToString(tableInfo.getNodeId()), (Object)log.toString());
            }
        }
        if (this.rowList.hasIntricateTables()) {
            for (double tableId : tables = this.rowList.getIntricateTables()) {
                try {
                    tableInfo = TableDescriptor.get(tableId);
                }
                catch (Throwable ex) {
                    Core.logger.error(null, ex);
                    continue;
                }
                this.idle();
                this.checkPermissions(tableId);
                rows = this.rowList.getIntricateRows(tableId);
                if (rows == null || ((double[])rows).length == 0) continue;
                db = this.connectionManager.getConnection(tableInfo.getDbId(), "DeleteEngine::processDelete");
                command = new SqlCommandBatch();
                for (double rowId : rows) {
                    SqlCommand cmd = new SqlCommand();
                    cmd.sqlText.append("delete from ").appendFull(tableInfo).append(" where ");
                    try {
                        this.generateIntricateFields((byte[])rowId, tableInfo, null, cmd.sqlText, cmd.params);
                    }
                    catch (IOException e) {
                        throw InformException.wrap(e);
                    }
                    command.add(cmd, db, this.ssContext);
                }
                this.idle();
                if (!command.isEmpty()) {
                    command.execute(db, this.ssContext);
                }
                this.idle();
            }
        }
        this.rowList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReplicationReferringIntegrity(TableDescriptor tableInfo, double[] rows) throws SQLException, InformException {
        try {
            if (!tableInfo.isCheckReferringIntegrity() || this.disableChecking) {
                return;
            }
            double[] refTables = tableInfo.getReferences(this.ssHost);
            if (refTables == null || refTables.length == 0) {
                return;
            }
            for (double refNodeId : refTables) {
                this.idle();
                TableDescriptor refTable = TableDescriptor.getIfExists(refNodeId);
                if (this.skipCheck(refTable, refNodeId) || refTable == null) continue;
                int checkedReferencesCount = 0;
                for (FieldDescriptor dirField : refTable.getFields()) {
                    DatabaseConnection db;
                    if (dirField.isVirtual() || dirField.getType() != DataType.DIRECTORY || dirField.getReferenceId() != tableInfo.getNodeId() || dirField.isDontCheckRefs()) continue;
                    ++checkedReferencesCount;
                    if (this.checkingRows.isIntricateTable(refNodeId)) {
                        this.processCheckReferringIntegrityFor(tableInfo, rows, refTable, dirField);
                        continue;
                    }
                    ProcessingTableRowList.TableRows refRows = this.checkingRows.hash.get(refNodeId);
                    double[] refArray = null;
                    FieldDescriptor recordIdField = refTable.getValidRecordIdField();
                    try {
                        db = this.connectionManager.getConnection(refTable.getDbId(), "DeleteEngine::checkReplicationReferringIntegrity");
                    }
                    catch (Throwable ex) {
                        throw InformException.detail(ex, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + refTable.toString());
                    }
                    SqlStringBuilder sql = new SqlStringBuilder();
                    sql.append("select ").append(recordIdField).append(", ").append(dirField).append(" from ").appendFull(refTable).append(" where ");
                    if (refNodeId == tableInfo.getNodeId()) {
                        sql.append(recordIdField).append("<>").append(dirField).append(" and ");
                    }
                    if (refRows != null && !refRows.empty()) {
                        refArray = refRows.toArray();
                        int size = refArray.length;
                        if (size == 1) {
                            sql.append(recordIdField).append("<>? and ");
                        } else {
                            sql.append(recordIdField).append(" not in (");
                            if (size > 1000) {
                                size = 1000;
                                refArray = Arrays.copyOf(refArray, size);
                            }
                            sql.append('?');
                            for (int i = 1; i < size; ++i) {
                                sql.append(",?");
                            }
                            sql.append(") and ");
                        }
                    }
                    sql.append(dirField).append(" in (?");
                    String sqlPrefix = sql.toString();
                    String sqlSuffix = ")";
                    int rowsLeft = rows.length;
                    while (rowsLeft > 0) {
                        int rowsOffset = rows.length - rowsLeft;
                        int currentBatchSize = Math.min(1000, rowsLeft);
                        rowsLeft -= currentBatchSize;
                        StringBuilder sqlFull = new StringBuilder(sqlPrefix);
                        for (int i = 1; i < currentBatchSize; ++i) {
                            sqlFull.append(",?");
                        }
                        sqlFull.append(sqlSuffix);
                        try (PreparedStatement statement = db.prepareStatement("DeleteEngine.checkReplicationReferringIntegrity", sqlFull.toString());){
                            statement.setQueryTimeout();
                            int index = 0;
                            if (refArray != null) {
                                for (double r : refArray) {
                                    statement.setDouble(++index, r);
                                }
                            }
                            for (int i = 0; i < currentBatchSize; ++i) {
                                statement.setDouble(++index, rows[rowsOffset + i]);
                            }
                            this.idle();
                            try (ResultSet fetcher = statement.executeQuery(this.ssContext);){
                                while (fetcher.next()) {
                                    this.idle();
                                    double refRowId = fetcher.getAsDouble(1);
                                    double rowId = fetcher.getAsDouble(2);
                                    if (refRows != null && refRows.contains(refRowId)) continue;
                                    this.addViolationReferringIntegrity(tableInfo, rowId, refTable, dirField);
                                }
                            }
                        }
                    }
                }
                if (checkedReferencesCount != 0) continue;
                TableDirectoryDependencis.incErrorCount();
            }
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void getReplicationReferringIntegrityDetail(TableDescriptor tableInfo, double[] rows, StringBuilder msg) throws SQLException, InformException {
        try {
            if (!tableInfo.isCheckReferringIntegrity() || this.disableChecking) {
                return;
            }
            refTables = tableInfo.getReferences(this.ssHost);
            if (refTables == null || refTables.length == 0) {
                return;
            }
            lastId = 0.0;
            lastIdInvalid = true;
            for (double refNodeId : refTables) {
                this.idle();
                refTable = TableDescriptor.getIfExists(refNodeId);
                if (this.skipCheck(refTable, refNodeId) || refTable == null) continue;
                checkedReferencesCount = 0;
                for (FieldDescriptor f : refTable.getFields()) {
                    if (f.isVirtual() || f.getType() != DataType.DIRECTORY || f.getReferenceId() != tableInfo.getNodeId() || f.isDontCheckRefs()) continue;
                    ++checkedReferencesCount;
                    db = this.connectionManager.getConnection(refTable.getDbId(), "DeleteEngine::checkReferringIntegrity");
                    sql = new SqlStringBuilder();
                    sql.append("select count(").append(f).append("), ").append(f).append(" from ").appendFull(refTable).append(" where ");
                    if (refNodeId == tableInfo.getNodeId()) {
                        sql.append(refTable.getRecordIdField()).append("<>").append(f).append(" and ");
                    }
                    sql.append(f).append(" in (?");
                    sqlPrefix = sql.toString();
                    sqlSuffix = ") group by " + f.getRawName() + " having count(" + f.getRawName() + ")>0";
                    rowsLeft = rows.length;
                    while (rowsLeft > 0) {
                        rowsOffset = rows.length - rowsLeft;
                        currentBatchSize = Math.min(1000, rowsLeft);
                        rowsLeft -= currentBatchSize;
                        sqlFull = new StringBuilder(sqlPrefix);
                        for (i = 1; i < currentBatchSize; ++i) {
                            sqlFull.append(",?");
                        }
                        sqlFull.append(sqlSuffix);
                        statement = db.prepareStatement("DeleteEngine.getReferringIntegrityDetail", sqlFull.toString());
                        try {
                            statement.setQueryTimeout();
                            for (i = 0; i < currentBatchSize; ++i) {
                                statement.setDouble(i + 1, rows[rowsOffset + i]);
                            }
                            this.idle();
                            fetcher = statement.executeQuery(this.ssContext);
lbl48:
                            // 3 sources

                            try {
                                while (fetcher.next()) {
                                    this.idle();
                                    rowCount = fetcher.getInt(1);
                                    if (rowCount <= 0) ** GOTO lbl48
                                    rowId = fetcher.getDouble(2);
                                    if (lastId != rowId || lastIdInvalid) {
                                        if (lastIdInvalid) {
                                            msg.append("\n\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c ").append(NumberConverter.doubleToString(rowId)).append(" \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(tableInfo).append(" \u0435\u0441\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438:");
                                        } else {
                                            msg.append("\n\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c ").append(NumberConverter.doubleToString(rowId)).append(" \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(NumberConverter.doubleToString(tableInfo.getNodeId())).append(':');
                                        }
                                        lastId = rowId;
                                        lastIdInvalid = false;
                                    }
                                    msg.append("\n\t").append(rowCount).append("\u0448\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ").append(refTable).append(" \u043f\u043e \u043f\u043e\u043b\u044e \"").append(f.getCaption()).append('\"');
                                    if (msg.length() <= 32768) ** GOTO lbl48
                                    msg.append("\n... <\u0434\u0438\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0430 \u0441\u0441\u044b\u043b\u043e\u0447\u043d\u043e\u0439 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0438\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e>");
                                    return;
                                }
                            }
                            finally {
                                fetcher.close();
                            }
                        }
                        finally {
                            statement.close();
                        }
                    }
                }
                if (checkedReferencesCount != 0) continue;
                TableDirectoryDependencis.incErrorCount();
            }
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    String getViolationReferringIntegrityDetail(StringBuilder detail) {
        if (this.vri == null || this.vriCount == 0) {
            return null;
        }
        StringBuilder msg = new StringBuilder();
        boolean msgIsFull = false;
        boolean detailIsFull = false;
        for (ViolationReferringIntegrityTable table : this.vri) {
            boolean addTable = true;
            if (msg.length() < 32768) {
                msg.append("\n\u0421\u0440\u0435\u0434\u0438 \u0443\u0434\u0430\u043b\u044f\u0435\u043c\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0438\u043c\u0435\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u0438 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(table.table).append(", \u043d\u0430 \u043a\u043e\u0442\u0440\u0443\u044e \u0435\u0441\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u0432 \u0437\u0430\u043f\u0438\u0441\u044f\u0445 \u0434\u0440\u0443\u0433\u0438\u0445 \u0442\u0430\u0431\u043b\u0438\u0446.");
            } else {
                msgIsFull = true;
            }
            for (ViolationReferringIntegrityRecord record : table) {
                for (ViolationReferringIntegrityReference ref : record) {
                    for (int i = 0; i < ref.dirFields.size() && !detailIsFull; ++i) {
                        if (detail.length() < 32768) {
                            detail.append("\n\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c ").append(NumberConverter.doubleToString(record.recordId)).append(" \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(NumberConverter.doubleToString(table.table.getNodeId())).append(':').append("\n\t").append(ref.counts.get(i)).append("\u0448\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ").append(ref.refTable).append(" \u043f\u043e \u043f\u043e\u043b\u044e ");
                            ref.dirFields.get(i).toLogString(detail);
                            continue;
                        }
                        detailIsFull = true;
                    }
                    if (!msgIsFull || !detailIsFull) continue;
                    break;
                }
                if (!msgIsFull || !detailIsFull) continue;
                break;
            }
            if (!msgIsFull || !detailIsFull) continue;
            break;
        }
        return msg.toString();
    }

    /*
     * Exception decompiling
     */
    public void checkReplicationReferringIntegrity() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setUserID(double userNodeId) {
        if (this.userNodeId == userNodeId) {
            return;
        }
        this.userNodeId = userNodeId;
        this.userNode = MtdEngine.getAccountNode(userNodeId);
        this.permissionsCheck_forTable = 0.0;
    }

    public boolean isDisableChecking() {
        return this.disableChecking;
    }

    public void setDisableChecking(boolean disableChecking) {
        this.disableChecking = disableChecking;
    }

    public boolean isDisableRelatedDelete() {
        return this.disableRelatedDelete;
    }

    public void setDisableRelatedDelete(boolean disableRelatedDelete) {
        this.disableRelatedDelete = disableRelatedDelete;
    }

    public void setCheckReferencesMessage(String checkReferencesMessage) {
        this.checkReferencesMessage = checkReferencesMessage;
    }

    private void checkPermissions(double tableNodeId) throws InformException {
        if (tableNodeId != this.permissionsCheck_forTable) {
            Node node = MtdEngine.getValidNode(tableNodeId);
            int accessMask = this.userNode == null ? 0 : Security.calculateAccessMask(node, this.userNode, this.userNode.effectiveGroups());
            this.permissionsCheck_accessDenied = AccessMask.accessDenied(0x800000, accessMask);
            this.permissionsCheck_forTable = tableNodeId;
        }
        if (this.permissionsCheck_accessDenied) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e ");
            MtdEngine.appendUserNameForLog(msg, this.userNodeId);
            msg.append("\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ");
            MtdEngine.appendNodeNameForLog(msg, tableNodeId);
            throw new DeleteEngineException(msg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalProcessRelatedRows(TableDescriptor tableInfo, double[] rows, DatabaseConnection database) throws InformException, SQLException {
        if (this.disableRelatedDelete) {
            return;
        }
        try {
            this.idle();
            this.processedRows.addAll(tableInfo.getNodeId(), rows);
            if (!this.disableChecking) {
                this.checkingRows.addAll(tableInfo.getNodeId(), rows);
            }
            TableLinkList links = tableInfo.getLinkList();
            for (LinkDescriptor link : links.getLinks()) {
                SqlCommand command;
                TableDescriptor relationInfo;
                TableNode relationTable;
                double tID;
                if (!link.isRowsOwnership() || (tID = link.getTable()) == 0.0 || (relationTable = (TableNode)MtdEngine.getNode(tID)) == null) continue;
                try {
                    relationInfo = relationTable.getDescriptor();
                }
                catch (InformException ex) {
                    throw new DeleteEngineException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u0441\u0441\u044b\u043b\u043e\u0447\u043d\u043e\u0439 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u0438.\n\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + tableInfo.toString() + " \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u0441\u0432\u044f\u0437\u044c " + link.toString(), ex);
                }
                if (!relationInfo.isOperableTable()) continue;
                if (relationInfo.getDbId() != database.getDescriptor().getNodeId()) {
                    database = this.connectionManager.getConnection(relationInfo.getDbId(), "DeleteEngine::internalProcessRelatedRows");
                }
                boolean hasLinkFields = true;
                boolean linkProcessed = false;
                for (LinkField field : link.getFields()) {
                    if (field.getLinkType() == 0) continue;
                    hasLinkFields = true;
                    if (field.getLinkType() != 3) continue;
                    linkProcessed = true;
                    boolean needCheckPermissions = true;
                    DoubleList relatedRows = new DoubleList(1);
                    int rowsLeft = rows.length;
                    while (rowsLeft > 0) {
                        int rowsOffset = rows.length - rowsLeft;
                        int currentBatchSize = Math.min(1000, rowsLeft);
                        rowsLeft -= currentBatchSize;
                        this.idle();
                        StringBuilder sql = new StringBuilder();
                        SqlStringBuilder whereSql = new SqlStringBuilder();
                        FieldDescriptor relationField = relationInfo.getExistingFieldDescriptor(field.getFieldId());
                        whereSql.append(" from ").appendFull(relationInfo);
                        whereSql.append(" where ").append(relationField.getRawName());
                        whereSql.append(" in (?");
                        for (int i = 1; i < currentBatchSize; ++i) {
                            whereSql.append(",?");
                        }
                        whereSql.append(')');
                        sql.append("select ").append(relationInfo.getRecordIdField().getRawName()).append(whereSql);
                        try (PreparedStatement statement = database.prepareStatement("DeleteEngine.internalProcessRelatedRows", sql.toString());){
                            statement.setQueryTimeout();
                            for (int i = 0; i < currentBatchSize; ++i) {
                                statement.setDouble(i + 1, rows[rowsOffset + i]);
                            }
                            this.idle();
                            try (ResultSet fetcher = statement.executeQuery(this.ssContext);){
                                while (fetcher.next()) {
                                    this.idle();
                                    double fetchedRowId = fetcher.getDouble(1);
                                    if (this.processedRows.contains(tID, fetchedRowId)) continue;
                                    if (needCheckPermissions) {
                                        needCheckPermissions = false;
                                        this.checkPermissions(relationInfo.getNodeId());
                                    }
                                    relatedRows.add(fetchedRowId);
                                    if (this.changeNotifier != null) {
                                        this.changeNotifier.add(relationInfo.getNodeId(), 2, fetchedRowId, null);
                                    }
                                    if (this.auditWriter == null) continue;
                                    this.auditWriter.registrateModification(relationInfo, fetchedRowId, AuditModification.DELETE);
                                }
                            }
                        }
                        if (relatedRows.empty()) continue;
                        if (this.blobfs != null) {
                            for (Cursor.Double c : relatedRows) {
                                this.blobfs.delete(this.ssContext, database, relationInfo, c.value);
                            }
                        }
                        this.internalProcessRelatedRows(relationInfo, relatedRows.toArray(), database);
                        relatedRows.clear();
                        sql = new StringBuilder();
                        sql.append("delete ").append(whereSql);
                        statement = database.prepareStatement("DeleteEngine.internalProcessRelatedRows", sql.toString());
                        try {
                            statement.setQueryTimeout();
                            for (int i = 0; i < currentBatchSize; ++i) {
                                statement.setDouble(i + 1, rows[rowsOffset + i]);
                            }
                            this.idle();
                            statement.executeUpdate(this.ssContext);
                        }
                        finally {
                            statement.close();
                        }
                    }
                }
                this.idle();
                if (linkProcessed || !hasLinkFields || (command = this.createDeleteLinkSqlCommand(link, tableInfo, relationInfo, database.getDescriptor())) == null) continue;
                boolean needCheckPermissions = true;
                DoubleList relatedRows = new DoubleList(1);
                SqlParameter param = new SqlParameter();
                command.params.add(param);
                for (double rowId : rows) {
                    param.setDouble(rowId);
                    try (ClosableResult closableResult = command.executeQuery(this.ssContext, database);){
                        ResultSet fetcher = closableResult.getResultSet();
                        while (fetcher.next()) {
                            this.idle();
                            double fetchedRowId = fetcher.getDouble(1);
                            if (this.processedRows.contains(tID, fetchedRowId)) continue;
                            if (needCheckPermissions) {
                                needCheckPermissions = false;
                                this.checkPermissions(relationInfo.getNodeId());
                            }
                            relatedRows.add(fetchedRowId);
                            if (this.changeNotifier != null) {
                                this.changeNotifier.add(relationInfo.getNodeId(), 2, fetchedRowId, null);
                            }
                            if (this.auditWriter == null) continue;
                            this.auditWriter.registrateModification(relationInfo, fetchedRowId, AuditModification.DELETE);
                        }
                    }
                }
                if (relatedRows.empty()) continue;
                if (this.blobfs != null) {
                    Object rowsLeft = relatedRows.iterator();
                    while (rowsLeft.hasNext()) {
                        Cursor.Double c = (Cursor.Double)rowsLeft.next();
                        this.blobfs.delete(this.ssContext, database, relationInfo, c.value);
                    }
                }
                this.internalProcessRelatedRows(relationInfo, relatedRows.toArray(), database);
                this.idle();
                SqlStringBuilder sql = new SqlStringBuilder();
                sql.append("delete ");
                sql.append(" from ").appendFull(relationInfo);
                sql.append(" where ").append(relationInfo.getRecordIdField().getRawName()).append("=?");
                SqlCommandBatch deleteCommand = new SqlCommandBatch();
                deleteCommand.setSql(sql.toString(), 1);
                for (Cursor.Double c : relatedRows) {
                    deleteCommand.addBatch(database, this.ssContext).setDouble(0, c.value);
                }
                deleteCommand.execute(database, this.ssContext);
                this.idle();
            }
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    private SqlCommand createDeleteLinkSqlCommand(LinkDescriptor link, TableDescriptor tableInfo, TableDescriptor relationInfo, DatabaseDescriptor database) throws InformException {
        FieldDescriptor relationPk = relationInfo.getRecordIdField();
        if (relationPk == null) {
            return null;
        }
        FieldDescriptor pk = tableInfo.getRecordIdField();
        if (pk == null) {
            return null;
        }
        SqlCommand command = new SqlCommand();
        command.sqlText.append("select R.").append(relationPk.getRawName()).append(" from ").appendFull(relationInfo).append(" R,").appendFull(tableInfo).append(" T where T.").append(pk.getRawName()).append("=?");
        int addedCount = 0;
        block6: for (LinkField field : link.getFields()) {
            FieldDescriptor tableField = tableInfo.getFieldDescriptor(field.getLinkField());
            if (tableField == null) {
                return null;
            }
            command.sqlText.append(" and T.").append(tableField.getRawName());
            switch (field.getLinkType()) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    SqlParameter param;
                    ++addedCount;
                    command.sqlText.append("=?");
                    DataType dataType = field.getConstType();
                    if (dataType.isNumberPresentation()) {
                        param = new SqlParameter();
                        param.setDouble(field.getNumberValue());
                        command.params.add(param);
                        continue block6;
                    }
                    if (dataType == DataType.DATE_TIME) {
                        param = new SqlParameter();
                        param.setDateTime(field.getNumberValue());
                        command.params.add(param);
                        continue block6;
                    }
                    param = new SqlParameter();
                    param.setString(field.getStringValue());
                    command.params.add(param);
                    continue block6;
                }
                case 4: {
                    command.sqlText.append(" is null");
                    continue block6;
                }
                case 2: {
                    FieldDescriptor relationField = relationInfo.getFieldDescriptor(field.getFieldId());
                    if (relationField == null) {
                        return null;
                    }
                    ++addedCount;
                    command.sqlText.append("=R.").append(relationField.getRawName());
                    continue block6;
                }
            }
            return null;
        }
        if (addedCount == 0) {
            return null;
        }
        return command;
    }

    private void processRelatedRows(TableDescriptor tableInfo, double[] rows) throws InformException, SQLException {
        if (this.disableRelatedDelete) {
            return;
        }
        DatabaseConnection database = this.connectionManager.getConnection(tableInfo.getDbId(), "DeleteEngine::processRelatedRows");
        this.internalProcessRelatedRows(tableInfo, rows, database);
    }

    private boolean skipCheck(TableDescriptor refTable, double refNodeId) {
        if (refTable == null) {
            Core.logger.warn("incErrorCount refTable == null table:{}", (Object)Core.idstr(refNodeId));
            TableDirectoryDependencis.incErrorCount();
            return true;
        }
        if (!refTable.isOperableTable()) {
            Core.logger.warn("incErrorCount !refTable.isOperableTable() table:{}", (Object)Core.idstr(refNodeId));
            TableDirectoryDependencis.incErrorCount();
            return true;
        }
        if (!refTable.isCheckReferringIntegrity()) {
            Core.logger.warn("incErrorCount !refTable.isCheckReferringIntegrity() table:{}", (Object)Core.idstr(refNodeId));
            TableDirectoryDependencis.incErrorCount();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCheckReferringIntegrityFor(TableDescriptor tableInfo, double[] rows, TableDescriptor refTable, FieldDescriptor dirField) throws SQLException, InformException {
        double refNodeId = refTable.getNodeId();
        DatabaseConnection db = this.connectionManager.getConnection(refTable.getDbId(), "DeleteEngine::processCheckReferringIntegrityFor");
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select count(").append(dirField).append("), ").append(dirField).append(" from ").appendFull(refTable).append(" where ");
        if (refNodeId == tableInfo.getNodeId()) {
            sql.append(refTable.getRecordIdField()).append("<>").append(dirField).append(" and ");
        }
        sql.append(dirField).append(" in (?");
        String sqlPrefix = sql.toString();
        String sqlSuffix = ") group by " + dirField.getRawName() + " having count(" + dirField.getRawName() + ")>0";
        int rowsLeft = rows.length;
        while (rowsLeft > 0) {
            int rowsOffset = rows.length - rowsLeft;
            int currentBatchSize = Math.min(1000, rowsLeft);
            rowsLeft -= currentBatchSize;
            StringBuilder sqlFull = new StringBuilder(sqlPrefix);
            for (int i = 1; i < currentBatchSize; ++i) {
                sqlFull.append(",?");
            }
            sqlFull.append(sqlSuffix);
            try (PreparedStatement statement = db.prepareStatement("DeleteEngine.processCheckReferringIntegrityFor", sqlFull.toString());){
                statement.setQueryTimeout();
                for (int i = 0; i < currentBatchSize; ++i) {
                    statement.setDouble(i + 1, rows[rowsOffset + i]);
                }
                this.idle();
                try (ResultSet fetcher = statement.executeQuery(this.ssContext);){
                    while (fetcher.next()) {
                        this.idle();
                        int rowCount = fetcher.getInt(1);
                        if (rowCount <= 0) continue;
                        double rowId = fetcher.getDouble(2);
                        StringBuilder msg = new StringBuilder();
                        msg.append("\u0421\u0440\u0435\u0434\u0438 \u0443\u0434\u0430\u043b\u044f\u0435\u043c\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0438\u043c\u0435\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u0438 [").append(NumberConverter.doubleToString(rowId)).append("] \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(tableInfo).append(", \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0435\u0441\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 (\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e ").append(rowCount).append(") \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ").append(refTable).append(", \u043f\u043e\u043b\u0435 \"").append(dirField.getCaption()).append("\".\r\n\u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u0441\u044b\u043b\u043a\u0438, \u0430 \u0437\u0430\u0442\u0435\u043c \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0432 \u0434\u0430\u043d\u043d\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u0435.");
                        if (Strings.isVoid(this.checkReferencesMessage)) {
                            throw new DeleteEngineException(msg.toString());
                        }
                        throw new DeleteEngineException(this.checkReferencesMessage).detail(msg.toString());
                    }
                }
            }
        }
    }

    private void checkReferringIntegrity(TableDescriptor tableInfo, double[] rows) throws SQLException, InformException {
        try {
            if (!tableInfo.isCheckReferringIntegrity() || this.disableChecking) {
                return;
            }
            double[] refTables = tableInfo.getReferences(this.ssHost);
            if (refTables == null || refTables.length == 0) {
                return;
            }
            for (double refNodeId : refTables) {
                this.idle();
                TableDescriptor refTable = TableDescriptor.getIfExists(refNodeId);
                if (this.skipCheck(refTable, refNodeId) || refTable == null) continue;
                int checkedReferencesCount = 0;
                for (FieldDescriptor f : refTable.getFields()) {
                    if (f.isVirtual() || f.getType() != DataType.DIRECTORY || f.getReferenceId() != tableInfo.getNodeId() || f.isDontCheckRefs()) continue;
                    ++checkedReferencesCount;
                    this.processCheckReferringIntegrityFor(tableInfo, rows, refTable, f);
                }
                if (checkedReferencesCount != 0) continue;
                TableDirectoryDependencis.incErrorCount();
            }
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void getReferringIntegrityDetail(TableDescriptor tableInfo, double[] rows, StringBuilder msg) throws SQLException, InformException {
        try {
            if (!tableInfo.isCheckReferringIntegrity() || this.disableChecking) {
                return;
            }
            refTables = tableInfo.getReferences(this.ssHost);
            if (refTables == null || refTables.length == 0) {
                return;
            }
            lastId = 0.0;
            lastIdInvalid = true;
            for (double refNodeId : refTables) {
                this.idle();
                refTable = TableDescriptor.getIfExists(refNodeId);
                if (this.skipCheck(refTable, refNodeId) || refTable == null) continue;
                checkedReferencesCount = 0;
                for (FieldDescriptor f : refTable.getFields()) {
                    if (f.isVirtual() || f.getType() != DataType.DIRECTORY || f.getReferenceId() != tableInfo.getNodeId() || f.isDontCheckRefs()) continue;
                    ++checkedReferencesCount;
                    db = this.connectionManager.getConnection(refTable.getDbId(), "DeleteEngine::checkReferringIntegrity");
                    sql = new SqlStringBuilder();
                    sql.append("select count(").append(f).append("), ").append(f).append(" from ").appendFull(refTable).append(" where ");
                    if (refNodeId == tableInfo.getNodeId()) {
                        sql.append(refTable.getRecordIdField()).append("<>").append(f).append(" and ");
                    }
                    sql.append(f).append(" in (?");
                    sqlPrefix = sql.toString();
                    sqlSuffix = ") group by " + f.getRawName() + " having count(" + f.getRawName() + ")>0";
                    rowsLeft = rows.length;
                    while (rowsLeft > 0) {
                        rowsOffset = rows.length - rowsLeft;
                        currentBatchSize = Math.min(1000, rowsLeft);
                        rowsLeft -= currentBatchSize;
                        sqlFull = new StringBuilder(sqlPrefix);
                        for (i = 1; i < currentBatchSize; ++i) {
                            sqlFull.append(",?");
                        }
                        sqlFull.append(sqlSuffix);
                        statement = db.prepareStatement("DeleteEngine.getReferringIntegrityDetail", sqlFull.toString());
                        try {
                            statement.setQueryTimeout();
                            for (i = 0; i < currentBatchSize; ++i) {
                                statement.setDouble(i + 1, rows[rowsOffset + i]);
                            }
                            this.idle();
                            fetcher = statement.executeQuery(this.ssContext);
lbl48:
                            // 3 sources

                            try {
                                while (fetcher.next()) {
                                    this.idle();
                                    rowCount = fetcher.getInt(1);
                                    if (rowCount <= 0) ** GOTO lbl48
                                    rowId = fetcher.getDouble(2);
                                    if (lastId != rowId || lastIdInvalid) {
                                        if (lastIdInvalid) {
                                            msg.append("\n\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c ").append(NumberConverter.doubleToString(rowId)).append(" \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(tableInfo).append(" \u0435\u0441\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438:");
                                        } else {
                                            msg.append("\n\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c ").append(NumberConverter.doubleToString(rowId)).append(" \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(NumberConverter.doubleToString(tableInfo.getNodeId())).append(':');
                                        }
                                        lastId = rowId;
                                        lastIdInvalid = false;
                                    }
                                    msg.append("\n\t").append(rowCount).append("\u0448\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ").append(refTable).append(" \u043f\u043e \u043f\u043e\u043b\u044e \"").append(f.getCaption()).append('\"');
                                    if (msg.length() <= 32768) ** GOTO lbl48
                                    msg.append("\n... <\u0434\u0438\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0430 \u0441\u0441\u044b\u043b\u043e\u0447\u043d\u043e\u0439 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0438\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e>");
                                    return;
                                }
                            }
                            finally {
                                fetcher.close();
                            }
                        }
                        finally {
                            statement.close();
                        }
                    }
                }
                if (checkedReferencesCount != 0) continue;
                TableDirectoryDependencis.incErrorCount();
            }
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needDelete(double tableId, double rowId) throws InformException, SQLException {
        TableDescriptor tableInfo;
        try {
            tableInfo = TableDescriptor.get(tableId);
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
            return false;
        }
        this.idle();
        DatabaseConnection db = this.connectionManager.getConnection(tableInfo.getDbId(), "DeleteEngine::needDelete");
        SqlStringBuilder sqlText = new SqlStringBuilder();
        sqlText.append("select ").append(tableInfo.getRecordIdField()).append(" from ").appendFull(tableInfo).append(" where ").append(tableInfo.getRecordIdField()).append("=?");
        try (PreparedStatement statement = db.prepareStatement("DeleteEngine.needDelete", sqlText.toString());){
            boolean bl;
            statement.setQueryTimeout();
            statement.setDouble(1, rowId);
            this.idle();
            ResultSet fetcher = statement.executeQuery(this.ssContext);
            try {
                this.idle();
                bl = fetcher.next();
            }
            catch (Throwable throwable) {
                fetcher.close();
                throw throwable;
            }
            fetcher.close();
            return bl;
        }
    }

    private int generateIntricateFields(byte[] intricateKey, TableDescriptor tableInfo, SqlStringBuilder fields, SqlStringBuilder where, SqlParameterList parameters) throws IOException {
        TaggedReader in = new TaggedReader(intricateKey);
        int comma = 32;
        String and = "";
        int fieldCount = 0;
        while (in.next()) {
            int fieldId = in.getInt();
            ++fieldCount;
            FieldDescriptor fieldInfo = tableInfo.getExistingFieldDescriptor(fieldId);
            if (fields != null) {
                fields.append((char)comma).append(fieldInfo);
                comma = 44;
            }
            if (where == null || parameters == null) continue;
            where.append(and).append(fieldInfo);
            and = " AND ";
            switch (in.getNextTag()) {
                case 10: {
                    where.append(" IS NULL");
                    break;
                }
                case 11: {
                    SqlParameter value = new SqlParameter();
                    parameters.add(value);
                    where.append("=?");
                    value.setInteger(in.getInt());
                    break;
                }
                case 12: {
                    SqlParameter value = new SqlParameter();
                    parameters.add(value);
                    where.append("=?");
                    value.setDouble(in.getDouble());
                    break;
                }
                case 13: {
                    SqlParameter value = new SqlParameter();
                    parameters.add(value);
                    where.append("=?");
                    value.setString(in.getAnsi());
                    break;
                }
                case 14: {
                    SqlParameter value = new SqlParameter();
                    parameters.add(value);
                    where.append("=?");
                    value.setDateTime(in.getDouble());
                    break;
                }
                case 15: {
                    SqlParameter value = new SqlParameter();
                    parameters.add(value);
                    where.append("=?");
                    value.setBlob(in.getRaw());
                    break;
                }
                case 24: {
                    SqlParameter value = new SqlParameter();
                    parameters.add(value);
                    where.append("=?");
                    value.setUnicode(in.getUnicode());
                }
            }
        }
        return fieldCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needDelete(double tableId, byte[] intricateKey) throws InformException, SQLException, IOException {
        TableDescriptor tableInfo;
        try {
            tableInfo = TableDescriptor.get(tableId);
        }
        catch (Throwable ex) {
            Core.logger.error(null, ex);
            return false;
        }
        this.idle();
        DatabaseConnection db = this.connectionManager.getConnection(tableInfo.getDbId(), "DeleteEngine::needDelete");
        SqlCommand command = new SqlCommand();
        SqlStringBuilder sqlFields = new SqlStringBuilder();
        SqlStringBuilder sqlWhere = new SqlStringBuilder();
        this.generateIntricateFields(intricateKey, tableInfo, sqlFields, sqlWhere, command.params);
        command.sqlText.append("select ").append(sqlFields).append(" from ").appendFull(tableInfo).append(" where ").append(sqlWhere);
        command.setTableDescriptor(tableInfo);
        try (ClosableResult closableResult = command.executeQuery(this.ssContext, db);){
            this.idle();
            boolean bl = closableResult.getResultSet().next();
            return bl;
        }
    }

    private void processDelete() throws SQLException, InformException, IOException {
        SqlCommandBatch command;
        DatabaseConnection db;
        Object rows;
        TableDescriptor tableInfo;
        double[] tables;
        if (this.rowList.hasTables()) {
            for (double tableId : tables = this.rowList.getTables()) {
                try {
                    tableInfo = TableDescriptor.get(tableId);
                }
                catch (Throwable ex) {
                    Core.logger.error(null, ex);
                    continue;
                }
                if (tableInfo.getRecordIdField() == null) {
                    throw new DeleteEngineException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 " + tableInfo.toString() + " \u043e\u0442\u0441\u0443\u0442\u0432\u0443\u0435\u0442 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
                }
                this.idle();
                this.checkPermissions(tableId);
                rows = this.rowList.getRows(tableId);
                if (rows == null || ((double[])rows).length == 0) continue;
                this.checkReferringIntegrity(tableInfo, (double[])rows);
                db = this.connectionManager.getConnection(tableInfo.getDbId(), "DeleteEngine::processDelete");
                command = new SqlCommandBatch();
                SqlStringBuilder sqlStringBuilder = new SqlStringBuilder();
                sqlStringBuilder.append("delete from ").appendFull(tableInfo).append(" where ").append(tableInfo.getRecordIdField().getRawName()).append("=?");
                command.setSql(sqlStringBuilder.toString(), 1);
                Object object = rows;
                int n = ((double[])object).length;
                for (int i = 0; i < n; ++i) {
                    double rowId = object[i];
                    if (this.blobfs != null) {
                        this.blobfs.delete(this.ssContext, db, tableInfo, rowId);
                    }
                    command.addBatch(db, this.ssContext);
                    command.getParameters().setDouble(0, rowId);
                    if (this.changeNotifier == null) continue;
                    this.changeNotifier.add(tableId, 2, rowId, null);
                }
                this.idle();
                if (!command.isEmpty()) {
                    command.execute(db, this.ssContext);
                }
                this.idle();
            }
        }
        if (this.rowList.hasIntricateTables()) {
            for (double tableId : tables = this.rowList.getIntricateTables()) {
                try {
                    tableInfo = TableDescriptor.get(tableId);
                }
                catch (Throwable ex) {
                    Core.logger.error(null, ex);
                    continue;
                }
                this.idle();
                this.checkPermissions(tableId);
                rows = this.rowList.getIntricateRows(tableId);
                if (rows == null || ((double[])rows).length == 0) continue;
                db = this.connectionManager.getConnection(tableInfo.getDbId(), "DeleteEngine::processDelete");
                command = new SqlCommandBatch();
                for (double rowId : rows) {
                    SqlCommand cmd = new SqlCommand();
                    cmd.sqlText.append("delete from ").appendFull(tableInfo).append(" where ");
                    this.generateIntricateFields((byte[])rowId, tableInfo, null, cmd.sqlText, cmd.params);
                    command.add(cmd, db, this.ssContext);
                }
                this.idle();
                if (!command.isEmpty()) {
                    command.execute(db, this.ssContext);
                }
                this.idle();
            }
        }
    }

    public void checkDeleteRow(double tableNodeId, double rowId) throws InformException, SQLException {
        this.idle();
        this.checkPermissions(tableNodeId);
        this.checkingRows = new ProcessingTableRowList();
        int index = this.rowList.tableRows.size();
        this.rowList.add(tableNodeId, rowId);
        for (int i = index; i < this.rowList.tableRows.size(); ++i) {
            TableDescriptor tableInfo;
            ProcessingTableRowList.TableRow tableRow = this.rowList.tableRows.get(i);
            try {
                tableInfo = TableDescriptor.get(tableRow.table);
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
                return;
            }
            if (this.processedRows.contains(tableInfo.getNodeId(), tableRow.row)) {
                return;
            }
            this.processRelatedRows(tableInfo, new double[]{tableRow.row});
            if (!tableInfo.isCascadeDeleteElements()) continue;
            this.enumElements(tableInfo, tableRow.row);
        }
        this.checkAllReferringIntegrity();
    }

    protected void checkAllReferringIntegrity() throws SQLException {
        if (this.disableChecking) {
            return;
        }
        try {
            for (ProcessingTableRowList.TableRows tableRows : this.checkingRows.hash) {
                TableDescriptor tableDescriptor = TableDescriptor.get(tableRows.tableNodeId);
                this.checkReferringIntegrity(tableDescriptor, tableRows.toArray());
            }
        }
        catch (DeleteEngineException e) {
            StringBuilder msg = new StringBuilder();
            for (ProcessingTableRowList.TableRows tableRows : this.checkingRows.hash) {
                TableDescriptor tableDescriptor = TableDescriptor.get(tableRows.tableNodeId);
                this.getReferringIntegrityDetail(tableDescriptor, tableRows.toArray(), msg);
            }
            if (msg.length() == 0) {
                throw e;
            }
            StringBuilder detail = new StringBuilder();
            detail.append("\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0430 \u0441\u0441\u044b\u043b\u043e\u0447\u043d\u0430\u044f \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c:").append((CharSequence)msg);
            throw new DeleteEngineException(e.getMessage(), e).detail(detail.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enumElements(TableDescriptor tableInfo, double row) throws InformException, SQLException {
        if (this.hasElements == null) {
            this.hasElements = new PhenixLinks.HasElements(this.ssContext, this.connectionManager);
        }
        if (!this.hasElements.hasElements(tableInfo)) {
            return;
        }
        DatabaseConnection connection = this.connectionManager.getConnection(tableInfo.getDbId(), "DeleteEngine::enumElements");
        SqlExecutor selectRight = PhenixLinks.createSelectRightTableExecutor(this.ssContext, 1, connection);
        SqlExecutor deleteLeft = PhenixLinks.createLeftDeleteExecutor(this.ssContext, 1, connection);
        SqlExecutor deleteLinked = PhenixLinks.createLeftOrRightDeleteExecutor(this.ssContext, 2, connection);
        try {
            int i;
            ArrayList<ProcessingTableRowList.TableRow> elements = new ArrayList<ProcessingTableRowList.TableRow>();
            ProcessingTableRowList.TableRow rec = new ProcessingTableRowList.TableRow(tableInfo.getNodeId(), row);
            elements.add(rec);
            for (i = 0; i < elements.size(); ++i) {
                ProcessingTableRowList.TableRow p_rec = (ProcessingTableRowList.TableRow)elements.get(i);
                ((SqlParameter)selectRight.params.get(0)).setDouble(p_rec.table);
                ((SqlParameter)selectRight.params.get(1)).setDouble(p_rec.row);
                try (ResultSet fetch = selectRight.executeQueryCached();){
                    while (fetch.next()) {
                        double rTable = fetch.getDouble(1);
                        double rRow = fetch.getDouble(2);
                        if (this.missingNodes.contains(rTable)) continue;
                        if (MtdEngine.getNode(rTable) == null) {
                            this.missingNodes.add(rTable);
                            continue;
                        }
                        rec = new ProcessingTableRowList.TableRow(rTable, rRow);
                        elements.add(rec);
                    }
                    ((SqlParameter)deleteLeft.params.get(0)).setDouble(p_rec.table);
                    ((SqlParameter)deleteLeft.params.get(1)).setDouble(p_rec.row);
                    ((SqlParameter)deleteLinked.params.get(0)).setDouble(p_rec.table);
                    ((SqlParameter)deleteLinked.params.get(1)).setDouble(p_rec.row);
                    ((SqlParameter)deleteLinked.params.get(2)).setDouble(p_rec.table);
                    ((SqlParameter)deleteLinked.params.get(3)).setDouble(p_rec.row);
                    deleteLeft.executeUpdateCached();
                    deleteLinked.executeUpdateCached();
                    continue;
                }
            }
            for (i = 1; i < elements.size(); ++i) {
                ProcessingTableRowList.TableRow r = (ProcessingTableRowList.TableRow)elements.get(i);
                this.rowList.add(r.table, r.row);
            }
        }
        finally {
            selectRight.close();
            deleteLeft.close();
            deleteLinked.close();
        }
    }

    private void idle() {
        if (this.ssHost != null) {
            this.ssHost.idle();
        } else if (!this.cancelThrowed && Thread.currentThread().isInterrupted()) {
            this.cancelThrowed = true;
            throw new CancelRequestException();
        }
    }

    void addViolationReferringIntegrity(TableDescriptor table, double recordId, TableDescriptor refTable, FieldDescriptor dirField) {
        ViolationReferringIntegrityTable ref = this.vri.get(table.getNodeId());
        if (ref == null) {
            this.vri.add(new ViolationReferringIntegrityTable(table, recordId, refTable, dirField));
        } else {
            ref.add(recordId, refTable, dirField);
        }
        ++this.vriCount;
    }

    static class ViolationReferringIntegrityTable
    extends DoubleHash<ViolationReferringIntegrityRecord>
    implements DoubleHash.Entry {
        final TableDescriptor table;
        int count;

        ViolationReferringIntegrityTable(TableDescriptor table, double recordId, TableDescriptor refTable, FieldDescriptor dirField) {
            this.table = table;
            this.count = 1;
            this.add(new ViolationReferringIntegrityRecord(recordId, refTable, dirField));
        }

        void add(double recordId, TableDescriptor refTable, FieldDescriptor dirField) {
            ViolationReferringIntegrityRecord ref = (ViolationReferringIntegrityRecord)this.get(recordId);
            if (ref == null) {
                this.add(new ViolationReferringIntegrityRecord(recordId, refTable, dirField));
            } else {
                ref.add(refTable, dirField);
            }
            ++this.count;
        }

        @Override
        public double key() {
            return this.table.getNodeId();
        }
    }

    static class ViolationReferringIntegrityRecord
    extends DoubleHash<ViolationReferringIntegrityReference>
    implements DoubleHash.Entry {
        final double recordId;

        ViolationReferringIntegrityRecord(double recordId, TableDescriptor refTable, FieldDescriptor dirField) {
            this.recordId = recordId;
            this.add(new ViolationReferringIntegrityReference(refTable, dirField));
        }

        void add(TableDescriptor refTable, FieldDescriptor dirField) {
            ViolationReferringIntegrityReference ref = (ViolationReferringIntegrityReference)this.get(refTable.getNodeId());
            if (ref == null) {
                this.add(new ViolationReferringIntegrityReference(refTable, dirField));
            } else {
                ref.add(dirField);
            }
        }

        @Override
        public double key() {
            return this.recordId;
        }
    }

    static class ViolationReferringIntegrityReference
    implements DoubleHash.Entry {
        final TableDescriptor refTable;
        final ArrayList<FieldDescriptor> dirFields;
        final IntegerList counts;

        public ViolationReferringIntegrityReference(TableDescriptor refTable, FieldDescriptor dirField) {
            this.refTable = refTable;
            this.dirFields = new ArrayList(1);
            this.dirFields.add(dirField);
            this.counts = new IntegerList(1);
            this.counts.add(1);
        }

        void add(FieldDescriptor dirField) {
            int size = this.dirFields.size();
            for (int i = 0; i < size; ++i) {
                FieldDescriptor f = this.dirFields.get(i);
                if (f.getId() != dirField.getId()) continue;
                this.counts.set(i, this.counts.get(i) + 1);
                return;
            }
            this.dirFields.add(dirField);
            this.counts.add(1);
        }

        @Override
        public double key() {
            return this.refTable.getNodeId();
        }
    }
}

