/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.commit;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.IntegerSet;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.Row;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlBatchParamList;
import inform.agent.db.utils.SqlCommand;
import inform.agent.db.utils.SqlCommandBatch;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.MtdEngine;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.util.Iterator;

public class TableDataAudit {
    private static final int AUDIT_ID = 0;
    private static final int AUDIT_TABLE_ID = 1;
    private static final int AUDIT_RECORD_ID = 2;
    private static final int AUDIT_OP_CODE = 3;
    private static final int AUDIT_OP_TIME = 4;
    private static final int AUDIT_USER_ID = 5;
    private static final int AUDIT_REPL_NODE_ID = 6;
    private static final int AUDIT_PREV_RECORD_ID = 7;
    private static final int AUDIT_OWNER_ID = 8;
    private static final int AUDIT_MODIFIED_FIELDS = 9;
    private static final int AUDIT_TRANS_ID = 10;
    private static final int AUDIT_SESSION_ID = 11;
    private static final int AUDIT_EVENT_ID = 12;
    private static final int AUDIT_REPLICA_ID = 13;
    private static final int AUDIT_FIELD_COUNT = 14;
    private static final int DATA_AUDIT_ID = 0;
    private static final int DATA_AUDIT_TABLE_ID = 1;
    private static final int DATA_AUDIT_RECORD_ID = 2;
    private static final int DATA_AUDIT_FIELD_ID = 3;
    private static final int DATA_AUDIT_OPERATION = 4;
    private static final int DATA_AUDIT_TIME = 5;
    private static final int DATA_AUDIT_USER_ID = 6;
    private static final int DATA_AUDIT_NUMBER_VALUE = 7;
    private static final int DATA_AUDIT_STRING_VALUE = 8;
    private static final int DATA_AUDIT_DATE_VALUE = 9;
    private static final int DATA_AUDIT_UNICODE_VALUE = 10;
    private static final int DATA_AUDIT_BLOB_VALUE = 7;
    private static final int TRANS_AUDIT_ID = 0;
    private static final int TRANS_AUDIT_BEGIN = 1;
    private static final int TRANS_AUDIT_END = 2;
    private static final int TRANS_AUDIT_REPL_NODE_ID = 3;
    private static final int TRANS_AUDIT_SESSION_ID = 4;
    private static final int TRANS_AUDIT_MOD_COUNT = 5;
    public static final String CHANGE_LOG_TABLE_NAME = "PHX_CHANGELOG";
    public static final String VALUE_CHANGE_LOG_TABLE_NAME = "PHX_CHANGELOG_VAL";
    public static final String BLOB_CHANGE_LOG_TABLE_NAME = "PHX_CHANGELOG_BLOB";
    public static final String TRANS_CHANGE_LOG_TABLE_NAME = "PHX_CHANGELOG_TRANS";
    private final boolean auditEnabled;
    private double userNodeId;
    private final double effectiveUserId;
    private final double receivingId;
    private final double replicaId;
    private final double sessionId;
    private boolean avoidBatch;
    private final DatabaseConnection database;
    private final double databaseId;
    private SqlCommandBatch operationCommand;
    private SqlCommandBatch dataCommand;
    private SqlCommandBatch blobCommand;
    private SqlCommand transCommand;
    private IntegerSet modifiedFields = null;
    private double auditEventId = 0.0;
    private double auditOwnerId = 0.0;
    private double beginTime = 0.0;
    private double transactionId = 0.0;
    private long modificationCount = 0L;
    private SSContext context;
    private IntegerSet auditPrevFields = null;
    private TableDescriptor auditPrevTable = null;
    private double auditPrevRecordId;
    private static final double TRANS_TIME_GAP = 3.472222222222222E-5;
    private DoubleHash<DeleteOperationBatchCommand> deleteOperationBatchCommands;
    public static final String AUDIT_ID_NAME = "ID";
    public static final String AUDIT_TABLE_ID_NAME = "TABLE_ID";
    public static final String AUDIT_RECORD_ID_NAME = "RECORD_ID";
    public static final String AUDIT_OP_CODE_NAME = "OP_CODE";
    public static final String AUDIT_OP_TIME_NAME = "OP_TIME";
    public static final String AUDIT_USER_ID_NAME = "USER_ID";
    public static final String AUDIT_REPL_NODE_ID_NAME = "REPL_NODE_ID";
    public static final String AUDIT_PREV_RECORD_ID_NAME = "PREV_RECORD_ID";
    public static final String AUDIT_OWNER_ID_NAME = "MASTER_TABLE_ID";
    public static final String AUDIT_REPLICA_ID_NAME = "MASTER_RECORD_ID";
    public static final String AUDIT_MODIFIED_FIELDS_NAME = "FLDS";
    public static final String AUDIT_TRANS_ID_NAME = "TRANS_ID";
    public static final String AUDIT_SESSION_ID_NAME = "SESSION_ID";
    public static final String AUDIT_EVENT_ID_NAME = "EVENT_ID";
    private static final String AUDIT_FIELDS = "ID,TABLE_ID,RECORD_ID,OP_CODE,OP_TIME,USER_ID,REPL_NODE_ID,PREV_RECORD_ID,MASTER_TABLE_ID,FLDS,TRANS_ID,SESSION_ID,EVENT_ID,MASTER_RECORD_ID";
    private static final FieldDescriptor AUDIT_TABLE_ID_FIELD = new FieldDescriptor(1, "TABLE_ID", DataType.METATREE_NODE, 0, true);
    private static final FieldDescriptor AUDIT_RECORD_ID_FIELD = new FieldDescriptor(2, "RECORD_ID", DataType.DIRECTORY, 0, true);
    private static final FieldDescriptor AUDIT_OP_CODE_FIELD = new FieldDescriptor(3, "OP_CODE", DataType.INTEGER, 0, true);
    private static final FieldDescriptor AUDIT_OP_TIME_FIELD = new FieldDescriptor(4, "OP_TIME", DataType.DATE_TIME, 0, true);
    private static final FieldDescriptor AUDIT_USER_ID_FIELD = new FieldDescriptor(5, "USER_ID", DataType.METATREE_NODE, 0, true);
    private static final FieldDescriptor AUDIT_REPL_NODE_ID_FIELD = new FieldDescriptor(6, "REPL_NODE_ID", DataType.METATREE_NODE, 0, true);
    private static final FieldDescriptor AUDIT_PREV_RECORD_ID_FIELD = new FieldDescriptor(7, "PREV_RECORD_ID", DataType.DIRECTORY, 0, true);
    private static final FieldDescriptor AUDIT_OWNER_ID_FIELD = new FieldDescriptor(8, "MASTER_TABLE_ID", DataType.METATREE_NODE, 0, true);
    private static final FieldDescriptor AUDIT_REPLICA_ID_FIELD = new FieldDescriptor(13, "MASTER_RECORD_ID", DataType.DIRECTORY, 0, true);
    private static final FieldDescriptor AUDIT_MODIFIED_FIELDS_FIELD = new FieldDescriptor(9, "FLDS", DataType.STRING, 4000, true);
    private static final FieldDescriptor AUDIT_TRANS_ID_FIELD = new FieldDescriptor(10, "TRANS_ID", DataType.DIRECTORY, 0, true);
    private static final FieldDescriptor AUDIT_SESSION_ID_FIELD = new FieldDescriptor(11, "SESSION_ID", DataType.DIRECTORY, 0, true);
    private static final FieldDescriptor AUDIT_EVENT_ID_FIELD = new FieldDescriptor(12, "EVENT_ID", DataType.DIRECTORY, 0, true);
    private static final FieldDescriptor[] AUDIT_FIELD_DESCRIPTORS = new FieldDescriptor[]{AUDIT_TABLE_ID_FIELD, AUDIT_RECORD_ID_FIELD, AUDIT_OP_CODE_FIELD, AUDIT_OP_TIME_FIELD, AUDIT_USER_ID_FIELD, AUDIT_REPL_NODE_ID_FIELD, AUDIT_PREV_RECORD_ID_FIELD, AUDIT_OWNER_ID_FIELD, AUDIT_REPLICA_ID_FIELD, AUDIT_MODIFIED_FIELDS_FIELD, AUDIT_TRANS_ID_FIELD, AUDIT_SESSION_ID_FIELD, AUDIT_EVENT_ID_FIELD};
    private static final FieldDescriptor[] AUDIT_3COL_INDEX_FIELD_DESCRIPTORS = new FieldDescriptor[]{AUDIT_TABLE_ID_FIELD, AUDIT_OP_TIME_FIELD, AUDIT_REPL_NODE_ID_FIELD};
    private static final FieldDescriptor[] AUDIT_RTOP_INDEX_FIELD_DESCRIPTORS = new FieldDescriptor[]{AUDIT_RECORD_ID_FIELD, AUDIT_TABLE_ID_FIELD, AUDIT_OP_TIME_FIELD};
    private static final FieldDescriptor[] AUDIT_TRNS_INDEX_FIELD_DESCRIPTORS = new FieldDescriptor[]{AUDIT_TRANS_ID_FIELD, AUDIT_TABLE_ID_FIELD, AUDIT_OP_CODE_FIELD};
    private static final String DATA_AUDIT_ID_NAME = "ID";
    private static final String DATA_AUDIT_TABLE_ID_NAME = "TABLE_ID";
    private static final String DATA_AUDIT_RECORD_ID_NAME = "RECORD_ID";
    private static final String DATA_AUDIT_FIELD_ID_NAME = "FIELD_ID";
    private static final String DATA_AUDIT_OPERATION_NAME = "OP_CODE";
    private static final String DATA_AUDIT_TIME_NAME = "OP_TIME";
    private static final String DATA_AUDIT_USER_ID_NAME = "USER_ID";
    private static final String DATA_AUDIT_NUMBER_VALUE_NAME = "NUM_VAL";
    private static final String DATA_AUDIT_STRING_VALUE_NAME = "STR_VAL";
    private static final String DATA_AUDIT_DATE_VALUE_NAME = "DT_VAL";
    private static final String DATA_AUDIT_UNICODE_VALUE_NAME = "UNICODE_VAL";
    private static final String DATA_AUDIT_BLOB_VALUE_NAME = "BLOB_VAL";
    private static final String DATA_AUDIT_FIELDS = "ID,TABLE_ID,RECORD_ID,FIELD_ID,OP_CODE,OP_TIME,USER_ID,NUM_VAL,STR_VAL,DT_VAL,UNICODE_VAL";
    private static final String DATA_AUDIT_PREV_FIELDS = "FIELD_ID,NUM_VAL,STR_VAL,DT_VAL,UNICODE_VAL";
    private static final int DATA_AUDIT_FIELD_COUNT = 11;
    private static final String BLOB_AUDIT_FIELDS = "ID,TABLE_ID,RECORD_ID,FIELD_ID,OP_CODE,OP_TIME,USER_ID,BLOB_VAL";
    private static final int BLOB_AUDIT_FIELD_COUNT = 8;
    private static final int PREV_DA_FIELD_ID = 1;
    private static final int PREV_DA_NUMBER = 2;
    private static final int PREV_DA_STRING = 3;
    private static final int PREV_DA_DATE = 4;
    private static final int PREV_DA_UNICODE = 5;
    private static final int DATA_AUDIT_STRING_VALUE_MAXLENGTH = 4000;
    public static final FieldDescriptor DATA_AUDIT_TABLE_ID_FIELD = new FieldDescriptor(1, "TABLE_ID", DataType.METATREE_NODE, 0, true);
    public static final FieldDescriptor DATA_AUDIT_RECORD_ID_FIELD = new FieldDescriptor(2, "RECORD_ID", DataType.DIRECTORY, 0, true);
    public static final FieldDescriptor DATA_AUDIT_FIELD_ID_FIELD = new FieldDescriptor(3, "FIELD_ID", DataType.INTEGER, 0, true);
    private static final FieldDescriptor DATA_AUDIT_OPERATION_FIELD = new FieldDescriptor(4, "OP_CODE", DataType.INTEGER, 0, true);
    public static final FieldDescriptor DATA_AUDIT_TIME_FIELD = new FieldDescriptor(5, "OP_TIME", DataType.DATE_TIME, 0, true);
    public static final FieldDescriptor DATA_AUDIT_USER_ID_FIELD = new FieldDescriptor(6, "USER_ID", DataType.METATREE_NODE, 0, true);
    public static final FieldDescriptor DATA_AUDIT_NUMBER_VALUE_FIELD = new FieldDescriptor(7, "NUM_VAL", DataType.FLOAT, 0, true);
    private static final FieldDescriptor DATA_AUDIT_STRING_VALUE_FIELD = new FieldDescriptor(8, "STR_VAL", DataType.STRING, 4000, true);
    private static final FieldDescriptor DATA_AUDIT_DATE_VALUE_FIELD = new FieldDescriptor(9, "DT_VAL", DataType.DATE_TIME, 0, true);
    private static final FieldDescriptor DATA_AUDIT_UNICODE_VALUE_FIELD = new FieldDescriptor(10, "UNICODE_VAL", DataType.UNICODE, 1000, true);
    public static final FieldDescriptor DATA_AUDIT_BLOB_VALUE_FIELD = new FieldDescriptor(7, "BLOB_VAL", DataType.BLOB, 0, true);
    private static final FieldDescriptor[] DATA_AUDIT_FIELD_DESCRIPTORS = new FieldDescriptor[]{DATA_AUDIT_TABLE_ID_FIELD, DATA_AUDIT_RECORD_ID_FIELD, DATA_AUDIT_FIELD_ID_FIELD, DATA_AUDIT_OPERATION_FIELD, DATA_AUDIT_TIME_FIELD, DATA_AUDIT_USER_ID_FIELD, DATA_AUDIT_NUMBER_VALUE_FIELD, DATA_AUDIT_STRING_VALUE_FIELD, DATA_AUDIT_DATE_VALUE_FIELD, DATA_AUDIT_UNICODE_VALUE_FIELD};
    private static final FieldDescriptor[] DATA_AUDIT_INDEX_FIELD_DESCRIPTORS = new FieldDescriptor[]{DATA_AUDIT_TABLE_ID_FIELD, DATA_AUDIT_RECORD_ID_FIELD, DATA_AUDIT_TIME_FIELD, DATA_AUDIT_FIELD_ID_FIELD};
    public static final String TRANS_AUDIT_ID_NAME = "ID";
    public static final String TRANS_AUDIT_BEGIN_NAME = "T_BEG";
    public static final String TRANS_AUDIT_END_NAME = "T_END";
    public static final String TRANS_AUDIT_REPL_NODE_ID_NAME = "REPL_NODE_ID";
    public static final String TRANS_AUDIT_SESSION_ID_NAME = "SESSION_ID";
    public static final String TRANS_AUDIT_MOD_COUNT_NAME = "MOD_COUNT";
    private static final FieldDescriptor TRANS_AUDIT_ID_FIELD = new FieldDescriptor(0, "ID", DataType.PRIMARY_KEY, 0, true);
    public static final FieldDescriptor TRANS_AUDIT_BEGIN_FIELD = new FieldDescriptor(1, "T_BEG", DataType.DATE_TIME, 0, true);
    public static final FieldDescriptor TRANS_AUDIT_END_FIELD = new FieldDescriptor(2, "T_END", DataType.DATE_TIME, 0, true);
    public static final FieldDescriptor TRANS_AUDIT_REPL_NODE_ID_FIELD = new FieldDescriptor(3, "REPL_NODE_ID", DataType.DIRECTORY, 0, true);
    public static final FieldDescriptor TRANS_AUDIT_SESSION_ID_FIELD = new FieldDescriptor(4, "SESSION_ID", DataType.DIRECTORY, 0, true);
    public static final FieldDescriptor TRANS_AUDIT_MOD_COUNT_FIELD = new FieldDescriptor(5, "MOD_COUNT", DataType.INTEGER, 0, true);
    private static final String TRANS_AUDIT_FIELDS = "ID,T_BEG,T_END,REPL_NODE_ID,SESSION_ID,MOD_COUNT";
    private static final FieldDescriptor[] TRANS_AUDIT_FIELD_DESCRIPTORS = new FieldDescriptor[]{TRANS_AUDIT_BEGIN_FIELD, TRANS_AUDIT_END_FIELD, TRANS_AUDIT_REPL_NODE_ID_FIELD, TRANS_AUDIT_SESSION_ID_FIELD, TRANS_AUDIT_MOD_COUNT_FIELD};
    private static final FieldDescriptor[] TRANS_AUDIT_INDEX_FIELD_DESCRIPTORS = new FieldDescriptor[]{TRANS_AUDIT_END_FIELD, TRANS_AUDIT_BEGIN_FIELD, TRANS_AUDIT_REPL_NODE_ID_FIELD, TRANS_AUDIT_ID_FIELD};
    private static TableDescriptor systemChangelog;
    private static TableDescriptor systemChangelogVal;
    private static TableDescriptor systemChangelogBlob;
    private static TableDescriptor systemTransChangelog;
    private static final String NUMBER_DELETE_FIELDS = "ID,TABLE_ID,RECORD_ID,FIELD_ID,OP_CODE,OP_TIME,USER_ID,NUM_VAL";
    private static final String STRING_DELETE_FIELDS = "ID,TABLE_ID,RECORD_ID,FIELD_ID,OP_CODE,OP_TIME,USER_ID,STR_VAL";
    private static final String DATE_DELETE_FIELDS = "ID,TABLE_ID,RECORD_ID,FIELD_ID,OP_CODE,OP_TIME,USER_ID,DT_VAL";
    private static final String UNICODE_DELETE_FIELDS = "ID,TABLE_ID,RECORD_ID,FIELD_ID,OP_CODE,OP_TIME,USER_ID,UNICODE_VAL";

    public TableDataAudit(SSContext context, DatabaseConnection database, double userNodeId, double effectiveUserId, double receivingId, double replicaId, double sessionId) {
        DatabaseDescriptor databaseInfo = database.getDescriptor();
        this.databaseId = databaseInfo.getNodeId();
        this.avoidBatch = true;
        this.auditEnabled = databaseInfo.isAuditEnabled();
        this.userNodeId = userNodeId;
        this.effectiveUserId = effectiveUserId;
        this.receivingId = receivingId;
        this.replicaId = replicaId;
        this.sessionId = sessionId;
        this.context = context;
        DatabaseConnection databaseConnection = this.database = this.auditEnabled ? database : null;
        if (!this.auditEnabled) {
            return;
        }
        this.operationCommand = TableDataAudit.createOperationBatchCommand(new SqlCommandBatch(), databaseInfo);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ");
        databaseInfo.appendDetailAuditTableRawName(VALUE_CHANGE_LOG_TABLE_NAME, sql);
        sql.append(" (").append(DATA_AUDIT_FIELDS).append(") values (?,?,?,?,?,?,?,?,?,?,?)");
        this.dataCommand = new SqlCommandBatch();
        this.dataCommand.setSql(sql.toString(), 11);
        sql = new StringBuilder();
        sql.append("insert into ");
        databaseInfo.appendDetailAuditTableRawName(BLOB_CHANGE_LOG_TABLE_NAME, sql);
        sql.append(" (").append(BLOB_AUDIT_FIELDS).append(") values (?,?,?,?,?,?,?,?)");
        this.blobCommand = new SqlCommandBatch();
        this.blobCommand.setSql(sql.toString(), 8);
        this.transCommand = new SqlCommand();
        this.transCommand.sqlText.append("insert into ");
        databaseInfo.appendDetailAuditTableRawName(TRANS_CHANGE_LOG_TABLE_NAME, this.transCommand.sqlText.getBuilder());
        this.transCommand.sqlText.append(" (").append(TRANS_AUDIT_FIELDS).append(") values (?,?,?,?,?,?)");
        this.transCommand.params.add(new SqlParameter(SqlDataType.DOUBLE));
        this.transCommand.params.add(new SqlParameter(SqlDataType.DATE_TIME));
        this.transCommand.params.add(new SqlParameter(SqlDataType.DATE_TIME));
        this.transCommand.params.add(new SqlParameter(SqlDataType.DOUBLE));
        this.transCommand.params.add(new SqlParameter(SqlDataType.DOUBLE));
        this.transCommand.params.add(new SqlParameter(SqlDataType.DOUBLE));
    }

    public void setContext(SSContext context) {
        this.context = context;
    }

    public boolean isAuditEnabled(TableDescriptor tableInfo) {
        return this.auditEnabled && tableInfo.getAuditType() != TableDescriptor.AuditType.NONE;
    }

    public boolean isDataAuditEnabled(TableDescriptor tableInfo) {
        return this.auditEnabled && tableInfo.getAuditType() == TableDescriptor.AuditType.ACTIONS_AND_DATA;
    }

    public void setAuditEventId(double auditEventId) {
        this.auditEventId = auditEventId;
    }

    public void setOwnerId(double auditOwnerId) {
        this.auditOwnerId = auditOwnerId;
    }

    public void registrateModification(TableDescriptor tableInfo, double rowId, AuditModification mod) throws SQLException, InformException {
        if (!this.isAuditEnabled(tableInfo)) {
            return;
        }
        this.registrateModification(tableInfo, rowId, mod, 0.0);
    }

    public void registerTransaction() throws SQLException {
        if (this.transactionId == 0.0) {
            return;
        }
        ((SqlParameter)this.transCommand.params.get(0)).setDouble(this.transactionId);
        ((SqlParameter)this.transCommand.params.get(1)).setDateTime(this.beginTime);
        ((SqlParameter)this.transCommand.params.get(2)).setDateTime(DateTime.currentDateTime() + 3.472222222222222E-5);
        if (this.receivingId == 0.0) {
            ((SqlParameter)this.transCommand.params.get(3)).setNull();
        } else {
            ((SqlParameter)this.transCommand.params.get(3)).setDouble(this.receivingId);
        }
        ((SqlParameter)this.transCommand.params.get(4)).setDouble(this.sessionId);
        ((SqlParameter)this.transCommand.params.get(5)).setDouble(this.modificationCount);
        this.transCommand.executeUpdate(this.context, this.database);
        this.transactionId = 0.0;
    }

    public void registrateModification(TableDescriptor tableInfo, double rowId, AuditModification mod, double prevRowId) throws SQLException, InformException {
        if (!this.isAuditEnabled(tableInfo)) {
            return;
        }
        double transId = this.database.transaction(this).id();
        if (this.transactionId != transId) {
            if (this.transactionId != 0.0) {
                throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0431\u0435\u0437 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439");
            }
            this.beginTime = DateTime.currentDateTime();
            this.transactionId = transId;
            this.modificationCount = 0L;
        }
        ++this.modificationCount;
        SqlCommandBatch operationCommand = mod != AuditModification.DELETE ? this.operationCommand : this.getDeleteOperationBatchCommand(tableInfo);
        SqlBatchParamList params = operationCommand.addBatch(this.database, this.context);
        params.setDateTime(4, DateTime.currentDateTime());
        params.setDoubleOrNull(5, this.userNodeId);
        params.setDoubleOrNull(6, this.receivingId);
        params.setDouble(0, Core.generateId());
        params.setDouble(1, tableInfo.getNodeId());
        params.setDouble(2, rowId);
        params.setInteger(3, mod.toInt());
        params.setDoubleOrNull(7, prevRowId);
        params.setDouble(8, this.auditOwnerId);
        String str = this.modifiedFieldsToString();
        if (str == null) {
            params.setNull(9, SqlDataType.STRING);
        } else {
            params.setString(9, str);
        }
        params.setDouble(10, this.transactionId);
        params.setDouble(11, this.sessionId);
        params.setDouble(12, this.auditEventId);
        params.setDoubleOrNull(13, this.replicaId);
        operationCommand.flush(this.database, this.avoidBatch, this.context);
        if (mod == AuditModification.DELETE) {
            this.registerDeleteDataAudit(tableInfo, rowId);
        }
    }

    private void registerEffectiveUser() throws SQLException, InformException {
        if (this.transactionId == 0.0 || this.effectiveUserId == 0.0 || this.effectiveUserId == this.userNodeId) {
            return;
        }
        SqlBatchParamList params = this.operationCommand.addBatch(this.database, this.context);
        params.setDateTime(4, DateTime.currentDateTime());
        params.setDoubleOrNull(5, this.userNodeId);
        params.setDoubleOrNull(6, this.receivingId);
        params.setDouble(0, Core.generateId());
        params.setDouble(1, 4.0);
        params.setDouble(2, this.effectiveUserId);
        params.setInteger(3, AuditModification.EFFECTIVE_USER.toInt());
        params.setDoubleOrNull(7, this.userNodeId);
        params.setDouble(8, this.auditOwnerId);
        String str = this.modifiedFieldsToString();
        if (str == null) {
            params.setNull(9, SqlDataType.STRING);
        } else {
            params.setString(9, str);
        }
        params.setDouble(10, this.transactionId);
        params.setDouble(11, this.sessionId);
        params.setDouble(12, this.auditEventId);
        params.setDoubleOrNull(13, this.replicaId);
        this.operationCommand.flush(this.database, this.avoidBatch, this.context);
    }

    private void internalAssignDataAuditFields(TableDescriptor tableInfo, double rowId, AuditModification mod, int fieldId) throws SQLException, InformException {
        SqlBatchParamList params = this.dataCommand.addBatch(this.database, this.context);
        params.setDouble(0, Core.generateId());
        params.setDouble(1, tableInfo.getNodeId());
        params.setDouble(2, rowId);
        params.setInteger(3, fieldId);
        params.setInteger(4, mod.toInt());
        params.setDateTime(5, DateTime.currentDateTime());
        params.setDoubleOrNull(6, this.userNodeId);
        params.setNull(7, SqlDataType.DOUBLE);
        params.setNull(8, SqlDataType.STRING);
        params.setNull(9, SqlDataType.DATE_TIME);
        params.setNull(10, SqlDataType.STRING);
    }

    private void assignDataAuditFields(TableDescriptor tableInfo, double rowId, AuditModification mod, int fieldId) throws SQLException, InformException {
        if (tableInfo.isAuditSavePrev()) {
            if (this.auditPrevFields != null && (this.auditPrevRecordId != rowId || tableInfo.getNodeId() != this.auditPrevTable.getNodeId())) {
                this.registerPrevDataAuditFields();
            }
            if (mod == AuditModification.MODIFY) {
                if (this.auditPrevFields == null) {
                    this.auditPrevFields = new IntegerSet();
                    this.auditPrevTable = tableInfo;
                    this.auditPrevRecordId = rowId;
                }
                this.auditPrevFields.add(fieldId);
            }
        }
        this.internalAssignDataAuditFields(tableInfo, rowId, mod, fieldId);
    }

    public void registrateFieldChanged(int fieldId) {
        this.addModifiedField(fieldId);
    }

    public void registrateSetNull(TableDescriptor tableInfo, double rowId, AuditModification mod, int fieldId) throws SQLException, InformException {
        this.addModifiedField(fieldId);
        FieldDescriptor field = tableInfo.getFieldDescriptor(fieldId);
        if (this.isDataAuditEnabled(tableInfo) || this.isAuditEnabled(tableInfo) && field != null && field.isDetailAudit()) {
            this.assignDataAuditFields(tableInfo, rowId, mod, fieldId);
            this.dataCommand.flush(this.database, false, this.context);
        }
    }

    public void registrateSetNumber(TableDescriptor tableInfo, double rowId, AuditModification mod, int fieldId, double value) throws SQLException, InformException {
        this.addModifiedField(fieldId);
        FieldDescriptor field = tableInfo.getFieldDescriptor(fieldId);
        if (this.isDataAuditEnabled(tableInfo) || this.isAuditEnabled(tableInfo) && field != null && field.isDetailAudit()) {
            this.assignDataAuditFields(tableInfo, rowId, mod, fieldId);
            this.dataCommand.getParameters().setDouble(7, value);
            this.dataCommand.flush(this.database, false, this.context);
        }
    }

    public void registrateSetString(TableDescriptor tableInfo, double rowId, AuditModification mod, int fieldId, String value) throws SQLException, InformException {
        this.addModifiedField(fieldId);
        FieldDescriptor field = tableInfo.getFieldDescriptor(fieldId);
        if (this.isDataAuditEnabled(tableInfo) || this.isAuditEnabled(tableInfo) && field != null && field.isDetailAudit()) {
            this.assignDataAuditFields(tableInfo, rowId, mod, fieldId);
            this.dataCommand.getParameters().setString(8, TableDataAudit.restrictLengthAuditStringValue(value));
            this.dataCommand.flush(this.database, false, this.context);
        }
    }

    public void registrateSetUnicode(TableDescriptor tableInfo, double rowId, AuditModification mod, int fieldId, String value) throws SQLException, InformException {
        this.addModifiedField(fieldId);
        FieldDescriptor field = tableInfo.getFieldDescriptor(fieldId);
        if (this.isDataAuditEnabled(tableInfo) || this.isAuditEnabled(tableInfo) && field != null && field.isDetailAudit()) {
            this.assignDataAuditFields(tableInfo, rowId, mod, fieldId);
            this.dataCommand.getParameters().setString(10, value);
            this.dataCommand.flush(this.database, false, this.context);
        }
    }

    public void registrateSetDateTime(TableDescriptor tableInfo, double rowId, AuditModification mod, int fieldId, double value) throws SQLException, InformException {
        this.addModifiedField(fieldId);
        FieldDescriptor field = tableInfo.getFieldDescriptor(fieldId);
        if (this.isDataAuditEnabled(tableInfo) || this.isAuditEnabled(tableInfo) && field != null && field.isDetailAudit()) {
            this.assignDataAuditFields(tableInfo, rowId, mod, fieldId);
            this.dataCommand.getParameters().setDateTime(9, value);
            this.dataCommand.flush(this.database, false, this.context);
        }
    }

    public void registrateSetBlob(TableDescriptor tableInfo, double rowId, AuditModification mod, FieldDescriptor field, byte[] value) throws SQLException, InformException {
        this.addModifiedField(field.getId());
        if (this.isAuditEnabled(tableInfo) && field.isDetailAudit()) {
            SqlBatchParamList params = this.blobCommand.addBatch(this.database, this.context);
            params.setDouble(0, Core.generateId());
            params.setDouble(1, tableInfo.getNodeId());
            params.setDouble(2, rowId);
            params.setInteger(3, field.getId());
            params.setInteger(4, mod.toInt());
            params.setDateTime(5, DateTime.currentDateTime());
            params.setDoubleOrNull(6, this.userNodeId);
            params.setBlob(7, value);
            this.dataCommand.flush(this.database, false, this.context);
        }
    }

    public void registrateRow(Row row) throws SQLException, InformException {
        AuditModification op;
        TableDescriptor tableInfo = row.getTableDescriptor();
        if (!this.isAuditEnabled(tableInfo)) {
            return;
        }
        if (row.isToBeDeleted()) {
            if (row.isNew()) {
                return;
            }
            op = AuditModification.DELETE;
        } else if (row.isModified()) {
            op = AuditModification.MODIFY;
        } else if (row.isNew()) {
            op = AuditModification.APPEND;
        } else {
            return;
        }
        if (op != AuditModification.DELETE) {
            boolean dataAudit = this.isDataAuditEnabled(tableInfo);
            Iterator<FieldDescriptor> it = row.getChangedFieldsIterator();
            block7: while (it.hasNext()) {
                FieldDescriptor f = it.next();
                if (row.getNullFlag(f.getIndex())) {
                    if (dataAudit) {
                        this.registrateSetNull(tableInfo, row.getId(), op, f.getId());
                        continue;
                    }
                    this.addModifiedField(f.getId());
                    continue;
                }
                switch (f.getType()) {
                    case FLOAT: 
                    case INTEGER: 
                    case INTERVAL: 
                    case METATREE_NODE: 
                    case PRIMARY_KEY: 
                    case DIRECTORY: 
                    case BOOLEAN: {
                        if (dataAudit) {
                            this.registrateSetNumber(tableInfo, row.getId(), op, f.getId(), row.getNumeric(f.getIndex()));
                            break;
                        }
                        this.addModifiedField(f.getId());
                        break;
                    }
                    case DATE_TIME: {
                        if (dataAudit) {
                            this.registrateSetDateTime(tableInfo, row.getId(), op, f.getId(), row.getNumeric(f.getIndex()));
                            break;
                        }
                        this.addModifiedField(f.getId());
                        break;
                    }
                    case BIG_NUMBER: 
                    case STRING: {
                        if (dataAudit) {
                            this.registrateSetString(tableInfo, row.getId(), op, f.getId(), (String)row.getComplex(f.getIndex()));
                            break;
                        }
                        this.addModifiedField(f.getId());
                        break;
                    }
                    case UNICODE: {
                        if (dataAudit) {
                            this.registrateSetUnicode(tableInfo, row.getId(), op, f.getId(), (String)row.getComplex(f.getIndex()));
                            break;
                        }
                        this.addModifiedField(f.getId());
                        break;
                    }
                    case BLOB: {
                        if (dataAudit) {
                            Object obj = row.getComplex(f.getIndex());
                            if (!(obj instanceof BinaryObject)) continue block7;
                            this.registrateSetBlob(tableInfo, row.getId(), op, f, ((BinaryObject)obj).toByteArray());
                            break;
                        }
                        this.addModifiedField(f.getId());
                    }
                }
            }
        }
        this.registrateModification(tableInfo, row.getId(), op);
    }

    public void registrateAllFieldsRow(Row row) throws SQLException, InformException {
        AuditModification op;
        TableDescriptor tableInfo = row.getTableDescriptor();
        if (!this.isAuditEnabled(tableInfo)) {
            return;
        }
        if (row.isToBeDeleted()) {
            if (row.isNew()) {
                return;
            }
            op = AuditModification.DELETE;
        } else if (row.isModified()) {
            op = AuditModification.MODIFY;
        } else if (row.isNew()) {
            op = AuditModification.APPEND;
        } else {
            return;
        }
        if (op != AuditModification.DELETE && this.isDataAuditEnabled(tableInfo)) {
            for (FieldDescriptor f : tableInfo.getFields()) {
                if (row.getNullFlag(f.getIndex())) {
                    this.registrateSetNull(tableInfo, row.getId(), op, f.getId());
                    continue;
                }
                switch (f.getType()) {
                    case FLOAT: 
                    case INTEGER: 
                    case INTERVAL: 
                    case METATREE_NODE: 
                    case PRIMARY_KEY: 
                    case DIRECTORY: 
                    case BOOLEAN: {
                        this.registrateSetNumber(tableInfo, row.getId(), op, f.getId(), row.getNumeric(f.getIndex()));
                        break;
                    }
                    case DATE_TIME: {
                        this.registrateSetDateTime(tableInfo, row.getId(), op, f.getId(), row.getNumeric(f.getIndex()));
                        break;
                    }
                    case BIG_NUMBER: 
                    case STRING: {
                        this.registrateSetString(tableInfo, row.getId(), op, f.getId(), (String)row.getComplex(f.getIndex()));
                        break;
                    }
                    case UNICODE: {
                        this.registrateSetUnicode(tableInfo, row.getId(), op, f.getId(), (String)row.getComplex(f.getIndex()));
                        break;
                    }
                    case BLOB: {
                        Object obj = row.getComplex(f.getIndex());
                        if (!(obj instanceof BinaryObject)) break;
                        this.registrateSetBlob(tableInfo, row.getId(), op, f, ((BinaryObject)obj).toByteArray());
                    }
                }
            }
        }
        this.registrateModification(tableInfo, row.getId(), op);
    }

    public void setUserID(double userNodeId) {
        this.userNodeId = userNodeId;
    }

    public void setBatchMode(boolean mode) {
        this.avoidBatch = !mode;
    }

    public void flush() throws SQLException {
        if (this.database == null || this.operationCommand == null || this.dataCommand == null || this.blobCommand == null) {
            return;
        }
        if (this.auditPrevFields != null) {
            this.registerPrevDataAuditFields();
        }
        this.registerEffectiveUser();
        this.operationCommand.execute(this.database, this.context);
        if (this.deleteOperationBatchCommands != null) {
            for (DeleteOperationBatchCommand batchCommand : this.deleteOperationBatchCommands) {
                batchCommand.execute(this.database, this.context);
            }
        }
        this.dataCommand.execute(this.database, this.context);
        this.blobCommand.execute(this.database, this.context);
    }

    private static String restrictLengthAuditStringValue(String value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        if (len <= 4000) {
            return value;
        }
        return value.substring(0, 4000);
    }

    public static TableDescriptor getSystemChangelogDescriptor() {
        TableDescriptor changelog = systemChangelog;
        if (changelog == null) {
            changelog = new TableDescriptor(CHANGE_LOG_TABLE_NAME, TableDescriptor.Kind.INTERNAL, AUDIT_FIELD_DESCRIPTORS);
            changelog.addIndex(new IndexDescriptor(0, "PHX_CHANGELOG_3COL", AUDIT_3COL_INDEX_FIELD_DESCRIPTORS));
            changelog.addIndex(new IndexDescriptor(1, "PHX_CHANGELOG_RTOP", AUDIT_RTOP_INDEX_FIELD_DESCRIPTORS));
            changelog.addIndex(new IndexDescriptor(2, "PHX_CHANGELOG_TRNS", AUDIT_TRNS_INDEX_FIELD_DESCRIPTORS));
            systemChangelog = changelog;
        }
        return changelog;
    }

    public static TableDescriptor getSystemTransChangelogDescriptor() {
        TableDescriptor changelog = systemTransChangelog;
        if (changelog == null) {
            changelog = new TableDescriptor(TRANS_CHANGE_LOG_TABLE_NAME, TableDescriptor.Kind.INTERNAL, TRANS_AUDIT_FIELD_DESCRIPTORS);
            changelog.addIndex(new IndexDescriptor(0, "PHX_CHANGELOG_TRANS_I1", TRANS_AUDIT_INDEX_FIELD_DESCRIPTORS));
            systemTransChangelog = changelog;
        }
        return changelog;
    }

    public static TableDescriptor getSystemChangelogValDescriptor() {
        TableDescriptor changelog = systemChangelogVal;
        if (changelog == null) {
            changelog = new TableDescriptor(VALUE_CHANGE_LOG_TABLE_NAME, TableDescriptor.Kind.INTERNAL, DATA_AUDIT_FIELD_DESCRIPTORS);
            changelog.addIndex(new IndexDescriptor(0, "PHX_CHANGELOG_VAL_I1", DATA_AUDIT_INDEX_FIELD_DESCRIPTORS));
            systemChangelogVal = changelog;
        }
        return changelog;
    }

    public static TableDescriptor getSystemChangelogBlobDescriptor() {
        TableDescriptor changelog = systemChangelogBlob;
        if (changelog == null) {
            changelog = new TableDescriptor(BLOB_CHANGE_LOG_TABLE_NAME, TableDescriptor.Kind.INTERNAL, new FieldDescriptor[]{DATA_AUDIT_TABLE_ID_FIELD, DATA_AUDIT_RECORD_ID_FIELD, DATA_AUDIT_FIELD_ID_FIELD, DATA_AUDIT_OPERATION_FIELD, DATA_AUDIT_TIME_FIELD, DATA_AUDIT_USER_ID_FIELD, DATA_AUDIT_BLOB_VALUE_FIELD});
            changelog.addIndex(new IndexDescriptor(0, changelog.getRawName() + "_I1", new FieldDescriptor[]{DATA_AUDIT_TABLE_ID_FIELD, DATA_AUDIT_RECORD_ID_FIELD, DATA_AUDIT_TIME_FIELD, DATA_AUDIT_FIELD_ID_FIELD}));
            systemChangelogBlob = changelog;
        }
        return changelog;
    }

    public static void dataSliceConditionSql(SqlStringBuilder sql, double backReceivingID) {
        sql.append(CHANGE_LOG_TABLE_NAME).append('.').append("TABLE_ID").append("=? and ").append(CHANGE_LOG_TABLE_NAME).append('.').append("OP_TIME").append(">=? and ").append(CHANGE_LOG_TABLE_NAME).append('.').append("OP_TIME").append("<=? and ");
        if (backReceivingID == 0.0) {
            sql.append(CHANGE_LOG_TABLE_NAME).append('.').append("REPL_NODE_ID").append(" is null");
        } else {
            sql.append('(').append(CHANGE_LOG_TABLE_NAME).append('.').append("REPL_NODE_ID").append("<>? or ").append(CHANGE_LOG_TABLE_NAME).append('.').append("REPL_NODE_ID").append(" is null").append(')');
        }
    }

    public static void dataSliceSql(DatabaseConnection connection, SqlStringBuilder sql, double backReceivingID) {
        sql.append(" inner join ");
        DatabaseDescriptor database = connection.getDescriptor();
        database.appendAuditTableRawName(CHANGE_LOG_TABLE_NAME, sql.getBuilder());
        sql.append(' ').append(CHANGE_LOG_TABLE_NAME).append(" on ");
        TableDataAudit.dataSliceConditionSql(sql, backReceivingID);
    }

    private String modifiedFieldsToString() {
        if (this.modifiedFields == null) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        for (Cursor.Integer c : this.modifiedFields) {
            value.append(Integer.toHexString(c.value)).append(';');
        }
        this.modifiedFields = null;
        return value.toString();
    }

    private void addModifiedField(int id) {
        if (this.modifiedFields == null) {
            this.modifiedFields = new IntegerSet();
        }
        this.modifiedFields.add(id);
    }

    private void registerDeleteDataAudit(TableDescriptor tableInfo, double rowId) throws SQLException {
        if (!tableInfo.hasDeleteDataAudit()) {
            return;
        }
        DatabaseDescriptor databaseInfo = this.database.getDescriptor();
        SqlCommand command = new SqlCommand();
        SqlParameter row = new SqlParameter(SqlDataType.DOUBLE).setDouble(rowId);
        boolean needClear = false;
        block6: for (FieldDescriptor field : tableInfo.getFields()) {
            if (!field.isDeleteDataAudit()) continue;
            if (needClear) {
                command.clear();
            }
            command.sqlText.append("insert into ");
            databaseInfo.appendDetailAuditTableRawName(VALUE_CHANGE_LOG_TABLE_NAME, command.sqlText.getBuilder());
            command.sqlText.append(" (");
            switch (field.getType()) {
                case FLOAT: 
                case INTEGER: 
                case INTERVAL: 
                case METATREE_NODE: 
                case DIRECTORY: 
                case BOOLEAN: {
                    command.sqlText.append(NUMBER_DELETE_FIELDS);
                    break;
                }
                case DATE_TIME: {
                    command.sqlText.append(DATE_DELETE_FIELDS);
                    break;
                }
                case BIG_NUMBER: 
                case STRING: {
                    command.sqlText.append(STRING_DELETE_FIELDS);
                    break;
                }
                case UNICODE: {
                    command.sqlText.append(UNICODE_DELETE_FIELDS);
                    break;
                }
                default: {
                    continue block6;
                }
            }
            command.sqlText.append(")  values (?,?,?,?,?,?,?,(select ").append(field.getRawName()).append(" from ").appendFull(tableInfo).append(" where ").append(tableInfo.getRecordIdField()).append("=?))");
            command.params.add(new SqlParameter().setDouble(Core.generateId()));
            command.params.add(new SqlParameter().setDouble(tableInfo.getNodeId()));
            command.params.add(new SqlParameter().setDouble(rowId));
            command.params.add(new SqlParameter().setInteger(field.getId()));
            command.params.add(new SqlParameter().setInteger(AuditModification.DELETE.toInt()));
            command.params.add(new SqlParameter().setDateTime(DateTime.currentDateTime()));
            if (this.userNodeId == 0.0) {
                command.params.add(new SqlParameter(SqlDataType.DOUBLE));
            } else {
                command.params.add(new SqlParameter().setDouble(this.userNodeId));
            }
            command.params.add(row);
            command.executeUpdate(this.context, this.database);
            needClear = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerPrevDataAuditFields() throws SQLException {
        try {
            if (this.auditPrevFields.empty()) {
                return;
            }
            SqlParameterList prevFields = new SqlParameterList();
            SqlStringBuilder sql = new SqlStringBuilder();
            sql.append("select ");
            int sep = 32;
            block49: for (Cursor.Integer fieldId : this.auditPrevFields) {
                FieldDescriptor field = this.auditPrevTable.getExistingFieldDescriptor(fieldId.value);
                SqlDataType type = field.getType().toSqlDataType();
                switch (type) {
                    case DOUBLE: 
                    case INTEGER: 
                    case BOOLEAN: {
                        prevFields.add(new SqlParameter(SqlDataType.DOUBLE).setId(fieldId.value));
                        break;
                    }
                    case DATE_TIME: 
                    case STRING: 
                    case UNICODE: {
                        prevFields.add(new SqlParameter(type).setId(fieldId.value));
                        break;
                    }
                    default: {
                        continue block49;
                    }
                }
                sql.append((char)sep).append(" T.").append(field);
                sep = 44;
            }
            if (prevFields.isEmpty()) {
                return;
            }
            sql.append(" from ").appendFull(this.auditPrevTable);
            sql.append(" T where ").append("T.").append(this.auditPrevTable.getRecordIdField()).append("=?");
            try (DatabaseConnection prev = this.database.getDescriptor().connect(null, "TableDataAudit");){
                prev.markAsReadonly();
                try (PreparedStatement statement = prev.prepareStatement(sql.toString());){
                    statement.setDouble(1, this.auditPrevRecordId);
                    try (ResultSet resultSet = statement.executeQuery(this.context);){
                        if (!resultSet.next()) {
                            return;
                        }
                        int index = 0;
                        block50: for (SqlParameter param : prevFields) {
                            switch (param.getType()) {
                                case DOUBLE: 
                                case INTEGER: 
                                case BOOLEAN: {
                                    double d = resultSet.getAsDouble(++index);
                                    if (resultSet.wasNull()) {
                                        param.setNull();
                                        continue block50;
                                    }
                                    param.setDouble(d);
                                    continue block50;
                                }
                                case DATE_TIME: {
                                    double d = resultSet.getAsDouble(++index);
                                    if (resultSet.wasNull()) {
                                        param.setNull();
                                        continue block50;
                                    }
                                    param.setDateTime(d);
                                    continue block50;
                                }
                                case STRING: 
                                case UNICODE: {
                                    String s = resultSet.getString(++index);
                                    if (resultSet.wasNull()) {
                                        param.setNull();
                                        continue block50;
                                    }
                                    param.setString(s);
                                    continue block50;
                                }
                            }
                            ++index;
                        }
                    }
                }
                DatabaseDescriptor databaseInfo = this.database.getDescriptor();
                sql = new SqlStringBuilder();
                sql.append("select ").append(DATA_AUDIT_PREV_FIELDS).append(" from ");
                databaseInfo.appendDetailAuditTableRawName(VALUE_CHANGE_LOG_TABLE_NAME, sql.getBuilder());
                sql.append(" T where ").append("RECORD_ID").append("=? and ");
                sql.append("OP_CODE").append(" in (0, 1, 3) and ");
                sql.append("TABLE_ID").append("=? and ");
                sql.append(DATA_AUDIT_FIELD_ID_NAME);
                if (prevFields.size() == 1) {
                    sql.append("=?");
                } else {
                    sql.append(" in (");
                    sep = 32;
                    for (int i = 0; i < prevFields.size(); ++i) {
                        sql.append((char)sep).append('?');
                        sep = 44;
                    }
                    sql.append(')');
                }
                sql.append(" order by ").append("OP_TIME").append(" desc");
                statement = prev.prepareStatement(sql.toString());
                try {
                    int index = 0;
                    statement.setDouble(++index, this.auditPrevRecordId);
                    statement.setDouble(++index, this.auditPrevTable.getNodeId());
                    for (SqlParameter p : prevFields) {
                        if (p == null) continue;
                        statement.setInt(++index, p.getId());
                    }
                    try (ResultSet resultSet = statement.executeQuery(this.context);){
                        block53: while (resultSet.next()) {
                            if (prevFields.isEmpty()) {
                                return;
                            }
                            int fieldId = resultSet.getAsInteger(1);
                            for (int i = 0; i < prevFields.size(); ++i) {
                                SqlParameter param = (SqlParameter)prevFields.get(i);
                                if (param.getId() != fieldId) {
                                    continue;
                                }
                                prevFields.remove(i);
                                switch (param.getType()) {
                                    case DOUBLE: 
                                    case INTEGER: 
                                    case BOOLEAN: {
                                        double d = resultSet.getAsDouble(2);
                                        if (resultSet.wasNull()) {
                                            if (param.isNull()) break;
                                            this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, fieldId);
                                            this.dataCommand.flush(this.database, false, this.context);
                                            break;
                                        }
                                        if (!param.isNull() && param.getDouble() == d) break;
                                        this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, fieldId);
                                        this.dataCommand.getParameters().setDouble(7, param.getDouble());
                                        this.dataCommand.flush(this.database, false, this.context);
                                        break;
                                    }
                                    case DATE_TIME: {
                                        double d = resultSet.getAsDouble(4);
                                        if (resultSet.wasNull()) {
                                            if (param.isNull()) break;
                                            this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, fieldId);
                                            this.dataCommand.flush(this.database, false, this.context);
                                            break;
                                        }
                                        if (!param.isNull() && param.getDouble() == d) break;
                                        this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, fieldId);
                                        this.dataCommand.getParameters().setDateTime(9, param.getDateTime());
                                        this.dataCommand.flush(this.database, false, this.context);
                                        break;
                                    }
                                    case STRING: {
                                        String s = resultSet.getString(3);
                                        if (resultSet.wasNull()) {
                                            if (param.isNull()) break;
                                            this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, fieldId);
                                            this.dataCommand.flush(this.database, false, this.context);
                                            break;
                                        }
                                        if (!param.isNull() && s.equals(param.getString())) break;
                                        this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, fieldId);
                                        this.dataCommand.getParameters().setString(8, TableDataAudit.restrictLengthAuditStringValue(param.getString()));
                                        this.dataCommand.flush(this.database, false, this.context);
                                        break;
                                    }
                                    case UNICODE: {
                                        String s = resultSet.getString(5);
                                        if (resultSet.wasNull()) {
                                            if (param.isNull()) break;
                                            this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, fieldId);
                                            this.dataCommand.flush(this.database, false, this.context);
                                            break;
                                        }
                                        if (!param.isNull() && s.equals(param.getString())) break;
                                        this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, fieldId);
                                        this.dataCommand.getParameters().setUnicode(10, param.getString());
                                        this.dataCommand.flush(this.database, false, this.context);
                                        continue block53;
                                    }
                                }
                                continue block53;
                            }
                        }
                    }
                }
                finally {
                    statement.close();
                }
            }
            Iterator iterator = prevFields.iterator();
            block55: while (iterator.hasNext()) {
                SqlParameter param = (SqlParameter)iterator.next();
                switch (param.getType()) {
                    case DOUBLE: 
                    case INTEGER: 
                    case BOOLEAN: {
                        if (param.isNull()) {
                            this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, param.getId());
                            this.dataCommand.flush(this.database, false, this.context);
                            break;
                        }
                        this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, param.getId());
                        this.dataCommand.getParameters().setDouble(7, param.getDouble());
                        this.dataCommand.flush(this.database, false, this.context);
                        break;
                    }
                    case DATE_TIME: {
                        if (param.isNull()) {
                            this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, param.getId());
                            this.dataCommand.flush(this.database, false, this.context);
                            break;
                        }
                        this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, param.getId());
                        this.dataCommand.getParameters().setDateTime(9, param.getDateTime());
                        this.dataCommand.flush(this.database, false, this.context);
                        break;
                    }
                    case STRING: {
                        if (param.isNull()) {
                            this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, param.getId());
                            this.dataCommand.flush(this.database, false, this.context);
                            break;
                        }
                        this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, param.getId());
                        this.dataCommand.getParameters().setString(8, TableDataAudit.restrictLengthAuditStringValue(param.getString()));
                        this.dataCommand.flush(this.database, false, this.context);
                        break;
                    }
                    case UNICODE: {
                        if (param.isNull()) {
                            this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, param.getId());
                            this.dataCommand.flush(this.database, false, this.context);
                            break;
                        }
                        this.internalAssignDataAuditFields(this.auditPrevTable, this.auditPrevRecordId, AuditModification.BACKUP, param.getId());
                        this.dataCommand.getParameters().setUnicode(10, param.getString());
                        this.dataCommand.flush(this.database, false, this.context);
                        continue block55;
                    }
                }
            }
            return;
        }
        finally {
            this.auditPrevFields = null;
        }
    }

    private SqlCommandBatch getDeleteOperationBatchCommand(TableDescriptor tableDescriptor) {
        SqlCommandBatch commandBatch;
        double tableRootId;
        double tableDbId = tableDescriptor.getDbId();
        if (tableDbId == this.databaseId) {
            return this.operationCommand;
        }
        DatabaseDescriptor tableDatabase = tableDescriptor.getDatabaseDescriptor();
        double rootId = this.database.getDescriptor().getEffectiveDatabaseId();
        if (rootId != (tableRootId = tableDatabase.getEffectiveDatabaseId()) && Ini.EnableCascadingDeleteCheck) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b ");
            MtdEngine.appendNodeNameForLog(msg, tableDescriptor.getNodeId());
            msg.append(", \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u043a\u0430\u0441\u043a\u0430\u0434\u043d\u043e \u0443\u0434\u0430\u043b\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u0438, \u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e \u0441 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435\u043c \u0432\u044b\u0448\u0435\u0441\u0442\u043e\u044f\u0449\u0435\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
            throw new InformException(msg.toString());
        }
        if (this.deleteOperationBatchCommands == null) {
            this.deleteOperationBatchCommands = new DoubleHash();
        } else {
            commandBatch = this.deleteOperationBatchCommands.get(tableDbId);
            if (commandBatch != null) {
                return commandBatch;
            }
        }
        commandBatch = new DeleteOperationBatchCommand(tableDbId);
        TableDataAudit.createOperationBatchCommand(commandBatch, tableDatabase);
        this.deleteOperationBatchCommands.add((DeleteOperationBatchCommand)commandBatch);
        return commandBatch;
    }

    private static SqlCommandBatch createOperationBatchCommand(SqlCommandBatch operationCommandBatchCommand, DatabaseDescriptor databaseDescriptor) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ");
        databaseDescriptor.appendAuditTableRawName(CHANGE_LOG_TABLE_NAME, sql);
        sql.append(" (").append(AUDIT_FIELDS).append(") values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        operationCommandBatchCommand.setSql(sql.toString(), 14);
        return operationCommandBatchCommand;
    }

    private static class DeleteOperationBatchCommand
    extends SqlCommandBatch
    implements DoubleHash.Entry {
        private final double databaseId;

        private DeleteOperationBatchCommand(double databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public double key() {
            return this.databaseId;
        }
    }
}

