/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.ObjectSizer;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.LogContext;
import inform.agent.RequestStatistics;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.RequestMonitor;
import inform.agent.db.connect.ResultSet;
import inform.agent.net.Client;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractStatement {
    public static final int QUERY_TIMEOUT = 2280000;
    protected static final String LONG_SQL_EXECUTING_MSG = "!!! LONG SQL EXECUTING";
    protected static final String LONG_SQL_FETCHING_MSG = "!!! LONG SQL FETCHING";
    @ObjectSizer.HintShared
    protected final DatabaseConnection connection;
    private final Statement statement;
    private int rscount;
    private boolean longSql;
    private boolean alreadyExplained;
    protected long queryTimeout;
    @ObjectSizer.HintShared
    protected TableDescriptor tableDescriptor;
    protected RequestMonitor.Stat rqStat;
    protected boolean isLogDangerSQL = false;

    public AbstractStatement(DatabaseConnection connection, Statement statement) {
        this.connection = connection;
        this.statement = statement;
    }

    protected Statement statement() {
        return this.statement;
    }

    public DatabaseConnection connection() {
        return this.connection;
    }

    public TableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    public void beforeExecute(SSContext ssContext, String sql) {
        this.connection.notifyStatementExecuted();
        ssContext = SSContext.getContext(ssContext);
        this.rqStat = new RequestMonitor.Stat(ssContext, sql);
        RequestMonitor.putRequest(this.rqStat);
    }

    public void beforeClose() {
        if (this.rqStat != null) {
            this.rqStat.closeTimeNano = System.nanoTime();
            this.rqStat.finished = true;
            this.rqStat = null;
        }
    }

    public void close() {
        this.beforeClose();
        if (this.rscount != 0) {
            Core.logger.warn("statement(connection={}) has {} unclosed result sets", (Object)this.connection.id, (Object)this.rscount);
        }
        this.connection.unregisterStatement(this);
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            this.connection.setDirty();
            Core.logger.error(this.getLogMessage(), e);
        }
    }

    public void setQueryTimeout(long timeout) {
        this.queryTimeout = timeout;
    }

    public void setQueryTimeout() throws SQLException {
        this.setQueryTimeout(2280000L);
    }

    public final String getLogMessage() {
        StringBuilder msg = new StringBuilder();
        this.generateLogMessage(msg);
        if (this.connection != null) {
            msg.append(" [").append(this.connection).append(" @").append(this.connection.getDescriptor().getUserName()).append(']');
        }
        return msg.toString();
    }

    public boolean isLogDangerSQL() {
        return this.isLogDangerSQL;
    }

    public void setLogDangerSQL() {
        this.isLogDangerSQL = true;
    }

    protected abstract void generateLogMessage(StringBuilder var1);

    protected void logDangerSql() {
        this.logDangerSql(0);
    }

    protected void logDangerSql(int batchCount) {
        String info = null;
        if (batchCount > 1) {
            info = "Batch count: " + batchCount;
        } else {
            Statement statement = this.statement();
            if (statement != null) {
                try {
                    int updateCount = statement.getUpdateCount();
                    info = "Update count: " + updateCount;
                }
                catch (SQLException e) {
                    Core.logger.error(null, e);
                }
            }
        }
        Core.logger.logDangerSql(this.getLogMessage(), info, this.connection);
    }

    protected void longSQLMessage(long time, boolean sqlAlreadyTraced, boolean explainNeed) throws SQLException {
        boolean explain;
        boolean bl = this.longSql = time > (long)Ini.WarnLongTimeSql;
        if (!this.longSql) {
            return;
        }
        StringBuilder message = new StringBuilder(LONG_SQL_EXECUTING_MSG);
        if (this.tableDescriptor != null) {
            message.append("[ tableID: { ").append((long)this.tableDescriptor.getNodeId()).append(" };");
        }
        if (!sqlAlreadyTraced) {
            message.append(" sql info: { ").append(this.getLogMessage()).append(" };");
        }
        message.append(" time: { ").append(time).append(" } ms]");
        boolean bl2 = explain = explainNeed && Ini.DbExplainLongSql;
        if (explain && this.connection.explainLastSql(" plan: { ", message)) {
            message.append(" }");
        }
        this.alreadyExplained = explain;
        Core.logger.warn(message.toString());
    }

    protected SQLException generateError(SQLException e) {
        SQLException uix;
        SQLException ex = new SQLException(null, this.getLogMessage(), e.getErrorCode(), e);
        if (this.tableDescriptor != null && (uix = this.connection.tryGetUniqueIndexConstraintException(e)) != null) {
            StringBuilder excMsg = new StringBuilder();
            excMsg.append("\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u043e \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0434\u043b\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b \"").append(this.tableDescriptor.toString()).append('\"');
            IndexDescriptor id = this.tableDescriptor.extractIndexFromMessage(uix.getMessage());
            if (id != null) {
                String msg = id.getUniqueErrorMsg();
                if (!Strings.isVoid(msg)) {
                    StringBuilder str = new StringBuilder();
                    str.append(msg).append("\r\n\u0418\u043d\u0434\u0435\u043a\u0441: ");
                    if (!id.getName().isEmpty()) {
                        str.append(id.getName());
                    } else {
                        str.append(id.getRawName());
                    }
                    return new SQLException(str.toString(), ex);
                }
                excMsg.append("\r\n\u0418\u043d\u0434\u0435\u043a\u0441: ").append(id.getRawName()).append("\r\n\u041f\u043e\u043b\u044f: ").append(id.fieldsList());
            }
            return new SQLException(excMsg.toString(), ex);
        }
        ex = this.connection.prepareException(ex);
        return ex;
    }

    protected void statSql(long duration) {
        Core.stat.sql(duration);
        this.connection.getDescriptor().statistics.sql(duration);
        LogContext lc = LogContext.CURRENT.get();
        if (lc == null) {
            return;
        }
        RequestStatistics.Value rqs = lc.rqstat();
        if (rqs != null) {
            rqs.sql(duration);
        }
    }

    protected void statRMod(int count) {
        Core.stat.sqlRowsModified(count);
        this.connection.getDescriptor().statistics.sqlRowsModified(count);
        LogContext lc = LogContext.CURRENT.get();
        if (lc == null) {
            return;
        }
        Client c = lc.client();
        if (c != null) {
            c.statistics.sqlRowsModified(count);
        }
    }

    void registerResultSet(ResultSet rs) {
        ++this.rscount;
    }

    void unregisterResultSet(ResultSet rs) throws SQLException {
        this.endOfResultSet(rs);
        if (this.rscount > 0) {
            --this.rscount;
        } else {
            Core.logger.warn("Oops, rscount=" + this.rscount);
        }
    }

    void endOfResultSet(ResultSet rs) throws SQLException {
        RequestStatistics.Value rqs;
        LogContext lc;
        if (rs.usedForForwardOnlyRowsets) {
            return;
        }
        if (rs.startFetchTime != 0L && (lc = LogContext.CURRENT.get()) != null && (rqs = lc.rqstat()) != null) {
            rqs.sqlFetchsDuration(System.currentTimeMillis() - rs.startFetchTime);
        }
        if (!this.longSql && rs.startTime != 0L) {
            this.longSQLMessage(System.currentTimeMillis() - rs.startTime, Ini.TraceSql, true);
        } else if (this.longSql && !this.alreadyExplained && Ini.DbExplainLongSql) {
            StringBuilder message = new StringBuilder(LONG_SQL_FETCHING_MSG);
            this.connection.explainLastSql(" plan:\n", message);
            Core.logger.warn(message.toString());
            this.alreadyExplained = true;
        }
    }
}

