/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.DbCapsConst;
import inform.agent.db.sql.engine.AggregateFunction;
import inform.agent.db.types.DataType;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.db.utils.SqlParameter;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;

public enum DatabaseCaps {
    ODBC(true, "length", "||", DbCapsConst.stdFunctions, DbCapsConst.DEFAULT_LIKE_TEMPLATE){

        @Override
        public String monthsBetweenBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String monthsBetweenMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String monthsBetweenEnd() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsEnd() {
            throw new IllegalStateException();
        }

        @Override
        public boolean addMonthsDateFirstArg() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrEnd() {
            throw new IllegalStateException();
        }
    }
    ,
    ORACLE(false, "length", "||", DbCapsConst.oracleFunctions, DbCapsConst.DEFAULT_LIKE_TEMPLATE){

        @Override
        public boolean isNullSortSupport() {
            return true;
        }

        @Override
        public String c_dateTime2sql(double val) {
            Calendar calValue = DateTime.toCalendar(val);
            String dateStr = String.format("%04d-%02d-%02d %02d:%02d:%02d", calValue.get(1), calValue.get(2) + 1, calValue.get(5), calValue.get(11), calValue.get(12), calValue.get(13));
            return "TO_DATE('" + dateStr + "', 'YYYY-MM-DD HH24:MI:SS')";
        }

        @Override
        public void g_storedProcedureExecuteSql(CharSequence params, CharSequence name, CharSequence fields, StringBuilder sql) {
            sql.append("select ").append(fields).append(" from Table(").append(name);
            if (params != null && params.length() > 0) {
                sql.append('(').append(params).append(')');
            }
            sql.append(')');
        }

        @Override
        public String g_selectFromSequenceSQL(DatabaseDescriptor database, String sequenceName, boolean asString) {
            StringBuilder sql = new StringBuilder();
            String scheme = database.getScheme();
            sql.append("select ");
            if (asString) {
                sql.append("CAST(");
            }
            if (scheme != null && !scheme.isEmpty() && !sequenceName.contains(".")) {
                sql.append(scheme).append('.');
            }
            sql.append(sequenceName).append(".NEXTVAL");
            String instance = database.getInstance();
            if (instance != null && !instance.isEmpty()) {
                sql.append('@').append(instance);
            }
            sql.append(" F");
            if (asString) {
                sql.append(" as varchar2)");
            }
            sql.append(" from dual");
            return sql.toString();
        }

        @Override
        public String g_selectResultStoredProcSQL(DatabaseDescriptor database, String procName, boolean asString) {
            StringBuilder sql = new StringBuilder();
            sql.append("select ");
            if (asString) {
                sql.append("CAST(");
            }
            sql.append(procName);
            if (asString) {
                sql.append(" as varchar2)");
            }
            sql.append(" F");
            sql.append(" from dual");
            return sql.toString();
        }

        @Override
        public void appendSequenceToFields(DatabaseDescriptor database, String sequenceName, StringBuilder sql) {
            String scheme = database.getScheme();
            if (scheme != null && !scheme.isEmpty() && !sequenceName.contains(".")) {
                sql.append(scheme).append('.');
            }
            sql.append(sequenceName).append(".NEXTVAL");
            String instance = database.getInstance();
            if (instance != null && !instance.isEmpty()) {
                sql.append('@').append(instance);
            }
        }

        @Override
        public void appendStoredProcToFields(DatabaseDescriptor database, String procName, StringBuilder sql) {
            sql.append(procName);
        }

        @Override
        public String getEmptyFromSQL() {
            return " from dual";
        }

        @Override
        public String truncateTableRecords() {
            return "truncate table ";
        }

        @Override
        public StringBuilder fetchLimitBeginning(int fetchLimit, StringBuilder sql) {
            if (fetchLimit <= 0) {
                return sql;
            }
            return sql.append(" /*+FIRST_ROWS(").append(fetchLimit).append(")*/ ");
        }

        @Override
        public StringBuilder fetchLimitEnding(int fetchLimit, StringBuilder sql) {
            if (fetchLimit <= 0) {
                return sql;
            }
            return sql.insert(0, "select * from(").append(") where ROWNUM <= ").append(fetchLimit);
        }

        @Override
        public StringBuilder fetchLimitWrap(int fetchLimit, StringBuilder sql) {
            return this.fetchLimitEnding(fetchLimit, sql);
        }

        @Override
        public void lpad(StringBuilder sql, String field, int size) {
            sql.append(" LPAD(").append(field).append(',').append(size).append(')');
        }

        @Override
        public boolean canLogNodeID() {
            return true;
        }

        @Override
        public String monthsBetweenBegin() {
            return "MONTHS_BETWEEN(";
        }

        @Override
        public String monthsBetweenMiddle() {
            return ",";
        }

        @Override
        public String monthsBetweenEnd() {
            return ")";
        }

        @Override
        public String addMonthsBegin() {
            return "ADD_MONTHS(";
        }

        @Override
        public String addMonthsMiddle() {
            return ",";
        }

        @Override
        public String addMonthsEnd() {
            return ")";
        }

        @Override
        public boolean addMonthsDateFirstArg() {
            return true;
        }

        @Override
        public String regexpSubstrBegin() {
            return "REGEXP_SUBSTR(";
        }

        @Override
        public String regexpSubstrMiddle() {
            return ",";
        }

        @Override
        public String regexpSubstrEnd() {
            return ")";
        }

        @Override
        public void truncDate(StringBuilder sql, ArgGenerator date, TruncDateType tdt) {
            String format;
            switch (tdt) {
                case year: {
                    format = "YEAR";
                    break;
                }
                case month: {
                    format = "MONTH";
                    break;
                }
                case quarter: {
                    format = "Q";
                    break;
                }
                case hour: {
                    format = "HH24";
                    break;
                }
                case week: {
                    format = "IW";
                    break;
                }
                default: {
                    date.generate();
                    return;
                }
            }
            sql.append("TRUNC(");
            date.generate();
            sql.append(", '").append(format).append("')");
        }

        @Override
        public String g_gatherTableStatsSQL(DatabaseDescriptor database, TableDescriptor table) {
            return "BEGIN dbms_stats.gather_table_stats(ownname=>'" + database.getScheme() + "', tabname=>'" + table.getRawName() + "',estimate_percent=>100); END;";
        }

        @Override
        public String toNumberFunction() {
            return "TO_NUMBER(";
        }

        @Override
        public String toNumberSuffix() {
            return ")";
        }

        @Override
        public SqlParameter intervalParameter(StringBuilder sql, double value) {
            sql.append("NUMTODSINTERVAL(?, 'second')");
            return new SqlParameter().setDouble((long)(value * 24.0 * 60.0 * 60.0));
        }

        @Override
        public boolean callFunctionSql(StringBuilder sql, DatabaseDescriptor dd, String name, String fields, DatabaseType.FunctionArgument[] args, boolean asFunction) {
            if (fields != null) {
                sql.append("SELECT").append(fields).append(" FROM TABLE(");
            } else {
                sql.append("BEGIN ");
                if (asFunction) {
                    sql.append("? := ");
                }
            }
            sql.append(name).append('(');
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (i != 0) {
                        sql.append(',');
                    }
                    DatabaseType.FunctionArgument arg = args[i];
                    if (arg.sqlType == SqlDataType.BOOLEAN) {
                        if (arg.value == null) {
                            sql.append("null");
                        } else if (ValueCaster.toBoolean(arg.value).booleanValue()) {
                            sql.append("true");
                        } else {
                            sql.append("false");
                        }
                        arg.inlined = true;
                        continue;
                    }
                    sql.append('?');
                    arg.inlined = false;
                }
            }
            sql.append(')');
            if (fields != null) {
                sql.append(')');
            } else {
                sql.append("; END;");
            }
            return fields == null;
        }

        @Override
        public void formatDateTime(int formatId, String field, StringBuilder sql) {
            String fmt;
            switch (formatId) {
                case 401: {
                    fmt = "DD.MM.YYYY";
                    break;
                }
                case 402: {
                    fmt = "MM.YYYY";
                    break;
                }
                case 403: {
                    fmt = "YYYY";
                    break;
                }
                case 404: {
                    fmt = "HH24:MI";
                    break;
                }
                case 405: {
                    fmt = "HH24:MI:SS";
                    break;
                }
                case 406: {
                    fmt = "DD.MM.YYYY HH24:MI";
                    break;
                }
                case 407: {
                    fmt = "HH24";
                    break;
                }
                case 408: {
                    fmt = "DD";
                    break;
                }
                case 409: {
                    fmt = "DD.MM";
                    break;
                }
                case 410: {
                    fmt = "DD.MM.YYYY HH24:MI:SS";
                    break;
                }
                case 412: {
                    fmt = "YYYY.MM.DD";
                    break;
                }
                default: {
                    super.formatDateTime(formatId, field, sql);
                    return;
                }
            }
            sql.append("to_char(").append(field).append(", '").append(fmt).append("')");
        }

        @Override
        public String currentDateTime() {
            return "SYSDATE";
        }

        @Override
        public String getIndexesValidationSql() {
            return "SELECT INDEX_NAME, TABLE_NAME FROM USER_INDEXES WHERE STATUS <> 'VALID' ORDER BY TABLE_NAME";
        }

        @Override
        public boolean isAnsiHierarchicSyntax() {
            return false;
        }
    }
    ,
    MSSQL(true, "datalength", "+", DbCapsConst.mssqlFunctions, DbCapsConst.MSSQL_LIKE_TEMPLATE){

        @Override
        public String c_dateTime2sql(double val) {
            Calendar calValue = DateTime.toCalendar(val);
            String dateStr = String.format("%04d-%02d-%02d %02d:%02d:%02d.%03d", calValue.get(1), calValue.get(2) + 1, calValue.get(5), calValue.get(11), calValue.get(12), calValue.get(13), calValue.get(14));
            return "CONVERT(datetime, '" + dateStr + "', 121)";
        }

        @Override
        public void g_storedProcedureExecuteSql(CharSequence params, CharSequence name, CharSequence fields, StringBuilder sql) {
            sql.append("exec ").append(name).append(params);
        }

        @Override
        public StringBuilder fetchLimitBeginning(int fetchLimit, StringBuilder sql) {
            if (fetchLimit <= 0) {
                return sql;
            }
            return sql.append(" top ").append(fetchLimit).append(' ');
        }

        @Override
        public StringBuilder fetchLimitTop(int fetchLimit, StringBuilder sql) {
            return this.fetchLimitBeginning(fetchLimit, sql);
        }

        @Override
        public String monthsBetweenBegin() {
            return "(DATEDIFF(second, ";
        }

        @Override
        public String monthsBetweenMiddle() {
            return ",";
        }

        @Override
        public String monthsBetweenEnd() {
            return ") / 2629746)";
        }

        @Override
        public String addMonthsBegin() {
            return "DATEADD(second, (";
        }

        @Override
        public String addMonthsMiddle() {
            return "*2629746), ";
        }

        @Override
        public String addMonthsEnd() {
            return ")";
        }

        @Override
        public boolean addMonthsDateFirstArg() {
            return false;
        }

        @Override
        public String regexpSubstrBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrEnd() {
            throw new IllegalStateException();
        }

        @Override
        public void truncDate(StringBuilder sql, ArgGenerator date, TruncDateType tdt) {
            switch (tdt) {
                case year: {
                    sql.append("CONVERT(datetime, CONVERT(varchar, YEAR(");
                    date.generate();
                    sql.append("))+'-01-01', 121)");
                    return;
                }
                case month: {
                    sql.append("CONVERT(datetime, CONVERT(varchar, YEAR(");
                    date.generate();
                    sql.append("))+'-'+CONVERT(varchar, MONTH(");
                    date.generate();
                    sql.append("))+'-01', 121)");
                    return;
                }
                case quarter: {
                    sql.append("CONVERT(datetime, CONVERT(varchar, YEAR(");
                    date.generate();
                    sql.append("))+'-'+CONVERT(varchar, (1+3*(DATEPART(QUARTER,").append(")-1)))+'-01', 121)");
                    return;
                }
                case hour: {
                    sql.append("CONVERT(datetime, CONVERT(varchar, YEAR(");
                    date.generate();
                    sql.append("))+'-'+CONVERT(varchar, MONTH(");
                    date.generate();
                    sql.append("))+'-'+CONVERT(varchar, DAY(");
                    date.generate();
                    sql.append("))+' '+CONVERT(varchar, DATEPART(hour,");
                    date.generate();
                    sql.append("))+':00:00', 121)");
                    return;
                }
                case week: {
                    sql.append("dateadd(dd, 1 - datepart(dw, ");
                    date.generate();
                    sql.append("), ");
                    date.generate();
                    sql.append(')');
                    return;
                }
            }
            super.truncDate(sql, date, tdt);
        }

        @Override
        public String stringToDateBegin() {
            return "CONVERT(datetime, ";
        }

        @Override
        public String stringToDateEnd() {
            return ", 103)";
        }

        @Override
        public String numberToStringFunction() {
            return "CONVERT(VARCHAR, ";
        }

        @Override
        public String numberToStringSuffix() {
            return ")";
        }

        @Override
        public String toMaxStringPrefix() {
            return "CONVERT(VARCHAR(MAX), ";
        }

        @Override
        public String toMaxStringSuffix() {
            return ")";
        }

        @Override
        public void dateTimeToStringFunction(StringBuilder sql, String date) {
            sql.append("(CONVERT(VARCHAR(10), ").append(date).append(", 104)").append("+' '+CONVERT(VARCHAR(10), ").append(date).append(", 108))");
        }

        @Override
        public void addSelectForUpdate(StringBuilder sql) {
        }

        @Override
        public String currentDateTime() {
            return "GetDate()";
        }

        @Override
        public String c_interval2sql(double val) {
            return this.c_float2sql(val);
        }

        @Override
        public String g_gatherTableStatsSQL(DatabaseDescriptor database, TableDescriptor table) {
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE STATISTICS ");
            database.appendTableRawName(table.getRawName(), sql);
            return sql.toString();
        }
    }
    ,
    JDBC(true, "length", "||", DbCapsConst.stdFunctions, DbCapsConst.DEFAULT_LIKE_TEMPLATE){

        @Override
        public String monthsBetweenBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String monthsBetweenMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String monthsBetweenEnd() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsEnd() {
            throw new IllegalStateException();
        }

        @Override
        public boolean addMonthsDateFirstArg() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrEnd() {
            throw new IllegalStateException();
        }
    }
    ,
    POSTGRESQL(false, "length", "||", DbCapsConst.stdFunctions, DbCapsConst.DEFAULT_LIKE_TEMPLATE){

        @Override
        public boolean isNullSortSupport() {
            return true;
        }

        @Override
        public String c_string2sql(String val, boolean typed) {
            String sql = super.c_string2sql(val, false);
            if (typed) {
                return sql + "::text";
            }
            return sql;
        }

        @Override
        public String c_dateTime2sql(double val) {
            Calendar calValue = DateTime.toCalendar(val);
            String dateStr = String.format("%04d-%02d-%02d %02d:%02d:%02d", calValue.get(1), calValue.get(2) + 1, calValue.get(5), calValue.get(11), calValue.get(12), calValue.get(13));
            return " to_timestamp('" + dateStr + "', 'YYYY-MM-DD HH24:MI:SS')";
        }

        @Override
        public String c_zeroTime2sql() {
            return "timezone('Europe/Moscow'::text, '1899-12-30 00:00:00+03'::timestamp with time zone)";
        }

        @Override
        public String c_bool2sql(boolean val) {
            return val ? "true" : "false";
        }

        @Override
        public String g_selectFromSequenceSQL(DatabaseDescriptor database, String sequenceName, boolean asString) {
            StringBuilder sql = new StringBuilder();
            String scheme = database.getScheme();
            sql.append("select nextval('");
            if (scheme != null && !scheme.isEmpty() && !sequenceName.contains(".")) {
                sql.append(scheme).append('.');
            }
            sql.append(sequenceName).append("')");
            return sql.toString();
        }

        @Override
        public String g_selectResultStoredProcSQL(DatabaseDescriptor database, String procName, boolean asString) {
            StringBuilder sql = new StringBuilder();
            sql.append("select ");
            if (asString) {
                sql.append("CAST(");
            }
            sql.append(procName).append("()");
            if (asString) {
                sql.append(" as text)");
            }
            sql.append(" F");
            return sql.toString();
        }

        @Override
        public void appendSequenceToFields(DatabaseDescriptor database, String sequenceName, StringBuilder sql) {
            String scheme = database.getScheme();
            sql.append("nextval('");
            if (scheme != null && !scheme.isEmpty() && !sequenceName.contains(".")) {
                sql.append(scheme).append('.');
            }
            sql.append(sequenceName).append("')");
        }

        @Override
        public void appendStoredProcToFields(DatabaseDescriptor database, String procName, StringBuilder sql) {
            sql.append(procName).append("()");
        }

        @Override
        public StringBuilder fetchLimitEnding(int fetchLimit, StringBuilder sql) {
            if (fetchLimit <= 0) {
                return sql;
            }
            sql.append(" LIMIT ").append(fetchLimit);
            return sql;
        }

        @Override
        public StringBuilder fetchLimitBottom(int fetchLimit, StringBuilder sql) {
            return this.fetchLimitEnding(fetchLimit, sql);
        }

        @Override
        public String daysBetweenBegin() {
            return "cast(extract(epoch from (";
        }

        @Override
        public String daysBetweenMiddle() {
            return ")-(";
        }

        @Override
        public String daysBetweenEnd() {
            return "))/86400 as numeric)";
        }

        @Override
        public String monthsBetweenBegin() {
            return "cast((select extract(year from age)*12+extract(month from age)+(extract(day from age))/31 from age(";
        }

        @Override
        public String monthsBetweenMiddle() {
            return ",";
        }

        @Override
        public String monthsBetweenEnd() {
            return ") as age) as numeric)";
        }

        @Override
        public String addMonthsBegin() {
            return "(";
        }

        @Override
        public String addMonthsMiddle() {
            return "+cast(cast(";
        }

        @Override
        public String addMonthsEnd() {
            return " as text)||'months' as interval))";
        }

        @Override
        public boolean addMonthsDateFirstArg() {
            return true;
        }

        @Override
        public String addDaysBegin() {
            return "(";
        }

        @Override
        public String addDaysMiddle() {
            return "+cast(cast(";
        }

        @Override
        public String addDaysEnd() {
            return " as text)||'days' as interval))";
        }

        @Override
        public String regexpSubstrBegin() {
            return "substring(";
        }

        @Override
        public String regexpSubstrMiddle() {
            return " from ";
        }

        @Override
        public String regexpSubstrEnd() {
            return ")";
        }

        @Override
        public void truncDate(StringBuilder sql, ArgGenerator date, TruncDateType tdt) {
            String format;
            switch (tdt) {
                case year: {
                    format = "year";
                    break;
                }
                case month: {
                    format = "month";
                    break;
                }
                case quarter: {
                    format = "quarter";
                    break;
                }
                case hour: {
                    format = "hour";
                    break;
                }
                case week: {
                    format = "week";
                    break;
                }
                default: {
                    date.generate();
                    return;
                }
            }
            sql.append("date_trunc('").append(format).append("', ");
            date.generate();
            sql.append(")");
        }

        @Override
        public void lpad(StringBuilder sql, String field, int size) {
            sql.append(" LPAD(").append(field).append(',').append(size).append(", '0')");
        }

        @Override
        public SqlParameter intervalParameter(StringBuilder sql, double value) {
            sql.append("cast(? as interval)");
            String v = (long)(value * 24.0 * 60.0 * 60.0) + " second";
            return new SqlParameter().setString(v);
        }

        @Override
        public String enquoteIfNeed(String name) {
            if (Strings.startsWith(name, '\"')) {
                return name;
            }
            String lname = name.toLowerCase();
            if ("limit".equals(lname)) {
                return "\"" + lname + "\"";
            }
            if ("notnull".equals(lname)) {
                return "\"" + lname + "\"";
            }
            return name;
        }

        @Override
        public void formatDateTime(int formatId, String field, StringBuilder sql) {
            String fmt;
            switch (formatId) {
                case 401: {
                    fmt = "DD.MM.YYYY";
                    break;
                }
                case 402: {
                    fmt = "MM.YYYY";
                    break;
                }
                case 403: {
                    fmt = "YYYY";
                    break;
                }
                case 404: {
                    fmt = "HH24:MI";
                    break;
                }
                case 405: {
                    fmt = "HH24:MI:SS";
                    break;
                }
                case 406: {
                    fmt = "DD.MM.YYYY HH24:MI";
                    break;
                }
                case 407: {
                    fmt = "HH24";
                    break;
                }
                case 408: {
                    fmt = "DD";
                    break;
                }
                case 409: {
                    fmt = "DD.MM";
                    break;
                }
                case 410: {
                    fmt = "DD.MM.YYYY HH24:MI:SS";
                    break;
                }
                case 412: {
                    fmt = "YYYY.MM.DD";
                    break;
                }
                default: {
                    super.formatDateTime(formatId, field, sql);
                    return;
                }
            }
            sql.append("to_char(").append(field).append(", '").append(fmt).append("')");
        }

        @Override
        public String tranformSqlParameter(FieldDescriptor fd) {
            if (fd.getType() == DataType.BLOB && fd.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) {
                return "to_tsvector('russian',?::text)";
            }
            return "?";
        }

        @Override
        public String getIndexesValidationSql() {
            return "SELECT c1.relname AS INDEX_NAME, n.nspname || '.' || c2.relname AS TABLE_NAME FROM pg_catalog.pg_index i JOIN pg_catalog.pg_class AS c1 ON i.indexrelid = c1.oid LEFT JOIN pg_catalog.pg_namespace AS n ON n.oid = c1.relnamespace JOIN pg_catalog.pg_class AS c2 ON i.indrelid = c2.oid WHERE NOT indisvalid AND n.nspname NOT IN ('pg_catalog', 'pg_toast', 'information_schema') ORDER BY TABLE_NAME";
        }

        @Override
        public String g_gatherTableStatsSQL(DatabaseDescriptor database, TableDescriptor table) {
            StringBuilder sql = new StringBuilder();
            sql.append("ANALYZE ");
            database.appendTableRawName(table.getRawName(), sql);
            return sql.toString();
        }

        @Override
        public boolean isPostgreSqlHierarchicSyntax() {
            return true;
        }

        @Override
        public void typifySuffix(DataType dataType, StringBuilder sql) {
            switch (dataType) {
                case DIRECTORY: 
                case METATREE_NODE: 
                case PRIMARY_KEY: {
                    sql.append("::double precision");
                    break;
                }
                case FLOAT: 
                case INTERVAL: {
                    sql.append("::numeric");
                    break;
                }
                case INTEGER: {
                    sql.append("::integer");
                    break;
                }
                case BOOLEAN: {
                    sql.append("::boolean");
                    break;
                }
                case STRING: 
                case UNICODE: {
                    sql.append("::character varying");
                    break;
                }
                case DATE_TIME: {
                    sql.append("::timestamp without time zone");
                    break;
                }
                case FILE: {
                    sql.append("::character varying");
                    break;
                }
                case GEOMETRY: {
                    sql.append("::geometry");
                }
            }
        }

        @Override
        public void typifySuffixCompat(DataType dataType, StringBuilder sql) {
            switch (dataType) {
                case DIRECTORY: 
                case METATREE_NODE: 
                case PRIMARY_KEY: {
                    sql.append("::double precision");
                    break;
                }
                case FLOAT: 
                case INTERVAL: {
                    sql.append("::numeric");
                    break;
                }
                case INTEGER: {
                    sql.append("::integer");
                    break;
                }
                case BOOLEAN: {
                    sql.append("::boolean");
                    break;
                }
                case STRING: 
                case UNICODE: {
                    sql.append("::text");
                    break;
                }
                case DATE_TIME: {
                    sql.append("::timestamp without time zone");
                    break;
                }
                case FILE: {
                    sql.append("::character varying");
                    break;
                }
                case GEOMETRY: {
                    sql.append("::geometry");
                }
            }
        }

        @Override
        public String aggregativePrefix(DataType dataType, AggregateFunction function) {
            if (dataType == DataType.BOOLEAN) {
                switch (function) {
                    case Min: {
                        return "bool_and(";
                    }
                    case Max: {
                        return "bool_or(";
                    }
                }
            }
            return super.aggregativePrefix(dataType, function);
        }
    }
    ,
    MYSQL(false, "length", "||", DbCapsConst.stdFunctions, null){

        @Override
        public String monthsBetweenBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String monthsBetweenMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String monthsBetweenEnd() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsEnd() {
            throw new IllegalStateException();
        }

        @Override
        public boolean addMonthsDateFirstArg() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrEnd() {
            throw new IllegalStateException();
        }

        @Override
        public String g_gatherTableStatsSQL(DatabaseDescriptor database, TableDescriptor table) {
            StringBuilder sql = new StringBuilder();
            sql.append("ANALYZE TABLE ");
            database.appendTableRawName(table.getRawName(), sql);
            return sql.toString();
        }
    }
    ,
    H2(true, "length", "||", DbCapsConst.stdFunctions, DbCapsConst.DEFAULT_LIKE_TEMPLATE){

        @Override
        public String c_dateTime2sql(double val) {
            Calendar calValue = DateTime.toCalendar(val);
            String dateStr = String.format("%04d-%02d-%02d %02d:%02d:%02d", calValue.get(1), calValue.get(2) + 1, calValue.get(5), calValue.get(11), calValue.get(12), calValue.get(13));
            return "(TIMESTAMP '" + dateStr + "')";
        }

        @Override
        public StringBuilder fetchLimitEnding(int fetchLimit, StringBuilder sql) {
            if (fetchLimit <= 0) {
                return sql;
            }
            sql.append(" LIMIT ").append(fetchLimit);
            return sql;
        }

        @Override
        public StringBuilder fetchLimitBottom(int fetchLimit, StringBuilder sql) {
            return this.fetchLimitEnding(fetchLimit, sql);
        }

        @Override
        public String c_bool2sql(boolean val) {
            return val ? "true" : "false";
        }

        @Override
        public String g_selectFromSequenceSQL(DatabaseDescriptor database, String sequenceName, boolean asString) {
            StringBuilder sql = new StringBuilder();
            sql.append("select nextval('");
            database.appendTableRawName(sequenceName, sql);
            sql.append("')");
            return sql.toString();
        }

        @Override
        public void lpad(StringBuilder sql, String field, int size) {
            sql.append(" LPAD(").append(field).append(',').append(size).append(')');
        }

        @Override
        public int calculateUpdatesCount(int[] batchResult, Statement statement) {
            int result = 0;
            for (int c : batchResult) {
                result += c;
            }
            return result;
        }

        @Override
        public String monthsBetweenBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String monthsBetweenMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String monthsBetweenEnd() {
            throw new IllegalStateException();
        }

        @Override
        public String addMonthsBegin() {
            return "DATEADD('MONTH', ";
        }

        @Override
        public String addMonthsMiddle() {
            return ", ";
        }

        @Override
        public String addMonthsEnd() {
            return ")";
        }

        @Override
        public boolean addMonthsDateFirstArg() {
            return false;
        }

        @Override
        public String regexpSubstrBegin() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrMiddle() {
            throw new IllegalStateException();
        }

        @Override
        public String regexpSubstrEnd() {
            throw new IllegalStateException();
        }

        @Override
        public void truncDate(StringBuilder sql, ArgGenerator date, TruncDateType tdt) {
            switch (tdt) {
                case year: {
                    sql.append("PARSEDATETIME('01-01-'||YEAR(");
                    date.generate();
                    sql.append("), 'dd-MM-yyyy')");
                    return;
                }
                case month: {
                    sql.append("PARSEDATETIME('01-'||MONTH(");
                    date.generate();
                    sql.append(")||'-'||YEAR(");
                    date.generate();
                    sql.append("), 'dd-MM-yyyy')");
                    return;
                }
                case hour: {
                    sql.append("PARSEDATETIME(''||DAY_OF_MONTH(");
                    date.generate();
                    sql.append(")||'-'||MONTH(");
                    date.generate();
                    sql.append(")||'-'||YEAR(");
                    date.generate();
                    sql.append(")||' '||HOUR(");
                    date.generate();
                    sql.append("), 'dd-MM-yyyy HH')");
                    return;
                }
                case week: {
                    sql.append("dateadd(day,(case day_of_week(");
                    date.generate();
                    sql.append(")when 1 then -6 else 2-day_of_week(");
                    date.generate();
                    sql.append(")end), ");
                    date.generate();
                    sql.append(')');
                    return;
                }
            }
            super.truncDate(sql, date, tdt);
        }

        @Override
        public String enquoteIfNeed(String name) {
            if (Strings.startsWith(name, '\"')) {
                return name;
            }
            String lname = name.toUpperCase();
            if ("LIMIT".equals(lname)) {
                return "\"" + lname + "\"";
            }
            if ("NOTNULL".equals(lname)) {
                return "\"" + lname + "\"";
            }
            if ("KEY".equals(lname)) {
                return "\"" + lname + "\"";
            }
            return name;
        }

        @Override
        public String currentDateTime() {
            return "CURRENT_TIMESTAMP";
        }

        @Override
        public String g_gatherTableStatsSQL(DatabaseDescriptor database, TableDescriptor table) {
            StringBuilder sql = new StringBuilder();
            sql.append("ANALYZE TABLE ");
            database.appendTableRawName(table.getRawName(), sql);
            sql.append(" SAMPLE_SIZE 100000");
            return sql.toString();
        }

        @Override
        public boolean isPostgreSqlHierarchicSyntax() {
            return true;
        }
    };

    private static final int SORT_LAST = 0;
    private static final int SORT_FIRST = 1;
    private final boolean nullIsLeast;
    public final String blobLengthFunction;
    public final String concatOperator;
    private final String[] functions;
    private final char[] likeTemplate;
    public static final int DAY_OF = 0;
    public static final int MONTH_OF = 1;
    public static final int YEAR_OF = 2;
    public static final int HOUR_OF = 3;
    public static final int MINUTE_OF = 4;
    public static final int SECOND_OF = 5;
    public static final int DATE_OF = 6;
    private static final char[] VALID_ESCAPE_CHARS;

    private DatabaseCaps(boolean nullIsLeast, String blobLengthFunction, String concatOperator, String[] functions, char[] likeTemplate) {
        this.nullIsLeast = nullIsLeast;
        this.blobLengthFunction = blobLengthFunction;
        this.concatOperator = concatOperator;
        this.functions = functions;
        this.likeTemplate = likeTemplate;
    }

    public boolean isNullFirst(int nullSortKind) {
        switch (nullSortKind) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return this.nullIsLeast;
    }

    public int nullSortType() {
        return this.nullIsLeast ? 1 : 0;
    }

    public String c_float2sql(double val) {
        Object result = SqlGenerator.doubleToString(val);
        if (((String)result).indexOf(46) == -1) {
            result = (String)result + ".0";
        }
        return result;
    }

    public String c_bool2sql(boolean val) {
        return val ? "1" : "0";
    }

    public String c_zeroTime2sql() {
        return this.c_dateTime2sql(0.0);
    }

    public String c_number2sql(double val) {
        return ValueCaster.toString(val);
    }

    public String c_interval2sql(double val) {
        return "interval '" + (long)(val * 24.0 * 60.0 * 60.0) + "' second";
    }

    public String c_dateTime2sql(double val) {
        return "'" + DateTime.toString(val) + "'";
    }

    public String c_string2sql(String val) {
        return this.c_string2sql(val, false);
    }

    public String c_string2sql(String val, boolean typed) {
        if (val.isEmpty()) {
            return "''";
        }
        StringBuilder str = new StringBuilder();
        boolean noneApostrophe = false;
        boolean addApostrophe = true;
        boolean endApostrophe = false;
        boolean addConcat = false;
        for (int i = 0; i < val.length(); ++i) {
            if (addConcat) {
                addConcat = false;
                str.append(this.concatOperator);
            }
            if (val.charAt(i) == '\'') {
                if (endApostrophe) {
                    str.append('\'');
                }
                endApostrophe = false;
                if (addConcat || noneApostrophe) {
                    str.append(this.concatOperator);
                }
                str.append("''''");
                addApostrophe = true;
                addConcat = true;
                noneApostrophe = false;
                continue;
            }
            if (addApostrophe) {
                addApostrophe = false;
                str.append('\'');
            }
            str.append(val.charAt(i));
            endApostrophe = true;
            noneApostrophe = true;
        }
        if (endApostrophe) {
            str.append('\'');
        }
        return str.toString();
    }

    public void g_storedProcedureExecuteSql(CharSequence params, CharSequence name, CharSequence fields, StringBuilder sql) {
        sql.append("select ").append(fields != null ? fields : "").append(" from ").append(name);
        if (params != null && params.length() != 0) {
            sql.append("(").append(params).append(")");
        }
    }

    public String g_selectFromSequenceSQL(DatabaseDescriptor database, String sequenceName, boolean asString) {
        throw new UnsupportedOperationException("\u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f");
    }

    public String g_selectResultStoredProcSQL(DatabaseDescriptor database, String procName, boolean asString) {
        throw new UnsupportedOperationException("\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    public void appendSequenceToFields(DatabaseDescriptor database, String sequenceName, StringBuilder sql) {
        throw new UnsupportedOperationException("\u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f");
    }

    public void appendStoredProcToFields(DatabaseDescriptor database, String procName, StringBuilder sql) {
        throw new UnsupportedOperationException("\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    public String getEmptyFromSQL() {
        return "";
    }

    public String g_gatherTableStatsSQL(DatabaseDescriptor database, TableDescriptor table) {
        throw new UnsupportedOperationException("\u0441\u0431\u043e\u0440 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    public String function(int type) {
        return this.functions[type * 2];
    }

    public String functionSuffix(int type) {
        return this.functions[type * 2 + 1];
    }

    public String truncateTableRecords() {
        return "delete from ";
    }

    public void lpad(StringBuilder sql, String field, int size) {
        sql.append(" SPACE(").append(size).append(" - datalength(").append(field).append(")) + ").append(field);
    }

    public StringBuilder fetchLimitBeginning(int fetchLimit, StringBuilder sql) {
        return sql;
    }

    public StringBuilder fetchLimitEnding(int fetchLimit, StringBuilder sql) {
        return sql;
    }

    public StringBuilder fetchLimitTop(int fetchLimit, StringBuilder sql) {
        return sql;
    }

    public StringBuilder fetchLimitWrap(int fetchLimit, StringBuilder sql) {
        return sql;
    }

    public StringBuilder fetchLimitBottom(int fetchLimit, StringBuilder sql) {
        return sql;
    }

    public boolean canLogNodeID() {
        return true;
    }

    public static boolean canLogNodeID(DatabaseType databaseType) {
        switch (databaseType) {
            case INTERBASE: 
            case ODBC: 
            case ORACLE_ODBC: 
            case INSQL_ODBC: {
                return false;
            }
        }
        return databaseType.caps().canLogNodeID();
    }

    public boolean isAnsiHierarchicSyntax() {
        return true;
    }

    public boolean isPostgreSqlHierarchicSyntax() {
        return false;
    }

    public int calculateUpdatesCount(int[] batchResult, Statement statement) throws SQLException {
        int result = statement.getUpdateCount();
        if (result < 0) {
            for (int u : batchResult) {
                if (u <= 0) continue;
                if (result < 0) {
                    result = u;
                    continue;
                }
                result += u;
            }
        }
        return result;
    }

    public SqlParameter intervalParameter(StringBuilder sql, double value) {
        sql.append("?");
        return new SqlParameter().setDouble(value);
    }

    public String toNumberFunction() {
        return "CAST(";
    }

    public String toNumberSuffix() {
        return " as NUMERIC)";
    }

    public String numberToStringFunction() {
        return "(''||(";
    }

    public String numberToStringSuffix() {
        return "))";
    }

    public String toMaxStringPrefix() {
        return "(''||(";
    }

    public String toMaxStringSuffix() {
        return "))";
    }

    public void dateTimeToStringFunction(StringBuilder sql, String date) {
        sql.append("TO_CHAR(").append(date).append(", 'DD.MM.YYYY HH24:MI:SS')");
    }

    public String daysBetweenBegin() {
        return "((";
    }

    public String daysBetweenMiddle() {
        return ")-(";
    }

    public String daysBetweenEnd() {
        return "))";
    }

    public void daysBetween(StringBuilder sql, String date1, String date2) {
        sql.append(this.daysBetweenBegin()).append(date1).append(this.daysBetweenMiddle()).append(date2).append(this.daysBetweenEnd());
    }

    public String dateValueBegin() {
        return this.daysBetweenBegin();
    }

    public String dateValueEnd() {
        return this.daysBetweenMiddle() + this.c_dateTime2sql(0.0) + this.daysBetweenEnd();
    }

    public void dateValue(StringBuilder sql, String date) {
        sql.append(this.dateValueBegin()).append(date).append(this.c_dateTime2sql(0.0)).append(this.daysBetweenEnd());
    }

    public abstract String monthsBetweenBegin();

    public abstract String monthsBetweenMiddle();

    public abstract String monthsBetweenEnd();

    public void monthsBetween(StringBuilder sql, String date1, String date2) {
        sql.append(this.monthsBetweenBegin()).append(date1).append(this.monthsBetweenMiddle()).append(date2).append(this.monthsBetweenEnd());
    }

    public abstract String addMonthsBegin();

    public abstract String addMonthsMiddle();

    public abstract String addMonthsEnd();

    public abstract boolean addMonthsDateFirstArg();

    public abstract String regexpSubstrBegin();

    public abstract String regexpSubstrMiddle();

    public abstract String regexpSubstrEnd();

    public String addDaysBegin() {
        return "((";
    }

    public String addDaysMiddle() {
        return ")+(";
    }

    public String addDaysEnd() {
        return "))";
    }

    public void truncDate(StringBuilder sql, ArgGenerator date, TruncDateType tdt) {
        switch (tdt) {
            case year: {
                throw new InformException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f '\u041d\u0430\u0447\u0430\u043b\u043e \u0433\u043e\u0434\u0430' (truncYear) \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            }
            case month: {
                throw new InformException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f '\u041d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u0441\u044f\u0446\u0430' (truncMonth) \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            }
            case quarter: {
                throw new InformException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f '\u041d\u0430\u0447\u0430\u043b\u043e \u043a\u0432\u0430\u0440\u0442\u0430\u043b\u0430' (truncQuarter) \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            }
            case hour: {
                throw new InformException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f '\u041d\u0430\u0447\u0430\u043b\u043e \u0447\u0430\u0441\u0430' (truncHour) \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            }
            case week: {
                throw new InformException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f '\u041d\u0430\u0447\u0430\u043b\u043e \u043d\u0435\u0434\u0435\u043b\u0438' (truncWeek) \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            }
        }
        throw new InformException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f '\u041d\u0430\u0447\u0430\u043b\u043e \u0434\u0430\u0442\u044b' (???) \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    public String stringToDateBegin() {
        return "TO_DATE(";
    }

    public String stringToDateEnd() {
        return ", 'DD MM YYYY HH24:MI:SS')";
    }

    public void stringToDate(StringBuilder sql, String date) {
        sql.append(this.stringToDateBegin()).append(date).append(this.stringToDateEnd());
    }

    public boolean callFunctionSql(StringBuilder sql, DatabaseDescriptor dd, String name, String fields, DatabaseType.FunctionArgument[] args, boolean asFunction) {
        sql.append("select ");
        if (fields != null) {
            sql.append(fields).append(" from ");
        } else if (asFunction) {
            sql.append("? from ");
        }
        dd.appendTableRawName(name, sql);
        sql.append('(');
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                args[i].inlined = false;
                if (i != 0) {
                    sql.append(',');
                }
                sql.append('?');
            }
        }
        sql.append(')');
        return false;
    }

    public String enquoteIfNeed(String name) {
        return name;
    }

    public char getEscapeLikeChar(String value) {
        if (Strings.isVoid(value)) {
            return '\u0000';
        }
        if (this.likeTemplate == null || this.likeTemplate.length == 0) {
            return '\u0000';
        }
        boolean escapeless = true;
        for (char t : this.likeTemplate) {
            if (value.indexOf(t) < 0) continue;
            escapeless = false;
            break;
        }
        if (escapeless) {
            return '\u0000';
        }
        char escapeChar = '\u0000';
        block1: for (char e : VALID_ESCAPE_CHARS) {
            for (char t : this.likeTemplate) {
                if (t == e) continue block1;
            }
            if (value.indexOf(e) >= 0) continue;
            escapeChar = e;
            break;
        }
        return escapeChar;
    }

    public String toLikeString(String value, char escapeChar) {
        if (escapeChar == '\u0000') {
            return value;
        }
        StringBuilder v = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            for (char t : this.likeTemplate) {
                if (t != c) continue;
                v.append(escapeChar);
                break;
            }
            v.append(c);
        }
        return v.toString();
    }

    public void formatDateTime(int formatId, String field, StringBuilder sql) {
        sql.append(field);
    }

    public void addSelectForUpdate(StringBuilder sql) {
        sql.append(" for update");
    }

    public String currentDateTime() {
        return "now()";
    }

    public boolean isNullSortSupport() {
        return false;
    }

    public String tranformSqlParameter(FieldDescriptor fd) {
        return "?";
    }

    public String getIndexesValidationSql() {
        throw new InformException("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u0432 \u0434\u043b\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0421\u0423\u0411\u0414 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u0430");
    }

    public void typifySuffix(DataType dataType, StringBuilder sql) {
    }

    public void typifySuffixCompat(DataType dataType, StringBuilder sql) {
    }

    public String aggregativePrefix(DataType dataType, AggregateFunction function) {
        return function.sql;
    }

    static {
        VALID_ESCAPE_CHARS = new char[]{'\\', '|', '&', '#', '@', '$', '(', ')', '-', '+', '=', '/', ':', ';', ',', '.', '?', '{', '}', '<', '>', '[', ']', '^', '!'};
    }

    public static enum TruncDateType {
        none,
        year,
        quarter,
        month,
        hour,
        week;

    }

    public static interface ArgGenerator {
        public void generate();
    }
}

