/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.oracle;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.connect.Advisor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.Plan;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.connect.oracle.CallableStatement;
import inform.agent.db.connect.oracle.schema.Scheme;
import inform.agent.db.schema.DbScheme;
import inform.agent.scripts.SSContext;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.OraclePreparedStatement;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.slf4j.impl.AsmoLogger;

public class Connection
extends DatabaseConnection {
    private static final Pattern RG_SSRV = Pattern.compile("//[^/:]+(:\\d+)?/[^/]+");
    private static final int OPTIMAL_ROW_PREFETCH = 128;
    private static final int UNIQUE_INDEX_CONSTR_ORACLE_ERROR = 1;
    private static final int DDL_LOCK_TIMEOUT = 15;
    private StructDescriptor _sdCache;
    private String program;
    private String process;
    private String terminal;
    private long sessionSID;
    private static final AtomicInteger TASK_ID_GEN = new AtomicInteger();

    StructDescriptor geometryDescriptor() throws SQLException {
        if (this._sdCache == null) {
            JGeometry g = new JGeometry(0.0, 0.0, 0);
            STRUCT st = JGeometry.store((JGeometry)g, (java.sql.Connection)this.connection);
            this._sdCache = st.getDescriptor();
        }
        return this._sdCache;
    }

    public Connection(DatabaseDescriptor descriptor) throws SQLException, InformException {
        super(descriptor);
    }

    @Override
    protected String connectionString() {
        return this.descriptor.getServer() + "@" + this.descriptor.getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.sql.Connection createConnection(Properties connInfo) throws SQLException, InformException {
        java.sql.Connection c;
        String ss = this.descriptor.getServer();
        if (ss == null || ss.isEmpty()) {
            this.connectionError("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430 Oracle", null);
        }
        if (!RG_SSRV.matcher(ss).matches()) {
            this.connectionError("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0438\u043c\u0435\u043d\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 Oracle (\u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f: \"//<host>[:<port>]/<service>\")", null);
        }
        connInfo.setProperty("user", this.descriptor.getUserName());
        connInfo.setProperty("password", this.descriptor.getPassword());
        connInfo.setProperty("charSet", "Cp1251");
        connInfo.setProperty("characterEncoding", "Cp1251");
        this.loadJdbcDriver();
        String url = "jdbc:oracle:" + (Ini.OCI ? "oci" : "thin") + ":@" + ss;
        try {
            c = DriverManager.getConnection(url, connInfo);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 12705 || e.getMessage().contains("ORA-12705")) {
                Core.logger.error(null, e);
                Locale l = Locale.getDefault();
                try {
                    Locale.setDefault(Locale.ENGLISH);
                    c = DriverManager.getConnection(url, connInfo);
                }
                finally {
                    Locale.setDefault(l);
                }
            }
            throw e;
        }
        return c;
    }

    private String getAppName() {
        StringBuilder r = new StringBuilder();
        if (Strings.isVoid(Ini.AgentID)) {
            r.append("ASMO Agent").append(" p").append(Ini.ProcessID);
        } else {
            r.append(Ini.AgentID);
        }
        if (!Strings.isVoid(Ini.ServerID)) {
            r.append('@').append(Ini.ServerID);
        }
        return r.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected java.sql.Connection establishConnection() throws SQLException, InformException {
        try {
            Properties connInfo = new Properties();
            this.program = this.getAppName();
            connInfo.setProperty("v$session.program", this.program);
            this.process = Integer.toString(Ini.ProcessID);
            connInfo.setProperty("v$session.process", this.process);
            this.terminal = Integer.toString(this.id);
            connInfo.setProperty("v$session.terminal", this.terminal);
            java.sql.Connection c = this.createConnection(connInfo);
            if (Ini.DbStatementCacheSize != 0) {
                ((OracleConnection)c).setImplicitCachingEnabled(true);
                ((OracleConnection)c).setStatementCacheSize(Ini.DbStatementCacheSize);
            }
            ((OracleConnection)c).setDefaultRowPrefetch(128);
            java.sql.Statement stmt = c.createStatement();
            try {
                int major = c.getMetaData().getDatabaseMajorVersion();
                StringBuilder sql = new StringBuilder();
                sql.append("alter session set nls_sort = ").append(major >= 10 ? "RUSSIAN_AI" : "RUSSIAN");
                if (Strings.isVoid(Ini.Locale)) {
                    sql.append(" nls_numeric_characters = '.,'");
                }
                sql.append(" nls_date_format = 'DD.MM.YYYY'");
                stmt.execute(sql.toString());
                if (major >= 11) {
                    stmt.execute("alter session set ddl_lock_timeout = 15");
                }
                if (Ini.Oratrace) {
                    String OratraceFileId = Ini.OratraceFileId;
                    if (OratraceFileId == null || OratraceFileId.isEmpty()) {
                        OratraceFileId = Ini.AgentID;
                    }
                    if (OratraceFileId == null || OratraceFileId.isEmpty()) {
                        Core.logger.info("Oratrace Enabled, Level: " + Ini.OratraceLevel);
                    } else {
                        OratraceFileId = DatabaseCaps.ORACLE.c_string2sql(OratraceFileId);
                        Core.logger.info("Oratrace Enabled, Level: " + OratraceFileId + " FileId: " + OratraceFileId);
                        stmt.execute("alter session set tracefile_identifier=" + OratraceFileId);
                    }
                    stmt.execute("alter session set max_dump_file_size = unlimited");
                    stmt.execute("alter session set timed_statistics = true");
                    stmt.execute("alter session set events '10046 trace name context forever, level " + Ini.OratraceLevel + "'");
                }
                if (Ini.DbExplainLongSql) {
                    stmt.execute("alter session set statistics_level = all");
                }
                String setClientInfoSQL = String.format("call DBMS_APPLICATION_INFO.SET_CLIENT_INFO('%s - %.0f')", Ini.AgentID, this.descriptor.getNodeId());
                stmt.execute(setClientInfoSQL);
                try (java.sql.ResultSet resultSet = stmt.executeQuery("select sys_context('USERENV', 'SID') from dual");){
                    if (resultSet.next()) {
                        this.sessionSID = resultSet.getLong(1);
                        this.toStringCache = null;
                        Core.logger.log(AsmoLogger.Level.INFO, "\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u043e " + this, null, this);
                    }
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
            }
            return c;
        }
        catch (SQLException ex) {
            this.connectionError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", ex);
            return null;
        }
    }

    private void connectionError(String msg, Throwable cause) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" node: ");
        buf.append((long)this.descriptor.getNodeId());
        String ss = this.descriptor.getDBConfName();
        if (!Strings.isVoid(ss)) {
            buf.append(" dbConf: ").append(ss);
        } else {
            ss = this.descriptor.getServer();
            if (ss != null) {
                buf.append(" service: ");
                buf.append(ss);
            }
        }
        throw new SQLException(buf.toString(), cause);
    }

    void loadJdbcDriver() throws SQLException {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
        }
        catch (Exception ex) {
            this.connectionError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 JDBC \u0434\u0440\u0430\u0439\u0432\u0435\u0440\u0430 Oracle", ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void killSessionImpl(String cause) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean internal_Check() throws SQLException {
        try (java.sql.Statement st = this.connection.createStatement();){
            java.sql.ResultSet rs;
            block8: {
                boolean bl;
                rs = st.executeQuery("SELECT sysdate FROM dual");
                try {
                    if (!rs.next()) break block8;
                    rs.getObject(1);
                    bl = !rs.wasNull();
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return bl;
            }
            boolean bl = false;
            rs.close();
            return bl;
        }
    }

    @Override
    protected Plan newExplainPlan(final boolean trace, String sqlText) throws SQLException, InformException {
        StringBuilder sql = new StringBuilder();
        if (trace) {
            sql.append(sqlText);
        } else {
            String statementId = NumberConverter.doubleToString(Core.generateId());
            sql.append("EXPLAIN PLAN SET STATEMENT_ID='").append(statementId).append("' FOR ").append(sqlText);
        }
        this.execute("alter session set statistics_level = all");
        return new Plan(this.prepareStatement(sql.toString())){
            PreparedStatement ps;

            @Override
            public ResultSet explain(SSContext ssContext) throws SQLException {
                if (trace) {
                    this.statement.execute(ssContext);
                    ResultSet rs = this.statement.getResultSet();
                    if (rs != null) {
                        int rc = 0;
                        while (rs.next()) {
                            ++rc;
                        }
                    }
                    this.ps = Connection.this.prepareStatement("SELECT * FROM table(dbms_xplan.display_cursor(null,null,'ALLSTATS LAST'))");
                    ResultSet _rs = this.ps.executeQuery(ssContext);
                    return _rs;
                }
                this.statement.execute(ssContext);
                this.ps = Connection.this.prepareStatement("SELECT * FROM table(dbms_xplan.display)");
                return this.ps.executeQuery(ssContext);
            }

            @Override
            public void close() {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (!Ini.DbExplainLongSql) {
                    try {
                        Connection.this.execute("alter session set statistics_level = typical");
                    }
                    catch (SQLException e) {
                        Core.logger.error("plan.close", e);
                    }
                }
                super.close();
            }
        };
    }

    @Override
    protected Advisor newAdvisor(String sqlText) throws SQLException, InformException {
        final String task_id = Integer.toString(TASK_ID_GEN.incrementAndGet());
        final String preparedSql = sqlText.replaceAll("'", "''").replaceAll("\n", " ");
        return new Advisor(){
            PreparedStatement ps;

            @Override
            public ResultSet advise(SSContext ssContext) throws SQLException {
                Connection.this.execute("alter session set nls_numeric_characters = '.,'");
                Connection.this.setDirty();
                Connection.this.execute("begin DBMS_ADVISOR.QUICK_TUNE(DBMS_ADVISOR.SQLACCESS_ADVISOR, '" + task_id + "', '" + preparedSql + "'); end;");
                this.ps = Connection.this.prepareStatement("SELECT command, attr1, attr2, attr3, attr4 FROM user_advisor_actions WHERE task_name = ?");
                this.ps.setString(1, task_id);
                return this.ps.executeQuery(ssContext);
            }

            @Override
            public void close() {
                try {
                    Connection.this.execute("begin DBMS_ADVISOR.DELETE_TASK('" + task_id + "'); end;");
                }
                catch (SQLException e) {
                    Core.logger.error("advisor", e);
                }
                if (this.ps != null) {
                    this.ps.close();
                }
            }
        };
    }

    private void execute(String sql) throws SQLException {
        try (java.sql.Statement stmt = this.connection.createStatement();){
            stmt.execute(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean explainLastSql(String prefix, StringBuilder out) throws SQLException {
        out.append(prefix);
        try (java.sql.Statement st = this.connection.createStatement();
             java.sql.ResultSet rs = st.executeQuery("SELECT * FROM table(dbms_xplan.display_cursor(NULL,NULL,'allstats advanced -projection -alias -outline last'))");){
            boolean first = true;
            while (rs.next()) {
                out.append(rs.getString(1));
                if (!first) {
                    out.append('\n');
                }
                first = false;
            }
        }
        return true;
    }

    @Override
    public DbScheme openScheme(String name) {
        return new Scheme(name, this, this.jdbcMetadata);
    }

    @Override
    protected void generateToString(StringBuilder builder) {
        builder.append(Ini.OCI ? ",oci" : ",thin");
        if (this.sessionSID != 0L) {
            builder.append(",sid:").append(this.sessionSID);
        }
    }

    @Override
    public boolean isUniqueIndexConstraintException(SQLException ex) {
        return ex.getErrorCode() == 1;
    }

    @Override
    public SQLException prepareException(SQLException e) {
        String msg;
        int code = e.getErrorCode();
        if (20000 <= code && code <= 20999 && (msg = e.getMessage()) != null) {
            int from = msg.indexOf(58) + 1;
            int to = msg.indexOf("ORA-", from);
            return new SQLException(msg.substring(from, to).trim(), e.getSQLState(), e.getErrorCode(), e);
        }
        return super.prepareException(e);
    }

    @Override
    protected inform.agent.db.connect.CallableStatement newCallableStatement(String comment, String sql) throws SQLException {
        return new CallableStatement(comment, sql, (OracleCallableStatement)this.connection.prepareCall(sql), this);
    }

    @Override
    protected PreparedStatement newPreparedStatement(String comment, String sql) throws SQLException {
        return new inform.agent.db.connect.oracle.PreparedStatement(comment, sql, (OraclePreparedStatement)this.connection.prepareStatement(sql), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAllConstraintsDeferred(SSContext ssContext) throws SQLException {
        if (this.deferredCheckConstraints) {
            return;
        }
        super.setAllConstraintsDeferred(ssContext);
        Statement statement = this.createStatement();
        try {
            statement.execute(ssContext, "set constraints all deferred");
        }
        finally {
            try {
                statement.close();
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
        }
    }
}

