/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.connect.postgresql.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbTable;
import inform.agent.db.sql.QueryTokenizer;
import inform.agent.db.types.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Index
extends DbIndex {
    private String condition;
    private IndexDescriptor.Method method;

    public Index(String name, DbTable table, boolean isUnique, String condition, IndexDescriptor.Method method) {
        super(name, table);
        this.unique = isUnique;
        this.method = method;
        if (Strings.isVoid(condition)) {
            this.condition = null;
        } else {
            ConditionParser parser = new ConditionParser();
            this.condition = parser.parse(table.scheme.getDatabaseType().caps(), condition);
        }
    }

    @Override
    public boolean equals(IndexDescriptor id) {
        if (this.unique != id.isUnique()) {
            return false;
        }
        IndexDescriptor.Method idxMethod = id.getMethod();
        if (this.method != idxMethod && (this.method != IndexDescriptor.Method.BTREE || idxMethod != IndexDescriptor.Method.DEFAULT)) {
            return false;
        }
        if (!Strings.equalsIgnoreCaseNotNul(this.condition, id.getCondition())) {
            return false;
        }
        return this.columnsEquals(id);
    }

    private static boolean equalsColumnExpression(String colExpr, FieldDescriptor fd) {
        colExpr = colExpr.toLowerCase();
        String fieldName = fd.getRawName().toLowerCase();
        if (!fd.isNullable()) {
            return fieldName.equals(colExpr);
        }
        String FUNC_NAME = "coalesce";
        int funcOffset = colExpr.indexOf("coalesce");
        if (funcOffset < 0) {
            return false;
        }
        int fieldOffset = colExpr.indexOf(fieldName, funcOffset + "coalesce".length());
        if (fieldOffset < 0) {
            return false;
        }
        int commaOffset = colExpr.indexOf(44, fieldOffset + fieldName.length());
        if (commaOffset < 0) {
            return false;
        }
        int bracketOffset = colExpr.indexOf(41, commaOffset + 1);
        return bracketOffset - commaOffset > 1;
    }

    @Override
    protected boolean columnsEquals(IndexDescriptor id) {
        boolean validColumns = true;
        for (DbColumn c : this.columns) {
            if (c != null) continue;
            validColumns = false;
            break;
        }
        if (!id.isStrongUnique()) {
            return validColumns && super.columnsEquals(id);
        }
        int colLen = this.raw_columns.size();
        Collection<FieldDescriptor> idxFields = id.getFields();
        if (idxFields.size() != colLen) {
            return false;
        }
        int index = 0;
        for (FieldDescriptor fd : idxFields) {
            String colExpr = (String)this.raw_columns.get(index);
            if (!Index.equalsColumnExpression(colExpr, fd)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static class ConditionParser {
        final ArrayList<IndexDescriptor.ConditionItem> condition = new ArrayList();
        boolean isCompatible;
        IndexDescriptor.ConditionItem currentItem;
        static final String[] skip_types = new String[]{"numeric", "text"};
        static final String[] skipNext_types = new String[]{"double"};
        static final String[] deprecated_symbols = new String[]{"<", ">"};
        static final String[] skip_words = new String[]{"or", "and"};
        static final String[] deprecated_words = new String[]{"not"};
        static final String[] value_words = new String[]{"true", "false"};

        private ConditionParser() {
        }

        private void addValue(String value, DataType type) {
            if (this.currentItem == null) {
                this.isCompatible = false;
                return;
            }
            this.currentItem.addValue(value, type);
        }

        private void addNull(boolean isNull, boolean isNotNull) {
            if (this.currentItem == null) {
                this.isCompatible = false;
                return;
            }
            this.currentItem.addNull(isNull, isNotNull);
        }

        private boolean waitWord(QueryTokenizer parser) {
            block5: while (true) {
                QueryTokenizer.Token tokenType = parser.nextToken();
                switch (tokenType) {
                    case Word: {
                        return true;
                    }
                    case Line: 
                    case Eof: 
                    case SplashSplashComment: 
                    case Symbol: {
                        continue block5;
                    }
                    case Number: 
                    case DoubleQuotedString: 
                    case SingleQuotedString: {
                        return false;
                    }
                }
                break;
            }
            return false;
        }

        private QueryTokenizer.Token processToken(QueryTokenizer parser, QueryTokenizer.Token tokenType) {
            switch (tokenType) {
                case Line: {
                    break;
                }
                case Word: {
                    this.processWord(parser);
                    break;
                }
                case Eof: {
                    break;
                }
                case Number: 
                case DoubleQuotedString: {
                    this.addValue(parser.value, DataType.NONE);
                    break;
                }
                case SingleQuotedString: {
                    this.addValue(Strings.unquote(parser.value), DataType.STRING);
                    break;
                }
                case SplashSplashComment: {
                    break;
                }
                case Symbol: {
                    this.processSymbol(parser);
                    break;
                }
            }
            return tokenType;
        }

        private void processWord(QueryTokenizer parser) {
            if ("timezone".equalsIgnoreCase(parser.value)) {
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                return;
            }
            for (String w : deprecated_words) {
                if (!w.equalsIgnoreCase(parser.value)) continue;
                this.isCompatible = false;
                return;
            }
            for (String w : skip_words) {
                if (!w.equalsIgnoreCase(parser.value)) continue;
                return;
            }
            for (String w : value_words) {
                if (!w.equalsIgnoreCase(parser.value)) continue;
                this.addValue(parser.value, DataType.NONE);
                return;
            }
            if ("is".equalsIgnoreCase(parser.value)) {
                if (!this.waitWord(parser)) {
                    this.isCompatible = false;
                    return;
                }
                if ("null".equalsIgnoreCase(parser.value)) {
                    this.addNull(true, false);
                    return;
                }
                if (!"not".equalsIgnoreCase(parser.value)) {
                    this.isCompatible = false;
                    return;
                }
                if (!this.waitWord(parser)) {
                    this.isCompatible = false;
                    return;
                }
                if ("null".equalsIgnoreCase(parser.value)) {
                    this.addNull(false, true);
                    return;
                }
                this.isCompatible = false;
                return;
            }
            for (IndexDescriptor.ConditionItem item : this.condition) {
                if (!item.isField(parser.value)) continue;
                this.currentItem = item;
                return;
            }
            this.currentItem = new IndexDescriptor.ConditionItem(parser.value);
            this.condition.add(this.currentItem);
        }

        private void processSymbol(QueryTokenizer parser) {
            if (parser.value.equals(":")) {
                boolean skip = true;
                boolean skipNext = false;
                block0: while (skip) {
                    skip = false;
                    QueryTokenizer.Token tokenType = parser.nextToken();
                    if (skipNext) {
                        skip = true;
                        skipNext = false;
                        continue;
                    }
                    if (tokenType == QueryTokenizer.Token.Symbol && parser.value.equals(":")) {
                        skip = true;
                        continue;
                    }
                    if (tokenType != QueryTokenizer.Token.Word) continue;
                    if ("timestamp".equalsIgnoreCase(parser.value)) {
                        tokenType = parser.nextToken();
                        if (tokenType == QueryTokenizer.Token.Word && "with".equalsIgnoreCase(parser.value) && (tokenType = parser.nextToken()) == QueryTokenizer.Token.Word && "time".equalsIgnoreCase(parser.value) && (tokenType = parser.nextToken()) == QueryTokenizer.Token.Word && "zone".equalsIgnoreCase(parser.value)) {
                            parser.nextToken();
                        }
                        return;
                    }
                    for (String w : skip_types) {
                        if (!w.equalsIgnoreCase(parser.value)) continue;
                        skip = true;
                        continue block0;
                    }
                    for (String w : skipNext_types) {
                        if (!w.equalsIgnoreCase(parser.value)) continue;
                        skip = true;
                        skipNext = true;
                        continue block0;
                    }
                }
                return;
            }
            for (String w : deprecated_symbols) {
                if (!w.equalsIgnoreCase(parser.value)) continue;
                this.isCompatible = false;
                return;
            }
        }

        String parse(DatabaseCaps caps, String text) {
            this.isCompatible = true;
            this.condition.clear();
            if (Strings.isVoid(text)) {
                return text;
            }
            this.currentItem = null;
            QueryTokenizer parser = new QueryTokenizer(text);
            QueryTokenizer.Token tokenType = null;
            while (tokenType != QueryTokenizer.Token.Eof) {
                tokenType = parser.nextToken();
                tokenType = this.processToken(parser, tokenType);
                if (this.isCompatible) continue;
                return text;
            }
            if (this.condition.isEmpty()) {
                return text;
            }
            Collections.sort(this.condition);
            StringBuilder sql = new StringBuilder();
            for (IndexDescriptor.ConditionItem item : this.condition) {
                item.sortValues();
                item.toSql(caps, sql);
            }
            return sql.toString();
        }
    }
}

