/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.expr;

import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.expr.DVEvaluator;
import inform.agent.db.utils.DirectoriesCollection;
import inform.agent.expr.OperationTerm;
import java.io.IOException;

public class DVBinaryOpEvalutor
extends DVEvaluator {
    private final DVEvaluator left;
    private final DVEvaluator right;

    public DVBinaryOpEvalutor(OperationTerm term, DVEvaluator left, DVEvaluator right) {
        super(term);
        this.left = left;
        this.right = right;
    }

    @Override
    public void generate(StringBuilder sql, DatabaseCaps caps) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        this.left.generate(sql, caps);
        switch (this.term.getToken()) {
            case add: {
                if (this.isStringType()) {
                    sql.append(caps.concatOperator);
                    break;
                }
                sql.append('+');
                break;
            }
            case sub: {
                sql.append('-');
                break;
            }
            case mul: {
                sql.append('*');
                break;
            }
            case div: {
                sql.append('/');
                break;
            }
            case mod: {
                sql.append('%');
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.right.generate(sql, caps);
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.left.isStringType() || this.right.isStringType();
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.left.isIgnored() || this.right.isIgnored();
    }

    @Override
    public void afterLoad(DirectoriesCollection collection) throws IOException {
        if (this.isIgnored()) {
            return;
        }
        this.left.afterLoad(collection);
        this.right.afterLoad(collection);
    }
}

