/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.Restructure;
import java.util.ArrayList;

public class CheckMtdTreeTables
extends Request {
    private static final int TAG_CMTT_RESULT = 1;
    private static final int TAG_CMTT_MTD_TREE = 2;
    private static final int TAG_CMTT_MTD_TREE_LOG = 3;
    private static final int TAG_CMTT_MTD_TREE_CONF = 4;

    public CheckMtdTreeTables(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        boolean checkMtdTree = false;
        boolean checkMtdTreeLog = false;
        boolean checkMtdConf = false;
        TaggedReader in = this.createRequestContentReader();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 2: {
                    checkMtdTree = true;
                    break;
                }
                case 3: {
                    checkMtdTreeLog = true;
                    break;
                }
                case 4: {
                    checkMtdConf = true;
                }
            }
        }
        final ArrayList log = new ArrayList();
        Restructure.RealLogger logger = new Restructure.RealLogger(){

            @Override
            public void info(String line) {
                super.info(line);
                log.add(line);
            }

            @Override
            public void log(TableDescriptor context, String line) {
                super.log(context, line);
                log.add(line);
            }
        };
        DatabaseDescriptor dd = DatabaseDescriptor.getMetabase();
        try (DatabaseConnection connection = dd.connectPrivileged("CheckMtdTreeTables::execute");
             Statement statement = connection.createStatement();){
            if (checkMtdTree) {
                Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdTree(), logger, true);
                connection.commit();
                Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdAgents(), logger, true);
                connection.commit();
                Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdLocks(), logger, true);
                connection.commit();
            }
            if (checkMtdTreeLog) {
                String logScheme = Core.getMetadataLogScheme();
                if (logScheme == null || logScheme.isEmpty()) {
                    logScheme = dd.getScheme();
                }
                Restructure.upcreateTable(null, connection.openScheme(logScheme), statement, TableDescriptor.getSystemMtdTreeLog(), logger, true);
                connection.commit();
            }
            if (checkMtdConf) {
                Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdConfNodes(), logger, true);
                connection.commit();
                Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdConf(), logger, true);
                connection.commit();
            }
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        if (log.isEmpty()) {
            writer.putAnsi(1, "\u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u043c");
        } else {
            for (String msg : log) {
                writer.putAnsi(1, msg);
            }
        }
        writer.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

