/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;
import java.util.ArrayList;

public class DataFilter
extends Request {
    public static final int TAG_DFR_GET_FILTERS = 1;
    public static final int TAG_DFR_SET_FILTERS = 2;
    public static final int TAG_DFR_DEL_FILTERS = 3;
    public static final int TAG_DFR_FILTERS = 4;
    public static final int TAG_DFR_DISABLED = 5;
    public static final int TAG_DFR_RENAME_FILTER = 7;
    public static final int TAG_DFR_NEW_NAME = 8;
    public static final int TAG_DFR_RESORT = 9;
    public static final int TAG_DF_FILTER = 1;
    public static final int TAG_DF_FILTER_ID = 1;
    public static final int TAG_DF_USER_ID = 2;
    public static final int TAG_DF_OWNER_ID = 3;
    public static final int TAG_DF_CONTROL_ID = 4;
    public static final int TAG_DF_NAME = 5;
    public static final int TAG_DF_CONTENT = 6;
    public static final int TAG_DF_SORT = 7;

    public DataFilter(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        AuditJournal filterTable = new AuditJournal(AuditJournal.Journal.DATAFILTER);
        if (!filterTable.isEnabled()) {
            out.putEmpty(5);
        } else {
            TaggedReader in = this.createRequestContentReader();
            block21: while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 1: {
                        TaggedReader stream = in.getStreamReader();
                        AuditJournal.DataFilterParam param = new AuditJournal.DataFilterParam();
                        param.userId = this.getUserID();
                        while (stream.next()) {
                            switch (stream.getCurrentTag()) {
                                case 2: {
                                    param.userId = stream.getDouble();
                                    break;
                                }
                                case 3: {
                                    param.formId = stream.getDouble();
                                    break;
                                }
                                case 4: {
                                    param.controlId = stream.getDouble();
                                }
                            }
                        }
                        AuditJournal.DataFilter[] filters = filterTable.readDataFilters(this.ssContext, param);
                        if (!filterTable.isEnabled()) break;
                        if (filters == null) continue block21;
                        for (AuditJournal.DataFilter f : filters) {
                            ByteArrayOutputStream r = new ByteArrayOutputStream();
                            TaggedWriter s = new TaggedWriter(r);
                            s.putDouble(1, f.recordID);
                            s.putDouble(2, f.userId);
                            s.putDouble(3, f.formId);
                            s.putDouble(4, f.controlId);
                            s.putString(5, f.name);
                            s.putRaw(6, f.content);
                            s.putDouble(7, f.sort);
                            s.flush();
                            out.putRaw(4, r.internalBuffer(), r.size());
                        }
                        break;
                    }
                    case 2: {
                        AuditJournal.DataFilter[] filters = new ArrayList();
                        TaggedReader stream = in.getStreamReader();
                        AuditJournal.DataFilter f = new AuditJournal.DataFilter();
                        filters.add(f);
                        f.userId = this.getUserID();
                        while (stream.next()) {
                            switch (stream.getCurrentTag()) {
                                case 1: {
                                    f.recordID = stream.getDouble();
                                    break;
                                }
                                case 2: {
                                    f.userId = stream.getDouble();
                                    break;
                                }
                                case 3: {
                                    f.formId = stream.getDouble();
                                    break;
                                }
                                case 4: {
                                    f.controlId = stream.getDouble();
                                    break;
                                }
                                case 5: {
                                    f.name = stream.getString();
                                    break;
                                }
                                case 6: {
                                    f.content = stream.getRaw();
                                    break;
                                }
                                case 7: {
                                    f.sort = stream.getDouble();
                                }
                            }
                        }
                        AuditJournal.DataFilter[] dataFilters = new AuditJournal.DataFilter[filters.size()];
                        filterTable.storeDataFilters(this.ssContext, filters.toArray(dataFilters), this);
                        break;
                    }
                    case 3: {
                        AuditJournal.DataFilter[] filters = (AuditJournal.DataFilter[])LittleEndian.toDoubleArray(in.getRaw());
                        filterTable.deleteDataFilters(this.ssContext, (double[])filters, this);
                        break;
                    }
                    case 7: {
                        AuditJournal.DataFilter f = new AuditJournal.DataFilter();
                        f.recordID = in.getDouble();
                        f.name = in.getString(8);
                        filterTable.renameDataFilter(this.ssContext, f, this);
                        break;
                    }
                    case 9: {
                        AuditJournal.DataFilter f;
                        AuditJournal.DataFilter[] filters = new ArrayList();
                        TaggedReader stream = in.getStreamReader();
                        while (stream.next()) {
                            f = new AuditJournal.DataFilter();
                            f.recordID = stream.getDouble(1);
                            f.sort = stream.getDouble(7);
                            filters.add(f);
                        }
                        AuditJournal.DataFilter[] dataFilters = new AuditJournal.DataFilter[filters.size()];
                        filterTable.updateDataFilterSorting(this.ssContext, filters.toArray(dataFilters), this);
                    }
                }
                if (filterTable.isEnabled()) continue;
                out.putEmpty(5);
                break;
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

