/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.CallableStatement;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.request.AbstractDataRequest;
import inform.agent.db.types.DataType;
import inform.agent.mtd.nodes.DatabaseNode;
import java.util.ArrayList;

public class ExecuteStoredProcedure
extends AbstractDataRequest {
    private static final int TAG_PROCEDURE_NAME = 1;
    private static final int TAG_RETURN_RESULT = 2;
    private static final int TAG_OUT_PARAMETER = 4;
    private static final int TAG_DECLARE_RETURN_RESULT = 8;
    private static final int TAG_DECLARE_RETURN_TABLE = 9;
    private static final int TAG_RETURN_SQL = 22;
    private static final int SPPT_IN = 1;
    private static final int SPPT_OUT = 2;

    public ExecuteStoredProcedure(RequestHeader rq) {
        super(rq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        String name = null;
        String fields = null;
        int[] formats = null;
        int declared_return_result_ft_data_type = 0;
        TaggedReader reader = this.createRequestContentReader();
        ArrayList<Param> params = new ArrayList<Param>();
        Param p = null;
        boolean returnSql = false;
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    name = reader.getAnsi();
                    break;
                }
                case 16: {
                    p = new Param();
                    int in_out = reader.getInt();
                    p.in = (in_out & 1) != 0;
                    p.out = (in_out & 2) != 0;
                    break;
                }
                case 15: {
                    if (p == null) break;
                    p.type = DataType.getDataTypeByJST(reader.getInt());
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    switch (reader.getCurrentTag()) {
                        case 11: {
                            if (p.type != DataType.BOOLEAN) {
                                p.type = DataType.INTEGER;
                            }
                            p.value = reader.getInt();
                            break;
                        }
                        case 12: {
                            p.type = DataType.FLOAT;
                            p.value = reader.getDouble();
                            break;
                        }
                        case 13: {
                            p.type = DataType.DATE_TIME;
                            p.value = reader.getDouble();
                            break;
                        }
                        case 14: {
                            p.type = DataType.STRING;
                            p.value = reader.getAnsi();
                        }
                    }
                    params.add(p);
                    p = null;
                    break;
                }
                case 8: {
                    declared_return_result_ft_data_type = reader.getInt();
                    break;
                }
                case 9: {
                    TableDescriptor td = TableDescriptor.get(reader.getDouble());
                    StringBuilder tmp = new StringBuilder();
                    int sep = 32;
                    int index = 0;
                    for (FieldDescriptor fd : td.getFields()) {
                        if (formats == null) {
                            formats = new int[td.getFields().size()];
                        }
                        formats[index++] = fd.getFormat();
                        tmp.append((char)sep).append(fd.getRawName());
                        sep = 44;
                    }
                    if (tmp.length() <= 0) break;
                    fields = tmp.toString();
                    break;
                }
                case 22: {
                    returnSql = true;
                }
            }
        }
        DatabaseDescriptor database = this.getNode(this.getNodeID(), DatabaseNode.class).getDescriptor();
        StringBuilder sql = new StringBuilder();
        DatabaseType.FunctionArgument[] arguments = new DatabaseType.FunctionArgument[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            p = (Param)params.get(i);
            p.sqlType = p.type.toSqlDataType();
            arguments[i] = p;
        }
        boolean nonselect = database.getDatabaseType().caps().callFunctionSql(sql, database, name, fields, arguments, declared_return_result_ft_data_type != 0);
        Param result = null;
        if (declared_return_result_ft_data_type != 0) {
            result = new Param();
            result.out = true;
            result.type = DataType.getDataTypeById(declared_return_result_ft_data_type);
            params.add(0, result);
        }
        if (returnSql) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(data);
            if (!params.isEmpty()) {
                int index = 0;
                int sep = 32;
                sql.append("\n{");
                for (Param prm : params) {
                    sql.append((char)sep);
                    PreparedStatement.appendLogParameter(sql, prm.type.toSqlDataType(), ++index, prm.value);
                    sep = 44;
                }
                sql.append('}');
            }
            out.putString(22, sql.toString());
            out.flush();
            this.sendResult(data.internalBuffer(), data.size());
            return;
        }
        ConnectionManager cm = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:ExecuteStoredProcedure");
        try {
            DatabaseConnection connection = cm.getConnection(this.getNodeID(), "rq:ExecuteStoredProcedure");
            boolean isOracle = connection.getDescriptor().getDatabaseType().isOracle();
            try (CallableStatement statement = connection.prepareCall(sql.toString());){
                statement.setLogDangerSQL();
                statement.setQueryTimeout();
                int idx = 1;
                for (Param prm : params) {
                    if (prm.inlined) continue;
                    if (prm.in) {
                        if (prm.value == null) {
                            statement.setNull(idx, prm.type.toSqlDataType());
                        } else {
                            switch (prm.type.toSqlDataType()) {
                                case BOOLEAN: {
                                    statement.setBoolean(idx, (Integer)prm.value != 0);
                                    break;
                                }
                                case INTEGER: {
                                    if (isOracle) {
                                        statement.setDouble(idx, ((Integer)prm.value).intValue());
                                        break;
                                    }
                                    statement.setInt(idx, (Integer)prm.value);
                                    break;
                                }
                                case DOUBLE: {
                                    statement.setDouble(idx, (Double)prm.value);
                                    break;
                                }
                                case STRING: {
                                    statement.setString(idx, (String)prm.value);
                                    break;
                                }
                                case DATE_TIME: {
                                    statement.setDateTime(idx, (Double)prm.value);
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException("Unsupported type: " + prm.type);
                                }
                            }
                        }
                    }
                    if (prm.out) {
                        statement.registerOutParameter(idx, prm.type.getSqlType());
                    }
                    ++idx;
                }
                try (ResultSet rs = null;){
                    if (nonselect) {
                        statement.execute(null);
                    } else {
                        rs = statement.executeQuery(null);
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    TaggedWriter writer = new TaggedWriter(out);
                    idx = 1;
                    for (Param prm : params) {
                        if (prm == result) {
                            writer.putInt32(2, result.type.getTypeId());
                            ExecuteStoredProcedure.writeParamValue(writer, statement, idx, prm.type, 0, this, 0.0);
                        } else if (prm.out) {
                            writer.putEmpty(4);
                            ExecuteStoredProcedure.writeParamValue(writer, statement, idx, prm.type, 0, this, 0.0);
                        }
                        ++idx;
                    }
                    int recordCount = 0;
                    if (rs != null) {
                        recordCount = this.writeResultSet(writer, rs, 0.0, formats);
                    }
                    writer.flush();
                    int dataSize = out.size();
                    this.sendResult(out.internalBuffer(), out.size());
                    if (recordCount > 30000 || dataSize > 0x4000000) {
                        Core.logger.warn("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u043e\u043b\u044c\u0448\u043e\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0434\u0430\u043d\u043d\u044b\u0445: {} \u0437\u0430\u043f\u0438\u0441\u0435\u0439, {} \u0431\u0430\u0439\u0442", (Object)recordCount, (Object)dataSize);
                    }
                }
            }
            cm.commit();
        }
        finally {
            cm.release();
        }
    }

    private static class Param
    extends DatabaseType.FunctionArgument {
        private String name;
        private boolean in;
        private boolean out;
        private DataType type;

        private Param() {
        }
    }
}

