/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.TaggedReader;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.BlobDataReader;
import inform.agent.db.types.BlobValueId;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.Adler32;

public class GetCachedBlobData
extends Request {
    private static final int TAG_CBD_BLOB_SIZE = 1;
    private static final int TAG_CBD_BLOB_CHECKSUM = 2;
    private static final int TAG_CBD_BLOB_ID = 3;
    private static final int TAG_CBD_BLOB_LIMIT = 4;
    public static final byte RESULT_CODE_LIMITED = -1;
    public static final byte RESULT_CODE_CONTENT = 0;
    public static final byte RESULT_CODE_CACHED = 1;
    public static final byte RESULT_CODE_HEADER = 2;
    private final boolean blobHeaderMode;

    public GetCachedBlobData(RequestHeader rq, boolean blobHeaderMode) {
        super(rq, RequestDuration.DATA_ACCESS);
        this.blobHeaderMode = blobHeaderMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws Throwable {
        InputStream blobIn;
        int bytesReaden;
        block43: {
            BlobDataReader blobData;
            block44: {
                block42: {
                    long bs;
                    TaggedReader in = this.createRequestContentReader();
                    int size = 0;
                    long checkSum = 0L;
                    boolean isSize = false;
                    boolean isCheckSum = false;
                    BlobValueId blobId = null;
                    int limit = 0;
                    block23: while (in.getNextTag() != 0) {
                        switch (in.getCurrentTag()) {
                            case 1: {
                                size = in.getInt();
                                isSize = true;
                                break;
                            }
                            case 2: {
                                checkSum = in.getUnsignedInt();
                                isCheckSum = true;
                                break;
                            }
                            case 3: {
                                blobId = new BlobValueId(in.getRaw());
                                break;
                            }
                            case 4: {
                                limit = in.getInt();
                                continue block23;
                            }
                        }
                    }
                    byte[] blobHeader = null;
                    boolean sendHeader = false;
                    blobData = new BlobDataReader(this.getRequestSessionID(), this, limit > 0);
                    if (isSize && isCheckSum) {
                        int blobSize = 0;
                        Adler32 blobCheckSum = new Adler32();
                        try (InputStream blobIn2 = blobData.readData(null, this.getNodeID(), blobId);){
                            long bs2;
                            if (limit > 0 && (bs2 = blobData.getBlobSize()) > (long)limit) {
                                if (!this.blobHeaderMode) {
                                    byte[] result = new byte[]{-1};
                                    this.sendResult(result);
                                    return;
                                }
                                sendHeader = true;
                            }
                            if (blobIn2 != null) {
                                byte[] buffer = new byte[4096];
                                do {
                                    if ((bytesReaden = blobIn2.read(buffer)) > 0) {
                                        blobSize += bytesReaden;
                                        blobCheckSum.update(buffer, 0, bytesReaden);
                                        if (this.blobHeaderMode && blobHeader == null) {
                                            blobHeader = Arrays.copyOf(buffer, bytesReaden);
                                        }
                                    }
                                    this.idle();
                                } while (bytesReaden > -1);
                            }
                        }
                        if (blobSize == size && blobCheckSum.getValue() == checkSum) {
                            byte[] result = new byte[]{1};
                            this.sendResult(result);
                            return;
                        }
                        if (this.blobHeaderMode && sendHeader && blobHeader != null) {
                            byte[] result = new byte[]{2};
                            this.sendChunk(result);
                            this.sendResult(blobHeader);
                            return;
                        }
                    }
                    blobIn = blobData.readData(null, this.getNodeID(), blobId);
                    if (blobIn == null || limit <= 0 || (bs = blobData.getBlobSize()) <= (long)limit) break block42;
                    if (!this.blobHeaderMode) {
                        byte[] r = new byte[]{-1};
                        this.sendResult(r);
                        return;
                    }
                    break block43;
                }
                byte[] result = new byte[]{0};
                this.sendChunk(result);
                if (blobIn != null) {
                    int bytesReaden2;
                    byte[] buffer = new byte[4096];
                    do {
                        if ((bytesReaden2 = blobIn.read(buffer)) > 0) {
                            this.sendChunk(buffer, bytesReaden2);
                        }
                        this.idle();
                    } while (bytesReaden2 > -1);
                }
                break block44;
                finally {
                    if (blobIn != null) {
                        blobIn.close();
                    }
                }
            }
            this.sendResult();
            return;
            finally {
                blobData.release();
            }
        }
        byte[] buffer = new byte[4096];
        do {
            if ((bytesReaden = blobIn.read(buffer)) > 0) {
                byte[] result = new byte[]{2};
                this.sendChunk(result);
                this.sendResult(buffer, bytesReaden);
                return;
            }
            this.idle();
        } while (bytesReaden > -1);
    }
}

