/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.expr.DVEvaluator;
import inform.agent.db.expr.DVExpression;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.DirectoriesCollection;
import inform.agent.db.utils.FieldLocation;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.db.utils.ValueFieldLocation;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.DatabaseNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.format.FormatManager;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class GetDistinctValues
extends Request {
    private static final int TAG_VALUE_TABLE_ID = 1;
    private static final int TAG_VALUE_FIELD_ID = 2;
    private static final int TAG_VALUE_DATA_TYPE = 3;
    private static final int TAG_VALUE_NULL = 4;
    private static final int TAG_VALUE_INTEGER = 5;
    private static final int TAG_VALUE_DOUBLE = 6;
    private static final int TAG_VALUE_STRING = 7;
    private static final int TAG_VALUE_FLITER = 8;
    private static final int TAG_VALUE_OPTIONS = 9;
    private static final int TAG_VALUE_ROW_ID = 10;
    private static final int TAG_VALUE_FIELD_PATH = 11;
    private static final int TAG_VALUE_DATA_TYPES = 12;
    private static final int TAG_VALUE_BEGIN = 13;
    private static final int TAG_VALUE_END = 14;
    private static final int TAG_VALUE_ACTUAL_POINT = 15;
    private static final int TAG_VALUE_UNICODE = 51;
    private static final int TAG_VALUE_EXPRESSION = 52;
    private static final int TAG_FILTER_FIELD_ID = 1;
    private static final int TAG_FILTER_NULL = 2;
    private static final int TAG_FILTER_INTEGER = 3;
    private static final int TAG_FILTER_DOUBLE = 4;
    private static final int TAG_FILTER_DATE_TIME = 5;
    private static final int TAG_FILTER_STRING = 6;
    private static final int TAG_FILTER_DIRETORY_ID = 7;
    private static final int TAG_FILTER_REF_FIELD_ID = 8;
    private static final int TAG_FILTER_FIELD_COUNT = 10;
    private static final int TAG_FILTER_TABLE_ID = 11;
    private static final int TAG_FILTER_GROUP_INDEX = 12;
    private static final int TAG_FILTER_DATE_TIME_P2 = 13;
    private static final int DVO_DISTINCT_DEFAULT = 0;
    private static final int DVO_GET_ALL_VALUES = 1;
    private static final int DVO_GET_VALUE_REF = 2;

    public GetDistinctValues(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        this.execute(this.getNodeID(), in);
    }

    protected void returnResult(byte[] buffer, int bufferLen) throws Exception {
        this.sendResult(buffer, bufferLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(double databaseId, TaggedReader in) throws Throwable {
        Node nodeInfo;
        DirectoriesCollection directoriesCollection = new DirectoriesCollection(this);
        ArrayList<ValueFieldLocation> valueFieldLocations = new ArrayList<ValueFieldLocation>();
        ArrayList currentPath = null;
        ArrayList<ArrayList> fieldPathList = new ArrayList<ArrayList>();
        SqlParameterList parameters = new SqlParameterList();
        int options = 0;
        DVEvaluator expression = null;
        block26: while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    if (currentPath == null) {
                        currentPath = new ArrayList();
                        fieldPathList.add(currentPath);
                    }
                    FieldLocation loc = new FieldLocation();
                    currentPath.add(loc);
                    loc.tableId = in.getDouble(1);
                    Object node = this.getNode(loc.tableId);
                    this.checkNodeAccess((Node)node, 0x4000000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0447\u0442\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
                    loc.fieldId = in.getInt(2);
                    loc.alias = directoriesCollection.newAlias();
                    break;
                }
                case 9: {
                    Object loc;
                    for (ArrayList path : fieldPathList) {
                        directoriesCollection.add(path);
                        loc = new ValueFieldLocation();
                        valueFieldLocations.add((ValueFieldLocation)loc);
                        ((ValueFieldLocation)loc).fieldInfo = (FieldLocation)path.get(path.size() - 1);
                        ((ValueFieldLocation)loc).tableInfo = TableDescriptor.get(((ValueFieldLocation)loc).fieldInfo.tableId);
                        FieldDescriptor f = ((ValueFieldLocation)loc).tableInfo.getExistingFieldDescriptor(((ValueFieldLocation)loc).fieldInfo.fieldId);
                        ((ValueFieldLocation)loc).type = f.getType();
                        ((ValueFieldLocation)loc).format = f.getFormat();
                        ((ValueFieldLocation)loc).name = f.getRawName();
                    }
                    options = in.getInt();
                    break;
                }
                case 15: {
                    directoriesCollection.setActualPoint(in.getDouble());
                    break;
                }
                case 8: {
                    TaggedReader reader = in.getStreamReader();
                    this.loadDistinctFilter(reader, directoriesCollection, parameters);
                    break;
                }
                case 11: {
                    Object loc;
                    ArrayList path;
                    TaggedReader stream = in.getSubStreamReader();
                    path = new ArrayList();
                    fieldPathList.add(path);
                    while (stream.getNextTag() != 0) {
                        if (stream.getCurrentTag() != 1) continue;
                        loc = new FieldLocation();
                        path.add(loc);
                        ((FieldLocation)loc).tableId = stream.getDouble(1);
                        Object node = this.getNode(((FieldLocation)loc).tableId);
                        this.checkNodeAccess((Node)node, 0x4000000, "\u0412\u0430\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0447\u0442\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
                        ((FieldLocation)loc).fieldId = stream.getInt(2);
                        ((FieldLocation)loc).alias = directoriesCollection.newAlias();
                    }
                    if (fieldPathList.isEmpty()) continue block26;
                    currentPath = (ArrayList)fieldPathList.get(0);
                    break;
                }
                case 52: {
                    byte[] exprContent = in.getRaw();
                    if (exprContent == null || exprContent.length == 0) break;
                    DVExpression expr = new DVExpression(currentPath, this.getUserID());
                    expr.load(new TaggedReader(exprContent));
                    expression = (DVEvaluator)expr.compile();
                }
            }
        }
        if (expression != null) {
            expression.afterLoad(directoriesCollection);
        }
        if (currentPath == null) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430");
        }
        StringBuilder sql = new StringBuilder();
        FieldLocation topFieldLoc = (FieldLocation)((ArrayList)fieldPathList.get(0)).get(0);
        TableDescriptor topTableInfo = TableDescriptor.get(topFieldLoc.tableId);
        if (topTableInfo.getKind() == TableDescriptor.Kind.VIRTUAL) {
            throw new InformException("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u044b\u0431\u043e\u0440 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439");
        }
        sql.append("select ");
        if ((options & 1) == 0) {
            sql.append("distinct ");
        }
        if ((nodeInfo = MtdEngine.getValidNode(databaseId)).getType() == 12) {
            databaseId = TableDescriptor.get(databaseId).getDbId();
        }
        boolean addComma = false;
        if (expression != null) {
            FieldDescriptor primaryKeyField;
            DatabaseDescriptor databaseDescriptor = ((DatabaseNode)MtdEngine.getValidNode(databaseId)).getDescriptor();
            DatabaseCaps caps = databaseDescriptor.getDatabaseType().caps();
            StringBuilder value = new StringBuilder();
            expression.generate(value, caps);
            ValueFieldLocation loc = (ValueFieldLocation)valueFieldLocations.get(0);
            sql.append(loc.fieldInfo.alias).append('.').append(loc.name).append(',').append((CharSequence)value);
            StringBuilder additionalWhere = new StringBuilder();
            if ((options & 1) != 0) {
                primaryKeyField = topTableInfo.getRecordIdField();
                sql.append(',').append(topFieldLoc.alias).append('.').append(primaryKeyField.getRawName());
                additionalWhere.append(topFieldLoc.alias).append('.').append(primaryKeyField.getRawName());
            } else {
                additionalWhere.append(loc.fieldInfo.alias).append('.').append(loc.name);
            }
            additionalWhere.append(" IS NOT NULL");
            sql.append(" from ").append((CharSequence)directoriesCollection.from);
            if (directoriesCollection.where.length() > 0) {
                sql.append(" where ").append((CharSequence)directoriesCollection.where).append(" and ").append((CharSequence)additionalWhere);
            } else {
                sql.append(" where ").append((CharSequence)additionalWhere);
            }
            sql.append(" order by ").append((CharSequence)value);
            if ((options & 1) != 0) {
                primaryKeyField = topTableInfo.getRecordIdField();
                sql.append(',').append(topFieldLoc.alias).append(primaryKeyField.getRawName());
            }
            ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:GetDistinctValues1");
            try {
                DatabaseConnection db = connectionManager.getConnection(databaseId, "rq:GetDistinctValues");
                if (!((AbstractConnectionManager)connectionManager).isPersonalSession()) {
                    db.markAsReadonly();
                }
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                TaggedWriter out = new TaggedWriter(result);
                try (PreparedStatement statement = db.prepareStatement("GetDistinctValues.run", sql.toString());){
                    statement.setQueryTimeout();
                    parameters.applyTo(statement);
                    try (ResultSet resultSet = statement.executeQuery(this.getSSContext());){
                        int[] types = resultSet.getColumnTypes();
                        DataType dataType = DataType.getDataTypeBySqlTypeId(types[1]);
                        out.putInt32(3, dataType.getTypeId());
                        while (resultSet.next()) {
                            this.idle();
                            out.putDouble(10, resultSet.getDouble(1));
                            this.putFieldValue(resultSet, 2, dataType, loc.format, out);
                        }
                    }
                }
                connectionManager.commit();
                out.flush();
                this.returnResult(result.internalBuffer(), result.size());
            }
            finally {
                ((AbstractConnectionManager)connectionManager).release();
            }
        }
        for (ValueFieldLocation loc : valueFieldLocations) {
            if (addComma) {
                sql.append(',');
            }
            sql.append(loc.fieldInfo.alias).append('.').append(loc.name);
            addComma = true;
        }
        StringBuilder additionalWhere = new StringBuilder();
        if ((options & 1) != 0) {
            FieldDescriptor primaryKeyField = topTableInfo.getValidRecordIdField();
            sql.append(',').append(topFieldLoc.alias).append('.').append(primaryKeyField.getRawName());
            additionalWhere.append(topFieldLoc.alias).append('.').append(primaryKeyField.getRawName());
        } else {
            additionalWhere.append(((ValueFieldLocation)valueFieldLocations.get((int)0)).fieldInfo.alias).append('.').append(((ValueFieldLocation)valueFieldLocations.get((int)0)).name);
        }
        additionalWhere.append(" IS NOT NULL");
        sql.append(" from ").append((CharSequence)directoriesCollection.from);
        if (directoriesCollection.where.length() > 0) {
            sql.append(" where ").append((CharSequence)directoriesCollection.where).append(" and ").append((CharSequence)additionalWhere);
        } else {
            sql.append(" where ").append((CharSequence)additionalWhere);
        }
        sql.append(" order by ");
        addComma = false;
        for (ValueFieldLocation loc : valueFieldLocations) {
            if (addComma) {
                sql.append(',');
            }
            sql.append(loc.fieldInfo.alias).append('.').append(loc.name);
            addComma = true;
        }
        ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:getDistinctValues2");
        try {
            DatabaseConnection db = connectionManager.getConnection(databaseId, "rq:GetDistinctValues");
            if (!((AbstractConnectionManager)connectionManager).isPersonalSession()) {
                db.markAsReadonly();
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            TaggedWriter out = new TaggedWriter(result);
            try (PreparedStatement statement = db.prepareStatement("GetDistinctValues.run", sql.toString());){
                statement.setQueryTimeout();
                parameters.applyTo(statement);
                try (ResultSet resultSet = statement.executeQuery(this.getSSContext());){
                    ResultSetMetaData metadata = resultSet.getMetaData();
                    int primaryKeyField = -1;
                    if (metadata.getColumnCount() > valueFieldLocations.size() && (options & 1) != 0) {
                        primaryKeyField = valueFieldLocations.size() + 1;
                    }
                    for (ValueFieldLocation loc : valueFieldLocations) {
                        if (loc.type != DataType.PRIMARY_KEY) continue;
                        loc.type = DataType.FLOAT;
                    }
                    if (valueFieldLocations.size() == 1) {
                        out.putInt32(3, ((ValueFieldLocation)valueFieldLocations.get((int)0)).type.getTypeId());
                    } else {
                        for (ValueFieldLocation loc : valueFieldLocations) {
                            out.putInt32(12, loc.type.getTypeId());
                        }
                    }
                    while (resultSet.next()) {
                        this.idle();
                        if (primaryKeyField > 0) {
                            double value = resultSet.getDouble(primaryKeyField);
                            if (!resultSet.wasNull()) {
                                out.putDouble(10, value);
                            }
                        }
                        if (valueFieldLocations.size() > 1) {
                            out.putEmpty(13);
                        }
                        for (int valueIndex = 0; valueIndex < valueFieldLocations.size(); ++valueIndex) {
                            ValueFieldLocation loc;
                            loc = (ValueFieldLocation)valueFieldLocations.get(valueIndex);
                            this.putFieldValue(resultSet, valueIndex + 1, loc.type, loc.format, out);
                        }
                        if (valueFieldLocations.size() <= 1) continue;
                        out.putEmpty(14);
                    }
                }
            }
            connectionManager.commit();
            out.flush();
            this.returnResult(result.internalBuffer(), result.size());
        }
        finally {
            ((AbstractConnectionManager)connectionManager).release();
        }
    }

    private boolean putFieldValue(ResultSet resultSet, int colIndex, DataType type, int format, TaggedWriter out) throws SQLException, IOException {
        if (type != null) {
            switch (type.toSqlDataType()) {
                case BOOLEAN: {
                    boolean value = resultSet.getBoolean(colIndex);
                    if (resultSet.wasNull()) break;
                    out.putInt32(5, value ? 1 : 0);
                    return true;
                }
                case INTEGER: {
                    int value = resultSet.getInt(colIndex);
                    if (resultSet.wasNull()) break;
                    out.putInt32(5, value);
                    return true;
                }
                case DOUBLE: {
                    double value = resultSet.getDouble(colIndex);
                    if (resultSet.wasNull()) break;
                    out.putDouble(6, value);
                    return true;
                }
                case STRING: 
                case UNICODE: {
                    String value = resultSet.getString(colIndex);
                    if (resultSet.wasNull()) break;
                    if (type == DataType.UNICODE) {
                        out.putUnicode(51, value);
                    } else {
                        out.putAnsi(7, value);
                    }
                    return true;
                }
                case DATE_TIME: 
                case TIMESTAMP: {
                    double value = resultSet.getDateTime(colIndex);
                    if (resultSet.wasNull()) break;
                    value = FormatManager.fromServerTime(value, format, this);
                    out.putDouble(6, value);
                    return true;
                }
            }
        }
        out.putEmpty(4);
        return false;
    }

    private void loadDistinctFilter(TaggedReader reader, DirectoriesCollection directoriesCollection, SqlParameterList parameters) throws IOException, InformException {
        int INVALID_GROUP_INDEX = -100;
        int prevGroupIndex = -100;
        FieldDescriptor field = null;
        StringBuilder where = new StringBuilder();
        FieldLocation filterField = null;
        boolean isInterval = false;
        double intervalEnd = 0.0;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 10: {
                    int count;
                    isInterval = false;
                    ArrayList<FieldLocation> path = new ArrayList<FieldLocation>(count);
                    for (count = reader.getInt(); count > 0; --count) {
                        FieldLocation fl = new FieldLocation();
                        path.add(fl);
                        fl.tableId = reader.getDouble(11);
                        fl.fieldId = reader.getInt(1);
                        fl.alias = directoriesCollection.newAlias();
                    }
                    int groupIndex = reader.getInt(12);
                    filterField = directoriesCollection.add(path);
                    TableDescriptor tableInfo = TableDescriptor.get(filterField.tableId);
                    if (prevGroupIndex != -100 && groupIndex == prevGroupIndex) {
                        where.append(" OR ");
                    } else if (where.length() > 0) {
                        where.append(") AND (");
                    } else {
                        where.append('(');
                    }
                    field = tableInfo.getFieldDescriptor(filterField.fieldId);
                    where.append(filterField.alias).append('.').append(field.getRawName());
                    prevGroupIndex = groupIndex;
                    break;
                }
                case 2: {
                    where.append(" is NULL");
                    break;
                }
                case 3: {
                    where.append("=?");
                    SqlParameter param = new SqlParameter();
                    parameters.add(param);
                    if (field != null && field.getType() == DataType.BOOLEAN) {
                        param.setBoolean(reader.getInt() != 0);
                        break;
                    }
                    param.setInteger(reader.getInt());
                    break;
                }
                case 4: {
                    where.append("=?");
                    SqlParameter param = new SqlParameter();
                    parameters.add(param);
                    param.setDouble(reader.getDouble());
                    break;
                }
                case 5: {
                    SqlParameter param = new SqlParameter();
                    parameters.add(param);
                    param.setDateTime(FormatManager.toServerTime(reader.getDouble(), field.getFormat(), this));
                    if (isInterval) {
                        assert (filterField != null);
                        assert (field != null);
                        where.append(">=? AND ").append(filterField.alias).append('.').append(field.getRawName()).append("<?");
                        param = new SqlParameter();
                        parameters.add(param);
                        param.setDateTime(intervalEnd);
                        break;
                    }
                    where.append("=?");
                    break;
                }
                case 6: {
                    where.append("=?");
                    SqlParameter param = new SqlParameter();
                    parameters.add(param);
                    param.setString(reader.getAnsi());
                    break;
                }
                case 13: {
                    isInterval = true;
                    intervalEnd = FormatManager.toServerTime(reader.getDouble(), field.getFormat(), this);
                }
            }
        }
        if (where.length() > 0) {
            if (directoriesCollection.where.length() > 0) {
                directoriesCollection.where.append(" AND ");
            }
            directoriesCollection.where.append((CharSequence)where).append(')');
        }
    }
}

