/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;

public class ReplaceRecordRefsRequest
extends Request {
    private static final int TAG_DIR_TABLE_ID = 1;
    private static final int TAG_TABLE_ID = 2;
    private static final int TAG_REC_ID = 3;
    private static final int TAG_REC_COUNT = 4;
    private static final int TAG_NEW_REC_ID = 5;
    private static final int IN_COUNT_LIMIT = 1000;

    public ReplaceRecordRefsRequest(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    @Override
    public void execute() throws Throwable {
        int count = 0;
        double tableID = 0.0;
        double fkRefsTableID = 0.0;
        double recordID = 0.0;
        double newRecordID = 0.0;
        TaggedReader reader = this.createRequestContentReader();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    tableID = reader.getDouble();
                    break;
                }
                case 2: {
                    fkRefsTableID = reader.getDouble();
                    break;
                }
                case 3: {
                    recordID = reader.getDouble();
                    break;
                }
                case 5: {
                    newRecordID = reader.getDouble();
                }
            }
        }
        count = ReplaceRecordRefsRequest.replaceRecordsRefs(this, tableID, recordID, newRecordID, fkRefsTableID);
        ByteArrayOutputStream ar = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(ar);
        writer.putInt32(4, count);
        writer.flush();
        this.sendResult(ar.internalBuffer(), ar.size());
    }

    public static int replaceRecordsRefs(ServerSideHost ssHost, double tableID, double recordID, double newRecordID, double fkRefsTableID) throws Throwable {
        int count = 0;
        if (ssHost != null && tableID != 0.0 && fkRefsTableID != 0.0 && recordID != 0.0) {
            IntegerSet Fields2 = new IntegerSet();
            TableDescriptor tDesc = new TableDescriptor(fkRefsTableID, false);
            for (FieldDescriptor f : tDesc.getFields()) {
                if (f.isVirtual() || f.getType() != DataType.DIRECTORY || f.getReferenceId() != tableID) continue;
                Fields2.add(f.getId());
            }
            if (!Fields2.empty()) {
                for (Cursor.Integer c : Fields2) {
                    DoubleSet Recs = ReplaceRecordRefsRequest.getRecords(ssHost, fkRefsTableID, recordID, c.value);
                    if (!Recs.empty()) {
                        count += Recs.size();
                    }
                    ReplaceRecordRefsRequest.updateRecords(ssHost, fkRefsTableID, Recs, newRecordID, c.value);
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DoubleSet getRecords(ServerSideHost ssHost, double fkRefsTableID, double recordId, int FieldID) throws Throwable {
        DoubleSet Recs = new DoubleSet();
        TableDescriptor tDesc = new TableDescriptor(fkRefsTableID, false);
        String tName = tDesc.getRawName();
        if (tName == null) {
            return Recs;
        }
        FieldDescriptor PrimaryKeyFieldDesc = tDesc.getRecordIdField();
        FieldDescriptor FieldDesc = tDesc.getFieldDescriptor(FieldID);
        if (PrimaryKeyFieldDesc == null || FieldDesc == null) {
            return Recs;
        }
        DatabaseDescriptor databaseDescriptor = tDesc.getDatabaseDescriptor();
        try (DatabaseConnection conn = databaseDescriptor.connect(ssHost, "rq:ReplaceRecordRefsRequest");){
            StringBuilder SelectStr = new StringBuilder();
            SelectStr.append(PrimaryKeyFieldDesc.getRawName());
            SelectStr.append(", ").append(FieldDesc.getRawName());
            StringBuilder WhereStr = new StringBuilder();
            WhereStr.append(FieldDesc.getRawName()).append("=").append(NumberConverter.doubleToString(recordId));
            String sql = String.format("SELECT %s FROM %s WHERE %s", SelectStr.toString(), databaseDescriptor.getTableRawName(tName), WhereStr.toString());
            PreparedStatement stmt = conn.prepareStatement(sql);
            try (ResultSet result = stmt.executeQuery(ssHost.getSSContext());){
                while (result.next()) {
                    Recs.add(result.getDouble(1));
                }
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
            }
        }
        return Recs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRecords(ServerSideHost ssHost, double fkRefsTableID, DoubleSet Recs, double newRecordID, int FieldID) throws Throwable {
        if (Recs.empty()) {
            return;
        }
        TableDescriptor tDesc = new TableDescriptor(fkRefsTableID, false);
        String tName = tDesc.getRawName();
        if (tName == null) {
            return;
        }
        FieldDescriptor PrimaryKeyFieldDesc = tDesc.getRecordIdField();
        FieldDescriptor FieldDesc = tDesc.getFieldDescriptor(FieldID);
        if (PrimaryKeyFieldDesc == null || FieldDesc == null) {
            return;
        }
        DatabaseDescriptor databaseDescriptor = tDesc.getDatabaseDescriptor();
        try (DatabaseConnection conn = databaseDescriptor.connect(ssHost, "rq:ReplaceRecordRefsRequest");){
            TableDataAudit audit = new TableDataAudit(ssHost.getSSContext(), conn, ssHost.getUserID(), 0.0, 0.0, 0.0, ssHost.getSessionID());
            audit.setBatchMode(true);
            StringBuilder SetStr = new StringBuilder();
            SetStr.append(FieldDesc.getRawName()).append("=");
            if (newRecordID == 0.0) {
                SetStr.append("NULL");
            } else {
                SetStr.append(NumberConverter.doubleToString(newRecordID));
            }
            StringBuilder WhereStr = new StringBuilder();
            WhereStr.append(PrimaryKeyFieldDesc.getRawName());
            StringBuilder InStr = new StringBuilder();
            int counter = 0;
            int count = Recs.size();
            for (Cursor.Double c : Recs) {
                if (InStr.length() > 0) {
                    InStr.append(",");
                }
                InStr.append(NumberConverter.doubleToString(c.value));
                audit.registrateModification(tDesc, c.value, AuditModification.MODIFY);
                if (++counter % 1000 != 0 && counter != count) continue;
                String sql = String.format("UPDATE %s SET %s WHERE %s IN (%s)", databaseDescriptor.getTableRawName(tName), SetStr.toString(), WhereStr.toString(), InStr.toString());
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.execute(ssHost.getSSContext());
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Throwable e) {
                        Core.logger.error(null, e);
                    }
                }
                audit.flush();
                conn.commit();
                InStr.setLength(0);
            }
        }
    }
}

