/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.TimeZoneHost;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleDoubleMap;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SearchParameters;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.FindNode;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class SearchInTree
extends Request {
    private static final int TAG_CONSTANTS = 1;
    private static final int TAG_DATASOURCE = 2;
    private static final int TAG_CONDITIONS = 3;
    private static final int TAG_START_WITH = 4;
    private static final int TAG_PATH = 1;
    private static final int TAG_NO_LEAFS = 2;

    public SearchInTree(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        byte[] constants_content = null;
        Constants constants = new Constants(this.rq.client.getUserId());
        Datasource root = null;
        Conditions conditions = null;
        DoubleSet roots = new DoubleSet();
        TaggedReader r = this.createRequestContentReader();
        while (r.next()) {
            switch (r.getCurrentTag()) {
                case 1: {
                    constants_content = r.getRaw();
                    constants.load(constants_content, (TimeZoneHost)this);
                    break;
                }
                case 2: {
                    root = new Datasource(0, r.getStreamReader(), this, constants);
                    break;
                }
                case 3: {
                    conditions = new Conditions(r.getStreamReader());
                    break;
                }
                case 4: {
                    for (double id : LittleEndian.toDoubleArray(r.getRaw())) {
                        roots.add(id);
                    }
                    break;
                }
            }
        }
        if (root == null) {
            throw new InformException("no datasources");
        }
        this.putRequestStateProgressMax(1000);
        try (DatabaseConnection cn = root.table.getDatabaseDescriptor().connect(this, "SearchInTree");){
            class Leaf {
                final double id;
                final double pid;

                Leaf(double id, double pid) {
                    this.id = id;
                    this.pid = pid;
                }
            }
            ArrayList<Leaf> leafs = new ArrayList<Leaf>();
            Datasource ds = root;
            FieldDescriptor fpk = SearchInTree.getSinglePk(ds.table);
            FieldDescriptor fho = null;
            for (Parameter p : ds.relations.values()) {
                int bdsid = p.getDatasourceBinding();
                if (bdsid != root.id) continue;
                if (fho != null) {
                    throw new InformException("too many field bindings");
                }
                fho = ds.table.getFieldDescriptor(p.getId());
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select ");
            sql.append(ds.id, fpk).append(", ");
            sql.append(ds.id, fho).append("\n  from ");
            ds.generate(this, constants_content, sql);
            sql.append(" ds").append(ds.id);
            sql.datasources.add(ds);
            String sep = root.generateFieldLinks("\n where ", sql, false);
            sep = SearchInTree.generate_conditions(sep, sql, conditions);
            for (Datasource c : root.children) {
                sql.append(sep);
                sep = " and ";
                this.generate_exists(sql, c, constants_content, conditions, "    ");
            }
            boolean limitedSearch = false;
            if (cn.getDescriptor().getDatabaseType().isOracle()) {
                sql.append("\n     start with ");
                sql.append(root.id, fpk).append(" in (");
                boolean first = true;
                for (Cursor.Double c : roots) {
                    if (first) {
                        first = false;
                    } else {
                        sql.append(',');
                    }
                    sql.append('?');
                    sql.parameters.createParameter(DataType.FLOAT).setAsNumber(c.value);
                }
                sql.append(')');
                ds.generateFieldLinks("\n     connect by ", sql, true);
                limitedSearch = true;
            }
            String stateText = "\u043f\u043e\u0438\u0441\u043a \u0437\u0430\u043f\u0438\u0441\u0435\u0439: ";
            this.putRequestStateText(stateText);
            try (PreparedStatement ps = cn.prepareStatement("fetchLeafs", sql.toString());){
                SearchInTree.applyParameters(sql.parameters.values(), ps);
                try (ResultSet rs = ps.executeQuery(null);){
                    int cnt = 0;
                    while (rs.next()) {
                        leafs.add(new Leaf(rs.getDouble(1), rs.getDouble(2)));
                        if (++cnt % 37 == 0) {
                            this.putRequestStateText(stateText + cnt);
                        }
                        this.idle();
                    }
                }
            }
            if (leafs.isEmpty()) {
                if (!limitedSearch) {
                    this.sendResult(new byte[]{2, 0});
                }
                return;
            }
            sql = new SqlBuilder();
            sql.append("select ");
            sql.append(ds.id, fho).append("\n  from ");
            ds.generate(this, constants_content, sql);
            sql.append(" ds").append(ds.id);
            sql.append("\n where ");
            sql.append(ds.id, fpk).append(" = ?");
            this.putRequestStateProgressPosition(600);
            String stateText2 = "\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + leafs.size() + "\n\u0442\u0440\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u0443\u0442\u0435\u0439: ";
            this.putRequestStateText(stateText2);
            try (PreparedStatement ps = cn.prepareStatement("fetchEdge", sql.toString());){
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                TaggedWriter writer = new TaggedWriter(output);
                DoubleDoubleMap edges = new DoubleDoubleMap();
                DoubleList path = new DoubleList(16);
                int cnt = 0;
                int sz = leafs.size();
                int ff = 0;
                for (Leaf l : leafs) {
                    if (++cnt % 37 == 0) {
                        this.putRequestStateProgressPosition(600 + 400 * cnt / sz);
                        this.putRequestStateText(stateText2 + cnt + "/" + sz + " " + ff);
                    }
                    this.idle();
                    if (!edges.contains(l.id)) {
                        edges.put(l.id, l.pid);
                    }
                    path.clear();
                    double pid = l.id;
                    while (pid != 0.0 && !roots.contains(pid)) {
                        path.add(pid);
                        if (!edges.contains(pid)) {
                            ps.setDouble(1, pid);
                            ResultSet rs = ps.executeQuery(null);
                            try {
                                if (!rs.next()) {
                                    pid = 0.0;
                                    break;
                                }
                                double npid = rs.getDouble(1);
                                edges.put(pid, npid);
                                pid = npid;
                                continue;
                            }
                            finally {
                                rs.close();
                                continue;
                            }
                        }
                        pid = edges.lget();
                    }
                    if (pid == 0.0) continue;
                    path.add(pid);
                    SearchInTree.reverse(path.internalArray(), path.size());
                    writer.putRaw(1, LittleEndian.doubleArrayToBinary(path.internalArray(), path.size()));
                    ++ff;
                }
                writer.flush();
                this.putRequestStateProgressPosition(1000);
                this.sendResult(output.internalBuffer(), output.size());
            }
        }
    }

    private static FieldDescriptor getSinglePk(TableDescriptor table) {
        ArrayList<FieldDescriptor> pks = table.getPrimaryKeyFields();
        if (pks.size() != 1) {
            throw new InformException("only one primary key need");
        }
        return pks.get(0);
    }

    private static void reverse(double[] array, int size) {
        int c = size / 2;
        for (int i = 0; i < c; ++i) {
            int j = size - i - 1;
            double t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    private static void applyParameters(Iterable<Parameter> parameters, PreparedStatement ps) throws SQLException {
        int idx = 0;
        block7: for (Parameter p : parameters) {
            if (p.getIsNull()) {
                ps.setNull(++idx, p.getDataType().toSqlDataType());
                continue;
            }
            switch (p.getDataType().toSqlDataType()) {
                case STRING: 
                case UNICODE: {
                    ps.setString(++idx, p.getAsString());
                    continue block7;
                }
                case DATE_TIME: {
                    ps.setDateTime(++idx, p.getAsDateValue());
                    continue block7;
                }
                case DOUBLE: {
                    ps.setDouble(++idx, p.getAsNumber());
                    continue block7;
                }
                case INTEGER: {
                    ps.setInt(++idx, (int)p.getAsNumber());
                    continue block7;
                }
                case BOOLEAN: {
                    ps.setBoolean(++idx, p.getAsBoolean());
                    continue block7;
                }
            }
            throw new InformException("unsupported parameter type: " + p.getDataType());
        }
    }

    private void generate_exists(SqlBuilder sql, Datasource ds, byte[] consts, Conditions conditions, String offset) throws IOException {
        sql.append("exists(select 0\n").append(offset).append("  from ");
        ds.generate(this, consts, sql);
        sql.datasources.add(ds);
        sql.append(" ds").append(ds.id);
        String sep = SearchInTree.generate_conditions("\n" + offset + " where ", sql, conditions);
        sep = ds.generateFieldLinks(sep, sql, false);
        for (Datasource c : ds.children) {
            sql.append(sep);
            sep = " and ";
            this.generate_exists(sql, c, consts, conditions, offset + "  ");
        }
        sql.append('\n').append(offset).append(')');
    }

    private static String generate_conditions(String sep, SqlBuilder sql, Conditions conditions) {
        for (Conditions.Condition l : conditions) {
            Datasource ds = sql.datasources.get(l.datasourceId);
            if (ds == null) continue;
            FieldDescriptor fd = ds.table.getFieldDescriptor(l.fieldId);
            sql.append(sep);
            sep = " and ";
            boolean hasMultiLookup = false;
            for (FieldDescriptor.LookupField lf : fd.multiLookupFields()) {
                if (!hasMultiLookup) {
                    sql.append('(');
                } else {
                    sql.append(" or ");
                }
                hasMultiLookup = true;
                sql.append('(');
                FieldDescriptor fp = ds.table.getFieldDescriptor(lf.path[0]);
                sql.append(ds.id, fp).append(" in (");
                int bc = 2;
                int pl = lf.path.length - 1;
                for (int i = 1; i <= pl; ++i) {
                    TableDescriptor td = TableDescriptor.get(fp.getReferenceId());
                    fp = td.getFieldDescriptor(lf.path[i]);
                    FieldDescriptor fpk = SearchInTree.getSinglePk(td);
                    sql.append("select ").append(fpk).append(" from ").append(td).append(" where ");
                    if (i != pl) {
                        sql.append(fp).append(" in (");
                        ++bc;
                        continue;
                    }
                    SearchInTree.generate_condition(sql, l, fp, 0);
                }
                sql.append(Strings.dup(')', bc));
            }
            if (hasMultiLookup) {
                sql.append(')');
                continue;
            }
            SearchInTree.generate_condition(sql, l, fd, ds.id);
        }
        return sep;
    }

    private static void generate_condition(SqlBuilder sql, Conditions.Condition condition, FieldDescriptor fd, int dsid) {
        sql.append("(lower(");
        if (dsid != 0) {
            sql.append(dsid, fd);
        } else {
            sql.append(fd);
        }
        switch (condition.operation) {
            case EQUAL_CI: {
                sql.append(") = ?)");
                break;
            }
            case LIKE_CI: {
                sql.append(") like '%'||?||'%')");
                break;
            }
            default: {
                throw new InformException("unknown operation: " + condition.operation);
            }
        }
        sql.parameters.createParameter(DataType.STRING).setAsString(condition.text.toLowerCase());
    }

    private static class HashedPath
    implements DoubleHash.Entry {
        final double[] path;

        @Override
        public double key() {
            return this.path[this.path.length - 1];
        }

        public HashedPath(double key) {
            this.path = new double[]{key};
        }

        public HashedPath(double key, HashedPath parent) {
            this.path = new double[parent.path.length + 1];
            System.arraycopy(parent.path, 0, this.path, 0, parent.path.length);
            this.path[parent.path.length] = key;
        }
    }

    private static class SqlBuilder
    extends SqlStringBuilder {
        final ParametersList parameters = new ParametersList();
        final IntegerHash<Datasource> datasources = new IntegerHash();

        private SqlBuilder() {
        }

        SqlBuilder append(SqlBuilder sql) {
            super.append(sql);
            for (Parameter p : sql.parameters.values()) {
                this.parameters.createParameter(p.getDataType()).assignParameter(p);
            }
            return this;
        }

        SqlBuilder append(int ds, FieldDescriptor f) {
            this.append("ds").append(ds).append('.').append(f);
            return this;
        }
    }

    private static class Conditions
    extends ArrayList<Condition> {
        static final int TAG_DATASOURCE_ID = 1;
        static final int TAG_FIELD_ID = 2;
        static final int TAG_OPERATION = 3;
        static final int TAG_TEXT_VALUE = 4;

        Conditions(TaggedReader r) throws IOException {
            while (r.next()) {
                if (r.getCurrentTag() != 1) continue;
                int dsid = r.getInt();
                int fid = r.getInt(2);
                int cop = r.getInt(3);
                String txt = r.getAnsi(4);
                this.add(new Condition(dsid, fid, cop, txt));
            }
        }

        static class Condition {
            final int datasourceId;
            final int fieldId;
            final Operation operation;
            final String text;

            Condition(int dsid, int fid, int cop, String txt) {
                this.datasourceId = dsid;
                this.fieldId = fid;
                this.operation = Operation.values()[cop];
                this.text = txt;
            }

            static enum Operation {
                EQUAL_CI,
                LIKE_CI;

            }
        }
    }

    private static class Datasource
    implements IntegerHash.Entry {
        static final int TAG_UID = 1;
        static final int TAG_NODE_ID = 2;
        static final int TAG_PARAMETERS = 3;
        static final int TAG_RELATIONS = 4;
        static final int TAG_DATASOURCE = 5;
        final int id;
        final int parentId;
        final BasicNode node;
        final TableDescriptor table;
        final boolean recursive;
        final ParametersList parameters;
        final ParametersList relations = new ParametersList();
        final Collection<Datasource> children = new ArrayList<Datasource>(2);

        Datasource(int parentId, TaggedReader r, TimeZoneHost timeZoneHost, Constants consts) throws IOException {
            ParametersList parameters_;
            this.parentId = parentId;
            this.id = r.getInt(1);
            double nodeId = r.getDouble(2);
            this.node = (BasicNode)MtdEngine.getValidNode(nodeId);
            TableDescriptor table_ = null;
            switch (this.node.getType()) {
                case 12: {
                    parameters_ = null;
                    table_ = ((TableNode)this.node).getDescriptor();
                    break;
                }
                case 19: {
                    FindNode.Descriptor find = ((FindNode)this.node).getDescriptor();
                    table_ = TableDescriptor.get(find.getRootTableId());
                    parameters_ = new ParametersList();
                    parameters_.load(consts, new TaggedReader(find.getInputParams()), Core.serverTimeZoneHost);
                    break;
                }
                default: {
                    throw new InformException("unsupported node type: " + this.node.getType());
                }
            }
            this.table = table_;
            this.parameters = parameters_;
            boolean recursive_ = false;
            while (r.next()) {
                switch (r.getCurrentTag()) {
                    case 3: {
                        if (this.parameters == null) {
                            throw new InformException("datasource " + this.id + " has no parameters");
                        }
                        this.parameters.loadParametersValues(consts, r.getStreamReader(), timeZoneHost);
                        break;
                    }
                    case 4: {
                        this.relations.load(consts, r.getStreamReader(), timeZoneHost);
                        break;
                    }
                    case 5: {
                        this.children.add(new Datasource(this.id, r.getStreamReader(), timeZoneHost, consts));
                    }
                }
            }
            this.recursive = recursive_;
        }

        @Override
        public int key() {
            return this.id;
        }

        void _generateFindSql(ServerSideHost host, byte[] constants, SqlBuilder sql) throws IOException {
            FindNode find = (FindNode)this.node;
            SqlGenerator sqlGen = new SqlGenerator(host, Core.serverTimeZoneHost);
            sqlGen.setTableId(find.getDescriptor().getRootTableId());
            sqlGen.setConstantsContent(constants, host);
            sqlGen.setSearchId(find.getId());
            byte[] searchContent = this.node.getContent();
            SqlGenerator.Method generationMethod = SqlGenerator.extractSearchGenerationMethod(searchContent);
            sqlGen.setSearchContent(searchContent);
            SearchParameters params = sqlGen.getParameters();
            for (Parameter p : this.parameters.values()) {
                params.addParameter(p.getId());
                if (p.getIsIgnored()) {
                    params.setIgnored();
                    continue;
                }
                SearchParameters.addParamValue(p, params);
            }
            GeneratedSql gsql = sqlGen.getGeneratedSql(generationMethod, -500);
            if (gsql.isHasError()) {
                throw new InformException(gsql.getError() + " datasource: " + this.id).detail(gsql.getErrorDetailing());
            }
            sql.append(gsql.getSqlText());
            TaggedReader reader = gsql.getParamersReader();
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        int typeId = reader.getInt();
                        DataType dataType = DataType.getDataTypeById(typeId);
                        sql.parameters.createParameter(dataType).clear();
                        break;
                    }
                    case 8: {
                        sql.parameters.createParameter(DataType.BOOLEAN).setAsBoolean(reader.getInt() != 0);
                        break;
                    }
                    case 2: {
                        sql.parameters.createParameter(DataType.INTEGER).setAsNumber(Double.valueOf(reader.getInt()));
                        break;
                    }
                    case 3: {
                        sql.parameters.createParameter(DataType.FLOAT).setAsNumber(reader.getDouble());
                        break;
                    }
                    case 4: {
                        sql.parameters.createParameter(DataType.STRING).setAsString(reader.getAnsi());
                        break;
                    }
                    case 6: {
                        sql.parameters.createParameter(DataType.DATE_TIME).setAsDateValue(reader.getDouble());
                        break;
                    }
                    case 7: {
                        sql.parameters.createParameter(DataType.UNICODE).setAsString(reader.getUnicode());
                    }
                }
            }
        }

        void generate(ServerSideHost host, byte[] constants, SqlBuilder sql) throws IOException {
            switch (this.node.getType()) {
                case 12: {
                    sql.append(this.table);
                    break;
                }
                case 19: {
                    sql.append('(');
                    this._generateFindSql(host, constants, sql);
                    sql.append(')');
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        String generateFieldLinks(String sep, SqlBuilder sql, boolean priorRecursive) {
            for (Parameter p : this.relations.values()) {
                int bdsid = p.getDatasourceBinding();
                if (!priorRecursive && bdsid == this.id) continue;
                sql.append(sep).append('(');
                sep = " and ";
                FieldDescriptor fd = this.table.getFieldDescriptor(p.getId());
                sql.append(this.id, fd);
                if (bdsid != 0) {
                    Datasource bds = sql.datasources.get(bdsid);
                    if (bds == null) {
                        throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043f\u043e\u0438\u0441\u043a\u0430 \u0432 \u0434\u0435\u0440\u0435\u0432\u0435").detail("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a [" + bdsid + "] \u0441\u0432\u044f\u0437\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                    }
                    FieldDescriptor bfd = bds.table.getFieldDescriptor(p.getFieldBinding());
                    sql.append(" = ");
                    if (bds.id == this.id) {
                        sql.append(" prior ");
                    }
                    sql.append(bds.id, bfd);
                } else {
                    int vc = p.getValueCount();
                    if (vc == 1) {
                        if (p.getIsNull()) {
                            sql.append(" is null");
                        } else {
                            sql.append(" = ?");
                            sql.parameters.createParameterByField(fd).assignParameter(p);
                        }
                    } else {
                        boolean hasNull = false;
                        boolean commaNeed = false;
                        sql.append(" in (");
                        for (int i = 0; i < vc; ++i) {
                            Object v = p.valueByIndex(i);
                            if (v == null) {
                                hasNull = true;
                                continue;
                            }
                            if (commaNeed) {
                                sql.append(',');
                            }
                            sql.append('?');
                            sql.parameters.createParameterByField(fd).setValue(v);
                            commaNeed = true;
                        }
                        sql.append(')');
                        if (hasNull) {
                            sql.append(" or ");
                            sql.append(this.id, fd);
                            sql.append(" is null");
                        }
                    }
                }
                sql.append(')');
            }
            return sep;
        }
    }
}

