/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.schema;

import inform.adt.Collections;
import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.IntegerSet;
import inform.agent.Core;
import inform.agent.LogContext;
import inform.agent.Request;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbIndex;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.db.schema.DbView;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Restructure {
    public static final Logger DDL_LOGGER = new RealLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntegerSet updateStructure(SSContext ssContext, DbScheme scheme, Statement statement, TableDescriptor ntd, TableDescriptor otd, Logger logger, Strategy strategy, Progress progress) throws SQLException {
        IntegerSet droppedIndices;
        block22: {
            Request rq;
            if (strategy == Strategy.RECREATE) {
                throw new UnsupportedOperationException(strategy + " not supported yet");
            }
            if (!Restructure.canRestructure(ntd, logger)) {
                return null;
            }
            progress.progress("\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
            if (ntd.isSystemTableName()) {
                switch (ntd.getKind()) {
                    case VIRTUAL: {
                        break;
                    }
                    case EXTERNAL: {
                        throw new InformException("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 " + ntd.toString() + " c \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u0439 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u043e\u0439 \u043d\u0435 \u043f\u043e\u0434\u043b\u0435\u0436\u0438\u0442 \u0440\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0438\u0440\u0438\u0437\u0430\u0446\u0438\u0438, \u0442\u0430\u043a \u043a\u0430\u043a \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439");
                    }
                    default: {
                        throw new InformException("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 " + ntd.toString() + " \u043d\u0435 \u043f\u043e\u0434\u043b\u0435\u0436\u0438\u0442 \u0440\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0438\u0440\u0438\u0437\u0430\u0446\u0438\u0438, \u0442\u0430\u043a \u043a\u0430\u043a \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439");
                    }
                }
            }
            droppedIndices = null;
            LogContext lc = LogContext.CURRENT.get();
            Request request = rq = lc instanceof Request ? (Request)lc : null;
            if (rq != null) {
                rq.vlongOp_begin();
            }
            try {
                DbTable table;
                if (ntd.getKind() == TableDescriptor.Kind.VIEW) {
                    DbView view = scheme.getView(ssContext, otd.getRawName());
                    if (view != null) {
                        view.drop(ssContext, statement);
                        logger.log(otd, "\u0442\u0430\u0431\u043b\u0438\u0446\u0430(View): \u0441\u0442\u0430\u0440\u043e\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u043e");
                    }
                    progress.progress("\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f");
                    scheme.createView(ssContext, statement, ntd);
                    logger.log(ntd, "\u0442\u0430\u0431\u043b\u0438\u0446\u0430(View): \u0441\u043e\u0437\u0434\u0430\u043d\u043e \u043d\u043e\u0432\u043e\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435");
                    break block22;
                }
                droppedIndices = new IntegerSet();
                DbTable dbTable = table = otd.urawnamed() ? null : scheme.getTable(ssContext, otd.getRawName());
                if (table == null) {
                    table = scheme.getTable(ssContext, ntd.getRawName());
                    if (table != null) {
                        throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443").detail(String.format("\u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f [%s] \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0421\u0423\u0411\u0414", table.name()));
                    }
                    progress.progress("\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
                    table = Restructure.createTable(ssContext, scheme, statement, ntd, logger);
                    table.updateFieldsInfo(ssContext, statement, ntd);
                    break block22;
                }
                String name = ntd.getRawName();
                if (!scheme.isNamesEquals(table.name(), name)) {
                    if (scheme.getTable(ssContext, name) != null) {
                        throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443").detail(String.format("\u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b [%s]: \u043d\u043e\u0432\u043e\u0435 \u0438\u043c\u044f [%s] \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", table.name(), name));
                    }
                    try {
                        progress.progress("\u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
                        table.rename(ssContext, statement, name);
                        logger.log(otd, "\u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0430");
                    }
                    catch (SQLFeatureNotSupportedException e) {
                        statement.connection().restoreTransactionAfterException(false);
                        Core.logger.warn("Failed to rename table", e);
                        DbTable nTable = Restructure.createTable(ssContext, scheme, statement, ntd, logger);
                        Restructure.copyTableData(ssContext, statement, otd, ntd, table, nTable);
                        logger.log(otd, "\u0434\u0430\u043d\u043d\u044b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u044b");
                        table.drop(ssContext, statement);
                        logger.log(otd, "\u0441\u0442\u0430\u0440\u0430\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430");
                        table = null;
                        nTable.updateFieldsInfo(ssContext, statement, ntd);
                    }
                }
                if (table != null) {
                    int tryCount = 3;
                    for (int i = 0; i < tryCount; ++i) {
                        progress.needRestart = false;
                        Restructure.restructureColumns(ssContext, statement, otd, ntd, table, logger, strategy, droppedIndices, progress);
                        if (!progress.needRestart) break;
                        table.invalidateColumns(ssContext);
                    }
                    table.updateFieldsInfo(ssContext, statement, ntd);
                }
            }
            finally {
                if (rq != null) {
                    rq.vlongOp_end();
                }
            }
        }
        return droppedIndices;
    }

    private static boolean isIndexWithSameStructureExists(SSContext ssContext, DbTable table, IndexDescriptor indexDescriptor) throws SQLException {
        DbIndex idx = table.getIndex(ssContext, indexDescriptor.getRawName());
        if (idx == null) {
            return false;
        }
        return idx.equals(indexDescriptor) && (!indexDescriptor.isSDOType() || !indexDescriptor.isSRIDChanged());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restructureIndices(SSContext ssContext, DbScheme scheme, Statement statement, TableDescriptor ntd, TableDescriptor otd, Logger logger, Strategy strategy, IntegerSet droppedIndices, Progress progress) throws SQLException {
        Request rq;
        DbTable table;
        if (!Restructure.canRestructure(ntd, logger)) {
            return;
        }
        DatabaseType dbt = scheme.getDatabaseType();
        progress.progress("\u0440\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u0432");
        DbTable dbTable = table = ntd.urawnamed() ? null : scheme.getTable(ssContext, ntd.getRawName());
        assert (table != null);
        LogContext lc = LogContext.CURRENT.get();
        Request request = rq = lc instanceof Request ? (Request)lc : null;
        if (rq != null) {
            rq.vlongOp_begin();
        }
        try {
            for (IndexDescriptor ni : ntd.getIndexes()) {
                ni.setSRIDChanged(false);
                if (!ni.isSDOType()) continue;
                ni.setSRIDChanged(Restructure.CreateNewSRID(ssContext, statement, table, ni));
            }
            HashSet<IndexDescriptor> create = new HashSet<IndexDescriptor>();
            HashSet<IndexDescriptor> delete = new HashSet<IndexDescriptor>();
            if (strategy == Strategy.RECREATE) {
                for (IndexDescriptor indexDescriptor : otd.getIndexes()) {
                    if (droppedIndices != null && droppedIndices.contains(indexDescriptor.getId())) continue;
                    delete.add(indexDescriptor);
                }
                create.addAll(ntd.getIndexes());
            } else {
                HashSet<Integer> modify = new HashSet<Integer>();
                for (IndexDescriptor oi : otd.getIndexes()) {
                    if (droppedIndices != null && droppedIndices.contains(oi.getId())) continue;
                    if (ntd.getIndexDescriptor(oi.getId()) == null) {
                        delete.add(oi);
                        continue;
                    }
                    modify.add(oi.getId());
                }
                for (IndexDescriptor ni : ntd.getIndexes()) {
                    DbIndex idx = table.getIndex(ssContext, ni.getRawName());
                    if (idx == null || idx.isValid()) {
                        modify.add(ni.getId());
                        continue;
                    }
                    create.add(ni);
                    delete.add(ni);
                }
                for (Integer id : modify) {
                    IndexDescriptor oi = otd.getIndexDescriptor(id);
                    IndexDescriptor ni = ntd.getIndexDescriptor(id);
                    if (oi != null && !ni.isApplicableTo(dbt)) {
                        delete.add(oi);
                        continue;
                    }
                    if (oi != null && !oi.isApplicableTo(dbt)) {
                        create.add(ni);
                        continue;
                    }
                    if (oi != null && !scheme.isNamesEquals(oi.getRawName(), ni.getRawName())) {
                        delete.add(oi);
                        create.add(ni);
                        continue;
                    }
                    DbIndex idx = table.getIndex(ssContext, ni.getRawName());
                    if (idx == null) {
                        create.add(ni);
                        continue;
                    }
                    if (idx.equals(ni) && (!ni.isSDOType() || !ni.isSRIDChanged())) continue;
                    delete.add(ni);
                    create.add(ni);
                }
            }
            for (IndexDescriptor indexDescriptor : delete) {
                DbIndex idx = table.getIndex(ssContext, indexDescriptor.getRawName());
                if (idx == null) continue;
                progress.progress("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u0430", indexDescriptor.getName());
                idx.drop(ssContext, statement);
                logger.log(ntd, "\u0423\u0434\u0430\u043b\u0435\u043d \u0438\u043d\u0434\u0435\u043a\u0441: %s", idx.name());
            }
            for (IndexDescriptor indexDescriptor : create) {
                if (!indexDescriptor.isApplicableTo(dbt)) continue;
                if (Restructure.isIndexWithSameStructureExists(ssContext, table, indexDescriptor)) {
                    logger.log(ntd, "\u0418\u043d\u0434\u0435\u043a\u0441 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442: %s", indexDescriptor.getRawName());
                    continue;
                }
                progress.progress("\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u0430", indexDescriptor.getName());
                DbIndex di = table.createIndex(ssContext, statement, indexDescriptor);
                logger.log(ntd, "\u0421\u043e\u0437\u0434\u0430\u043d \u0438\u043d\u0434\u0435\u043a\u0441: %s", di.name());
            }
        }
        finally {
            if (rq != null) {
                rq.vlongOp_end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean IndexNeedNewSRID(SSContext ssContext, DbTable table, IndexDescriptor ni) throws SQLException {
        boolean res;
        block15: {
            res = false;
            if (table != null && table.scheme != null && table.scheme.connection != null && ni != null && ni.isSDOType()) {
                if (!table.scheme.connection.getDescriptor().getDatabaseType().isOracle()) {
                    return res;
                }
                res = true;
                DatabaseConnection conn = table.scheme.connection;
                StringBuilder sql = new StringBuilder("SELECT SDO_LB, SDO_UB, SDO_TOLERANCE");
                sql.append(" FROM TABLE(SELECT DIMINFO");
                sql.append(" FROM USER_SDO_GEOM_METADATA WHERE TABLE_NAME='");
                sql.append(Strings.unquote(table.name())).append("' AND COLUMN_NAME='");
                Iterator<FieldDescriptor> iterator = ni.getFields().iterator();
                if (iterator.hasNext()) {
                    FieldDescriptor fd = iterator.next();
                    sql.append(fd.getRawName()).append("')");
                }
                try (PreparedStatement stmt = conn.prepareStatement(sql.toString());
                     ResultSet rs = stmt.executeQuery(ssContext);){
                    if (rs == null) break block15;
                    int DimsCount = 0;
                    while (rs.next()) {
                        if (++DimsCount == 1) {
                            if (rs.getDouble(1) == ni.getDim1Min() && !rs.wasNull() && rs.getDouble(2) == ni.getDim1Max() && !rs.wasNull() && rs.getDouble(3) == ni.getDimTolerance()) {
                                if (!rs.wasNull()) continue;
                            }
                        } else {
                            if (DimsCount == 2) {
                                if (rs.getDouble(1) != ni.getDim2Min() || rs.wasNull() || rs.getDouble(2) != ni.getDim2Max() || rs.wasNull() || rs.getDouble(3) != ni.getDimTolerance() || rs.wasNull()) continue;
                                res = false;
                                continue;
                            }
                            res = true;
                        }
                        break;
                    }
                }
            }
        }
        return res;
    }

    private static boolean CreateNewSRID(SSContext ssContext, Statement statement, DbTable table, IndexDescriptor ni) throws SQLException {
        boolean res = false;
        if (Restructure.IndexNeedNewSRID(ssContext, table, ni)) {
            StringBuilder sql = new StringBuilder("DELETE FROM USER_SDO_GEOM_METADATA WHERE TABLE_NAME='");
            sql.append(Strings.unquote(table.name())).append("' AND COLUMN_NAME='");
            Iterator<FieldDescriptor> iterator = ni.getFields().iterator();
            if (iterator.hasNext()) {
                FieldDescriptor fd = iterator.next();
                sql.append(fd.getRawName()).append("'");
            }
            statement.execute(ssContext, sql.toString());
            StringBuilder sql1 = new StringBuilder("INSERT INTO USER_SDO_GEOM_METADATA");
            sql1.append(" (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID) VALUES ('");
            sql1.append(Strings.unquote(table.name())).append("', '");
            Iterator<FieldDescriptor> iterator2 = ni.getFields().iterator();
            if (iterator2.hasNext()) {
                FieldDescriptor fd = iterator2.next();
                sql1.append(fd.getRawName());
                sql1.append("', SDO_DIM_ARRAY(SDO_DIM_ELEMENT('X', ");
                sql1.append(ni.getDim1Min()).append(", ").append(ni.getDim1Max()).append(", ").append(ni.getDimTolerance());
                sql1.append("), SDO_DIM_ELEMENT('Y', ");
                sql1.append(ni.getDim2Min()).append(", ").append(ni.getDim2Max()).append(", ").append(ni.getDimTolerance());
                sql1.append(")), NULL)");
            }
            statement.execute(ssContext, sql1.toString());
            res = true;
        }
        return res;
    }

    public static boolean isTableExists(SSContext ssContext, DbScheme scheme, TableDescriptor descriptor) throws SQLException {
        if (descriptor.urawnamed()) {
            return false;
        }
        DbTable table = scheme.getTable(ssContext, descriptor.getRawName());
        return table != null;
    }

    public static boolean tryDropAllIndices(SSContext ssContext, DbScheme scheme, Statement statement, TableDescriptor descriptor, Logger logger) throws SQLException {
        DbTable table;
        if (!Restructure.canRestructure(descriptor, logger)) {
            return false;
        }
        DbTable dbTable = table = descriptor.urawnamed() ? null : scheme.getTable(ssContext, descriptor.getRawName());
        if (table == null) {
            return false;
        }
        for (IndexDescriptor index : descriptor.getIndexes()) {
            DbIndex idx = table.getIndex(ssContext, index.getRawName());
            if (idx == null) continue;
            idx.drop(ssContext, statement);
            logger.log(descriptor, "\u0423\u0434\u0430\u043b\u0435\u043d \u0438\u043d\u0434\u0435\u043a\u0441: %s", idx.name());
        }
        return true;
    }

    public static void updateTable(SSContext ssContext, DbScheme scheme, Statement statement, TableDescriptor ntd, TableDescriptor otd, Logger logger, Strategy strategy) throws InformException, SQLException {
        IntegerSet droppedIndices = Restructure.updateStructure(ssContext, scheme, statement, ntd, otd, logger, strategy, Progress.NULL);
        if (droppedIndices != null) {
            Restructure.restructureIndices(ssContext, scheme, statement, ntd, otd, logger, strategy, droppedIndices, Progress.NULL);
        }
    }

    public static void upcreateTable(SSContext ssContext, DbScheme scheme, Statement statement, TableDescriptor descriptor, Logger logger, boolean manual) throws SQLException, InformException {
        logger.info("\"\u041c\u044f\u0433\u043a\u043e\u0435\" \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + descriptor.getRawName() + ":");
        DbTable table = scheme.getTable(ssContext, descriptor.getRawName());
        if (table == null) {
            table = Restructure.createTable(ssContext, scheme, statement, descriptor, logger);
            for (IndexDescriptor id : descriptor.getIndexes()) {
                DbIndex di = table.createIndex(ssContext, statement, id);
                logger.log(descriptor, "\u0421\u043e\u0437\u0434\u0430\u043d \u0438\u043d\u0434\u0435\u043a\u0441: %s", di.name());
            }
            return;
        }
        int ccc = 0;
        for (FieldDescriptor fd : descriptor.getFields()) {
            if (table.getColumn(ssContext, fd.getRawName()) != null) continue;
            DbColumn dc = table.createColumn(ssContext, statement, fd.getRawName(), fd.getType(), fd.getBlobRawType(), fd.getSize(), fd.isNullable(), fd);
            ++ccc;
            logger.log(descriptor, "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446: %s", dc.name());
        }
        if (manual || ccc > 0) {
            try {
                for (IndexDescriptor id : descriptor.getIndexes()) {
                    DbIndex di;
                    DbIndex idx = table.getIndex(ssContext, id.getRawName());
                    if (idx == null) {
                        di = table.createIndex(ssContext, statement, id);
                        logger.log(descriptor, "\u0421\u043e\u0437\u0434\u0430\u043d \u0438\u043d\u0434\u0435\u043a\u0441: %s", di.name());
                        continue;
                    }
                    if (idx.equals(id)) continue;
                    logger.log(descriptor, "! \u0418\u043d\u0434\u0435\u043a\u0441 \u0432 \u0411\u0414 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u043c: %s", idx.name());
                    idx.drop(ssContext, statement);
                    di = table.createIndex(ssContext, statement, id);
                    logger.log(descriptor, "\u041f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d \u0438\u043d\u0434\u0435\u043a\u0441: %s", di.name());
                }
            }
            catch (SQLException e) {
                logger.log(descriptor, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0438\u043d\u0434\u0435\u043a\u0441\u0430 %s", e);
                if (manual) {
                    throw e;
                }
                Core.logger.error("Can`t create indices", e);
            }
        } else {
            logger.info("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u0432 \u043f\u0440\u043e\u0438\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043e, \u0442.\u043a. \u043d\u0435 \u0431\u044b\u043b\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0441\u0442\u043e\u043b\u0431\u0446\u0430");
        }
    }

    private static DbTable createTable(SSContext ssContext, DbScheme scheme, Statement statement, TableDescriptor table, Logger logger) throws InformException, SQLException {
        DbTable result = scheme.createTable(ssContext, statement, table, logger);
        return result;
    }

    private static void copyTableData(SSContext ssContext, Statement statement, TableDescriptor dFrom, TableDescriptor dTo, DbTable from, DbTable to) throws SQLException {
        ArrayList<String> fromNames = new ArrayList<String>();
        ArrayList<String> toNames = new ArrayList<String>();
        for (DbColumn c : to.getColumns(ssContext).values()) {
            DbColumn fc;
            FieldDescriptor ffd;
            FieldDescriptor fd = dTo.getField(c.name());
            if (fd == null || fd.isVirtual() || (ffd = dFrom.getFieldDescriptor(fd.getId())) == null || ffd.isVirtual() || (fc = from.getColumn(ssContext, ffd.getRawName())) == null) continue;
            fromNames.add(fc.name());
            toNames.add(c.name());
        }
        StringBuilder sql = new StringBuilder("INSERT INTO ");
        sql.append(to.fullName()).append(" (");
        Collections.join(toNames, ',', sql);
        sql.append(") SELECT ");
        Collections.join(fromNames, ',', sql);
        sql.append(" FROM ").append(from.fullName());
        statement.execute(ssContext, sql.toString());
    }

    private static void dropIndicesIfNeed(SSContext ssContext, Statement statement, int fieldId, TableDescriptor descriptor, DbTable table, IntegerSet droppedIndices, Logger logger) throws SQLException {
        HashSet<IndexDescriptor> delete = null;
        block0: for (IndexDescriptor index : descriptor.getIndexes()) {
            for (FieldDescriptor field : index.getFields()) {
                if (field.getId() != fieldId) continue;
                if (droppedIndices.contains(index.getId())) continue block0;
                if (delete == null) {
                    delete = new HashSet<IndexDescriptor>();
                }
                delete.add(index);
                continue block0;
            }
        }
        if (delete == null || delete.isEmpty()) {
            return;
        }
        for (IndexDescriptor index : delete) {
            DbIndex idx = table.getIndex(ssContext, index.getRawName());
            if (idx != null) {
                idx.drop(ssContext, statement);
                logger.log(descriptor, "\u0443\u0434\u0430\u043b\u0435\u043d \u0438\u043d\u0434\u0435\u043a\u0441: %s", idx.name());
            }
            droppedIndices.add(index.getId());
        }
    }

    private static void restructureColumns(SSContext ssContext, Statement statement, TableDescriptor told, TableDescriptor tnew, DbTable table, Logger logger, Strategy strategy, IntegerSet droppedIndices, Progress progress) throws SQLException {
        DbColumn co;
        for (FieldDescriptor fieldDescriptor : told.getFields()) {
            FieldDescriptor rn;
            DbColumn c;
            boolean rawNameChanged;
            FieldDescriptor fdn;
            if (fieldDescriptor.isVirtual() || (fdn = tnew.getFieldDescriptor(fieldDescriptor.getId())) != null && (!(rawNameChanged = !table.scheme().isNamesEquals(fdn.getRawName(), fieldDescriptor.getRawName())) || told.getField(fdn.getRawName()) == null) || (c = table.getColumn(ssContext, fieldDescriptor.getRawName())) == null || (rn = tnew.getField(fieldDescriptor.getRawName())) != null) continue;
            progress.progress("\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u043e\u043b\u0431\u0446\u0430", fieldDescriptor.getCaption());
            c.drop(ssContext, statement);
            logger.log(told, "\u0443\u0434\u0430\u043b\u0435\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446 %s", c.name());
        }
        for (FieldDescriptor fieldDescriptor : tnew.getFields()) {
            DbColumn cn;
            boolean rawNameChanged;
            FieldDescriptor fdo;
            if (fieldDescriptor.isVirtual() || (fdo = told.getFieldDescriptor(fieldDescriptor.getId())) != null && !fdo.isVirtual() && (!(rawNameChanged = !table.scheme().isNamesEquals(fieldDescriptor.getRawName(), fdo.getRawName())) || (cn = table.getColumn(ssContext, fieldDescriptor.getRawName())) != null || told.getField(fieldDescriptor.getRawName()) == null && (co = table.getColumn(ssContext, fdo.getRawName())) != null)) continue;
            DbColumn c = table.getColumn(ssContext, fieldDescriptor.getRawName());
            if (c != null) {
                if (c.canHold(fieldDescriptor)) continue;
                StringBuilder msg = new StringBuilder();
                msg.append("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443.\n").append("\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0441\u0442\u043e\u043b\u0431\u0435\u0446 ").append(fieldDescriptor.getCaption()).append(" \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(tnew.toString()).append(" \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u043d\u043e\u0432\u044b\u043c.");
                StringBuilder detail = new StringBuilder();
                detail.append("\u041f\u043e\u043b\u0435: ").append(fieldDescriptor.getCaption()).append(", id : ").append(fieldDescriptor.getId()).append(", name: ").append(fieldDescriptor.getIdent()).append(", rawName: ").append(fieldDescriptor.getRawName()).append(", \u0442\u0438\u043f: ").append(fieldDescriptor.getType().toString());
                switch (fieldDescriptor.getType()) {
                    case STRING: 
                    case UNICODE: {
                        detail.append('(').append(fieldDescriptor.getSize()).append(')');
                    }
                }
                detail.append(", \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0432\u0432\u043e\u0434\u0430: ").append(fieldDescriptor.isNullable() ? "\u043d\u0435\u0442" : "\u0434\u0430").append(", \u0442\u0438\u043f \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u043b\u044f \u0432 \u0441\u0443\u0431\u0434: ").append(c.getType().toString());
                switch (c.getType()) {
                    case STRING: 
                    case UNICODE: {
                        detail.append('(').append(c.getSize()).append(')');
                    }
                }
                detail.append(", \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0432\u0432\u043e\u0434\u0430 \u0432 \u0441\u0443\u0431\u0434: ").append(c.isNullable() ? "\u043d\u0435\u0442" : "\u0434\u0430");
                throw new InformException(msg.toString()).detail(detail.toString());
            }
            progress.progress("\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0442\u043e\u043b\u0431\u0446\u0430", fieldDescriptor.getCaption());
            TableDescriptor foreignKeyDir = fieldDescriptor.foreignKeyDir();
            c = table.createColumn(ssContext, statement, fieldDescriptor.getRawName(), fieldDescriptor.getType(), fieldDescriptor.getBlobRawType(), fieldDescriptor.getSize(), fieldDescriptor.isNullable(), fieldDescriptor);
            Object colInfo = c.getSqlType();
            if (!fieldDescriptor.isNullable()) {
                colInfo = (String)colInfo + " NOT NULL";
            }
            if (foreignKeyDir != null) {
                colInfo = (String)colInfo + " FOREIGN KEY REFERENCE " + foreignKeyDir.getRawName();
            }
            logger.log(tnew, "\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446 %s %s", c.name(), colInfo);
        }
        HashMap<FieldDescriptor, DbColumn> copyMap = new HashMap<FieldDescriptor, DbColumn>();
        for (FieldDescriptor fdn : tnew.getFields()) {
            DbColumn cn;
            FieldDescriptor fdo;
            if (fdn.isVirtual() || (fdo = told.getFieldDescriptor(fdn.getId())) == null || fdo.isVirtual()) continue;
            boolean needRename = !table.scheme().isNamesEquals(fdo.getRawName(), fdn.getRawName());
            co = table.getColumn(ssContext, fdo.getRawName());
            if (needRename) {
                FieldDescriptor orn = told.getField(fdn.getRawName());
                if (orn != null) {
                    DbColumn dbColumn = table.getColumn(ssContext, fdn.getRawName());
                    if (dbColumn != null) {
                        needRename = false;
                        co = dbColumn;
                    }
                } else {
                    FieldDescriptor fieldDescriptor = tnew.getField(fdo.getRawName());
                    if (fieldDescriptor != null) {
                        needRename = false;
                        co = table.getColumn(ssContext, fdn.getRawName());
                    }
                }
            }
            if (needRename && (cn = table.getColumn(ssContext, fdn.getRawName())) != null) {
                if (co != null && co != cn) {
                    throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u043c\u044f \u0441\u0442\u043e\u043b\u0431\u0446\u0430 " + co.name()).detail(String.format("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 [%s] \u0441\u0442\u043e\u043b\u0431\u0435\u0446 [%s] \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", table.name(), fdn.getRawName()));
                }
                if (co == null) {
                    if (cn.canHold(fdn)) continue;
                    throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u044b").detail(String.format("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 [%s] \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0442\u043e\u043b\u0431\u0435\u0446 [%s] \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0433\u043e \u0442\u0438\u043f\u0430", table.name(), fdn.getRawName()));
                }
            }
            if (co != null) {
                boolean droppedFK = true;
                try {
                    if (co.isForeignKey()) {
                        boolean bl = droppedFK = !Strings.equals(co.getForeignKeyRefs(), fdn.foreignKeyRefs());
                        if (!(droppedFK || Strings.isVoid(fdn.foreignKeyRawName()) || table.scheme().isNamesEquals(co.getForeignKeyName(), fdn.foreignKeyRawName()))) {
                            droppedFK = true;
                        }
                        if (droppedFK) {
                            String string = co.getForeignKeyRefs();
                            co.dropForeignKey(ssContext, statement);
                            if (string != null) {
                                logger.log(told, "\u0438\u0437\u043c\u0435\u043d\u0435\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446 %s DROP FOREIGN KEY REFERENCE %s", co.name(), string);
                            }
                        }
                    }
                    if (needRename) {
                        String string = co.name();
                        progress.progress("\u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u043e\u043b\u0431\u0446\u0430", fdn.getCaption());
                        co.rename(ssContext, statement, fdn.getRawName());
                        logger.log(told, "\u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446: %s -> %s", string, co.name());
                    }
                    try {
                        if (!co.compatibleTo(fdn)) {
                            Restructure.dropIndicesIfNeed(ssContext, statement, fdo.getId(), told, table, droppedIndices, logger);
                            progress.progress("\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 \u0441\u0442\u043e\u043b\u0431\u0446\u0430", fdn.getCaption());
                            String string = co.scheme().ct2sql(fdo);
                            co.setType(ssContext, statement, fdn.getType(), fdn.getBlobRawType(), fdn.getSize(), fdn.isNullable(), fdn.isRecordIdPresentation(), fdn);
                            String newType = co.getSqlType();
                            logger.log(told, "\u0438\u0437\u043c\u0435\u043d\u0451\u043d \u0442\u0438\u043f \u0441\u0442\u043e\u043b\u0431\u0446\u0430 %s %s -> %s", co.name(), string, newType);
                        }
                    }
                    catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                        statement.connection().restoreTransactionAfterException(false);
                        Core.logger.warn("Failed to change column type", sQLFeatureNotSupportedException);
                        if (co != null && co.isCannotConvertType(fdn)) {
                            StringBuilder msg = new StringBuilder();
                            msg.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b. ").append("\u041f\u043e\u043b\u0435 ").append(fdn.getCaption()).append(" \u0442\u0430\u0431\u043b\u0438\u0446\u044b ").append(tnew.toString()).append(" \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u043a \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u043e\u043c\u0443 \u0442\u0438\u043f\u0443.");
                            StringBuilder detail = new StringBuilder();
                            detail.append("\u041f\u043e\u043b\u0435: ").append(fdn.getCaption()).append(", id : ").append(fdn.getId()).append(", name: ").append(fdn.getIdent()).append(", rawName: ").append(fdn.getRawName()).append(", \u0442\u0438\u043f: ").append(fdn.getType().toString()).append(", \u0442\u0438\u043f \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u043b\u044f \u0432 \u0441\u0443\u0431\u0434: ").append(co.getType().toString());
                            throw new InformException(msg.toString(), sQLFeatureNotSupportedException).detail(detail.toString());
                        }
                        copyMap.put(fdn, co);
                        progress.needRestart = true;
                        statement.connection().setAutoCommit();
                    }
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                    statement.connection().restoreTransactionAfterException(false);
                    Core.logger.warn("Failed to change column", sQLFeatureNotSupportedException);
                    copyMap.put(fdn, co);
                    progress.needRestart = true;
                    statement.connection().setAutoCommit();
                }
                if (!fdn.isForeignKey() || !droppedFK) continue;
                TableDescriptor tableDescriptor = fdn.foreignKeyDir();
                table.addForeignKey(ssContext, statement, fdn.getRawName(), fdn);
                if (tableDescriptor == null) continue;
                logger.log(told, "\u0438\u0437\u043c\u0435\u043d\u0435\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446 %s ADD FOREIGN KEY REFERENCE %s", co.name(), tableDescriptor.getRawName());
                continue;
            }
            progress.progress("\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0442\u043e\u043b\u0431\u0446\u0430", fdn.getCaption());
            TableDescriptor foreignKeyDir = fdn.foreignKeyDir();
            DbColumn dbColumn = table.createColumn(ssContext, statement, fdn.getRawName(), fdn.getType(), fdn.getBlobRawType(), fdn.getSize(), fdn.isNullable(), fdn);
            Object colInfo = dbColumn.getSqlType();
            if (!fdn.isNullable()) {
                colInfo = (String)colInfo + " NOT NULL";
            }
            if (foreignKeyDir != null) {
                colInfo = (String)colInfo + " FOREIGN KEY REFERENCE " + foreignKeyDir.getRawName();
            }
            logger.log(tnew, "\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446: %s %s", dbColumn.name(), colInfo);
        }
        if (!copyMap.isEmpty()) {
            FieldDescriptor fd;
            String string = "_TMP" + (int)(Math.random() * 65535.0);
            StringBuilder sql1 = new StringBuilder("UPDATE ");
            sql1.append(table.fullName()).append(" SET");
            StringBuilder sql2 = new StringBuilder(sql1.toString());
            HashMap<FieldDescriptor, DbColumn> tmp = new HashMap<FieldDescriptor, DbColumn>();
            char comma = ' ';
            progress.progress("\u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044e \u0434\u0430\u043d\u043d\u044b\u0445");
            for (Map.Entry entry : copyMap.entrySet()) {
                fd = (FieldDescriptor)entry.getKey();
                boolean needRename = !fd.getRawName().equalsIgnoreCase(((DbColumn)entry.getValue()).name());
                String name = needRename ? fd.getRawName() : fd.getRawName() + string;
                DbColumn c = table.createColumn(ssContext, statement, name, fd.getType(), fd.getBlobRawType(), fd.getSize(), true, fd);
                sql1.append(comma).append(c.name()).append('=');
                ((DbColumn)entry.getValue()).appendConvertTo(c, sql1);
                if (!needRename) {
                    sql2.append(comma).append(((FieldDescriptor)entry.getKey()).getRawName()).append('=').append(c.name());
                    tmp.put(fd, c);
                }
                comma = ',';
            }
            try {
                progress.progress("\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445");
                statement.execute(ssContext, sql1.toString());
            }
            catch (SQLException e) {
                try {
                    try {
                        logger.log(told, "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0441\u0442\u043e\u043b\u0431\u0446\u043e\u0432 \n%s", e.toString());
                    }
                    catch (Throwable throwable) {
                        Core.logger.error(null, throwable);
                    }
                    Core.logger.warn("Restore transaction (rollback)");
                    statement.connection().restoreTransactionAfterException(false);
                    for (DbColumn c : tmp.values()) {
                        c.dropForeignKey(ssContext, statement);
                        c.drop(ssContext, statement);
                    }
                }
                catch (Throwable throwable) {
                    Core.logger.error(null, throwable);
                }
                throw e;
            }
            for (DbColumn dbColumn : copyMap.values()) {
                dbColumn.dropForeignKey(ssContext, statement);
                dbColumn.drop(ssContext, statement);
            }
            if (!tmp.isEmpty()) {
                for (Map.Entry entry : tmp.entrySet()) {
                    fd = (FieldDescriptor)entry.getKey();
                    DbColumn c = (DbColumn)entry.getValue();
                    if (!fd.isNullable()) {
                        c.setType(ssContext, statement, fd.getType(), fd.getBlobRawType(), fd.getSize(), fd.isNullable(), fd.isRecordIdPresentation(), fd);
                    }
                    DbColumn old = table.getColumn(ssContext, fd.getRawName());
                    String oldType = null;
                    String oldNullable = null;
                    String oldFK = null;
                    if (old != null) {
                        oldType = old.getSqlType();
                        oldNullable = old.isNullable() ? "NULLABLE" : "NOT NULL";
                        oldFK = old.getForeignKeyRefs();
                        old.dropForeignKey(ssContext, statement);
                        old.drop(ssContext, statement);
                    }
                    c.rename(ssContext, statement, fd.getRawName());
                    String newType = c.getSqlType();
                    String newNullable = c.isNullable() ? "NULLABLE" : "NOT NULL";
                    String newFK = c.getForeignKeyRefs();
                    Object colInfo = c.name();
                    if (old == null) {
                        colInfo = (String)colInfo + " " + newType;
                        if (!c.isNullable()) {
                            colInfo = (String)colInfo + " NOT NULL";
                        }
                        if (newFK != null) {
                            colInfo = (String)colInfo + " FOREIGN KEY REFERENCE " + newFK;
                        }
                    } else {
                        if (!Strings.equals(newType, oldType)) {
                            colInfo = (String)colInfo + " " + oldType + " -> " + newType;
                        }
                        if (!Strings.equals(oldNullable, newNullable)) {
                            colInfo = (String)colInfo + " " + oldNullable + " -> " + newNullable;
                        }
                        if (!Strings.equals(oldFK, newFK)) {
                            colInfo = oldFK == null ? (String)colInfo + " ADD FOREIGN KEY REFERENCE " + newFK : (newFK == null ? (String)colInfo + " ADD FOREIGN KEY REFERENCE " + oldFK : (String)colInfo + " FOREIGN KEY REFERENCE " + oldFK + " FOREIGN KEY REFERENCE " + newFK);
                        }
                    }
                    logger.log(tnew, "\u043f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u043d \u0441\u0442\u043e\u043b\u0431\u0435\u0446 %s", colInfo);
                }
            }
        }
    }

    public static boolean isRestructurable(TableDescriptor table) throws InformException {
        if (table.getKind() == TableDescriptor.Kind.VIRTUAL) {
            return false;
        }
        if (table.getKind() == TableDescriptor.Kind.EXTERNAL && !table.isExternalStructureManaged()) {
            return false;
        }
        if (table.urawnamed()) {
            return false;
        }
        DatabaseDescriptor databaseDescriptor = table.getDbDescIfExists();
        return databaseDescriptor != null && !databaseDescriptor.isExternal();
    }

    private static boolean canRestructure(TableDescriptor table, Logger cause) throws InformException {
        if (table.getKind() == TableDescriptor.Kind.VIRTUAL) {
            return false;
        }
        DatabaseDescriptor db = table.getDatabaseDescriptor();
        if (db.isExternal()) {
            return false;
        }
        Restructure.checkTablePreconditions(table);
        if (table.getKind() == TableDescriptor.Kind.EXTERNAL && !table.isExternalStructureManaged()) {
            cause.info("\u0442\u0430\u0431\u043b\u0438\u0446\u0430 \u043d\u0435 \u043f\u043e\u0434\u043b\u0435\u0436\u0438\u0442 \u0440\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0438\u0440\u0438\u0437\u0430\u0446\u0438\u0438");
            return false;
        }
        return true;
    }

    private static void checkTablePreconditions(TableDescriptor td) throws InformException {
        boolean internal;
        if (td.urawnamed()) {
            throw new InformException(String.format("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 [ID:%.0f] \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0438\u043c\u0435\u043d\u0438", td.getNodeId()));
        }
        String rawName = td.getRawName();
        if (td.getDbId() == 0.0) {
            throw new InformException(String.format("\u0423 \u0442\u0430\u0431\u043b\u0438\u0446\u044b [%s] \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0431\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445", rawName));
        }
        boolean bl = internal = td.getKind() == TableDescriptor.Kind.INTERNAL;
        if (!Restructure.checkQuotes(rawName)) {
            throw new InformException(String.format("\u041d\u0435\u043f\u0430\u0440\u043d\u044b\u0435 \u043a\u0430\u0432\u044b\u0447\u043a\u0438 \u0432 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u0438\u043c\u0435\u043d\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044b. \u0418\u043c\u044f \u043d\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442 [%s]", rawName));
        }
        if (internal && !Restructure.checkIdentificator(rawName)) {
            throw new InformException(String.format("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0434\u043e\u043b\u0436\u043d\u043e \u043d\u0430\u0447\u0438\u043d\u0430\u0442\u044c\u0441\u044f \u0441 \u0431\u0443\u043a\u0432\u044b. \u0418\u043c\u044f \u043d\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442 [%s]", rawName));
        }
        for (FieldDescriptor f : td.getFields()) {
            if (rawName == null || rawName.isEmpty()) {
                throw new InformException(String.format("\u041f\u043e\u043b\u0435 [ID:%d] \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0438\u043c\u0435\u043d\u0438", f.getId()));
            }
            String fieldRawName = f.getRawName();
            if (!Restructure.checkQuotes(fieldRawName)) {
                throw new InformException(String.format("\u041d\u0435\u043f\u0430\u0440\u043d\u044b\u0435 \u043a\u0430\u0432\u044b\u0447\u043a\u0438 \u0432 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u0438\u043c\u0435\u043d\u0438 \u043f\u043e\u043b\u044f. \u0418\u043c\u044f \u043d\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442 [%s]", rawName));
            }
            if (!internal || Restructure.checkIdentificator(fieldRawName)) continue;
            throw new InformException(String.format("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u043e \u043d\u0430\u0447\u0438\u043d\u0430\u0442\u044c\u0441\u044f \u0441 \u0431\u0443\u043a\u0432\u044b. \u0418\u043c\u044f \u043d\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442 [%s]", rawName));
        }
    }

    private static boolean checkQuotes(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.charAt(0) == '\"') {
            return name.charAt(name.length() - 1) == '\"';
        }
        return true;
    }

    private static boolean checkIdentificator(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        char first = name.charAt(0);
        return first == '\"' || Character.isLetter(first);
    }

    public static abstract class Progress {
        public static final Progress NULL = new Progress(){

            @Override
            public void progress(String msg) {
            }
        };
        public boolean needRestart = false;

        public abstract void progress(String var1);

        public void progress(String msg, String arg) {
            this.progress(msg + ": " + arg);
        }

        public static class FromSSHost
        extends Progress {
            private final ServerSideHost ssHost;

            public FromSSHost(ServerSideHost ssHost) {
                this.ssHost = ssHost;
            }

            @Override
            public void progress(String msg) {
                try {
                    this.ssHost.putRequestStateText(msg);
                }
                catch (Exception e) {
                    throw InformException.wrap(e);
                }
            }
        }
    }

    public static class RealLogger
    extends Logger {
        @Override
        public boolean dummy() {
            return false;
        }
    }

    public static abstract class Logger {
        public abstract boolean dummy();

        public void info(String line) {
        }

        public void log(TableDescriptor context, String line) {
            if (context != null) {
                Core.logger.ddl("{}:{}", (Object)context.toString(), (Object)line);
            } else {
                Core.logger.ddl(line);
            }
        }

        public void log(TableDescriptor context, String fmt, Object ... args) {
            if (!this.dummy()) {
                this.log(context, String.format(fmt, args));
            }
        }
    }

    public static enum Strategy {
        UPDATE,
        RECREATE;

    }
}

