/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql;

import inform.agent.db.sql.ISqlBuilderState;

public class QueryTokenizer
implements ISqlBuilderState {
    public Token token = null;
    public String value = null;
    private final String text;
    private Token prevToken;
    private String prevValue;
    private int pos = 0;
    private int count = 0;
    private int prevPos = 0;
    private int prevCount = 0;
    private int x;
    private int y;
    private int nextX;
    private int nextY;
    private int prevX;
    private int prevY;
    private final byte[] ctype = new byte[256];
    private static final byte SKIP = 1;
    private static final byte DIGIT = 2;
    private static final byte WORD = 3;
    private static final byte NUMBER = 8;
    private static final byte NEWLINE = 16;
    private static final byte SYMBOL = 32;

    public QueryTokenizer(String text) {
        this.text = text;
        this.charTypes(97, 122, 3);
        this.charTypes(65, 90, 3);
        this.charTypes(160, 255, 3);
        for (int i = 48; i <= 57; ++i) {
            this.ctype[i] = 11;
        }
        this.ctype[35] = 3;
        this.ctype[95] = 3;
        this.ctype[36] = 3;
        this.ctype[46] = 3;
        this.ctype[42] = 3;
        this.ctype[45] = 2;
        this.ctype[43] = 2;
        this.ctype[69] = (byte)(this.ctype[69] | 2);
        this.ctype[101] = (byte)(this.ctype[101] | 2);
        this.ctype[10] = 16;
        this.nextY = 1;
        this.y = 1;
        this.prevY = 1;
        this.nextX = 1;
        this.x = 1;
        this.prevX = 1;
    }

    public Token nextToken() {
        if (this.text == null) {
            return Token.Eof;
        }
        this.prevX = this.x;
        this.prevY = this.y;
        this.x = this.nextX++;
        this.y = this.nextY++;
        this.prevPos = this.pos;
        this.prevCount = this.count;
        this.prevToken = this.token;
        this.prevValue = this.value;
        this.pos += this.count;
        this.count = 0;
        this.value = null;
        this.skip();
        switch (this.token) {
            case Eof: {
                break;
            }
            case Line: {
                this.count = 1;
                this.nextX = 1;
                this.value = "\n";
                break;
            }
            case Number: {
                this.readValue(2);
                this.nextX += this.count;
                break;
            }
            case Word: {
                this.readValue(3);
                this.nextX += this.count;
                break;
            }
            case SingleQuotedString: {
                this.readSingleQuoted();
                break;
            }
            case DoubleQuotedString: {
                this.readDoubleQuoted();
                break;
            }
            case Symbol: {
                if (this.isCurrent('-', '-')) {
                    this.readValueEndLine();
                    this.token = Token.MinisMinusComment;
                    this.nextX += this.count;
                    break;
                }
                if (this.isCurrent('/', '/')) {
                    this.readValueEndLine();
                    this.token = Token.SplashSplashComment;
                    this.nextX += this.count;
                    break;
                }
                if (this.isCurrent('/', '*')) {
                    this.readSplashStarComment();
                    this.token = Token.SplashStarComment;
                    break;
                }
                this.value = this.text.substring(this.pos, this.pos + 1);
                this.count = 1;
            }
        }
        return this.token;
    }

    public void backward() {
        this.pos = this.prevPos;
        this.count = this.prevCount;
        this.token = this.prevToken;
        this.value = this.prevValue;
        this.nextX = this.x;
        this.nextY = this.y;
        this.x = this.prevX;
        this.y = this.prevY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public String getCurrentState() {
        return String.format("\u0441\u0442\u0440\u043e\u043a\u0430: %d, \u043f\u043e\u0437\u0438\u0446\u0438\u044f: %d", this.y, this.x);
    }

    public static String formatInsensitiveText(String text) {
        StringBuilder result = new StringBuilder(2 * text.length());
        QueryTokenizer parser = new QueryTokenizer(text);
        parser.ctype[42] = 32;
        parser.ctype[45] = 32;
        parser.ctype[43] = 32;
        boolean noneSpace = false;
        boolean needSpace = false;
        block6: while (parser.nextToken() != Token.Eof) {
            if (needSpace) {
                result.append(' ');
                needSpace = false;
            }
            Object value = null;
            switch (parser.token) {
                case Line: {
                    continue block6;
                }
                case Symbol: {
                    if (!" ".equals(parser.value)) break;
                    continue block6;
                }
                case Word: {
                    value = parser.value.toLowerCase();
                    break;
                }
                case SplashStarComment: {
                    value = "/*" + QueryTokenizer.formatInsensitiveText(parser.value.substring(2, parser.value.length() - 2)) + "*/";
                }
            }
            noneSpace = true;
            result.append((String)(value == null ? parser.value : value));
            needSpace = true;
        }
        text = result.toString();
        return text;
    }

    private boolean isCurrent(int index, char c1, char c2) {
        if (index < 0) {
            return false;
        }
        if (index >= this.text.length() - 1) {
            return false;
        }
        return this.text.charAt(index) == c1 && this.text.charAt(index + 1) == c2;
    }

    private boolean isCurrent(char c1, char c2) {
        return this.isCurrent(this.pos, c1, c2);
    }

    private void readValueEndLine() {
        int index;
        for (index = this.pos + 1; (this.charTypeAt(index) & 0x10) == 0 && index < this.text.length(); ++index) {
            char ch = this.text.charAt(index);
            if (this.isCurrent(index, '\'', '\'')) {
                ++index;
                continue;
            }
            if (ch != '\'') continue;
            ++index;
            break;
        }
        this.value = this.text.substring(this.pos, index);
        this.count = this.value.length();
    }

    private void readSplashStarComment() {
        int index = this.pos + 2;
        this.nextX += 2;
        while (index < this.text.length()) {
            char ch = this.text.charAt(index);
            if ((this.charType(ch) & 0x10) != 0) {
                ++this.nextY;
                this.nextX = 0;
            } else if (this.isCurrent(index, '*', '/')) {
                index += 2;
                this.nextX += 2;
                break;
            }
            ++index;
            ++this.nextX;
        }
        this.value = this.text.substring(this.pos, index);
        this.count = this.value.length();
    }

    private void readSingleQuoted() {
        int index = this.pos + 1;
        ++this.nextX;
        while (index < this.text.length()) {
            char ch = this.text.charAt(index);
            if ((this.charType(ch) & 0x10) != 0) {
                ++this.nextY;
                this.nextX = 0;
            } else if (this.isCurrent(index, '\'', '\'')) {
                ++this.nextX;
                ++index;
            } else if (ch == '\'') {
                ++this.nextX;
                ++index;
                break;
            }
            ++index;
            ++this.nextX;
        }
        this.value = this.text.substring(this.pos, index);
        this.count = this.value.length();
    }

    private void readDoubleQuoted() {
        int index = this.pos + 1;
        ++this.nextX;
        while (index < this.text.length()) {
            char ch = this.text.charAt(index);
            if ((this.charType(ch) & 0x10) != 0) {
                ++this.nextY;
                this.nextX = 0;
            } else if (this.isCurrent(index, '\"', '\"')) {
                ++this.nextX;
                ++index;
            } else if (ch == '\"') {
                ++this.nextX;
                ++index;
                break;
            }
            ++index;
            ++this.nextX;
        }
        this.value = this.text.substring(this.pos, index);
        this.count = this.value.length();
    }

    private void readValue(int ct) {
        int index;
        for (index = this.pos + 1; (this.charTypeAt(index) & ct) != 0 && index < this.text.length(); ++index) {
        }
        this.value = this.text.substring(this.pos, index);
        this.count = this.value.length();
    }

    private void skip() {
        Token t = this.determineToken();
        while (t == null && this.pos < this.text.length()) {
            ++this.pos;
            t = this.determineToken();
        }
        this.token = t == null ? Token.Eof : t;
    }

    private Token determineToken() {
        if (this.pos >= this.text.length()) {
            return Token.Eof;
        }
        char ch = this.text.charAt(this.pos);
        if (ch == '\"') {
            return Token.DoubleQuotedString;
        }
        if (ch == '\'') {
            return Token.SingleQuotedString;
        }
        if (ch < '\u0000' || ch > '\u00ff') {
            return Token.Word;
        }
        byte ct = this.ctype[ch];
        if ((ct & 8) != 0) {
            return Token.Number;
        }
        if ((ct & 3) != 0) {
            return Token.Word;
        }
        if ((ct & 0x10) != 0) {
            return Token.Line;
        }
        if ((ct & 1) != 0) {
            return null;
        }
        return Token.Symbol;
    }

    private int charTypeAt(int index) {
        if (index < 0 || index >= this.text.length()) {
            return 0;
        }
        return this.charType(this.text.charAt(index));
    }

    private int charType(char ch) {
        if (ch < '\u0000' || ch > '\u00ff') {
            return 3;
        }
        return this.ctype[ch];
    }

    private void charTypes(int low, int hi, int ct) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            int n = low++;
            this.ctype[n] = (byte)(this.ctype[n] | ct);
        }
    }

    public static enum Token {
        SplashSplashComment,
        SplashStarComment,
        MinisMinusComment,
        Number,
        DoubleQuotedString,
        SingleQuotedString,
        Word,
        Symbol,
        Line,
        Eof;

    }
}

