/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.Strings;
import inform.adt.collections.ArrayMap;
import inform.adt.collections.IntegerSet;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.AggregateFunction;
import inform.agent.db.sql.engine.Condition;
import inform.agent.db.sql.engine.DataEntry;
import inform.agent.db.sql.engine.DirectoryEntry;
import inform.agent.db.sql.engine.Engine;
import inform.agent.db.sql.engine.GenerateCondition;
import inform.agent.db.sql.engine.GenerateFieldExpression;
import inform.agent.db.sql.engine.NestedEntry;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.db.sql.engine.SearchField;
import inform.agent.db.sql.engine.SearchSorting;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.scripts.Parameter;
import java.io.IOException;
import java.util.ArrayList;

public class Generate {
    public static final int ORACLE_HINT_JOIN_TYPE_NL = 1;
    public static final int ORACLE_HINT_JOIN_TYPE_HASH = 2;
    public static final int ORACLE_HINT_JOIN_TYPE_MERGE = 3;
    public static final int SYSTEM_ENTRY_ID = -10;
    public static final int SYSTEM_ELEMENTS_ENTRY_ID = -1001;
    public static final int SYSTEM_LINKED_ENTRY_ID = -1002;
    public static final int SYSTEM_FIELD_LEVEL = 1;
    public static final int[] LINK_ENTRY_ID = new int[]{0, -1001, -1002, -1001, -1002};
    public static final int DATE_MOD_DAY = 1;
    public static final int DATE_MOD_MONTH = 2;
    public static final int DATE_MOD_YEAR = 3;
    public static final int DATE_MOD_M_Y = 4;
    public static final int DATE_MOD_D_M_Y = 5;
    public static final int DATE_MOD_Q_Y = 6;
    public static final int DATE_MOD_COUNT = 7;
    public static final int[] DATE_MOD_FUNCTION = new int[]{-1, 0, 1, 2, -1, 6, -1};
    public static final int STR_MOD_INSENSITIVE = 1;
    public static final int BOOL_MOD_DEFAULT = 0;
    public static final int BOOL_MOD_2DIGIT = 1;
    public static final int BOOL_MOD_3DIGIT = 2;
    public static final String ENTRIES_SOURCE = "\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043f\u043e\u0438\u0441\u043a\u0430 ";
    public static final String LINE_NO = "\u043d\u043e\u043c\u0435\u0440 \u0441\u0442\u0440\u043e\u043a\u0438 ";
    public static final String RECIRSIVE_FIELD_PREFIX = "R";
    public static final String HIERARCHIC_SORT_BASE = "1000000";

    static boolean isSqlDateModificator(int modificator) {
        return 0 <= modificator && modificator < DATE_MOD_FUNCTION.length && DATE_MOD_FUNCTION[modificator] >= 0;
    }

    static boolean isDateExtractModificator(int modificator) {
        switch (modificator) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    static void fieldModificatorPrefix(DatabaseCaps caps, DataType dataType, int modificator, StringBuilder sql) {
        switch (dataType) {
            case STRING: {
                if (modificator != 1) break;
                sql.append("upper(");
                break;
            }
            case DATE_TIME: {
                int function_type;
                int n = function_type = 0 <= modificator && modificator <= 7 ? DATE_MOD_FUNCTION[modificator] : -1;
                if (function_type < 0) break;
                sql.append(caps.function(function_type));
            }
        }
    }

    static void fieldModificatorSuffix(DatabaseCaps caps, DataType dataType, int modificator, StringBuilder sql) {
        switch (dataType) {
            case STRING: {
                if (modificator != 1) break;
                sql.append(')');
                break;
            }
            case DATE_TIME: {
                int function_type;
                int n = function_type = 0 <= modificator && modificator <= 7 ? DATE_MOD_FUNCTION[modificator] : -1;
                if (function_type < 0) break;
                sql.append(caps.functionSuffix(function_type));
            }
        }
    }

    static void fieldWithModificator(DatabaseCaps caps, SearchEntry entry, int fieldId, int modificator, StringBuilder sql, String source, String line, int lineNo) {
        FieldDescriptor field = entry.getValidFieldDescriptor(fieldId, source, line, lineNo);
        Generate.fieldModificatorPrefix(caps, field.getType(), modificator, sql);
        entry.generateFieldAlias(field, sql);
        Generate.fieldModificatorSuffix(caps, field.getType(), modificator, sql);
    }

    static void parameterValues(Search search, DatabaseCaps caps, Section section, DataType dataType, Parameter parameter) {
        int sep = 32;
        if (search.inlineParams()) {
            int count = parameter.getValueCount();
            for (int i = 0; i < count; ++i) {
                Object v = parameter.valueByIndex(i);
                section.sql.append((char)sep);
                String stringValue = "";
                if (v == null) {
                    stringValue = "null";
                } else {
                    switch (parameter.getDataType().toSqlDataType()) {
                        case BOOLEAN: {
                            stringValue = caps.c_bool2sql(ValueCaster.toBoolean(v));
                            break;
                        }
                        case INTEGER: {
                            stringValue = caps.c_number2sql(ValueCaster.toInt(v));
                            break;
                        }
                        case DOUBLE: {
                            stringValue = caps.c_float2sql(ValueCaster.toDouble(v));
                            break;
                        }
                        case STRING: 
                        case UNICODE: {
                            stringValue = caps.c_string2sql(ValueCaster.toString(v));
                            break;
                        }
                        case DATE_TIME: {
                            stringValue = caps.c_dateTime2sql(ValueCaster.toDouble(v));
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                }
                section.sql.append(stringValue);
                sep = 44;
            }
        } else {
            int count = parameter.getValueCount();
            block16: for (int i = 0; i < count; ++i) {
                Object v = parameter.valueByIndex(i);
                section.sql.append((char)sep).append('?');
                sep = 44;
                if (v == null) {
                    section.addNullParam(dataType);
                    continue;
                }
                switch (dataType) {
                    case INTEGER: {
                        section.addIntegerParam(ValueCaster.toInt(v));
                        continue block16;
                    }
                    case BOOLEAN: {
                        section.addBooleanParam(ValueCaster.toBoolean(v));
                        continue block16;
                    }
                    case PRIMARY_KEY: 
                    case FLOAT: 
                    case INTERVAL: 
                    case DIRECTORY: 
                    case METATREE_NODE: {
                        section.addDoubleParam(ValueCaster.toDouble(v));
                        continue block16;
                    }
                    case DATE_TIME: {
                        section.addDateTimeParam(ValueCaster.toDouble(v));
                        continue block16;
                    }
                    case STRING: 
                    case BIG_NUMBER: {
                        section.addStringParam(ValueCaster.toString(v));
                        continue block16;
                    }
                    case UNICODE: {
                        section.addUnicodeParam(ValueCaster.toString(v));
                        continue block16;
                    }
                    default: {
                        throw new Search.Exception(search, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430");
                    }
                }
            }
        }
    }

    static void systemField(Search search, Engine engine, int fieldId, Section section) {
        if (fieldId == 1) {
            if (engine.caps.isAnsiHierarchicSyntax()) {
                if (search.isHierarchicConditionSection()) {
                    if (!search.rootEntry.generateSystemFieldAlias(search, engine, fieldId, section)) {
                        section.sql.append('1');
                    }
                } else {
                    section.sql.append('1');
                }
            } else {
                section.sql.append("level");
            }
        } else {
            section.sql.append("__UNKNOWN_SYS_FIELD__");
        }
    }

    static void processStandardOrderByField(Search search, DatabaseCaps caps, OrderBy sqls, SearchSorting.Field sf, CharSequence orderField) {
        if (sqls.orderBy == null) {
            sqls.orderBy = new StringBuilder();
        } else {
            sqls.orderBy.append(',');
        }
        String suffix = "";
        if (search.nullSortKind != NullSortKind.Default) {
            if (caps.isNullSortSupport()) {
                NullSortKind nsk = search.nullSortKind;
                if (!sf.ascending) {
                    switch (nsk) {
                        case First: {
                            nsk = NullSortKind.Last;
                            break;
                        }
                        case Last: {
                            nsk = NullSortKind.First;
                        }
                    }
                }
                switch (nsk) {
                    case First: {
                        suffix = " nulls first ";
                        break;
                    }
                    case Last: {
                        suffix = " nulls last ";
                    }
                }
            } else {
                switch (search.nullSortKind) {
                    case First: {
                        sqls.orderBy.append("case when ").append(orderField).append(" is null").append(" then ").append('0').append(" else ").append('1').append(" end");
                        break;
                    }
                    case Last: {
                        sqls.orderBy.append("case when ").append(orderField).append(" is null").append(" then ").append('1').append(" else ").append('1').append(" end");
                    }
                }
                sqls.orderBy.append(sf.ascending ? " asc " : " desc ").append(',');
            }
        }
        sqls.orderBy.append(orderField).append(sf.ascending ? " asc " : " desc ").append(suffix);
    }

    static String generateStandardOrderByField(Search search, DatabaseCaps caps, OrderBy sqls, SearchSorting.Field sf, int index, boolean generated) {
        StringBuilder orderField;
        sf.entry.addUsage();
        FieldDescriptor field = sf.entry.getValidFieldDescriptor(sf.fieldId, "\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0435", "\u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438", index);
        if (field.hasPeriodicStorage() && sf.entry.excludePeriodicData()) {
            return null;
        }
        StringBuilder stringBuilder = orderField = sqls.processOrderBy ? new StringBuilder() : null;
        if (field.isRightPadded()) {
            if (sqls.fields == null) {
                sqls.fields = new StringBuilder();
            } else {
                sqls.fields.append(',');
            }
            StringBuilder fieldNameBuilder = new StringBuilder();
            sf.entry.generateFieldAlias(field, fieldNameBuilder);
            String fieldName = fieldNameBuilder.toString();
            caps.lpad(sqls.fields, fieldName, field.getSize());
            sqls.fields.append(" as ");
            sf.entry.generateTempField(field, sqls.fields);
            if (orderField != null) {
                sf.entry.generateTempField(field, orderField);
            }
            if (search.sortableFields != null) {
                search.sortableFields.add(field);
            }
        } else if (sf.entry.parentEntry != null) {
            if (generated) {
                if (orderField != null) {
                    sf.entry.generateFieldAlias(field, orderField);
                }
            } else {
                if (sqls.fields == null) {
                    sqls.fields = new StringBuilder();
                } else {
                    sqls.fields.append(',');
                }
                sf.entry.generateFieldAlias(field, sqls.fields);
                sqls.fields.append(" as ");
                sf.entry.generateTempField(field, sqls.fields);
                if (orderField != null) {
                    sf.entry.generateTempField(field, orderField);
                }
            }
        } else {
            if (field.getId() != -1) {
                if (sqls.fields == null) {
                    sqls.fields = new StringBuilder();
                } else {
                    sqls.fields.append(',');
                }
                sf.entry.generateFieldAlias(field, sqls.fields);
            }
            if (orderField != null) {
                sf.entry.generateFieldAlias(field, orderField);
            }
        }
        if (sf.entry.parentEntry == null && field.getId() != -1 && !generated) {
            if (sqls.fieldIds == null) {
                sqls.fieldIds = new IntegerSet();
            }
            sqls.fieldIds.add(field.getId());
        }
        if (sqls.processOrderBy) {
            Generate.processStandardOrderByField(search, caps, sqls, sf, orderField);
            return generated ? orderField.toString() : null;
        }
        return null;
    }

    static OrderBy generateStandardOrderBy(Search search, DatabaseCaps caps) {
        if (search.sorting == null || search.sorting.isEmpty()) {
            return null;
        }
        if (search.skipOrderBy() || search.excludeOrderBy()) {
            return null;
        }
        OrderBy sqls = new OrderBy();
        int index = 0;
        for (SearchSorting.Field sf : search.sorting.fields()) {
            Generate.generateStandardOrderByField(search, caps, sqls, sf, ++index, false);
        }
        if (sqls.orderBy != null) {
            return sqls;
        }
        return null;
    }

    static OrderBy generateStandardDataFilterOrderBy(Search search, DatabaseCaps caps) {
        if (search.sorting == null || search.sorting.isEmpty()) {
            return null;
        }
        if (search.skipOrderBy() || search.excludeOrderBy()) {
            return null;
        }
        OrderBy sqls = new OrderBy();
        int index = 0;
        for (SearchSorting.Field sf : search.sorting.fields()) {
            sf.entry.addUsage();
            FieldDescriptor field = sf.entry.getValidFieldDescriptor(sf.fieldId, "\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0435", "\u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438", ++index);
            ++search.dataFilterAliasNo;
            String alias = "TMPSRT" + search.dataFilterAliasNo;
            if (sqls.fields == null) {
                sqls.fields = new StringBuilder();
            } else {
                sqls.fields.append(", ");
            }
            if (field.isRightPadded()) {
                StringBuilder fieldNameBuilder = new StringBuilder();
                sf.entry.generateFieldAlias(field, fieldNameBuilder);
                String fieldName = fieldNameBuilder.toString();
                caps.lpad(sqls.fields, fieldName, field.getSize());
            } else {
                sf.entry.generateFieldAlias(field, sqls.fields);
            }
            sqls.fields.append(" as ").append(alias);
            if (search.dataFilterOrderBy == null) {
                search.dataFilterOrderBy = new StringBuilder();
            } else {
                search.dataFilterOrderBy.append(", ");
            }
            Generate.processStandardOrderByField(search, caps, sqls, sf, "filter." + alias);
        }
        if (sqls.orderBy != null) {
            search.dataFilterOrderBy = sqls.orderBy;
            sqls.orderBy = null;
            return sqls;
        }
        return null;
    }

    static StringBuilder generateAdvancedOrderBy(Search search, Engine engine, Section fields) {
        boolean processOrderBy;
        Search sortingSearch;
        if (search.isUnionItem() && search.parentSearch != null) {
            sortingSearch = search.parentSearch;
            processOrderBy = false;
        } else {
            sortingSearch = search;
            processOrderBy = true;
        }
        if (sortingSearch.sorting == null || sortingSearch.sorting.isEmpty()) {
            return null;
        }
        if (search.skipOrderBy() || search.excludeOrderBy()) {
            return null;
        }
        OrderBy sqls = new OrderBy();
        sqls.processOrderBy = processOrderBy;
        sqls.fields = fields.sql;
        int index = 0;
        for (SearchSorting.Field sf : sortingSearch.sorting.fields()) {
            StringBuilder orderField;
            ++index;
            if (sf.entry.parentEntry != null) {
                if (!sortingSearch.selfSortFields()) {
                    throw new Search.Exception(search, "\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u043e \u043f\u043e\u043b\u044f\u043c \u043d\u0435 \u0438\u0437 \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0432 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u043e\u043c \u043f\u043e\u0438\u0441\u043a\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430");
                }
                String orderField2 = Generate.generateStandardOrderByField(search, engine.caps, sqls, sf, index, true);
                if (orderField2 == null) continue;
                if (fields.extra == null) {
                    fields.extra = new StringBuilder();
                } else {
                    fields.extra.append(", ");
                }
                fields.extra.append(orderField2);
                continue;
            }
            SearchField searchField = search.fields.find(sf.fieldId);
            if (searchField == null || searchField.proxyField == null) continue;
            sf.entry.addUsage();
            StringBuilder stringBuilder = orderField = processOrderBy ? new StringBuilder() : null;
            if (searchField.position < 0) {
                if (orderField == null) continue;
                Section fieldSection = new Section();
                GenerateFieldExpression.generate(search, engine, false, fieldSection, searchField);
                orderField.append(fieldSection.sql.toString());
                fields.addParameters(fieldSection.sqlParameters);
            } else if (searchField.proxyField.isRightPadded()) {
                Section rightPaddedField = new Section();
                GenerateFieldExpression.generate(search, engine, false, rightPaddedField, searchField);
                String fieldName = rightPaddedField.sql.toString();
                fields.addParameters(rightPaddedField.sqlParameters);
                sqls.fields.append(", ");
                engine.caps.lpad(sqls.fields, fieldName, searchField.proxyField.getSize());
                sqls.fields.append(" as ");
                sf.entry.generateTempField(searchField.proxyField, sqls.fields);
                if (orderField != null) {
                    sf.entry.generateTempField(searchField.proxyField, orderField);
                }
                if (search.sortableFields != null) {
                    search.sortableFields.add(searchField.proxyField);
                }
            } else if (orderField != null) {
                orderField.append(searchField.proxyField.getRawName());
            }
            if (!processOrderBy) continue;
            if (sqls.orderBy == null) {
                sqls.orderBy = new StringBuilder();
            } else {
                sqls.orderBy.append(',');
            }
            String suffix = "";
            if (search.nullSortKind != NullSortKind.Default) {
                if (engine.caps.isNullSortSupport()) {
                    NullSortKind nsk = search.nullSortKind;
                    if (!sf.ascending) {
                        switch (nsk) {
                            case First: {
                                nsk = NullSortKind.Last;
                                break;
                            }
                            case Last: {
                                nsk = NullSortKind.First;
                            }
                        }
                    }
                    switch (nsk) {
                        case First: {
                            suffix = " nulls first ";
                            break;
                        }
                        case Last: {
                            suffix = " nulls last ";
                        }
                    }
                } else {
                    switch (search.nullSortKind) {
                        case First: {
                            sqls.orderBy.append("case when ").append((CharSequence)orderField).append(" is null").append(" then ").append('0').append(" else ").append('1').append(" end");
                            break;
                        }
                        case Last: {
                            sqls.orderBy.append("case when ").append((CharSequence)orderField).append(" is null").append(" then ").append('1').append(" else ").append('1').append(" end");
                        }
                    }
                    sqls.orderBy.append(sf.ascending ? " asc " : " desc ").append(',');
                }
            }
            sqls.orderBy.append((CharSequence)orderField).append(sf.ascending ? " asc " : " desc ").append(suffix);
        }
        return sqls.orderBy;
    }

    static StringBuilder addEntryToFrom(Section from, SearchEntry entry, Engine engine) throws IOException {
        assert (!entry.selected());
        entry.selected(true);
        if (entry.isCTE()) {
            NestedEntry nested = (NestedEntry)entry;
            if (nested.cte != null && nested.cteSection == null) {
                if (nested.usedFields != null && !nested.usedFields.empty()) {
                    nested.cte.applyUsedFields(nested.usedFields);
                }
                nested.cteSection = engine.generateEntrySql(nested.cte, entry);
            }
        } else if (entry.inplaceSearch != null) {
            Section section;
            entry.inplaceSearch.returnedFields = entry.visibleFields;
            if (entry.usedFields != null && !entry.usedFields.empty()) {
                entry.inplaceSearch.applyUsedFields(entry.usedFields);
            }
            if ((section = engine.generateEntrySql(entry.inplaceSearch, entry)) != null) {
                if (entry.inplaceSearch.kind == Search.Kind.Advanced && !entry.inplaceSearch.hasFieldsSection()) {
                    throw new Search.Exception(entry.inplaceSearch, "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u043f\u043e\u0438\u0441\u043a \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u043e\u043b\u0435\u0439. \u0412\u044b\u0431\u043e\u0440\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
                }
                from.addParameters(section.sqlParameters);
                from.sql.append('(').append((CharSequence)section.sql).append(')').append(' ');
                entry.generateAlias(from.sql);
                return from.sql;
            }
        }
        entry.generateTableRawName(from.sql);
        from.sql.append(' ');
        entry.generateAlias(from.sql);
        return from.sql;
    }

    static void addRelatedEntry(Section from, SearchEntry child, Engine engine, SearchEntry hierarchicEntry) throws IOException {
        if (child.kind == SearchEntry.Kind.Directory || child.selected() || child.ignored() || !(child instanceof DataEntry)) {
            return;
        }
        if (child.hasRelations()) {
            Section section;
            DataEntry dataEntry = (DataEntry)child;
            from.sql.append("\r\n");
            switch (dataEntry.joinType) {
                case LEFT_OUTER: {
                    from.sql.append(" left outer join ");
                    break;
                }
                default: {
                    from.sql.append(" inner join ");
                }
            }
            Generate.addEntryToFrom(from, child, engine).append(" on ");
            boolean separator = false;
            if (dataEntry.linkCondition != null && !dataEntry.linkCondition.isEmpty() && (section = GenerateCondition.createSection(engine, dataEntry.linkCondition)) != null && section.sql.length() != 0) {
                from.addParameters(section.sqlParameters);
                from.sql.append('(').append((CharSequence)section.sql).append(')');
                separator = true;
            }
            if (dataEntry.fieldBindings != null && !dataEntry.fieldBindings.isEmpty() && (section = GenerateCondition.createSection(engine, dataEntry.fieldBindings)) != null && section.sql.length() != 0) {
                from.addParameters(section.sqlParameters);
                if (separator) {
                    from.sql.append(Condition.LogicalOperator.AND.sql);
                }
                from.sql.append((CharSequence)section.sql);
            }
            Generate.addDirectories(from, child, engine, true);
            Generate.addRelated(from, child, engine, null);
        } else {
            Generate.addToFrom(from, child, engine, hierarchicEntry);
        }
    }

    static void addRelated(Section from, SearchEntry entry, Engine engine, SearchEntry hierarchicEntry) throws IOException {
        if (entry.children != null) {
            for (SearchEntry child : entry.children) {
                if (!child.hasRelations()) continue;
                Generate.addRelatedEntry(from, child, engine, null);
            }
        }
        if (hierarchicEntry != null && hierarchicEntry.related != null) {
            for (SearchEntry related : hierarchicEntry.related) {
                if (related.selected() || !related.hasRelations()) continue;
                Generate.addRelatedEntry(from, related, engine, null);
            }
        }
    }

    static void addDirectories(Section from, SearchEntry entry, Engine engine, boolean root) throws IOException {
        if (entry.children == null || root && entry.kind == SearchEntry.Kind.Directory) {
            return;
        }
        for (SearchEntry child : entry.children) {
            if (child.kind != SearchEntry.Kind.Directory || child.selected() || child.ignored()) continue;
            DirectoryEntry directory = (DirectoryEntry)child;
            FieldDescriptor directoryField = entry.findFieldDescriptor(directory.directoryReferenceFieldId);
            if (directoryField == null) {
                child.selected(true);
            } else {
                from.sql.append("\r\n").append(" left outer join ");
                Generate.addEntryToFrom(from, child, engine).append(" on ").append('(');
                entry.generateFieldAlias(directoryField, from.sql).append('=');
                child.generateFieldAlias(-1, from.sql).append(')');
                Generate.addRelated(from, child, engine, null);
            }
            Generate.addDirectories(from, child, engine, false);
        }
    }

    static void addToFrom(Section from, SearchEntry entry, Engine engine, SearchEntry hierarchicEntry) throws IOException {
        if (entry.ignored()) {
            entry.selected(true);
        } else if (!entry.selected()) {
            if (entry.hasExplicitRelations()) {
                Generate.addRelatedEntry(from, entry, engine, null);
            } else {
                if (from.sql.length() != 0) {
                    from.sql.append(',');
                }
                Generate.addEntryToFrom(from, entry, engine);
            }
            Generate.addDirectories(from, entry, engine, true);
            Generate.addRelated(from, entry, engine, hierarchicEntry);
        }
        if (entry.children != null) {
            for (SearchEntry child : entry.children) {
                if (child.ignored() || child.selected() || child.kind == SearchEntry.Kind.Directory) {
                    Generate.addToFrom(from, child, engine, null);
                    continue;
                }
                Generate.addRelatedEntry(from, child, engine, hierarchicEntry);
            }
        }
    }

    static Section generateFrom(Search search, Engine engine) throws IOException {
        Section from = new Section();
        Generate.addToFrom(from, search.rootEntry, engine, search.rootEntry);
        return from;
    }

    static Section generateFields(Search search, Engine engine) {
        if (search.isUnionItem() && search.parentSearch != null && search.parentSearch.sorting != null && !search.parentSearch.sorting.isEmpty()) {
            search.sortableFields = new ArrayList();
        }
        Section fields = null;
        int position = 1;
        boolean standardPrimaryKeyGenerated = false;
        for (SearchField field : search.fields.items) {
            boolean fieldVirtual = false;
            if (field.id == -1 && search.rootEntry.generated()) {
                if (field.proxyField == null) {
                    if (search.isSubject() && search.subjectFieldId != field.id || !search.generateNullFields()) continue;
                    if (fields == null) {
                        fields = new Section();
                    } else {
                        fields.sql.append(',');
                    }
                    fields.sql.append("null");
                    field.generated(true);
                    field.ignored(true);
                    ++position;
                    continue;
                }
                field.dataType = DataType.PRIMARY_KEY;
                search.hasPrimaryKeyExpression(true);
            } else {
                SearchField.Extra extra;
                if (standardPrimaryKeyGenerated && field.proxyField != null && field.proxyField.isPrimaryKey() && (!(field.proxyField instanceof SearchField.Extra) || !(extra = (SearchField.Extra)field.proxyField).hasMapping()) || (field.proxyField == null || field.dataType == DataType.PRIMARY_KEY) && !field.hasExpression() && field.function != AggregateFunction.CountEx) continue;
                if (field.id == -1) {
                    search.hasPrimaryKeyExpression(true);
                } else {
                    boolean bl = fieldVirtual = field.proxyField == null;
                }
            }
            if (search.isSubject() && search.subjectFieldId != field.id) {
                GenerateFieldExpression.determineGroupable(field);
                continue;
            }
            if (!field.hasExpression() && field.function != AggregateFunction.CountEx || fieldVirtual) {
                field.position = -1;
                if (search.generateNullFields()) {
                    if (fields == null) {
                        fields = new Section();
                    } else {
                        fields.sql.append(',');
                    }
                    fields.sql.append("null");
                    engine.caps.typifySuffix(field.dataType, fields.sql);
                    if (!search.isSubject()) {
                        fields.sql.append(" as ").append(field.proxyField.getRawName());
                    }
                    if (search.hasDataFilter()) {
                        search.dataFilterFields.add(field.proxyField.getRawName());
                    }
                    field.position = position++;
                    field.generated(true);
                    field.ignored(true);
                    if (search.sortableFields != null) {
                        search.sortableFields.add(field.proxyField.isRightPadded() ? null : field.proxyField);
                    }
                }
            } else {
                if (!GenerateFieldExpression.generable(search, engine, field) && !search.generateNullFields()) {
                    field.position = -1;
                    field.ignored(true);
                    field.generated(true);
                    continue;
                }
                if (fields == null) {
                    fields = new Section();
                } else {
                    fields.sql.append(',');
                }
                if (search.isSubject()) {
                    Generate.fieldModificatorPrefix(engine.caps, field.dataType, search.subjectFieldModificator, fields.sql);
                }
                GenerateFieldExpression.generate(search, engine, false, fields, field);
                field.generated(true);
                field.position = position++;
                if (search.isSubject()) {
                    Generate.fieldModificatorSuffix(engine.caps, field.dataType, search.subjectFieldModificator, fields.sql);
                } else {
                    fields.sql.append(" as ").append(field.proxyField.getRawName());
                }
                if (search.hasDataFilter()) {
                    search.dataFilterFields.add(field.proxyField.getRawName());
                }
                if (search.sortableFields != null) {
                    search.sortableFields.add(field.proxyField.isRightPadded() ? null : field.proxyField);
                }
            }
            if (field.id != -1) continue;
            standardPrimaryKeyGenerated = true;
        }
        return fields;
    }

    static boolean needGroupBy(Search search, Engine engine) {
        if (search.fields == null) {
            return false;
        }
        for (SearchField field : search.fields.items) {
            if (field.function == AggregateFunction.NONE || !field.generated() || field.ignored()) continue;
            return true;
        }
        return false;
    }

    static Section generateGroupBy(Search search, Engine engine) {
        Section section = null;
        for (SearchField field : search.fields.items) {
            if (field.function == AggregateFunction.CountEx || field.function != AggregateFunction.NONE || !field.groupable() || !field.generated() || field.ignored()) continue;
            if (section == null) {
                section = new Section();
            } else {
                section.sql.append(", ");
            }
            GenerateFieldExpression.generate(search, engine, false, section, field);
        }
        return section;
    }

    static class OrderBy {
        public StringBuilder fields = null;
        public StringBuilder orderBy = null;
        public IntegerSet fieldIds = null;
        public boolean processOrderBy = true;

        OrderBy() {
        }
    }

    public static class Section {
        StringBuilder sql = new StringBuilder();
        final SqlParameterList sqlParameters = new SqlParameterList();
        StringBuilder extra = null;

        boolean isEmpty() {
            return this.sql.length() == 0;
        }

        void addNullParam(DataType dataType) {
            this.sqlParameters.addParameter(new SqlParameter().setNull(dataType.toSqlDataType()));
        }

        void addBooleanParam(boolean value) {
            this.sqlParameters.addParameter(new SqlParameter().setBoolean(value));
        }

        void addIntegerParam(int value) {
            this.sqlParameters.addParameter(new SqlParameter().setInteger(value));
        }

        void addDoubleParam(double value) {
            this.sqlParameters.addParameter(new SqlParameter().setDouble(value));
        }

        void addDateTimeParam(double value) {
            this.sqlParameters.addParameter(new SqlParameter().setDateTime(value));
        }

        void addStringParam(String value) {
            this.sqlParameters.addParameter(new SqlParameter().setString(value));
        }

        void addUnicodeParam(String value) {
            this.sqlParameters.addParameter(new SqlParameter().setUnicode(value));
        }

        void addParameters(SqlParameterList parameters) {
            this.sqlParameters.addParameters(parameters);
        }

        void append(Section section) {
            this.append(null, section);
        }

        void append(String separator, Section section) {
            if (section == null || section.sql.length() == 0) {
                return;
            }
            if (!Strings.isVoid(separator)) {
                this.sql.append(separator);
            }
            this.sql.append((CharSequence)section.sql);
            this.addParameters(section.sqlParameters);
        }
    }

    static enum EntryExclusionMethod {
        Default(0),
        WithParent(1);

        private final int typeId;
        static final ArrayMap<EntryExclusionMethod> kindMap;

        private EntryExclusionMethod(int value) {
            this.typeId = value;
        }

        public int toInt() {
            return this.typeId;
        }

        public static EntryExclusionMethod fromInt(int typeId) {
            return kindMap.get(typeId);
        }

        static {
            kindMap = new ArrayMap<EntryExclusionMethod>(EntryExclusionMethod.values());
        }
    }

    static enum BlobReceiving {
        Skip(0),
        Length(1),
        Content(2);

        private final int typeId;
        static final ArrayMap<BlobReceiving> kindMap;

        private BlobReceiving(int value) {
            this.typeId = value;
        }

        public int toInt() {
            return this.typeId;
        }

        public static BlobReceiving fromInt(int typeId) {
            return kindMap.get(typeId);
        }

        static {
            kindMap = new ArrayMap<BlobReceiving>(BlobReceiving.values());
        }
    }

    static enum NullSortKind {
        Default(0),
        First(1),
        Last(2);

        private final int typeId;
        static final ArrayMap<NullSortKind> kindMap;

        private NullSortKind(int value) {
            this.typeId = value;
        }

        public int toInt() {
            return this.typeId;
        }

        public static NullSortKind fromInt(int typeId) {
            return kindMap.get(typeId);
        }

        static {
            kindMap = new ArrayMap<NullSortKind>(NullSortKind.values());
        }
    }
}

