/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.Strings;
import inform.adt.collections.ArrayMap;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.sql.engine.DirectoryEntry;
import inform.agent.db.sql.engine.Engine;
import inform.agent.db.sql.engine.Generate;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.types.DataType;
import inform.agent.mtd.MtdEngine;
import java.io.IOException;
import java.util.ArrayList;

public abstract class SearchEntry
implements IntegerHash.Entry {
    protected static final int PROP_selected = 1;
    protected static final int PROP_generated = 2;
    protected static final int PROP_ignored = 4;
    protected static final int PROP_checkUsageCount = 8;
    protected static final int PROP_excludeIfExcludedFromConditions = 16;
    protected static final int PROP_excludable = 32;
    protected static final int PROP_excludePeriodicData = 64;
    protected static final int PROP_excludeUnusedFields = 128;
    protected static final int PROP_initialSelected = 256;
    protected static final int PROP_initialCheckUsageCount = 512;
    protected static final int PROP_initialIgnored = 1024;
    protected static final int PROP_wasReset = 2048;
    protected static final int PROP_periodicExpanded = 4096;
    protected static final int PROP_linkVisibility = 8192;
    protected static final int PROP_isInffective = 16384;
    protected static final int PROP_hasExplicitRelations = 32768;
    protected static final int PROP_isNotIneffective = 65536;
    protected static final int PROP_maybeIneffective = 131072;
    protected int props = 48;
    static final int ELEMENTS_LINK_ID = 1;
    static final int LINKED_LINK_ID = 2;
    static final int PARENT_ELEMENTS_LINK_ID = 3;
    static final int PARENT_LINKED_LINK_ID = 4;
    static final int DIRECTORY_LINK_ID = 5;
    final int entryId;
    final Kind kind;
    double tableId;
    Search owner;
    private TableDescriptor tableDescriptor;
    ArrayList<SearchEntry> children;
    ArrayList<SearchEntry> related;
    int oracleHint_JoinType = 0;
    String oracleHint_Index = null;
    protected Search inplaceSearch;
    SearchEntry parentEntry;
    protected String description;
    IntegerSet usedFields;
    IntegerSet visibleFields;
    protected IntegerSet significantFields;
    protected int alias = Integer.MAX_VALUE;
    protected int usageCount = 0;

    public SearchEntry(int entryId, Kind kind, double tableId) {
        this.entryId = entryId;
        this.kind = kind;
        this.tableId = tableId;
    }

    SearchEntry cloneEntry() {
        return null;
    }

    void loaded() {
        if (this.children != null) {
            for (SearchEntry child : this.children) {
                child.loaded();
            }
        }
    }

    boolean isRoot() {
        return this.parentEntry == null;
    }

    boolean isSubject() {
        return false;
    }

    boolean isEmpty() {
        return this.children == null || this.children.size() == 0;
    }

    void process(Process process) {
        process.processEntry(this);
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.process(process);
            }
        }
    }

    public void reset() {
        if ((this.props & 0x800) == 0) {
            this.props |= 0x800;
            this.initialSelected(this.selected());
            this.initialCheckUsageCount(this.checkUsageCount());
            this.initialIgnored(this.ignored());
        } else {
            this.selected(this.initialSelected());
            this.checkUsageCount(this.initialCheckUsageCount());
            this.ignored(this.initialIgnored());
        }
        this.usageCount = 0;
        this.linkVisibility(false);
        this.isInffective(false);
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.reset();
            }
        }
    }

    void clearUsedFields() {
        this.usedFields = null;
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.clearUsedFields();
            }
        }
    }

    void fillUsedFields(SearchEntry entry) {
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.fillUsedFields(entry);
            }
        }
    }

    public void fillSignificantFields() {
        this.owner.fillUsedFields(this);
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.fillSignificantFields();
            }
        }
    }

    void finishFillSignificantFields() {
        this.significantFields = this.usedFields;
        this.usedFields = null;
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.finishFillSignificantFields();
            }
        }
    }

    void fillUsedFieldsAdvanced(Search topSearch) {
        if (!this.ignored() && this.excludeUnusedFields() && this.inplaceSearch != null && this.inplaceSearch.kind == Search.Kind.Advanced && this.inplaceSearch.fields != null) {
            topSearch.fillUsedFields(this);
        }
        this.fillChildrenUsedFieldsAdvanced(topSearch);
    }

    void fillChildrenUsedFieldsAdvanced(Search topSearch) {
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.fillUsedFieldsAdvanced(topSearch);
            }
        }
    }

    public void addUsage() {
        ++this.usageCount;
        if (this.parentEntry != null) {
            this.parentEntry.addUsage();
        }
    }

    public void withdraw() {
        --this.usageCount;
        if (this.parentEntry != null) {
            this.parentEntry.withdraw();
        }
    }

    public void addUsedField(int fieldId) {
        if (this.usedFields == null) {
            this.usedFields = new IntegerSet();
        }
        this.usedFields.add(fieldId);
    }

    public void checkEntry(boolean check) {
        if (check) {
            TableDescriptor table = this.getTableDescriptor();
            if (this.inplaceSearch == null && table.getKind() == TableDescriptor.Kind.VIRTUAL) {
                throw new Search.Exception(this.owner, "\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u044b\u0431\u043e\u0440 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439");
            }
        }
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.checkEntry(true);
            }
        }
    }

    public int initEntryAlias(int alias) {
        this.alias = alias++;
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                alias = child.initEntryAlias(alias);
            }
        }
        return alias;
    }

    public int initNestedAlias(int alias) {
        return this.initChildNestedAlias(alias);
    }

    protected int initChildNestedAlias(int alias) {
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                alias = child.initNestedAlias(alias);
            }
        }
        return alias;
    }

    public int initCTEAlias(int alias) {
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                alias = child.initCTEAlias(alias);
            }
        }
        return alias;
    }

    public TableDescriptor getTableDescriptor() {
        if (this.tableDescriptor == null) {
            this.tableDescriptor = TableDescriptor.get(this.tableId);
        }
        return this.tableDescriptor;
    }

    public TableDescriptor tryGetTableDescriptor() {
        if (this.tableDescriptor == null) {
            this.tableDescriptor = TableDescriptor.getIfExists(this.tableId);
        }
        return this.tableDescriptor;
    }

    public FieldDescriptor getValidFieldDescriptor(int fieldId) {
        return this.getTableDescriptor().getValidFieldDescriptor(fieldId, null);
    }

    public FieldDescriptor findFieldDescriptor(int fieldId) {
        return this.getTableDescriptor().getFieldDescriptor(fieldId);
    }

    public FieldDescriptor getValidFieldDescriptor(int fieldId, String source, String line, int lineNo) {
        TableDescriptor table = this.getTableDescriptor();
        FieldDescriptor field = table.getFieldDescriptor(fieldId);
        if (field == null) {
            throw new Search.Exception(this.owner, "\u041f\u043e\u043b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 " + source + " (" + line + ": " + lineNo + ")").detail("[\u0442\u0430\u0431\u043b\u0438\u0446\u0430: " + this.toString() + " id \u043f\u043e\u043b\u044f: " + fieldId + "]");
        }
        return field;
    }

    public void addEntry(SearchEntry entry) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(entry);
    }

    public void addRelated(SearchEntry entry) {
        if (this.related == null) {
            this.related = new ArrayList();
        }
        this.related.add(entry);
    }

    public SearchEntry addDirectory(Search search, double tableId, int fieldId) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        DirectoryEntry directoryEntry = new DirectoryEntry(++search.lastEntryId, tableId, fieldId);
        directoryEntry.owner = this.owner;
        this.children.add(directoryEntry);
        search.entries.add(directoryEntry);
        return directoryEntry;
    }

    public void fillEntries(IntegerHash<SearchEntry> entries) {
        entries.add(this);
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry entry : this.children) {
                entry.fillEntries(entries);
            }
        }
    }

    public boolean isFieldSignificant(int fieldId) {
        return this.significantFields == null || this.significantFields.empty() || this.significantFields.contains(fieldId);
    }

    public void setSignificantFields(IntegerSet significantFields) {
        block4: {
            if (!this.getTableDescriptor().isHasPeriodicStorage()) break block4;
            this.significantFields = new IntegerSet();
            if (significantFields == null || significantFields.empty()) {
                for (FieldDescriptor field : this.getTableDescriptor().getFields()) {
                    this.significantFields.add(field.getId());
                }
            } else {
                for (Cursor.Integer id : significantFields) {
                    this.significantFields.add(id.value);
                }
            }
        }
    }

    public void addSignificantField(int fieldId) {
        if (this.significantFields == null) {
            this.significantFields = new IntegerSet();
        }
        this.significantFields.add(fieldId);
    }

    public void setIneffective() {
        if (this.isInffective()) {
            return;
        }
        if (this.kind == Kind.Query || this.parentEntry == null) {
            return;
        }
        this.isInffective(true);
        this.checkUsageCount(true);
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.setIneffective();
            }
        }
    }

    public void applyIneffective() {
        if (this.maybeIneffective()) {
            this.setIneffective();
        }
        if (this.isInffective()) {
            this.owner.applyIneffectiveEntry(this.entryId);
        }
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.applyIneffective();
            }
        }
    }

    public void setIsNotIneffective() {
        this.isNotIneffective(true);
        if (this.parentEntry != null) {
            this.parentEntry.setIsNotIneffective();
        }
    }

    public boolean isChildOf(int entryId) {
        if (this.entryId == entryId) {
            return true;
        }
        if (this.parentEntry == null) {
            return false;
        }
        return this.parentEntry.isChildOf(entryId);
    }

    public boolean hasDistinctRelations() {
        return this.hasChildrenDistinctRelations();
    }

    protected final boolean hasChildrenDistinctRelations() {
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                if (!child.hasDistinctRelations()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRelations() {
        return false;
    }

    public void adjustRelations(DatabaseCaps caps) {
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.adjustRelations(caps);
            }
        }
    }

    public void addLinkUsage() {
    }

    public void excludeByRelations() {
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.excludeByRelations();
            }
        }
    }

    public void clearLinkVisibility() {
        this.linkVisibility(false);
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.clearLinkVisibility();
            }
        }
    }

    private void setIgnoredRecursive() {
        if (this.ignored()) {
            return;
        }
        this.ignored(true);
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.setIgnoredRecursive();
            }
        }
    }

    private void checkIgnoredReverse() {
        if (this.ignored()) {
            return;
        }
        if (this.excludeIfExcludedFromConditions() && (this.checkUsageCount() || this.owner.entryExclusionMethod == Generate.EntryExclusionMethod.WithParent) && this.usageCount == 0) {
            this.setIgnoredRecursive();
        }
        if (this.parentEntry != null) {
            this.parentEntry.checkIgnoredReverse();
        }
    }

    public void checkIgnored() {
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.checkIgnored();
            }
        } else {
            this.checkIgnoredReverse();
        }
    }

    public void excludePeriodicDataRecursive() {
        this.excludePeriodicData(true);
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.excludePeriodicDataRecursive();
            }
        }
    }

    void expandPeriodic() {
    }

    public void expandPeriodicTables() {
        if (!this.ignored()) {
            this.expandPeriodic();
        }
        if (this.children != null && !this.children.isEmpty()) {
            for (SearchEntry child : this.children) {
                child.expandPeriodicTables();
            }
        }
    }

    public boolean isCTE() {
        return false;
    }

    public StringBuilder generateAlias(StringBuilder sql) {
        sql.append('T').append(this.alias);
        return sql;
    }

    public void generateTableRawName(StringBuilder sql) {
        TableDescriptor table = this.getTableDescriptor();
        String rawName = table.getRawName();
        if (Strings.isVoid(rawName)) {
            throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 " + table.toString() + " \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438\u043c\u044f");
        }
        sql.append(table.getDatabaseDescriptor().getTableRawName(table.getRawName()));
    }

    public StringBuilder generateFieldAlias(int fieldId, StringBuilder sql) {
        return this.generateAlias(sql).append('.').append(this.getValidFieldDescriptor(fieldId).getRawName());
    }

    public StringBuilder generateFieldAlias(FieldDescriptor field, StringBuilder sql) {
        return this.generateAlias(sql).append('.').append(field.getRawName());
    }

    public void generateFieldAliasCasted(FieldDescriptor field, StringBuilder sql) {
        if (field.getType() == DataType.BIG_NUMBER) {
            sql.append("cast(");
            this.generateFieldAlias(field, sql);
            sql.append(" as ").append("varchar(100))");
        } else {
            this.generateFieldAlias(field, sql);
        }
    }

    public void generateTempField(FieldDescriptor field, StringBuilder sql) {
        sql.append("tmp");
        if (this.owner.isUnionItem() || this.owner.isUnions()) {
            sql.append("union");
        } else {
            this.generateAlias(sql);
        }
        sql.append("tmp").append(field.getRawName());
    }

    public boolean generateSystemFieldAlias(Search search, Engine engine, int fieldId, Generate.Section section) {
        return false;
    }

    public String getDescription() {
        if (this.description == null) {
            if (this.inplaceSearch != null) {
                this.description = MtdEngine.getNodeName(this.inplaceSearch.searchNodeId);
                if (this.description == null) {
                    this.description = "???[" + NumberConverter.doubleToString(this.inplaceSearch.searchNodeId) + "]";
                }
            } else {
                this.description = "???";
            }
        }
        return this.description;
    }

    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 4: {
                this.description = in.getString();
                break;
            }
            case 17: {
                this.owner.hasOptimizer(true);
                TaggedReader stream = in.getSubStreamReader();
                while (stream.next()) {
                    switch (stream.getCurrentTag()) {
                        case 1: {
                            this.oracleHint_JoinType = stream.getInt();
                            break;
                        }
                        case 2: {
                            this.oracleHint_Index = stream.getAnsi();
                        }
                    }
                }
                break;
            }
            case 13: {
                TaggedReader stream = in.getSubStreamReader();
                while (stream.next()) {
                    if (stream.getCurrentTag() != 1) continue;
                    if (this.visibleFields == null) {
                        this.visibleFields = new IntegerSet();
                    }
                    this.visibleFields.add(stream.getInt());
                }
                break;
            }
            case 14: {
                this.excludeUnusedFields(true);
                break;
            }
            case 15: {
                this.excludable(false);
            }
        }
    }

    public abstract double entryNodeId();

    @Override
    public int key() {
        return this.entryId;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        if (!Strings.isVoid(this.description)) {
            text.append((CharSequence)text);
        } else {
            MtdEngine.appendNodeNameForLog(text, this.entryNodeId());
        }
        text.append(" (entryId: ").append(this.entryId).append(')');
        return text.toString();
    }

    public boolean selected() {
        return (this.props & 1) != 0;
    }

    public void selected(boolean value) {
        this.props = value ? (this.props |= 1) : (this.props &= 0xFFFFFFFE);
    }

    public boolean generated() {
        return (this.props & 2) != 0;
    }

    public void generated(boolean value) {
        this.props = value ? (this.props |= 2) : (this.props &= 0xFFFFFFFD);
    }

    public boolean ignored() {
        return (this.props & 4) != 0;
    }

    public void ignored(boolean value) {
        this.props = value ? (this.props |= 4) : (this.props &= 0xFFFFFFFB);
    }

    public boolean checkUsageCount() {
        return (this.props & 8) != 0;
    }

    public void checkUsageCount(boolean value) {
        this.props = value ? (this.props |= 8) : (this.props &= 0xFFFFFFF7);
    }

    public boolean excludeIfExcludedFromConditions() {
        return (this.props & 0x10) != 0;
    }

    public void excludeIfExcludedFromConditions(boolean value) {
        this.props = value ? (this.props |= 0x10) : (this.props &= 0xFFFFFFEF);
    }

    public boolean excludable() {
        return (this.props & 0x20) != 0;
    }

    public void excludable(boolean value) {
        this.props = value ? (this.props |= 0x20) : (this.props &= 0xFFFFFFDF);
    }

    public boolean excludePeriodicData() {
        return (this.props & 0x40) != 0;
    }

    public void excludePeriodicData(boolean value) {
        this.props = value ? (this.props |= 0x40) : (this.props &= 0xFFFFFFBF);
    }

    public boolean periodicExpanded() {
        return (this.props & 0x1000) != 0;
    }

    public void periodicExpanded(boolean value) {
        this.props = value ? (this.props |= 0x1000) : (this.props &= 0xFFFFEFFF);
    }

    public boolean excludeUnusedFields() {
        return (this.props & 0x80) != 0;
    }

    public void excludeUnusedFields(boolean value) {
        this.props = value ? (this.props |= 0x80) : (this.props &= 0xFFFFFF7F);
    }

    public boolean initialSelected() {
        return (this.props & 0x100) != 0;
    }

    public void initialSelected(boolean value) {
        this.props = value ? (this.props |= 0x100) : (this.props &= 0xFFFFFEFF);
    }

    public boolean initialCheckUsageCount() {
        return (this.props & 0x200) != 0;
    }

    public void initialCheckUsageCount(boolean value) {
        this.props = value ? (this.props |= 0x200) : (this.props &= 0xFFFFFDFF);
    }

    public boolean initialIgnored() {
        return (this.props & 0x400) != 0;
    }

    public void initialIgnored(boolean value) {
        this.props = value ? (this.props |= 0x400) : (this.props &= 0xFFFFFBFF);
    }

    public boolean linkVisibility() {
        return (this.props & 0x2000) != 0;
    }

    public void linkVisibility(boolean value) {
        this.props = value ? (this.props |= 0x2000) : (this.props &= 0xFFFFDFFF);
    }

    public boolean isInffective() {
        return (this.props & 0x4000) != 0;
    }

    public void isInffective(boolean value) {
        this.props = value ? (this.props |= 0x4000) : (this.props &= 0xFFFFBFFF);
        this.props &= 0xFFFCFFFF;
    }

    public boolean isNotIneffective() {
        return (this.props & 0x10000) != 0;
    }

    public void isNotIneffective(boolean value) {
        this.props = value ? (this.props |= 0x10000) : (this.props &= 0xFFFEFFFF);
    }

    public boolean maybeIneffective() {
        return (this.props & 0x20000) != 0 && (this.props & 0x10000) == 0;
    }

    public void maybeIneffective(boolean value) {
        this.props = value ? (this.props |= 0x20000) : (this.props &= 0xFFFDFFFF);
    }

    public boolean hasExplicitRelations() {
        return (this.props & 0x8000) != 0;
    }

    public void hasExplicitRelations(boolean value) {
        this.props = value ? (this.props |= 0x8000) : (this.props &= 0xFFFF7FFF);
    }

    protected void assignProps(SearchEntry entry) {
        this.description = entry.description;
        this.inplaceSearch = null;
        this.usageCount = 0;
    }

    public static interface Process {
        public void processEntry(SearchEntry var1);
    }

    public static enum Kind {
        Table(0),
        Query(1),
        Directory(2),
        Unknown(3),
        None(4),
        Find(5),
        Subject(1000),
        Hierarchic(1001);

        public final int typeId;
        static final ArrayMap<Kind> kindMap;

        private Kind(int value) {
            this.typeId = value;
        }

        public int toInt() {
            return this.typeId;
        }

        public static Kind fromInt(int typeId) {
            return kindMap.get(typeId);
        }

        static {
            kindMap = new ArrayMap<Kind>(Kind.values());
        }
    }
}

