/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.types;

import inform.agent.db.types.DataType;

public enum SqlDataType {
    UNSUPPORTED(0, 0, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f"),
    INTEGER(1, 4, "\u0426\u0435\u043b\u043e\u0435"),
    DOUBLE(2, 8, "\u0427\u0438\u0441\u043b\u043e"),
    STRING(3, 12, "\u0421\u0442\u0440\u043e\u043a\u0430"),
    BLOB(4, 2004, "\u0411\u043b\u043e\u0431"),
    DATE_TIME(5, 91, "\u0414\u0430\u0442\u0430 \u0432\u0440\u0435\u043c\u044f"),
    UNICODE(6, -9, "\u042e\u043d\u0438\u043a\u043e\u0434"),
    BOOLEAN(7, 16, "\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435"),
    TIMESTAMP(17, 93, "\u0414\u0430\u0442\u0430 \u0432\u0440\u0435\u043c\u044f"),
    GEOMETRY(20, 1111, "\u0413\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f"),
    FILE(21, 12, "\u0424\u0430\u0439\u043b");

    private int typeId;
    private int sqlType;
    private String caption;

    private SqlDataType(int typeId, int sqlType, String caption) {
        this.typeId = typeId;
        this.sqlType = sqlType;
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public int toInteger() {
        return this.typeId;
    }

    public int toSqlType() {
        return this.sqlType;
    }

    public static SqlDataType get(int typeId) {
        for (SqlDataType t : SqlDataType.values()) {
            if (t.toInteger() != typeId) continue;
            return t;
        }
        return null;
    }

    public static SqlDataType get(DataType type) {
        for (SqlDataType t : SqlDataType.values()) {
            if (t.toSqlType() != type.getSqlType()) continue;
            return t;
        }
        return null;
    }

    public DataType toDataType() {
        switch (this) {
            case UNSUPPORTED: {
                return DataType.NONE;
            }
            case INTEGER: {
                return DataType.INTEGER;
            }
            case DOUBLE: {
                return DataType.FLOAT;
            }
            case STRING: {
                return DataType.STRING;
            }
            case BLOB: {
                return DataType.BLOB;
            }
            case DATE_TIME: {
                return DataType.DATE_TIME;
            }
            case UNICODE: {
                return DataType.UNICODE;
            }
            case BOOLEAN: {
                return DataType.BOOLEAN;
            }
            case TIMESTAMP: {
                return DataType.DATE_TIME;
            }
            case GEOMETRY: {
                return DataType.GEOMETRY;
            }
            case FILE: {
                return DataType.FILE;
            }
        }
        return DataType.NONE;
    }
}

