/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.InformException;
import inform.adt.TimeZoneHost;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.MultitypeArrayGetter;
import inform.agent.db.types.DataType;
import inform.agent.db.types.Geometry;
import inform.agent.files.BFS;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.format.FormatManager;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PackedRowContent {
    public static final int PACK_BLOB_VALUE_EMPTY = 0;
    public static final int PACK_BLOB_VALUE_REFERENCE = 1;
    public static final int PACK_BLOB_VALUE_INLINE_DATA = 2;
    public static final int PACK_BLOB_VALUE_LENGTH = 3;
    public static final int PACK_BLOB_VALUE_CONTENT = 4;
    private final int blobReceiving;
    private final int geoFormat;
    private final boolean newGeometryFormat;
    private final TimeZoneHost timeZoneHost;
    private final boolean bomStringMode;

    public PackedRowContent(int blobReceiving, int geoFormat, boolean newGeometryFormat, TimeZoneHost timeZoneHost, boolean bomStringMode) {
        this.blobReceiving = blobReceiving;
        this.geoFormat = geoFormat;
        this.newGeometryFormat = newGeometryFormat;
        this.timeZoneHost = timeZoneHost;
        this.bomStringMode = bomStringMode;
    }

    public void packMetadata(TableDescriptor metadata, OutputStream packedMetadata) throws IOException {
        List<FieldDescriptor> fields = metadata.getFields();
        int fieldCount = fields.size();
        LittleEndianDataOutputStream stream = new LittleEndianDataOutputStream(packedMetadata);
        for (int i = 0; i < fieldCount; ++i) {
            FieldDescriptor field = fields.get(i);
            stream.writeInt(field.getId());
            stream.writeInt(field.getType().getTypeId());
        }
        stream.flush();
    }

    public void packMetadata(ArrayList<FieldDescriptor> recordFields, OutputStream packedMetadata) throws IOException {
        LittleEndianDataOutputStream stream = new LittleEndianDataOutputStream(packedMetadata);
        for (FieldDescriptor field : recordFields) {
            if (field == null) continue;
            stream.writeInt(field.getId());
            stream.writeInt(field.getType().getTypeId());
        }
        stream.flush();
    }

    public static int getHeaderSize(int fieldCount) {
        return (fieldCount + 7) / 8;
    }

    public void packRecordContent(Row row, OutputStream packedContent) throws IOException, InformException {
        List<FieldDescriptor> fields = row.getTableDescriptor().getFields();
        int fieldCount = fields.size();
        int headerCount = PackedRowContent.getHeaderSize(fieldCount);
        byte[] header = new byte[headerCount];
        for (int i = 0; i < headerCount; ++i) {
            header[i] = 0;
        }
        ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
        LittleEndianDataOutputStream dataStream = new LittleEndianDataOutputStream(dataBuffer);
        for (int i = 0; i < fieldCount; ++i) {
            FieldDescriptor field = fields.get(i);
            boolean isNull = row.getNullFlag(i);
            if (!isNull) {
                block0 : switch (field.getType()) {
                    case INTEGER: 
                    case BOOLEAN: {
                        dataStream.writeInt((int)row.getNumeric(i));
                        break;
                    }
                    case PRIMARY_KEY: 
                    case FLOAT: 
                    case INTERVAL: 
                    case DIRECTORY: 
                    case METATREE_NODE: {
                        double number = row.getNumeric(i);
                        dataStream.writeDouble(number);
                        break;
                    }
                    case DATE_TIME: {
                        double number = row.getNumeric(i);
                        dataStream.writeDouble(FormatManager.fromServerTime(number, field.getFormat(), this.timeZoneHost));
                        break;
                    }
                    case STRING: 
                    case BIG_NUMBER: {
                        isNull = PackedRowContent.writeString(dataStream, (String)row.getComplex(i), true, this.bomStringMode);
                        break;
                    }
                    case UNICODE: {
                        String str = (String)row.getComplex(i);
                        if (str == null) {
                            isNull = true;
                            break;
                        }
                        str = PackedRowContent.fixstr(str);
                        dataStream.writeUTF(str);
                        dataStream.writeByte(0);
                        dataStream.writeByte(0);
                        break;
                    }
                    case BLOB: 
                    case FILE: {
                        switch (this.blobReceiving) {
                            case 1: {
                                dataStream.writeInt(3);
                                dataStream.writeDouble(row.getTableDescriptor().getNodeId());
                                dataStream.writeDouble(row.getId());
                                dataStream.writeInt(field.getId());
                                dataStream.writeLong(row.getBlobLength(i));
                                break block0;
                            }
                            case 2: {
                                Object obj = row.getComplex(i);
                                if (!(obj instanceof BinaryObject)) {
                                    isNull = true;
                                    break block0;
                                }
                                BinaryObject blob = (BinaryObject)obj;
                                if (blob.getSize() == 0) {
                                    isNull = true;
                                    break block0;
                                }
                                dataStream.writeInt(4);
                                dataStream.writeDouble(row.getTableDescriptor().getNodeId());
                                dataStream.writeDouble(row.getId());
                                dataStream.writeInt(field.getId());
                                dataStream.writeLong(blob.getSize());
                                dataStream.write(blob.getInternalBuffer(), 0, blob.getSize());
                                break block0;
                            }
                        }
                        dataStream.writeInt(1);
                        dataStream.writeDouble(row.getTableDescriptor().getNodeId());
                        dataStream.writeDouble(row.getId());
                        dataStream.writeInt(field.getId());
                        break;
                    }
                    default: {
                        isNull = true;
                    }
                }
            }
            if (isNull) continue;
            byte mask = (byte)(1 << (byte)(i % 8));
            header[i / 8] = (byte)(header[i / 8] | mask);
        }
        dataStream.flush();
        LittleEndianDataOutputStream resultStream = new LittleEndianDataOutputStream(packedContent);
        resultStream.write(header);
        resultStream.write(dataBuffer.internalBuffer());
        resultStream.flush();
    }

    public void packRecordContent(MultitypeArrayGetter resultSet, ArrayList<FieldDescriptor> recordFields, int[] columnsMap, double tableId, double rowId, ByteArrayOutputStream packedContent) throws IOException, SQLException, InformException, TaggedReaderException {
        int fieldCount = recordFields.size();
        int headerCount = PackedRowContent.getHeaderSize(fieldCount);
        for (int i = 0; i < headerCount; ++i) {
            packedContent.write(0);
        }
        LittleEndianDataOutputStream dataStream = new LittleEndianDataOutputStream(packedContent);
        int packIndex = 0;
        for (int i = 0; i < columnsMap.length; ++i) {
            FieldDescriptor field = recordFields.get(i);
            DataType fieldType = field.getType();
            int columnIndex = columnsMap[i];
            boolean isNull = false;
            if (columnIndex <= 0 && fieldType != DataType.BLOB && fieldType != DataType.FILE) {
                isNull = true;
            } else {
                try {
                    block1 : switch (fieldType) {
                        case INTEGER: 
                        case BOOLEAN: {
                            int intVal = resultSet.getAsInteger(columnIndex);
                            isNull = resultSet.wasNull();
                            if (isNull) break;
                            dataStream.writeInt(intVal);
                            break;
                        }
                        case PRIMARY_KEY: 
                        case FLOAT: 
                        case INTERVAL: 
                        case DIRECTORY: 
                        case METATREE_NODE: {
                            double number = resultSet.getAsDouble(columnIndex);
                            isNull = resultSet.wasNull();
                            if (isNull) break;
                            dataStream.writeDouble(number);
                            break;
                        }
                        case DATE_TIME: {
                            double number = resultSet.getAsDouble(columnIndex);
                            isNull = resultSet.wasNull();
                            if (isNull) break;
                            dataStream.writeDouble(FormatManager.fromServerTime(number, field.getFormat(), this.timeZoneHost));
                            break;
                        }
                        case STRING: 
                        case BIG_NUMBER: {
                            isNull = PackedRowContent.writeString(dataStream, resultSet.getString(columnIndex), true, this.bomStringMode);
                            break;
                        }
                        case UNICODE: {
                            String str = resultSet.getString(columnIndex);
                            if (str == null || resultSet.wasNull()) {
                                isNull = true;
                                break;
                            }
                            str = PackedRowContent.fixstr(str);
                            if (fieldType == DataType.UNICODE) {
                                dataStream.writeUTF(str);
                                dataStream.writeByte(0);
                                dataStream.writeByte(0);
                                break;
                            }
                            dataStream.write(str.getBytes(TaggedWriter.ANSI));
                            dataStream.writeByte(0);
                            break;
                        }
                        case BLOB: 
                        case FILE: {
                            switch (this.blobReceiving) {
                                case 1: {
                                    long blobSize;
                                    if (fieldType == DataType.FILE) {
                                        String blobPoint = resultSet.getString(columnIndex);
                                        blobSize = BFS.getFileSize(field, blobPoint, -1);
                                    } else {
                                        blobSize = resultSet.getLong(columnIndex);
                                    }
                                    dataStream.writeInt(3);
                                    dataStream.writeDouble(tableId);
                                    dataStream.writeDouble(rowId);
                                    dataStream.writeInt(field.getId());
                                    dataStream.writeLong(blobSize);
                                    break block1;
                                }
                                case 2: {
                                    byte[] blobContent;
                                    String blobPoint;
                                    if (fieldType == DataType.FILE) {
                                        blobPoint = resultSet.getString(columnIndex);
                                        blobContent = BFS.getFileBytes(field, blobPoint);
                                    } else {
                                        blobContent = resultSet.getBlobBytes(columnIndex);
                                    }
                                    if (blobContent == null || blobContent.length == 0) {
                                        isNull = true;
                                        break block1;
                                    }
                                    dataStream.writeInt(4);
                                    dataStream.writeDouble(tableId);
                                    dataStream.writeDouble(rowId);
                                    dataStream.writeInt(field.getId());
                                    dataStream.writeLong(blobContent.length);
                                    dataStream.write(blobContent);
                                    break block1;
                                }
                                case 500: {
                                    byte[] blobContent;
                                    String blobPoint;
                                    if (fieldType == DataType.FILE) {
                                        blobPoint = resultSet.getString(columnIndex);
                                        blobContent = BFS.getFileBytes(field, blobPoint);
                                    } else {
                                        blobContent = resultSet.getBlobBytes(columnIndex);
                                    }
                                    if (blobContent == null || blobContent.length == 0) {
                                        isNull = true;
                                        break block1;
                                    }
                                    dataStream.writeInt(2);
                                    dataStream.writeInt(blobContent.length);
                                    dataStream.writeLong(0L);
                                    dataStream.writeLong(0L);
                                    dataStream.write(blobContent);
                                    break block1;
                                }
                            }
                            dataStream.writeInt(1);
                            dataStream.writeDouble(tableId);
                            dataStream.writeDouble(rowId);
                            dataStream.writeInt(field.getId());
                            break;
                        }
                        case GEOMETRY: {
                            Geometry g = resultSet.getGeometry(columnIndex);
                            isNull = g == null || resultSet.wasNull();
                            if (isNull) break;
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            switch (this.geoFormat) {
                                case 0: {
                                    g.serialize(out);
                                    break;
                                }
                                case 1: {
                                    g.serializeWkb(out);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438: " + this.geoFormat);
                                }
                            }
                            if (!this.newGeometryFormat) {
                                dataStream.writeInt(out.size());
                                dataStream.write(out.internalBuffer(), 0, out.size());
                                break;
                            }
                            dataStream.writeInt(4);
                            dataStream.writeDouble(tableId);
                            dataStream.writeDouble(rowId);
                            dataStream.writeInt(field.getId());
                            dataStream.writeLong(out.size());
                            dataStream.write(out.internalBuffer(), 0, out.size());
                            break;
                        }
                        default: {
                            isNull = true;
                        }
                    }
                    dataStream.flush();
                }
                catch (SQLException e) {
                    throw new SQLException(String.format("\u041f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u044f \"%s\" \u0442\u0430\u0431\u043b\u0438\u0446\u044b (ID:%.0f) \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: %s", field.getRawName(), tableId, e.getMessage()), e);
                }
            }
            if (!isNull) {
                byte mask = (byte)(1 << (byte)(packIndex % 8));
                byte[] header = packedContent.internalBuffer();
                header[packIndex / 8] = (byte)(header[packIndex / 8] | mask);
            }
            ++packIndex;
        }
        dataStream.flush();
    }

    private static String fixstr(String str) {
        int i = str.indexOf(0);
        if (i == -1) {
            return str;
        }
        return str.substring(0, i);
    }

    private static boolean writeString(LittleEndianDataOutputStream dataStream, String value, boolean ansi, boolean compact) throws IOException {
        if (value == null) {
            return true;
        }
        value = PackedRowContent.fixstr(value);
        if (compact) {
            byte[] data = value.getBytes(TaggedWriter.ANSI);
            String revertVal = new String(data, TaggedWriter.ANSI);
            if (revertVal.equals(value)) {
                ansi = true;
            } else {
                byte[] utf8val = value.getBytes(TaggedWriter.UTF8);
                int dataSize = utf8val.length + 2;
                dataStream.writeByte(7);
                dataStream.writeByte(11);
                dataStream.write(utf8val);
                dataStream.writeByte(0);
            }
        }
        if (ansi) {
            dataStream.write(value.getBytes(TaggedWriter.ANSI));
            dataStream.writeByte(0);
        } else {
            dataStream.writeUTF(value);
            dataStream.writeByte(0);
            dataStream.writeByte(0);
        }
        return false;
    }
}

