/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.agent.Core;
import inform.agent.db.ClosableResult;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.IndexDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlCommandBatch;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.scripts.SSContext;
import inform.common.Exceptions;
import java.sql.SQLException;
import java.util.ArrayList;

public class SqlCommand {
    public SqlStringBuilder sqlText = new SqlStringBuilder();
    public SqlParameterList params = new SqlParameterList();
    public boolean avoidBatch = false;
    public double rowId = 0.0;
    public boolean recordIdValid = false;
    private TableDescriptor tableDescriptor = null;
    SqlCommandBatch.OrderedIntegerSet modifiedFields = null;

    public int executeUpdate(SSContext ssContext, DatabaseConnection database) throws SQLException {
        if (this.params.isEmpty()) {
            return 0;
        }
        try (PreparedStatement statement = database.prepareStatement("SqlCommand", this.sqlText.toString());){
            statement.setQueryTimeout();
            statement.setTableDesc(this.tableDescriptor);
            this.params.applyTo(statement);
            try {
                int n = statement.executeUpdate(ssContext);
                return n;
            }
            catch (SQLException ex) {
                database.restoreTransactionAfterException(false);
                StringBuilder msg = new StringBuilder();
                if (this.analyseUniqueIndexConstraint(database, ex, msg)) {
                    msg.append(statement.getLogMessage());
                    throw new SQLException(ex.getMessage(), msg.toString(), ex);
                }
                throw ex;
            }
        }
    }

    public ClosableResult executeQuery(SSContext ssContext, DatabaseConnection database) throws SQLException {
        PreparedStatement statement = database.prepareStatement("SqlCommand", this.sqlText.toString());
        try {
            statement.setQueryTimeout();
            statement.setTableDesc(this.tableDescriptor);
            this.params.applyTo(statement);
            return new ClosableResult(statement, statement.executeQuery(ssContext));
        }
        catch (SQLException ex) {
            try {
                statement.close();
            }
            catch (Throwable closeEx) {
                Core.logger.error(null, closeEx);
            }
            throw ex;
        }
    }

    public void clear() {
        this.sqlText = new SqlStringBuilder();
        this.params = new SqlParameterList();
        if (this.modifiedFields != null) {
            this.modifiedFields.clear();
        }
        this.rowId = 0.0;
        this.recordIdValid = false;
    }

    public TableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    public void setTableDescriptor(TableDescriptor tableDescriptor) {
        this.tableDescriptor = tableDescriptor;
    }

    public void addModifiedField(int fieldId) {
        if (this.modifiedFields == null) {
            this.modifiedFields = new SqlCommandBatch.OrderedIntegerSet();
        }
        this.modifiedFields.add(fieldId);
    }

    public void setUpdateType(boolean isInsert) {
        if (this.modifiedFields == null) {
            this.modifiedFields = new SqlCommandBatch.OrderedIntegerSet();
        }
        this.modifiedFields.isInsert = isInsert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectUniqueViolationRecords(DatabaseConnection connection, IndexDescriptor index, StringBuilder msg) {
        if (index == null) {
            return;
        }
        FieldDescriptor recordIdField = this.tableDescriptor.getRecordIdField();
        if (recordIdField == null) {
            return;
        }
        SqlParameterList existingValues = new SqlParameterList();
        SqlStringBuilder s = new SqlStringBuilder();
        s.append("select");
        int comma = 32;
        ArrayList<FieldDescriptor> ef = new ArrayList<FieldDescriptor>();
        boolean needSelectValue = false;
        for (FieldDescriptor e : index.getFields()) {
            int pi = this.modifiedFields.indexOf(e.getId());
            if (pi >= 0) {
                SqlParameter p = ((SqlParameter)this.params.get(pi)).clone();
                p.setId(e.getId());
                existingValues.add(p);
                continue;
            }
            s.append((char)comma).append(e);
            comma = 44;
            ef.add(e);
            needSelectValue = true;
        }
        if (needSelectValue) {
            s.append(" from ").append(this.tableDescriptor).append(" where ").append(recordIdField).append("=?");
            int recordIdIndex = this.modifiedFields.indexOf(recordIdField.getId());
            if (recordIdIndex < 0) {
                return;
            }
            SqlParameter p = ((SqlParameter)this.params.get(recordIdIndex)).clone();
            try (PreparedStatement statement = connection.prepareStatement("SqlCommandBatch", s.toString());){
                p.applyTo(1, statement);
                try (ResultSet fetch = statement.executeQuery(null);){
                    if (fetch.next()) {
                        block23: for (int i = 0; i < ef.size(); ++i) {
                            FieldDescriptor e = (FieldDescriptor)ef.get(i);
                            p = new SqlParameter(e.getType().toSqlDataType());
                            p.setId(e.getId());
                            existingValues.add(p);
                            switch (p.getType()) {
                                case INTEGER: 
                                case DOUBLE: {
                                    p.setDouble(fetch.getAsDouble(i + 1));
                                    continue block23;
                                }
                                case STRING: 
                                case UNICODE: {
                                    p.setString(fetch.getString(i + 1));
                                    continue block23;
                                }
                                case DATE_TIME: 
                                case TIMESTAMP: {
                                    p.setDateTime(fetch.getDateTime(i + 1));
                                    continue block23;
                                }
                                case BOOLEAN: {
                                    p.setBoolean(fetch.getBoolean(i + 1));
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
                return;
            }
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        SqlParameterList sqlParameters = new SqlParameterList();
        sql.append("select ").append(recordIdField).append(" from ").append(this.tableDescriptor);
        sql.append(" where ");
        String and = "";
        StringBuilder nulls = new StringBuilder();
        String or = "";
        msg.append("\n\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438:");
        int comma2 = 32;
        for (FieldDescriptor f : index.getFields()) {
            boolean is_null = true;
            msg.append((char)comma2).append("'");
            comma2 = 44;
            f.toLogString(msg);
            msg.append("'=");
            for (SqlParameter p : existingValues) {
                if (p.getId() != f.getId()) continue;
                if (p.isNull()) break;
                is_null = false;
                sql.append(and).append(f).append("=?");
                sqlParameters.add(p);
                and = " and ";
                p.getLogValue(msg);
                break;
            }
            if (!is_null) continue;
            nulls.append(or).append(f).append(" is null");
            or = " or ";
            msg.append("null");
        }
        if (nulls.length() != 0) {
            sql.append(and).append('(').append(nulls).append(')');
            and = " and ";
        }
        DoubleSet ids = new DoubleSet();
        try (PreparedStatement statement = connection.prepareStatement("SqlCommandBatch", sql.toString());){
            statement.setQueryTimeout();
            statement.setTableDesc(this.tableDescriptor);
            sqlParameters.applyTo(statement);
            try (ResultSet fetch = statement.executeQuery(null);){
                while (fetch.next()) {
                    ids.add(fetch.getAsDouble(1));
                }
            }
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
        }
        comma2 = 32;
        msg.append("\n\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u044e\u0449\u0438\u0435 \u0437\u0430\u043f\u0438\u0441\u0438:");
        for (Cursor.Double id : ids) {
            msg.append((char)comma2).append(NumberConverter.doubleToString(id.value));
            comma2 = 44;
        }
        msg.append('\n');
    }

    private boolean analyseUniqueIndexConstraint(DatabaseConnection database, SQLException ex, StringBuilder msg) {
        if (this.tableDescriptor == null || !this.tableDescriptor.hasStandartPrimaryKey()) {
            return false;
        }
        if (this.modifiedFields != null && !this.modifiedFields.integerList.empty()) {
            SQLException uix = database.tryGetUniqueIndexConstraintException(ex);
            if (uix == null) {
                return false;
            }
            IndexDescriptor indexDescriptor = this.tableDescriptor.extractIndexFromMessage(uix.getMessage());
            if (indexDescriptor == null) {
                return false;
            }
            StringBuilder detailing = new StringBuilder();
            StringBuilder callstack = new StringBuilder();
            Exceptions.toString(ex, detailing, callstack);
            msg.append("\n\u0418\u043d\u0434\u0435\u043a\u0441: ").append(indexDescriptor.getName()).append('[').append(indexDescriptor.getRawName()).append(']');
            try {
                this.selectUniqueViolationRecords(database, indexDescriptor, msg);
            }
            catch (Throwable e) {
                Core.logger.error(null, e);
            }
            return true;
        }
        return false;
    }
}

