/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.document;

import inform.adt.Strings;
import inform.agent.document.CellData;
import inform.agent.document.CustomItem;
import inform.agent.document.Data;
import inform.agent.document.Marker;
import inform.agent.document.TabItem;
import inform.agent.document.Table;
import inform.agent.document.TextItem;
import java.util.HashSet;

public class UsedStyleFinder {
    public HashSet<Integer> usedTextStyles = new HashSet();
    public HashSet<Integer> usedParaStyles = new HashSet();
    public HashSet<Integer> usedListStyles = new HashSet();

    public void prepare(Data data) {
        for (int i = 0; i < data.itemList.size(); ++i) {
            String text;
            CustomItem item = data.itemList.get(i);
            if (item instanceof Table) {
                for (int r = 0; r < ((Table)item).rowCount(); ++r) {
                    for (int c = 0; c < ((Table)item).colCount(); ++c) {
                        CellData cell = ((Table)item).cells(r, c);
                        if (cell == null) continue;
                        this.prepare(cell);
                    }
                }
            } else {
                if (item.styleNo() == -300) {
                    throw new Error("\u041c\u0435\u0442\u043e\u0434 prepare \u043d\u0435 \u0433\u043e\u0442\u043e\u0432 \u0434\u043b\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432");
                }
                if (item instanceof Marker) {
                    this.usedListStyles.add(((Marker)item).listNo);
                }
            }
            if (item instanceof TextItem && Strings.isVoid(text = ((TextItem)item).itemText()) && (item.sameAsPrev() || i + 1 == data.itemList.size())) continue;
            if (item.styleNo() == -12) {
                this.usedTextStyles.add(((TabItem)item).textStyleNo);
            } else if (item.styleNo() >= 0) {
                this.usedTextStyles.add(item.styleNo());
            }
            this.usedParaStyles.add(item.paraNo);
        }
    }
}

