/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.exchange;

import inform.agent.exchange.ExchangeNode;
import java.util.ArrayList;
import java.util.HashMap;

public class ExportNodesList
extends ArrayList<ExchangeNode> {
    private HashMap<Double, ExchangeNode> _hash = new HashMap();
    private ArrayList<Integer> _nodesTypes = new ArrayList();

    public ExchangeNode findNode(double nodeId) {
        if (this._hash.containsKey(nodeId)) {
            return this._hash.get(nodeId);
        }
        return null;
    }

    private boolean containsType(int nodeType) {
        for (int i : this._nodesTypes) {
            if (i != nodeType) continue;
            return true;
        }
        return false;
    }

    public void addNode(ExchangeNode n) {
        if (this.findNode(n.nodeRecord().getId()) == null) {
            this.add(n);
            this._hash.put(n.nodeRecord().getId(), n);
        }
        if (!this.containsType(n.nodeRecord().getType())) {
            this._nodesTypes.add(n.nodeRecord().getType());
        }
    }

    public void removeNode(ExchangeNode n) {
        this._hash.remove(n.nodeRecord().getId());
        int index = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != n) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.remove(index);
        }
    }

    public ExchangeNode getItem(int index) {
        return (ExchangeNode)this.get(index);
    }

    @Override
    public void clear() {
        this._hash.clear();
        super.clear();
    }

    public void rehash() {
        this._hash.clear();
        for (int i = 0; i < this.size(); ++i) {
            this._hash.put(((ExchangeNode)this.get(i)).nodeRecord().getId(), (ExchangeNode)this.get(i));
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

