/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.exchange;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.exchange.ExchangeNode;
import inform.agent.exchange.ExchangeSettings;
import inform.agent.exchange.ExportNodesList;
import inform.agent.exchange.NodesTree;
import inform.agent.mtd.NodeRecord;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ImportNodesTree
extends NodesTree {
    private double _exportId;
    private String _comment;
    private int _nodeCount;
    private boolean _containsAuditSetting = false;
    private boolean _containsConst = false;
    private boolean _containsData = false;
    private ExportNodesList _folders;
    private double _hierarchyRoot;

    public ImportNodesTree(ExchangeSettings sett) {
        this._settings = sett;
        this._folders = new ExportNodesList();
        this._comment = "";
    }

    public double exportId() {
        return this._exportId;
    }

    public String comment() {
        return this._comment;
    }

    public ExportNodesList folders() {
        return this._folders;
    }

    public double exportedHierarchyRoot() {
        return this._hierarchyRoot;
    }

    public void parseFileDataBuffer(byte[] content, ServerSideHost host) throws IOException {
        int MIN_PEX_SERVER_VERSION = 83886105;
        TaggedReader reader = new TaggedReader(content);
        if (reader.getNextTag() != 150) {
            throw new TaggedReaderException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0438\u0433\u043d\u0430\u0442\u0443\u0440\u0430");
        }
        int chuckCount = 0;
        VersionInfo info = new VersionInfo();
        VersionInfo serverVers = new VersionInfo(Core.serverVersionMajor, Core.serverVersionMajor, Core.serverVersionRelease);
        VersionInfo clientVers = host.getClientVersion();
        VersionInfo checkServerVers = new VersionInfo();
        checkServerVers.setNumber(83886105L);
        long minClientVersion = 0L;
        long minServerVersion = 0L;
        String entryName = "";
        NodeRecord curNodeInfo = new NodeRecord();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 22: {
                    minServerVersion = reader.getUnsignedInt();
                    info.clear();
                    info.setNumber(minServerVersion);
                    if (minServerVersion <= 0L || !serverVers.lessThen(info)) break;
                    throw new InformException("\u0414\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u0435\u0440\u0432\u0435\u0440 \u0432\u0435\u0440\u0441\u0438\u0438 \u0431\u043e\u043b\u0435\u0435 " + VersionInfo.toString(info.toNumber()));
                }
                case 17: {
                    this._exportId = reader.getDouble();
                    break;
                }
                case 18: {
                    this._comment = reader.getAnsi();
                    break;
                }
                case 8: {
                    this._nodeCount = reader.getInt();
                    break;
                }
                case 19: {
                    this._containsAuditSetting = true;
                    this._settings.dataAuditAction = ExchangeSettings.DataAuditType.create(reader.getInt());
                    break;
                }
                case 1: {
                    entryName = reader.getAnsi();
                    break;
                }
                case 2: {
                    reader.skip();
                    curNodeInfo.setId(reader.getDouble(151));
                    break;
                }
                case 3: {
                    reader.skip();
                    curNodeInfo.setParentId(reader.getDouble(151));
                    break;
                }
                case 4: {
                    curNodeInfo.setType(reader.getInt());
                    if (curNodeInfo.getType() != 7) break;
                    this._containsConst = true;
                    break;
                }
                case 16: {
                    curNodeInfo.setModificationContentTime(reader.getDate(Core.serverTimeZoneHost).getTime());
                    break;
                }
                case 11: {
                    curNodeInfo.setReplId(1.0);
                    break;
                }
                case 27: {
                    reader.skip();
                    curNodeInfo.setReplNodeId(reader.getDouble(151));
                    break;
                }
                case 23: {
                    curNodeInfo.setModificationUserId(reader.getDouble());
                    break;
                }
                case 5: {
                    curNodeInfo.setName(reader.getAnsi());
                    ExchangeNode curNode = new ExchangeNode(curNodeInfo);
                    curNodeInfo = new NodeRecord();
                    curNode.entryPath(entryName);
                    curNode.dataEntryCount(chuckCount);
                    chuckCount = 0;
                    this._nodes.addNode(curNode);
                    if (curNode.nodeRecord().getType() == 10 && curNodeInfo.getReplId() == 0.0) {
                        this._databaseNodes.addNode(curNode);
                    }
                    if (curNode.nodeRecord().getType() != 12 || curNodeInfo.getReplId() != 0.0) break;
                    this._tableNodes.addNode(curNode);
                    break;
                }
                case 9: {
                    this._containsData = true;
                    break;
                }
                case 15: {
                    int dataImportAction = reader.getInt();
                    this._settings.dataImportAction = ExchangeSettings.DataImportType.create(dataImportAction);
                    break;
                }
                case 12: {
                    curNodeInfo.clear();
                    reader.skip();
                    curNodeInfo.setId(reader.getDouble(151));
                    curNodeInfo.setType(10);
                    break;
                }
                case 13: {
                    curNodeInfo.setName(reader.getAnsi());
                    ExchangeNode curDNode = new ExchangeNode(curNodeInfo);
                    curNodeInfo = new NodeRecord();
                    this._databaseNodes.addNode(curDNode);
                    break;
                }
                case 20: {
                    minClientVersion = reader.getUnsignedInt();
                    info.clear();
                    info.setNumber(minClientVersion);
                    if (minClientVersion <= 0L || !clientVers.lessThen(info)) break;
                    throw new InformException("\u0414\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043a\u043b\u0438\u0435\u043d\u0442 \u0432\u0435\u0440\u0441\u0438\u0438 \u0431\u043e\u043b\u0435\u0435 " + VersionInfo.toString(info.toNumber()));
                }
                case 21: {
                    chuckCount = reader.getInt();
                    if (!serverVers.lessThen(checkServerVers)) break;
                    throw new InformException("\u0414\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u0435\u0440\u0432\u0435\u0440 \u0432\u0435\u0440\u0441\u0438\u0438 \u0431\u043e\u043b\u0435\u0435 " + VersionInfo.toString(checkServerVers.toNumber()));
                }
                case 24: {
                    this._settings.importConstantsAction = ExchangeSettings.ImportConstantsAction.create(reader.getInt());
                    break;
                }
                case 25: {
                    this._settings.importMoveNodes = reader.getBoolean();
                    break;
                }
                case 26: {
                    this._settings.importOnlyData = reader.getBoolean();
                }
            }
        }
    }

    public void parseTreeFoldersBuffer(byte[] content) throws IOException {
        TaggedReader reader = new TaggedReader(content);
        NodeRecord nodeInfo = new NodeRecord();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 5: {
                    reader.skip();
                    this._hierarchyRoot = reader.getDouble(151);
                    break;
                }
                case 1: {
                    nodeInfo.clear();
                    reader.skip();
                    nodeInfo.setId(reader.getDouble(151));
                    break;
                }
                case 3: {
                    reader.skip();
                    nodeInfo.setParentId(reader.getDouble(151));
                    break;
                }
                case 2: {
                    nodeInfo.setType(reader.getInt());
                    break;
                }
                case 16: {
                    nodeInfo.setModificationContentTime(reader.getDate(Core.serverTimeZoneHost).getTime());
                    break;
                }
                case 4: {
                    nodeInfo.setName(reader.getAnsi());
                    ExchangeNode node = new ExchangeNode(nodeInfo);
                    nodeInfo = new NodeRecord();
                    this._folders.addNode(node);
                }
            }
        }
    }

    public void loadNodesFromPex(ZipFile zip, ServerSideHost host) throws IOException {
        String pexMetadataEntry = NodesTree.getPexMetadataEntryName(zip);
        ZipEntry entry = zip.getEntry(pexMetadataEntry);
        InputStream stream = zip.getInputStream(entry);
        byte[] fileData = this.readZipInputStreamData(stream);
        stream.close();
        this.parseFileDataBuffer(fileData, host);
        entry = zip.getEntry(".TreeFolders");
        stream = zip.getInputStream(entry);
        byte[] treeFolder = this.readZipInputStreamData(stream);
        stream.close();
        this.parseTreeFoldersBuffer(treeFolder);
        this.buildTree();
        this._isBuild = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readZipInputStreamData(InputStream is) throws IOException {
        byte[] data;
        byte[] buf = new byte[4096];
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int n;
            while ((n = is.read(buf)) > -1) {
                output.write(buf, 0, n);
            }
            data = output.toByteArray();
        }
        return data;
    }
}

