/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.exchange;

import inform.agent.exchange.ExchangeNode;
import inform.agent.exchange.ExchangeSettings;
import inform.agent.exchange.ExportNodesList;
import java.util.zip.ZipFile;

public class NodesTree {
    protected ExchangeSettings _settings;
    protected ExportNodesList _rootNodes;
    protected ExportNodesList _nodes = new ExportNodesList();
    protected ExportNodesList _databaseNodes;
    protected ExportNodesList _tableNodes;
    boolean _isBuild = false;

    public NodesTree() {
        this._rootNodes = new ExportNodesList();
        this._databaseNodes = new ExportNodesList();
        this._tableNodes = new ExportNodesList();
    }

    public ExportNodesList rootNodes() {
        return this._rootNodes;
    }

    public ExportNodesList nodes() {
        return this._nodes;
    }

    public ExportNodesList databaseNodes() {
        return this._databaseNodes;
    }

    public ExportNodesList tableNodes() {
        return this._tableNodes;
    }

    public boolean isBuild() {
        return this._isBuild;
    }

    public void clear() {
        this._nodes.clear();
        this._rootNodes.clear();
        this._databaseNodes.clear();
        this._tableNodes.clear();
        this._isBuild = false;
    }

    public boolean deleteNodeForBuildTree(ExchangeNode n) {
        if (this._databaseNodes.contains(n)) {
            return false;
        }
        this._nodes.removeNode(n);
        this._rootNodes.removeNode(n);
        this._tableNodes.removeNode(n);
        return true;
    }

    public boolean fitsIDFilter(double id) {
        return true;
    }

    public boolean fitsMUserFilter(double modUser) {
        return true;
    }

    protected void buildTree() {
        ExchangeNode node;
        if (this._isBuild) {
            throw new IllegalStateException();
        }
        int i = 0;
        while (i < this._nodes.size()) {
            if (!this.fitsMUserFilter(((ExchangeNode)this._nodes.get(i)).nodeRecord().getModificationUserId()) || !this.fitsIDFilter(((ExchangeNode)this._nodes.get(i)).nodeRecord().getId())) {
                if (this.deleteNodeForBuildTree((ExchangeNode)this._nodes.get(i))) continue;
                ++i;
                continue;
            }
            ++i;
        }
        this._nodes.rehash();
        this._rootNodes.rehash();
        this._tableNodes.rehash();
        this._databaseNodes.rehash();
        for (i = 0; i < this._nodes.size(); ++i) {
            ExchangeNode parentNode;
            node = this._nodes.getItem(i);
            if (node == null || node.nodeRecord().getId() == 0.0 || (parentNode = this._nodes.findNode(node.nodeRecord().getParentId())) == null) continue;
            node.setParentNode(parentNode);
            parentNode.addChildNode(node);
        }
        for (i = 0; i < this._nodes.size(); ++i) {
            node = this._nodes.getItem(i);
            if (node.parentNode() != null) continue;
            this._rootNodes.addNode(node);
        }
    }

    public static String getPexMetadataEntryName(ZipFile zip) {
        if (zip.getEntry(".PexInfo") != null) {
            return ".PexInfo";
        }
        if (zip.getEntry(".FileData") != null) {
            return ".FileData";
        }
        throw new IllegalStateException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043b\u0438\u0431\u043e \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 pex-\u0444\u0430\u0439\u043b\u0430");
    }
}

