/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.exchange;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.VersionInfo;
import inform.agent.db.types.DataType;
import inform.agent.exchange.ConstantsSet;
import inform.agent.exchange.ExchangeNode;
import inform.agent.exchange.ExchangeSettings;
import inform.agent.exchange.ImportNodesTree;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.mtd.request.AddNode;
import inform.agent.mtd.request.ModifyNode;
import inform.agent.replication.request.UploadNode;
import inform.agent.replication.request.UploadNodeSet;
import inform.agent.scripts.SSContext;
import inform.common.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PexImportProcess {
    private ImportNodesTree _importTree;
    private ExchangeSettings _settings;
    private double _hierarchyRoot = 0.0;
    private ArrayList<ExchangeError> _errors;
    private double _startTime;
    private double _minServerTime;
    private SSContext _ssContext;
    ServerSideHost _host;
    private HashSet<Double> _createdDatabases;
    private ArrayList<NodeRecord> _conflictNodes;
    private HashMap<Double, Double> _nodesCorrespondence;
    double _exportReplicaId;
    String _pexFilePath;
    String _markFile;
    double _auditRecordId = 0.0;
    String _warnings = null;
    private static final int TAG_TBL_FIELD_ID = 10;
    private static final int TAG_TBL_FIELD_TYPE = 12;
    private static final int TAG_TBL_FIELD_NAME = 13;
    private static final int TAG_TABLE_KIND = 27;

    public PexImportProcess(SSContext context, ServerSideHost host, ImportNodesTree tree, ExchangeSettings sett, double root) {
        this._ssContext = context;
        this._host = host;
        this._importTree = tree;
        this._settings = sett;
        this._hierarchyRoot = root;
        this._createdDatabases = new HashSet();
        this._nodesCorrespondence = new HashMap();
        this._exportReplicaId = 0.0;
        this._pexFilePath = null;
        this._markFile = null;
        this._conflictNodes = new ArrayList();
        this._warnings = "";
    }

    public double getExportID() {
        return this._importTree.exportId();
    }

    public double getAuditRecordId() {
        return this._auditRecordId;
    }

    public String getWarnings() {
        return this._warnings;
    }

    private void filterDatabaseNodes() {
        for (ExchangeNode node : this._importTree.nodes()) {
            if (node.nodeRecord().getType() != 10) continue;
            throw new InformException("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u0443\u0437\u043b\u044b \u0441 \u0411\u0414 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e.");
        }
    }

    private ArrayList<Double> fillDatabasesFromExchangeTree() {
        ArrayList<Double> nodeIds = new ArrayList<Double>();
        for (int i = 0; i < this._importTree.rootNodes().size(); ++i) {
            nodeIds.addAll(this.fillEntry((ExchangeNode)this._importTree.rootNodes().get(i)));
        }
        return nodeIds;
    }

    private ArrayList<Double> fillEntry(ExchangeNode node) {
        ArrayList<Double> nodeIds = new ArrayList<Double>();
        if (node.nodeRecord().getType() == 10) {
            nodeIds.add(node.nodeRecord().getId());
        }
        if (node.children() == null || node.children().isEmpty()) {
            return nodeIds;
        }
        for (int j = 0; j < node.children().size(); ++j) {
            nodeIds.addAll(this.fillEntry((ExchangeNode)node.children().get(j)));
        }
        return nodeIds;
    }

    private void setImportDBsCorrespondence() {
        boolean i = false;
        for (ExchangeNode node : this._importTree.databaseNodes()) {
            ExchangeSettings.DSCorLine line = this._settings.createDSCorLine();
            line.fileNodeId = node.nodeRecord().getId();
            line.fileNodeFullName = "/" + node.nodeRecord().getName();
            line.enabled = true;
            Node mtdNode = MtdEngine.getNode(node.nodeRecord().getId());
            if (mtdNode != null) {
                NodeRecord mtdNodeInfo = new NodeRecord();
                mtdNode.getNodeRecord(mtdNodeInfo);
                StringBuilder nodePath = new StringBuilder();
                mtdNode.getNodeStringPath(0.0, nodePath);
                if (mtdNodeInfo.getType() == 10) {
                    line.phenixNodeId = mtdNodeInfo.getId();
                    line.phenixNodeFullName = nodePath.toString() + "/" + node.nodeRecord().getName();
                }
            }
            this._settings.importDBsCorrespondence.add(line);
        }
        if (!this._settings.importDBsCorrespondence.isEmpty()) {
            StringBuilder dbsLog = new StringBuilder("\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u043c\u0435\u0436\u0434\u0443 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u044b\u043c\u0438 \u0411\u0414 \u0438 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u043c\u0438: ");
            for (ExchangeSettings.DSCorLine line : this._settings.importDBsCorrespondence) {
                if (line.enabled && line.phenixNodeId == 0.0) {
                    throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445: " + line.fileNodeFullName);
                }
                dbsLog.append(line.fileNodeFullName).append(" -> ").append(line.phenixNodeFullName).append("\n");
            }
            Core.logger.info(dbsLog.toString());
        }
    }

    private void setDatabasesToProcess() {
        this.filterDatabaseNodes();
        ArrayList<Double> dbsIds = this.fillDatabasesFromExchangeTree();
        for (Double d : dbsIds) {
            ExchangeSettings.ExportDatabaseInfo info = this._settings.createExportDatabaseInfo();
            info.nodeId = d;
            info.enabled = true;
            this._settings.databasesToProcess.add(info);
        }
    }

    private String replicaInfo(String fileName, int count) {
        String res = fileName == null || fileName.isEmpty() ? "\u0424\u0430\u0439\u043b \u0438\u0437 \u0431\u043b\u043e\u0431\u0430 \u0443\u0436\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u043b\u0441\u044f " + count : "\u0424\u0430\u0439\u043b " + fileName + " \u0443\u0436\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u043b\u0441\u044f " + count;
        int mod1 = count % 10;
        int mod2 = count % 100;
        res = !(mod1 != 2 && mod1 != 3 && mod1 != 4 || count >= 10 && mod2 >= 10 && mod2 <= 20) ? res + " \u0440\u0430\u0437\u0430." : res + " \u0440\u0430\u0437.";
        return res;
    }

    private void logReplicaId() throws SQLException {
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.REPLICATION);
        int replicaCount = journal.getRegisteredReplicaIdCount(this._ssContext, this._exportReplicaId);
        if (replicaCount <= 0) {
            return;
        }
        String infoPath = this._pexFilePath;
        if (infoPath == null || infoPath.isEmpty()) {
            infoPath = this._markFile;
        }
        Core.logger.info(this.replicaInfo(infoPath, replicaCount));
    }

    private int parseDangerTable(TaggedReader in, ArrayList<TableFieldPart> part) throws IOException {
        int kind = 0;
        TableFieldPart p = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 10: {
                    p = new TableFieldPart();
                    p.fieldId = in.getInt();
                    part.add(p);
                    break;
                }
                case 13: {
                    if (p == null) break;
                    p.name = in.getAnsi();
                    break;
                }
                case 12: {
                    if (p == null) break;
                    p.type = in.getInt();
                    break;
                }
                case 27: {
                    kind = in.getInt();
                }
            }
        }
        return kind;
    }

    private void fillClientPart(ZipFile zip, ExchangeNode node, ArrayList<TableFieldPart> clientPart) throws IOException {
        byte[] content = null;
        byte[] nodeContent = null;
        ZipEntry contentEntry = zip.getEntry(node.contentEntryPath());
        if (contentEntry == null) {
            return;
        }
        try (InputStream is = zip.getInputStream(contentEntry);){
            content = this.readZipInputStreamData(is);
        }
        TaggedReader reader = new TaggedReader(content);
        while (reader.next()) {
            if (reader.getCurrentTag() != 2) continue;
            nodeContent = reader.getRaw();
        }
        if (nodeContent == null || nodeContent.length == 0) {
            return;
        }
        TaggedReader clReader = new TaggedReader(nodeContent);
        while (clReader.next()) {
            if (clReader.getCurrentTag() != 14) continue;
            byte[] inData = clReader.getRaw();
            TaggedReader dataReader = new TaggedReader(inData);
            this.parseDangerTable(dataReader, clientPart);
        }
    }

    private String getNameType(DataType t) {
        switch (t) {
            case PRIMARY_KEY: {
                return "\u041f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447";
            }
            case INTEGER: {
                return "\u0426\u0435\u043b\u043e\u0435";
            }
            case FLOAT: {
                return "\u0414\u0440\u043e\u0431\u043d\u043e\u0435";
            }
            case STRING: {
                return "\u0421\u0442\u0440\u043e\u043a\u0430";
            }
            case DATE_TIME: {
                return "\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f";
            }
            case INTERVAL: {
                return "\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b";
            }
            case DIRECTORY: {
                return "\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430";
            }
            case BOOLEAN: {
                return "\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435";
            }
            case BLOB: {
                return "BLOB";
            }
            case FILE: {
                return "BLOB \u0441\u0441\u044b\u043b\u043a\u0430";
            }
            case METATREE_NODE: {
                return "\u0423\u0437\u0435\u043b \u043c\u0435\u0442\u0430\u0434\u0435\u0440\u0435\u0432\u0430";
            }
            case VARIANT: {
                return "\u0412\u0430\u0440\u0438\u0430\u043d\u0442";
            }
            case BIG_NUMBER: {
                return "\u0411\u043e\u043b\u044c\u0448\u043e\u0435 \u0447\u0438\u0441\u043b\u043e";
            }
            case UNICODE: {
                return "Unicode";
            }
            case GEOMETRY: {
                return "\u0413\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u044f";
            }
        }
        return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439";
    }

    private void isChangedFields(ZipFile zip, ExchangeNode node) throws IOException, InformException {
        if (node.nodeRecord().getType() != 12) {
            return;
        }
        Node snode = MtdEngine.getNode(node.nodeRecord().getId());
        if (snode == null) {
            return;
        }
        BasicNode mtdNode = snode.getRealNode();
        if (mtdNode == null || mtdNode.getType() != 12) {
            return;
        }
        BasicNode.NodeContent mtdContent = mtdNode.getNodeContent(0.0, true);
        int VIRTUAL_KIND = 2;
        TaggedReader reader = new TaggedReader(mtdContent.content);
        ArrayList<TableFieldPart> serverPart = new ArrayList<TableFieldPart>();
        int serverKind = this.parseDangerTable(reader, serverPart);
        if (serverKind == 2) {
            return;
        }
        ArrayList<TableFieldPart> clientPart = new ArrayList<TableFieldPart>();
        this.fillClientPart(zip, node, clientPart);
        int clientType = 0;
        Object logTable = "";
        boolean isTableChanged = false;
        boolean isFieldDeleted = false;
        boolean isFieldTypeChanged = false;
        for (int i = 0; i < serverPart.size(); ++i) {
            clientType = 0;
            isFieldDeleted = true;
            isFieldTypeChanged = false;
            for (int j = 0; j < clientPart.size(); ++j) {
                if (serverPart.get((int)i).fieldId != clientPart.get((int)j).fieldId) continue;
                isFieldDeleted = false;
                isFieldTypeChanged = serverPart.get((int)i).type != clientPart.get((int)j).type;
                clientType = clientPart.get((int)j).type;
                break;
            }
            if (!isFieldDeleted && !isFieldTypeChanged) continue;
            if (!isTableChanged) {
                logTable = (String)logTable + "\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 " + String.format("%.0f", node.nodeRecord().getId()) + " \u0431\u0443\u0434\u0443\u0442 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f. ";
                isTableChanged = true;
            }
            if (isFieldDeleted) {
                logTable = (String)logTable + "\u041f\u043e\u043b\u0435 [" + serverPart.get((int)i).fieldId + "] " + serverPart.get((int)i).name + " \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u043e. ";
            }
            if (!isFieldTypeChanged) continue;
            DataType clType = DataType.getDataTypeById(clientType);
            DataType sType = DataType.getDataTypeById(serverPart.get((int)i).type);
            logTable = (String)logTable + "\u0412 \u043f\u043e\u043b\u0435 [" + serverPart.get((int)i).fieldId + "] " + serverPart.get((int)i).name + " \u0431\u0443\u0434\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u0442\u0438\u043f. \u0411\u044b\u043b \u0442\u0438\u043f " + this.getNameType(sType) + ", \u0441\u0442\u0430\u043b " + this.getNameType(clType) + ". ";
        }
        if (!((String)logTable).isEmpty()) {
            Core.logger.info((String)logTable);
        }
    }

    private void dangerTables(ZipFile zip) throws IOException, InformException {
        for (int i = 0; i < this._importTree.tableNodes().size(); ++i) {
            this.isChangedFields(zip, (ExchangeNode)this._importTree.tableNodes().get(i));
        }
    }

    public void beforeExecute(ZipFile zip, String filePath, String mark) throws IOException, InformException, SQLException {
        this._exportReplicaId = this._importTree.exportId();
        this._pexFilePath = filePath;
        this._markFile = mark;
        this.setImportDBsCorrespondence();
        this.setDatabasesToProcess();
        this.logReplicaId();
        this.dangerTables(zip);
    }

    private boolean setupDatabases() {
        for (int i = 0; i < this._settings.importDBsCorrespondence.size(); ++i) {
            ExchangeSettings.DSCorLine line = this._settings.importDBsCorrespondence.get(i);
            if (!line.enabled) continue;
            if (line.phenixNodeId == 0.0) {
                throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445: " + line.fileNodeFullName);
            }
            this._nodesCorrespondence.put(line.fileNodeId, line.phenixNodeId);
        }
        return true;
    }

    private byte[] extractNodeAttrs(TaggedReader reader) throws IOException {
        byte[] attrs = null;
        while (reader.next()) {
            int tag = reader.getCurrentTag();
            if (tag != 2) continue;
            attrs = reader.getRaw();
        }
        return attrs;
    }

    private byte[] readNodeAttrs(InputStream is) throws IOException {
        TaggedReader contentReader = new TaggedReader(is);
        return this.extractNodeAttrs(contentReader);
    }

    private boolean dependsOnProhibitedDBs(ExchangeNode node, TaggedReader reader) throws IOException {
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 202: {
                    TaggedReader subReader = reader.getStreamReader();
                    if (!this.dependsOnProhibitedDBs(node, subReader)) break;
                    return true;
                }
                case 151: {
                    int i;
                    double dependency = reader.getDouble();
                    for (i = 0; i < this._settings.databasesToProcess.size(); ++i) {
                        if (this._settings.databasesToProcess.get((int)i).nodeId != dependency || this._settings.databasesToProcess.get((int)i).enabled) continue;
                        return true;
                    }
                    for (i = 0; i < this._settings.importDBsCorrespondence.size(); ++i) {
                        if (this._settings.importDBsCorrespondence.get((int)i).fileNodeId != dependency || this._settings.importDBsCorrespondence.get((int)i).enabled) continue;
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }

    private boolean dependsOnProhibitedDBs(ExchangeNode node, byte[] nodeContent) throws IOException {
        if (nodeContent == null) {
            return false;
        }
        TaggedReader reader = new TaggedReader(nodeContent);
        return this.dependsOnProhibitedDBs(node, reader);
    }

    private void changeNodeParent(double id, double newParentId, String newName, ExchangeNode node) throws Exception, IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        writer.putDouble(3, newParentId);
        if (newName != null) {
            writer.putString(4, newName);
        }
        if (this._exportReplicaId != 0.0) {
            writer.putDouble(29, this._exportReplicaId);
        }
        writer.flush();
        ModifyNode.modifyNode(this._ssContext, this._host, stream.toByteArray(), false, id);
    }

    private boolean canMoveNode(NodeRecord record) {
        if (record.getType() == 10 && this._createdDatabases.contains(record.getId())) {
            return true;
        }
        return this._settings.importMoveNodes;
    }

    private void createIdentifiedNode(double nodeId, double parentId, int typeId, String name, double replicaId) throws Exception {
        AddNode.AddNodeParams params = new AddNode.AddNodeParams();
        params.nodeId = nodeId;
        params.parentId = parentId;
        params.typeId = typeId;
        params.name = name;
        params.replicaId = replicaId;
        AddNode.checkParams(params, this._host);
        AddNode.addNodeImpl(params, this._host, null);
    }

    private void createNodePath(ExchangeNode node) throws Exception {
        if (node.nodeRecord().getParentId() == this._hierarchyRoot || node.nodeRecord().getParentId() == 0.0) {
            return;
        }
        ExchangeNode parentNode = this._importTree.nodes().findNode(node.nodeRecord().getParentId());
        if (parentNode != null && parentNode.moveToHierarchyRoot) {
            return;
        }
        parentNode = this._importTree.folders().findNode(node.nodeRecord().getParentId());
        if (parentNode == null) {
            throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0443\u0437\u043b\u0443 [" + node.nodeRecord().getParentId() + "] \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430\u044f \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f [" + node.nodeRecord().getId() + "]");
        }
        Node parentN = MtdEngine.getNode(node.nodeRecord().getParentId());
        if (parentN != null) {
            NodeRecord nodeParentInfo = new NodeRecord();
            parentN.getNodeRecord(nodeParentInfo);
            if (nodeParentInfo.getParentId() == 1.0) {
                this.changeNodeParent(nodeParentInfo.getId(), this._hierarchyRoot, null, node);
            }
            if (parentNode.nodeRecord().getParentId() != nodeParentInfo.getParentId() && this.canMoveNode(nodeParentInfo)) {
                this.changeNodeParent(nodeParentInfo.getId(), parentNode.nodeRecord().getParentId(), null, node);
            }
        } else {
            this.createNodePath(parentNode);
            this.createIdentifiedNode(parentNode.nodeRecord().getId(), parentNode.nodeRecord().getParentId(), parentNode.nodeRecord().getType(), parentNode.nodeRecord().getName(), this._exportReplicaId);
        }
    }

    private void ensureNodeExists(ExchangeNode node) throws Exception {
        NodeRecord nodeInfo = new NodeRecord();
        Objects.requireNonNull(this._settings);
        Node n = MtdEngine.getNode(node.nodeRecord().getId());
        if (n == null) {
            double parentId;
            if (node.moveToHierarchyRoot) {
                parentId = this._hierarchyRoot;
            } else {
                this.createNodePath(node);
                parentId = node.nodeRecord().getParentId();
            }
            this.createIdentifiedNode(node.nodeRecord().getId(), parentId, node.nodeRecord().getType(), node.nodeRecord().getName(), this._exportReplicaId);
        } else {
            double parentId;
            if (node.moveToHierarchyRoot) {
                parentId = this._hierarchyRoot;
            } else {
                this.createNodePath(node);
                parentId = node.nodeRecord().getParentId();
            }
            n.getNodeRecord(nodeInfo);
            if (nodeInfo.getParentId() != parentId && this.canMoveNode(nodeInfo)) {
                String newName = node.nodeRecord().getName();
                if (nodeInfo.getName().equals(newName)) {
                    newName = null;
                }
                this.changeNodeParent(node.nodeRecord().getId(), parentId, newName, node);
            }
        }
    }

    private void translateBuffer(int tag, TaggedWriter writer, byte[] buffer, int depth) throws IOException {
        TaggedReader subReader = new TaggedReader(buffer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(out);
        this.translateStream(subReader, subWriter, depth + 1);
        subWriter.flush();
        writer.putRaw(tag, out);
    }

    private void translateStream(TaggedReader reader, TaggedWriter writer, int depth) throws IOException {
        byte[] buffer = null;
        while (reader.next()) {
            int tag = reader.getCurrentTag();
            if (tag == 14 && depth == 0) {
                buffer = reader.getRaw();
                if (TaggedReader.containsTag(150, buffer)) {
                    this.translateBuffer(tag, writer, buffer, depth);
                    continue;
                }
                writer.putRaw(tag, buffer);
                continue;
            }
            if (tag == 202) {
                buffer = reader.getRaw();
                this.translateBuffer(tag, writer, buffer, depth);
                continue;
            }
            if (tag == 151) {
                double nodeId = reader.getDouble();
                if (this._nodesCorrespondence.containsKey(nodeId)) {
                    nodeId = this._nodesCorrespondence.get(nodeId);
                }
                writer.putDouble(151, nodeId);
                continue;
            }
            reader.transferTag(writer);
        }
    }

    private void uploadNode(ZipFile zip, ExchangeNode node, byte[] attrs, byte[] tableData) throws Throwable {
        File f = new File(this._pexFilePath);
        if (this._host.security().role() != UserRole.ADMIN) {
            AccountNode.UserInterface ui = this._host.security().getUserInterface();
            if (!ui.canUploadPex) {
                double userId = this._host.getUserID();
                String userName = MtdEngine.tryGetUserName(userId);
                throw new InformException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e " + userName + " [" + NumberConverter.doubleToString(userId) + "] \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u043f\u0435\u043a\u0441");
            }
        }
        double uploadNodeId = 0.0;
        Objects.requireNonNull(this._settings);
        uploadNodeId = node.nodeRecord().getId();
        ByteArrayOutputStream uploadContent = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(uploadContent);
        if (this._importTree.exportId() != 0.0) {
            writer.putDouble(16, this._importTree.exportId());
        }
        if (!f.getName().isEmpty()) {
            writer.putString(20, f.getName());
        }
        if (!this._settings.importMoveNodes) {
            writer.putEmpty(18);
        }
        if (attrs != null && attrs.length > 0) {
            if (node.nodeRecord().getType() == 12 || node.nodeRecord().getType() == 19 || node.nodeRecord().getType() == 49) {
                TaggedReader translatorReader = new TaggedReader(attrs);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                TaggedWriter translatorWriter = new TaggedWriter(out);
                this.translateStream(translatorReader, translatorWriter, 0);
                translatorWriter.flush();
                writer.putRaw(2, out);
            } else {
                writer.putRaw(2, attrs);
            }
        }
        if (this._settings.dataAuditAction == ExchangeSettings.DataAuditType.datAudit) {
            writer.putEmpty(14);
        }
        if (this._settings.detailedAudit) {
            writer.putEmpty(21);
        }
        if (node.nodeRecord().getType() == 12 && tableData != null) {
            if (this._settings.dataImportAction == ExchangeSettings.DataImportType.itReplace) {
                writer.putEmpty(8);
            }
            if (this._settings.dataImportAction == ExchangeSettings.DataImportType.itReplace) {
                Core.logger.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0447\u0435\u0440\u0435\u0437 pex: \u0440\u0435\u0436\u0438\u043c \u0417\u0410\u041c\u0415\u0429\u0415\u041d\u0418\u042f \u0434\u0430\u043d\u043d\u044b\u0445[" + node.nodeRecord().getName() + "] " + node.nodeRecord().getId());
            } else {
                Core.logger.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0447\u0435\u0440\u0435\u0437 pex: \u0440\u0435\u0436\u0438\u043c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445[" + node.nodeRecord().getName() + "] " + node.nodeRecord().getId());
            }
            writer.putRaw(11, tableData);
            if (node.dataEntryCount() > 1 && zip != null) {
                for (int chunkNo = 1; chunkNo < node.dataEntryCount(); ++chunkNo) {
                    String s = node.getDataEntryPath(chunkNo);
                    ZipEntry entry = zip.getEntry(s);
                    if (entry == null) continue;
                    InputStream is = zip.getInputStream(entry);
                    byte[] chunkData = this.readZipInputStreamData(is);
                    is.close();
                    if (chunkData == null) continue;
                    writer.putRaw(11, chunkData);
                }
            }
        }
        writer.flush();
        TaggedReader reader = new TaggedReader(uploadContent.toByteArray());
        UploadNodeSet upParams = new UploadNodeSet(this._ssContext, this._host, false);
        UploadNode.uploadNode(uploadNodeId, upParams, this._ssContext, this._host, reader);
    }

    private byte[] extractContent(byte[] attrs) throws IOException {
        if (attrs == null) {
            return null;
        }
        byte[] content = null;
        TaggedReader attrsReader = new TaggedReader(attrs);
        while (attrsReader.next()) {
            if (attrsReader.getCurrentTag() != 14) continue;
            content = attrsReader.getRaw();
            break;
        }
        return content;
    }

    private void importConstants(ExchangeNode node, byte[] attrs) throws Throwable {
        if (this._settings.importConstantsAction == ExchangeSettings.ImportConstantsAction.icaReplace) {
            this.uploadNode(null, node, attrs, null);
            return;
        }
        if (this._settings.importConstantsAction != ExchangeSettings.ImportConstantsAction.icaMerge) {
            return;
        }
        byte[] nodeContent = this.extractContent(attrs);
        ConstantsSet existingConstSet = new ConstantsSet();
        ConstantsSet importSet = new ConstantsSet();
        importSet.open(nodeContent);
        if (!existingConstSet.open()) {
            throw new InformException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442");
        }
        existingConstSet.merge(importSet);
        ByteArrayOutputStream newContent = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(newContent);
        existingConstSet.save(out);
        existingConstSet.setContent(this._ssContext, this._host, newContent.toByteArray(), null);
    }

    private void importEntry(ZipFile zip, ExchangeNode node) throws IOException, Exception, Throwable {
        int SERVER_VERSION_5_1 = 0x5010000;
        Core.logger.info("load [" + String.format("%.0f", node.nodeRecord().getId()) + "] " + node.nodeRecord().getName());
        String s = node.getDataEntryPath(0);
        ZipEntry dataEntry = zip.getEntry(s);
        byte[] nodeAttrs = null;
        byte[] data = null;
        VersionInfo serverVers = new VersionInfo(Core.serverVersionMajor, Core.serverVersionMajor, Core.serverVersionRelease);
        VersionInfo serverVers51 = new VersionInfo();
        serverVers51.setNumber(0x5010000L);
        if ((node.nodeRecord().getType() != 16 || serverVers.lessThen(serverVers51)) && !this.skipConflictNodes(node)) {
            ZipEntry contentEntry;
            if (!this._settings.importOnlyData && (contentEntry = zip.getEntry(node.contentEntryPath())) != null) {
                InputStream is = zip.getInputStream(contentEntry);
                nodeAttrs = this.readNodeAttrs(is);
                is.close();
            }
            if (!this.dependsOnProhibitedDBs(node, nodeAttrs)) {
                if (this._settings.dataImportAction != ExchangeSettings.DataImportType.itNone && dataEntry != null) {
                    InputStream is = zip.getInputStream(dataEntry);
                    data = this.readZipInputStreamData(is);
                    is.close();
                }
                this.ensureNodeExists(node);
                if (node.nodeRecord().getType() == 7) {
                    this.importConstants(node, nodeAttrs);
                } else {
                    this.uploadNode(zip, node, nodeAttrs, data);
                }
            }
        }
        for (int i = 0; i < node.children().size(); ++i) {
            this.importEntry(zip, (ExchangeNode)node.children().get(i));
        }
    }

    private boolean skipConflictNodes(ExchangeNode node) {
        if (!this._settings.jsSkipConflictNodes) {
            return false;
        }
        if (node == null || node.nodeRecord() == null) {
            return false;
        }
        Node n = MtdEngine.getNode(node.nodeRecord().getId());
        if (n == null) {
            return false;
        }
        NodeRecord nodeInfo = new NodeRecord();
        n.getNodeRecord(nodeInfo);
        if (nodeInfo != null && nodeInfo.getModificationContentTime() > node.nodeRecord().getModificationContentTime()) {
            this._conflictNodes.add(nodeInfo);
            return true;
        }
        return false;
    }

    private void auditImport(String note, long replicaSize, String file_path) {
        int i;
        Object comment;
        if (Ini.ReadonlyMode) {
            Core.logger.error("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!");
            return;
        }
        AuditJournal.ReplicationParams params = new AuditJournal.ReplicationParams();
        if (this._errors == null) {
            params.successfullyResult = true;
        }
        params.timeBeginOperation = this._startTime;
        params.timeEndOperation = DateTime.currentDateTime();
        params.replicaId = this._importTree.exportId();
        params.opCode = 3;
        params.replNodeId = 2.0;
        params.replicaSize = replicaSize;
        if (file_path != null && !file_path.isEmpty()) {
            File f = new File(file_path);
            params.fileName = f.getName();
        }
        params.note = note;
        if (this._errors == null) {
            comment = this._settings.fileComment;
        } else {
            String comma = "\n";
            StringBuilder text = new StringBuilder("\u0423\u0437\u043b\u044b ");
            text.append(comma).append("\u041e\u0448\u0438\u0431\u043a\u0438: ");
            for (i = 0; i < this._errors.size(); ++i) {
                text.append(comma).append(this._errors.get((int)i).details);
            }
            comment = text.toString();
        }
        if (!this._conflictNodes.isEmpty()) {
            Object message = "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u044b \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u043d\u044b\u0435 \u0443\u0437\u043b\u044b:\n";
            boolean oneNode = true;
            for (i = 0; i < this._conflictNodes.size(); ++i) {
                NodeRecord nr = this._conflictNodes.get(i);
                if (nr == null) continue;
                if (!oneNode) {
                    message = (String)message + "\n";
                }
                message = (String)message + "[" + String.format("%.0f", nr.getId()) + "] " + nr.getName();
                oneNode = false;
            }
            if (!((String)comment).isEmpty()) {
                comment = (String)comment + "\n";
            }
            comment = (String)comment + (String)message;
            if (!this._warnings.isEmpty()) {
                this._warnings = this._warnings + "\n";
            }
            this._warnings = this._warnings + (String)message;
        }
        StringBuilder msg = new StringBuilder();
        if (file_path != null && !file_path.isEmpty()) {
            if (!params.successfullyResult) {
                msg.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430");
            }
        } else {
            msg.append("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0438\u0437 \u0431\u043b\u043e\u0431\u0430");
        }
        if (!((String)comment).isEmpty()) {
            if (msg.length() > 0) {
                msg.append("\n");
            }
            msg.append((String)comment);
        }
        params.resultMessage = msg.toString();
        params.userNodeId = this._host.getUserID();
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.REPLICATION);
        this._auditRecordId = journal.registerReplication(this._ssContext, params);
    }

    private String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is, "Cp1251").useDelimiter("\\A");
        String res = s.hasNext() ? s.next() : "";
        s.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(ZipFile zip, long replicaSize) throws IOException, Throwable {
        this._startTime = DateTime.currentDateTime();
        String note = this._settings.fileComment;
        try {
            try {
                this.setupDatabases();
                if (this._importTree.nodes().isEmpty()) {
                    throw new NegativeArraySizeException("\u041d\u0435\u0442 \u0443\u0437\u043b\u043e\u0432 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
                }
                for (int i = 0; i < this._importTree.rootNodes().size(); ++i) {
                    this.importEntry(zip, (ExchangeNode)this._importTree.rootNodes().get(i));
                }
            }
            catch (Throwable e) {
                StringBuilder detailing = new StringBuilder();
                StringBuilder callstack = new StringBuilder();
                String errorMessage = Exceptions.toString(e, detailing, callstack);
                String fullError = errorMessage + "\nDetails:\n" + detailing + "\nStack trace:\n" + callstack;
                Core.logger.error("PexImportProcess: error in doExecute:\n" + fullError);
                if (this._errors == null) {
                    this._errors = new ArrayList();
                }
                ExchangeError er = new ExchangeError();
                er.details = fullError;
                this._errors.add(er);
            }
            ZipEntry noteEntry = zip.getEntry("readme.txt");
            if (noteEntry != null) {
                InputStream is = zip.getInputStream(noteEntry);
                note = this.convertStreamToString(is);
                is.close();
            }
        }
        finally {
            String infoPath = this._pexFilePath;
            if (infoPath == null || infoPath.isEmpty()) {
                infoPath = this._markFile;
            }
            this.auditImport(note, replicaSize, infoPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readZipInputStreamData(InputStream is) throws IOException {
        byte[] data = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int n = 0;
        byte[] buf = new byte[4096];
        try {
            while ((n = is.read(buf)) > -1) {
                output.write(buf, 0, n);
            }
            data = output.toByteArray();
        }
        finally {
            output.close();
        }
        return data;
    }

    private static class TableFieldPart {
        int fieldId;
        int type = -1;
        String name = null;

        private TableFieldPart() {
        }
    }

    private static class ExchangeError {
        public String details;

        private ExchangeError() {
        }
    }
}

