/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.agent.expr.AbstractEvaluator;
import inform.agent.expr.Expression;
import inform.agent.expr.OperationTerm;
import inform.agent.expr.SymbolTerm;
import inform.agent.expr.Term;
import inform.agent.scripts.sql.expr.QueryFieldTerm;
import java.util.ArrayList;

public class ConditionBlockTerm
extends Term {
    private final ArrayList<Term> items = new ArrayList(3);
    private OperationTerm andOperation = null;
    private SymbolTerm braceOperation = null;
    private int operationId;
    private int operationRangeId;

    public ConditionBlockTerm(int id, Expression expr) {
        super(expr);
        this.id = id;
    }

    @Override
    public Expression.Token getToken() {
        return Expression.Token.conditionBlock;
    }

    @Override
    public Expression.Priority getPriority() {
        return Expression.Priority.COMPARE;
    }

    @Override
    public void afterLoad() {
        for (Term t : this.items) {
            t.afterLoad();
        }
    }

    @Override
    public Term createClone(Expression e) {
        return null;
    }

    public int getOperationId() {
        return this.operationId;
    }

    public void setOperationId(int operationId) {
        this.operationId = operationId;
    }

    public int getOperationRangeId() {
        return this.operationRangeId;
    }

    public void setOperationRangeId(int operationRangeId) {
        this.operationRangeId = operationRangeId;
    }

    public void addTerm(Term term) {
        if (term instanceof OperationTerm) {
            ((OperationTerm)term).setRangeId(this.operationRangeId);
        }
        this.items.add(term);
    }

    public AbstractEvaluator createEvaluator() {
        Object evaluator;
        switch (this.operationId) {
            case 18: 
            case 19: {
                Object a1 = this.expression.createEvaluator(this.items.get(0));
                Object a2 = this.expression.createEvaluator(this.items.get(4));
                Object f = this.expression.createEvaluator(this.items.get(2));
                OperationTerm op1 = (OperationTerm)this.items.get(1);
                OperationTerm op2 = (OperationTerm)this.items.get(3);
                op1.setRangeId(this.operationRangeId);
                op2.setRangeId(this.operationRangeId);
                Object c1 = this.expression.createEvaluator(this.items.get(1), f, a1);
                f = this.expression.createEvaluator(this.items.get(2));
                Object c2 = this.expression.createEvaluator(this.items.get(3), f, a2);
                if (this.andOperation == null) {
                    this.andOperation = new OperationTerm(10, this.expression);
                    this.braceOperation = new SymbolTerm(this.expression, 0);
                }
                evaluator = this.expression.createEvaluator(this.andOperation, c1, c2);
                evaluator = this.expression.createEvaluator(this.braceOperation, evaluator);
                break;
            }
            default: {
                Object f = this.expression.createEvaluator(this.items.get(0));
                Object a = this.expression.createEvaluator(this.items.get(2));
                OperationTerm operationTerm = (OperationTerm)this.items.get(1);
                if (this.operationRangeId != 0) {
                    operationTerm.setRangeId(this.operationRangeId);
                }
                evaluator = this.expression.createEvaluator(operationTerm, f, a);
            }
        }
        return evaluator;
    }

    public void replaceDatasourceID(int id) {
        for (Term t : this.items) {
            if (!(t instanceof QueryFieldTerm)) continue;
            ((QueryFieldTerm)t).replaceDatasourceID(id);
        }
    }
}

