/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.expr.AbstractEvaluator;
import inform.agent.expr.ConditionBlockTerm;
import inform.agent.expr.ConstantTerm;
import inform.agent.expr.DatasourcePropertyTerm;
import inform.agent.expr.FieldTerm;
import inform.agent.expr.FunctionTerm;
import inform.agent.expr.OperationTerm;
import inform.agent.expr.ParameterTerm;
import inform.agent.expr.SymbolTerm;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.Constant;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import org.mozilla.javascript.Scriptable;

public abstract class Expression<Evaluator extends AbstractEvaluator>
extends SmartScriptableObject {
    protected final ArrayList<Term> expr = new ArrayList();
    protected static final int eekField = 1;
    protected static final int eekConst = 2;
    protected static final int eekGlobalConst = 3;
    protected static final int eekParam = 4;
    protected static final int eekFunc = 5;
    protected static final int eekOperation = 6;
    protected static final int eekSymbol = 7;
    protected static final int eekDecor = 8;
    protected static final int eekInline = 9;
    protected static final int eekDsProp = 10;
    private static final int TAG_ELEMENT_TYPE = 1;
    private static final int TAG_ELEMENT_CONDITION_BLOCK = 2;
    private static final int TAG_ELEMENT_CONDITION_BLOCK_OP = 3;
    private static final int TAG_ELEMENT_CONDITION_BLOCK_END = 4;
    private static final int TAG_ELEMENT_CONDITION_BLOCK_RANGE = 6;
    protected static final OperationTerm nopOperation = new OperationTerm(-1, null);

    public Expression(Scriptable scope) {
        if (scope != null) {
            this.setParentScope(scope);
        }
    }

    public abstract Constants getConstants();

    public abstract ParametersList getParameters();

    public abstract Evaluator createIgnored();

    public abstract Evaluator createNOP(Evaluator var1, Evaluator var2);

    public abstract Evaluator createEvaluator(Term var1);

    public abstract Evaluator createEvaluator(Term var1, Evaluator var2);

    public abstract Evaluator createEvaluator(Term var1, Evaluator var2, Evaluator var3);

    protected Term createTerm(int termType) {
        switch (termType) {
            case 1: {
                return new FieldTerm(this);
            }
            case 9: {
                throw new IllegalStateException();
            }
            case 2: {
                return new ValueTerm(this);
            }
            case 3: {
                return new ConstantTerm(this);
            }
            case 4: {
                return new ParameterTerm(this);
            }
            case 5: {
                return new FunctionTerm(this);
            }
            case 6: {
                return new OperationTerm(this);
            }
            case 7: {
                return new SymbolTerm(this);
            }
            case 8: {
                return null;
            }
            case 10: {
                return new DatasourcePropertyTerm(this);
            }
        }
        throw new IllegalStateException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f (term: " + termType + ")");
    }

    public void load(TaggedReader in) throws IOException {
        ConditionBlockTerm block = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    int termId = in.getInt();
                    Term term = this.createTerm(termId);
                    if (term != null) {
                        TaggedReader termReader = in.getStreamReader(202);
                        term.load(termReader);
                        if (block != null) {
                            block.addTerm(term);
                            break;
                        }
                        this.expr.add(term);
                        break;
                    }
                    in.skip();
                    break;
                }
                case 2: {
                    block = new ConditionBlockTerm(in.getInt(), this);
                    this.expr.add(block);
                    break;
                }
                case 3: {
                    if (block == null) break;
                    block.setOperationId(in.getInt());
                    break;
                }
                case 6: {
                    if (block == null) break;
                    block.setOperationRangeId(in.getInt());
                    break;
                }
                case 4: {
                    block = null;
                }
            }
        }
    }

    public void afterLoad() {
        for (Term term : this.expr) {
            term.afterLoad();
        }
    }

    public boolean hasBindedData() {
        for (Term term : this.expr) {
            if (!(term instanceof FieldTerm)) continue;
            return true;
        }
        return false;
    }

    public Term addValue(Term term, DataType type, Object value) throws IOException {
        int index = this.expr.indexOf(term);
        ValueTerm valueTerm = (ValueTerm)this.createTerm(2);
        valueTerm.setValue(type, value);
        this.expr.add(index, valueTerm);
        return valueTerm;
    }

    protected Term createObjectArg(Term term, Object arg) throws Exception {
        if (arg instanceof Parameter) {
            Parameter parameter = (Parameter)arg;
            ParameterTerm parameterTerm = new ParameterTerm(this);
            parameterTerm.setParameter(parameter);
            int index = this.expr.indexOf(term);
            this.expr.add(index, parameterTerm);
            return parameterTerm;
        }
        if (arg instanceof Constant) {
            Constant constant = (Constant)arg;
            ConstantTerm constantTerm = new ConstantTerm(this);
            constantTerm.setConstant(constant);
            int index = this.expr.indexOf(term);
            this.expr.add(index, constantTerm);
            return constantTerm;
        }
        return null;
    }

    @Override
    public Object get(String name, Scriptable start) {
        for (Term t : this.expr) {
            if (!name.equals(t.getName())) continue;
            return t;
        }
        return super.get(name, start);
    }

    public Term createOperator(Term term, String op) throws IOException {
        int index = this.expr.indexOf(term);
        OperationTerm opTerm = null;
        if ("+".equals(op)) {
            opTerm = new OperationTerm(0, this);
        } else if ("-".equals(op)) {
            opTerm = new OperationTerm(1, this);
        } else if ("*".equals(op)) {
            opTerm = new OperationTerm(2, this);
        } else if ("/".equals(op)) {
            opTerm = new OperationTerm(3, this);
        } else if ("%".equals(op)) {
            opTerm = new OperationTerm(4, this);
        } else if ("<".equals(op)) {
            opTerm = new OperationTerm(5, this);
        } else if ("<=".equals(op)) {
            opTerm = new OperationTerm(6, this);
        } else if (">".equals(op)) {
            opTerm = new OperationTerm(7, this);
        } else if (">=".equals(op)) {
            opTerm = new OperationTerm(8, this);
        } else if ("=".equals(op)) {
            opTerm = new OperationTerm(9, this);
        } else if ("&&".equals(op)) {
            opTerm = new OperationTerm(10, this);
        } else if ("||".equals(op)) {
            opTerm = new OperationTerm(11, this);
        } else if ("!".equals(op)) {
            opTerm = new OperationTerm(12, this);
        } else if ("!=".equals(op)) {
            opTerm = new OperationTerm(13, this);
        } else if ("@".equals(op)) {
            opTerm = new OperationTerm(14, this);
        }
        if (opTerm != null) {
            this.expr.add(index, opTerm);
        }
        return opTerm;
    }

    public Evaluator compile() {
        if (this.expr.isEmpty()) {
            return null;
        }
        Parser it = new Parser(this.expr);
        if (it.current == null) {
            return null;
        }
        return this.compileOr(it);
    }

    public Evaluator compile(Parser it) {
        return this.compileOr(it);
    }

    protected Evaluator compileOr(Parser it) {
        Evaluator result = this.compileAnd(it);
        if (result == null) {
            return null;
        }
        while (it.hasNext()) {
            Term term = it.current;
            if (term == null || term.getPriority() != Priority.OR) {
                return result;
            }
            it.next();
            Evaluator right = this.compileAnd(it);
            if (right == null) {
                return result;
            }
            result = this.createEvaluator(term, result, right);
        }
        return result;
    }

    protected Evaluator compileAnd(Parser it) {
        Evaluator result = this.compileNot(it);
        if (result == null) {
            return null;
        }
        while (it.hasNext()) {
            Term term = it.current;
            if (term == null || term.getPriority() != Priority.AND) {
                return result;
            }
            it.next();
            Evaluator right = this.compileNot(it);
            if (right == null) {
                return result;
            }
            result = this.createEvaluator(term, result, right);
        }
        return result;
    }

    protected Evaluator compileNot(Parser it) {
        Term term = it.current;
        if (term == null || term.getPriority() != Priority.NOT) {
            return this.compileCompare(it);
        }
        it.next();
        Evaluator result = this.compileNot(it);
        if (result == null) {
            return null;
        }
        result = this.createEvaluator(term, result);
        return result;
    }

    protected Evaluator compileCompare(Parser it) {
        Evaluator result = this.compileAddSub(it);
        if (result == null) {
            return null;
        }
        while (it.hasNext()) {
            Term term = it.current;
            if (term == null || term.getPriority() != Priority.COMPARE) {
                return result;
            }
            it.next();
            Evaluator right = this.compileAddSub(it);
            if (right == null) {
                return result;
            }
            result = this.createEvaluator(term, result, right);
        }
        return result;
    }

    protected Evaluator compileAddSub(Parser it) {
        Evaluator result = this.compileMulDiv(it);
        if (result == null) {
            return null;
        }
        while (it.hasNext()) {
            Term term = it.current;
            if (term == null || term.getPriority() != Priority.ADD) {
                return result;
            }
            it.next();
            Evaluator right = this.compileMulDiv(it);
            if (right == null) {
                return result;
            }
            result = this.createEvaluator(term, result, right);
        }
        return result;
    }

    protected Evaluator compileMulDiv(Parser it) {
        Evaluator result = this.compileToken(it);
        if (result == null) {
            return null;
        }
        while (it.hasNext()) {
            Term term = it.current;
            if (term == null || term.getPriority() != Priority.MUL) {
                return result;
            }
            it.next();
            Evaluator right = this.compileToken(it);
            if (right == null) {
                return result;
            }
            result = this.createEvaluator(term, result, right);
        }
        return result;
    }

    protected Evaluator compileToken(Parser it) {
        Term term = it.current;
        block10: while (term != null) {
            switch (term.getPriority()) {
                case FUNCTION: {
                    Evaluator function = this.createEvaluator(term);
                    term = it.next();
                    if (term == null || term.getToken() != Token.openBrace) {
                        throw new InformException("\u0412 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0430\u044f \u0441\u043a\u043e\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u0434 \u0444\u0443\u043d\u043a\u0446\u0438\u0435\u0439");
                    }
                    term = it.next();
                    while (true) {
                        Evaluator evaluator;
                        if ((evaluator = this.compileOr(it)) == null) {
                            if (it.current == null) {
                                throw new InformException("\u0412 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0430\u044f \u0441\u043a\u043e\u0431\u043a\u0430");
                            }
                            if (it.current.getToken() == Token.closeBrace) break;
                            if (it.current.getToken() == Token.comma) {
                                it.next();
                                continue;
                            }
                            throw new InformException("\u0412 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0430\u044f \u0441\u043a\u043e\u0431\u043a\u0430");
                        }
                        ((AbstractEvaluator)function).addArgument((AbstractEvaluator)evaluator);
                    }
                    it.next();
                    return this.compileInline(function, it);
                }
                case OPERAND: {
                    it.next();
                    Evaluator evaluator = this.createEvaluator(term);
                    return this.compileInline(evaluator, it);
                }
            }
            switch (term.getToken()) {
                case add: {
                    term = it.next();
                    continue block10;
                }
                case sub: {
                    it.next();
                    Evaluator evaluator = this.compileToken(it);
                    if (evaluator == null) {
                        return null;
                    }
                    return this.createEvaluator(term, evaluator);
                }
                case openBrace: {
                    it.next();
                    Evaluator evaluator = this.compileOr(it);
                    if (it.current == null || it.current.getToken() != Token.closeBrace) {
                        throw new InformException("\u0412 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u043e\u0442\u0441\u0443\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0430\u044f \u0441\u043a\u043e\u0431\u043a\u0430");
                    }
                    it.next();
                    evaluator = evaluator == null || term.isIgnored() ? this.createIgnored() : this.createEvaluator(term, evaluator);
                    return this.compileInline(evaluator, it);
                }
                case inline: {
                    Evaluator evaluator;
                    it.next();
                    if (it.current == null || it.current instanceof OperationTerm) {
                        evaluator = this.createEvaluator(term);
                    } else {
                        Evaluator left = this.createEvaluator(term);
                        Evaluator right = this.compileToken(it);
                        evaluator = this.createNOP(left, right);
                    }
                    return this.compileInline(evaluator, it);
                }
            }
            return null;
        }
        return null;
    }

    protected Evaluator compileInline(Evaluator evaluator, Parser it) {
        while (it.current != null && it.current.getToken() == Token.inline) {
            Evaluator right = this.createEvaluator(it.current);
            evaluator = this.createNOP(evaluator, right);
            it.next();
            if (it.current == null || it.current.getToken() == Token.inline) continue;
            if (it.current instanceof OperationTerm || (right = this.compileToken(it)) == null) break;
            evaluator = this.createNOP(evaluator, right);
        }
        return evaluator;
    }

    protected static class Parser {
        final ArrayList<Term> expr;
        final ListIterator<Term> it;
        public Term current;

        public Parser(ArrayList<Term> expr) {
            this.expr = expr;
            this.it = this.expr.listIterator();
            this.next();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Term next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            return this.current;
        }
    }

    public static enum Token {
        invalid,
        skip,
        nop,
        or,
        and,
        not,
        equal,
        notEqual,
        less,
        lessEqual,
        greater,
        greaterEqual,
        like,
        notLike,
        startWith,
        notStartWith,
        fastFilter,
        conditionBlock,
        add,
        sub,
        mul,
        div,
        mod,
        inline,
        openBrace,
        closeBrace,
        comma,
        field,
        globalConst,
        param,
        value,
        functionAbs,
        functionTrim,
        functionRoundTo,
        functionTrunc,
        functionToNumber,
        functionNumberToString,
        functionMax,
        functionMin,
        functionRegexpSubstr,
        functionAddSeparators,
        functionDateOf,
        functionDaysBetween,
        functionMonthsBetween,
        functionAddMonths,
        functionAddDays,
        functionToDate,
        functionTruncDateYear,
        functionTruncDateMonth,
        functionTruncDateQuarter,
        functionTruncDateHour,
        functionTruncDateWeek,
        functionDayOf,
        functionMonthOf,
        functionQuarterOf,
        functionYearOf,
        functionHourOf,
        functionMinuteOf,
        functionSecondOf,
        functionNVL,
        functionBlobSize,
        functionCase,
        functionWhen,
        functionExists,
        functionPrior,
        functionAgrSum,
        functionAgrAvg,
        functionAgrCount,
        functionAgrCountAll,
        functionAgrMin,
        functionAgrMax,
        datasourceProperty,
        functionDateValue,
        functionMonthEndDate;

    }

    public static enum Priority {
        NONE,
        OR,
        AND,
        NOT,
        COMPARE,
        ADD,
        MUL,
        OPERAND,
        FUNCTION;

    }
}

