/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.files;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.ReadOnDemandFileInputStream;
import inform.adt.Strings;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.Hashing;
import inform.agent.BinFileName;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.files.FileHardLink;
import inform.agent.scripts.SSContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BFS {
    private static final int HASH_SIZE = 809;
    public static final long FILE_OBSOLETE_INTERVAL = 86400000L;
    public static final long UPLOAD_OBSOLETE_INTERVAL = 259200000L;
    public static final String BFS_EXT = ".blob";
    public static final String ERROR_ABSENT_BLOB_FILE = "\u0412 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0431\u043b\u043e\u0431-\u0444\u0430\u0439\u043b ";
    public static boolean useHardLink = true;
    private static final int IN_COUNT_LIMIT = 1000;
    private static final int DIAGNOSTIC_SEND_LIMIT = 100000;
    public static final int TAG_FILE_SIZE = 1;
    public static final int TAG_CHUNK_SIZE = 2;
    public static final int TAG_HASHSUM = 3;
    public static final int TAG_FIELD_ID = 4;
    public static final int TAG_CHUNKHASH = 5;
    public static final int TAG_CHUNK = 6;
    public static final int TAG_CHUNK_OFFSET = 7;
    public static final int TAG_RECORD_ID = 8;
    public static final int TAG_GETALLCHUNKS = 9;
    public static final int TAG_CHUNK_DATA = 10;
    public static final int TAG_PROGRESS = 11;
    private static final int PATH_STD = 1;
    private static final int PATH_HASHING_ALL = 2;
    private static final int PATH_HASHING_TABLE = 4;
    private static final int PATH_HASHING_FIELD = 8;
    private static final int PATH_IS_HASHING = 14;
    private ArrayList<String> commits = null;
    private ArrayList<String> rollbacks = null;
    private HashMap<String, String> fixedFiles = null;

    public static void checkBlobFSField(TableDescriptor table, FieldDescriptor field) {
        String mountPoint = field.getBlobFS();
        if (Strings.isVoid(mountPoint)) {
            String msg = "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u043c\u0435\u0441\u0442\u043e \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0431\u043b\u043e\u0431 \u0444\u0430\u0439\u043b\u043e\u0432( \u0442\u0430\u0431\u043b\u0438\u0446\u0430: " + table.getCaption() + " [" + NumberConverter.doubleToString(table.getNodeId()) + "],  \u043f\u043e\u043b\u0435: " + field.getCaption() + "[" + field.getId() + "]";
            throw new InformException(msg);
        }
        if (!Core.blobfs.hasMountPoint(mountPoint)) {
            String msg = "\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043c\u0435\u0441\u0442\u043e \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0431\u043b\u043e\u0431 \u0444\u0430\u0439\u043b\u043e\u0432 " + mountPoint + "( \u0442\u0430\u0431\u043b\u0438\u0446\u0430: " + table.getCaption() + " [" + NumberConverter.doubleToString(table.getNodeId()) + "],  \u043f\u043e\u043b\u0435: " + field.getCaption() + "[" + field.getId() + "]";
            throw new InformException(msg);
        }
    }

    public String insert(double tableId, FieldDescriptor fieldDescriptor, double recordId, byte[] content) throws IOException {
        String point = fieldDescriptor.getBlobFS();
        String blobPoint = BFS.createBlob(point, tableId, fieldDescriptor, recordId, content);
        if (!Strings.isVoid(blobPoint)) {
            String blobPath = point + ":/" + blobPoint;
            if (!BFS.isHashingPath(blobPoint)) {
                this.addRollback(blobPath);
            }
        }
        return blobPoint;
    }

    public String modify(String oldBlobPoint, double tableId, FieldDescriptor fieldDescriptor, double recordId, byte[] content) throws IOException {
        String point = fieldDescriptor.getBlobFS();
        String blobPoint = BFS.createBlob(point, tableId, fieldDescriptor, recordId, content);
        if (!Strings.isVoid(blobPoint) && !BFS.isHashingPath(blobPoint)) {
            this.addRollback(point + ":/" + blobPoint);
        }
        if (!Strings.isVoid(oldBlobPoint) && !BFS.isHashingPath(oldBlobPoint)) {
            this.addCommit(point + ":/" + oldBlobPoint);
        }
        return blobPoint;
    }

    public String modify(SSContext ssContext, DatabaseConnection databaseConnection, double recordId, TableDescriptor table, FieldDescriptor field, byte[] content) throws IOException, SQLException {
        this.delete(ssContext, databaseConnection, table, field, recordId);
        if (content != null && content.length != 0) {
            return this.insert(table.getNodeId(), field, recordId, content);
        }
        return null;
    }

    private static void createFolders(File path, String mountPoint) {
        if (path.exists()) {
            return;
        }
        Core.blobfs.checkNFSMounted(mountPoint);
        if (!path.mkdirs()) {
            Core.logger.error("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443 '" + path.getAbsolutePath() + "\"");
        }
    }

    public String upload(SSContext ssContext, ServerSideHost host, DatabaseConnection databaseConnection, boolean modify, double recordId, TableDescriptor table, FieldDescriptor field, byte[] digest) throws IOException, SQLException {
        String openMode;
        boolean needFix;
        MessageDigest md;
        if (BFS.isStorageContainsHashedBlob(host, table, field, digest)) {
            return BFS.digestToBlobPath(table, field, digest);
        }
        if (modify) {
            this.delete(ssContext, databaseConnection, table, field, recordId);
        }
        if (host != null) {
            host.idle();
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw InformException.wrap(e);
        }
        String tempPath = field.getBlobFS() + ":/" + BFS.getFullTempPath(table, field, digest);
        String sourceFile = Core.blobfs.resolvePath(tempPath);
        String fixFilePath = sourceFile + BFS_EXT;
        File uploadedFilePath = new File(sourceFile + BFS_EXT);
        boolean bl = needFix = !uploadedFilePath.exists();
        if (needFix) {
            openMode = "rw";
            uploadedFilePath = new File(sourceFile);
        } else {
            openMode = "r";
        }
        try (RandomAccessFile uploadedFile = new RandomAccessFile(uploadedFilePath, openMode);){
            boolean checkHash = true;
            if (!field.isHashedBlobFs() && useHardLink && this.fixedFiles != null && this.fixedFiles.containsKey(fixFilePath)) {
                checkHash = false;
            }
            if (checkHash) {
                md.reset();
                byte[] chunk = new byte[0x100000];
                while (true) {
                    int size;
                    if (host != null) {
                        host.idle();
                    }
                    if ((size = uploadedFile.read(chunk)) < 0) break;
                    if (size == 0) continue;
                    md.update(chunk, 0, size);
                }
                byte[] uploadedDigest = md.digest();
                if (!Arrays.equals(digest, uploadedDigest)) {
                    throw new BFSException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0431\u043b\u043e\u0431-\u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0439", sourceFile).detail(tempPath);
                }
            }
            String digestText = field.isHashedBlobFs() ? Strings.bytes2hex(digest) : null;
            String name = BFS.getBlobFileName(recordId, digestText);
            Object blobPoint = name;
            StringBuilder blobPointBuilder = new StringBuilder();
            BFS.getBlobPath(blobPointBuilder, table.getNodeId(), field, recordId, digestText);
            String mountPoint = field.getBlobFS();
            File path = new File(Core.blobfs.resolvePath(mountPoint + ":/" + blobPointBuilder));
            BFS.createFolders(path, mountPoint);
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                if (host != null) {
                    host.idle();
                }
                File file = new File(path, (String)blobPoint + BFS_EXT);
                if (field.isHashedBlobFs()) {
                    blobPointBuilder.append('/').append((String)blobPoint).append(BFS_EXT);
                    uploadedFile.close();
                    if (!file.exists()) {
                        Files.move(uploadedFilePath.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    }
                    String string = blobPointBuilder.toString();
                    return string;
                }
                if (!file.exists()) {
                    blobPointBuilder.append('/').append((String)blobPoint).append(BFS_EXT);
                    String result = blobPointBuilder.toString();
                    String blobPath = field.getBlobFS() + ":/" + result;
                    this.addRollback(blobPath);
                    if (useHardLink) {
                        if (this.fixedFiles == null) {
                            this.fixedFiles = new HashMap();
                        }
                        this.fixedFiles.put(fixFilePath, fixFilePath);
                        File fixFile = new File(fixFilePath);
                        uploadedFile.close();
                        if (needFix) {
                            BFS.deleteFile(fixFile);
                            uploadedFilePath.renameTo(fixFile);
                        }
                        FileHardLink.createHardLink(file.getAbsolutePath(), fixFile.getAbsolutePath());
                    } else {
                        uploadedFile.close();
                        uploadedFilePath.renameTo(file);
                    }
                    uploadedFilePath.setReadOnly();
                    String string = result;
                    return string;
                }
                blobPoint = name + "_" + i;
            }
        }
        return null;
    }

    private String replicate(SSContext ssContext, ServerSideHost host, DatabaseConnection databaseConnection, boolean modify, double recordId, TableDescriptor table, FieldDescriptor field, File uploadedPath, RandomAccessFile uploadedFile, String digestText) throws IOException, SQLException {
        if (modify) {
            this.delete(ssContext, databaseConnection, table, field, recordId);
        }
        if (host != null) {
            host.idle();
        }
        String name = BFS.getBlobFileName(recordId, digestText);
        StringBuilder blobPointBuilder = new StringBuilder();
        BFS.getBlobPath(blobPointBuilder, table.getNodeId(), field, recordId, digestText);
        String blobPointPath = blobPointBuilder.toString();
        String mountPoint = field.getBlobFS();
        File path = new File(Core.blobfs.resolvePath(mountPoint + ":/" + blobPointPath));
        BFS.createFolders(path, mountPoint);
        Object blobPoint = name;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (host != null) {
                host.idle();
            }
            File file = new File(path, (String)blobPoint + BFS_EXT);
            if (field.isHashedBlobFs()) {
                String result = blobPointPath + "/" + (String)blobPoint + BFS_EXT;
                if (!file.exists()) {
                    uploadedFile.close();
                    uploadedPath.renameTo(file);
                    uploadedPath.setReadOnly();
                }
                return result;
            }
            if (!file.exists()) {
                String result = blobPointPath + "/" + (String)blobPoint + BFS_EXT;
                String blobPath = field.getBlobFS() + ":/" + result;
                this.addRollback(blobPath);
                uploadedFile.close();
                uploadedPath.renameTo(file);
                uploadedPath.setReadOnly();
                return result;
            }
            blobPoint = name + "_" + i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SSContext ssContext, DatabaseConnection connection, TableDescriptor table, double recordId) throws SQLException {
        if (!table.isHasBlobFile()) {
            return;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select");
        int comma = 32;
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        for (FieldDescriptor field : table.getFields()) {
            if (field.getType() != DataType.FILE || Strings.isVoid(field.getBlobFS())) continue;
            fields.add(field);
            sql.append((char)comma).append(field);
            comma = 44;
        }
        sql.append(" from ").appendFull(table).append(" T where T.").append(table.getRecordIdField()).append("=?");
        try (PreparedStatement statement = connection.prepareStatement("BFS.delete record blobs", sql.toString());){
            statement.setDouble(1, recordId);
            try (ResultSet fetch = statement.executeQuery(ssContext);){
                while (fetch.next()) {
                    int index = 1;
                    for (FieldDescriptor field : fields) {
                        String blobPoint;
                        if (Strings.isVoid(blobPoint = fetch.getString(index++)) || fetch.wasNull() || BFS.isHashingPath(blobPoint)) continue;
                        this.addCommit(field.getBlobFS() + ":/" + blobPoint);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String selectBlobPath(SSContext ssContext, DatabaseConnection connection, TableDescriptor table, FieldDescriptor field, double recordId) throws SQLException {
        if (!table.isHasBlobFile()) {
            return null;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select ").append(field);
        sql.append(" from ").appendFull(table).append(" T where T.").append(table.getRecordIdField()).append("=?");
        try (PreparedStatement statement = connection.prepareStatement("BFS.delete record blobs", sql.toString());){
            statement.setDouble(1, recordId);
            try (ResultSet fetch = statement.executeQuery(ssContext);){
                if (fetch.next()) {
                    String blobPoint = fetch.getString(1);
                    if (!Strings.isVoid(blobPoint) && !fetch.wasNull()) {
                        String string = blobPoint;
                        return string;
                    }
                    String string = null;
                    return string;
                }
            }
        }
        return null;
    }

    public void delete(SSContext ssContext, DatabaseConnection connection, TableDescriptor table, FieldDescriptor field, double recordId) throws SQLException {
        String blobPoint = BFS.selectBlobPath(ssContext, connection, table, field, recordId);
        if (!Strings.isVoid(blobPoint) && !BFS.isHashingPath(blobPoint)) {
            this.addCommit(field.getBlobFS() + ":/" + blobPoint);
        }
    }

    public void commit() {
        this.apply(this.commits, this.rollbacks);
        this.commits = null;
        this.rollbacks = null;
    }

    public void rollback() {
        this.apply(this.rollbacks, this.commits);
        this.commits = null;
        this.rollbacks = null;
    }

    public static String getResolvedFilePath(FieldDescriptor fieldDescriptor, String blobPath) {
        return Core.blobfs.resolvePath(fieldDescriptor.getBlobFS() + ":/" + blobPath);
    }

    public static InputStream getFileStream(FieldDescriptor fieldDescriptor, String blobPath) throws FileNotFoundException {
        String mountPoint = fieldDescriptor.getBlobFS() + ":/" + blobPath;
        String filePath = Core.blobfs.resolvePath(mountPoint);
        File file = new File(filePath);
        if (file.exists()) {
            return new ReadOnDemandFileInputStream(mountPoint, file);
        }
        throw new BFSException(ERROR_ABSENT_BLOB_FILE + mountPoint, filePath);
    }

    public static byte[] getFileBytes(FieldDescriptor fieldDescriptor, String blobPath) throws IOException {
        String mountPoint = fieldDescriptor.getBlobFS() + ":/" + blobPath;
        String filePath = Core.blobfs.resolvePath(mountPoint);
        File file = new File(filePath);
        if (file.exists()) {
            byte[] bytes = new byte[(int)file.length()];
            try (FileInputStream inputStream = new FileInputStream(file);){
                int ln = ((InputStream)inputStream).read(bytes);
                if (ln != bytes.length) {
                    throw new BFSException("\u0420\u0430\u0437\u043c\u0435\u0440 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0444\u0430\u0439\u043b\u043e\u043c " + ln + " " + bytes.length + " " + mountPoint, filePath);
                }
            }
            return bytes;
        }
        throw new BFSException(ERROR_ABSENT_BLOB_FILE + mountPoint, filePath);
    }

    public static long getFileSize(FieldDescriptor fieldDescriptor, String blobPath, int defaultSize) throws IOException {
        if (Strings.isVoid(blobPath)) {
            return 0L;
        }
        String mountPoint = fieldDescriptor.getBlobFS() + ":/" + blobPath;
        String filePath = Core.blobfs.resolvePath(mountPoint);
        File file = new File(filePath);
        if (file.exists()) {
            return file.length();
        }
        if (defaultSize != 0) {
            return defaultSize;
        }
        throw new BFSException(ERROR_ABSENT_BLOB_FILE + mountPoint, filePath);
    }

    public static long getFileSize(FieldDescriptor fieldDescriptor, String blobPath) throws IOException {
        return BFS.getFileSize(fieldDescriptor, blobPath, 0);
    }

    private void apply(ArrayList<String> list, ArrayList<String> skipList) {
        if (list == null) {
            return;
        }
        for (String bp : list) {
            boolean skip = false;
            if (skipList != null) {
                for (String s : skipList) {
                    if (!s.equals(bp)) continue;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            File file = new File(Core.blobfs.resolvePath(bp));
            BFS.deleteFileSilent(file, "BFS.apply", Ini.TraceBlobFS);
        }
    }

    private void addRollback(String blobPoint) {
        if (Strings.isVoid(blobPoint)) {
            return;
        }
        if (this.rollbacks == null) {
            this.rollbacks = new ArrayList();
        }
        this.rollbacks.add(blobPoint);
    }

    private void addCommit(String blobPoint) {
        if (Strings.isVoid(blobPoint)) {
            return;
        }
        if (this.commits == null) {
            this.commits = new ArrayList();
        }
        this.commits.add(blobPoint);
    }

    private static int whatAPath(String[] path) {
        if (path == null || path.length == 0) {
            return 0;
        }
        String s = path[0];
        if (Strings.isVoid(s)) {
            return 0;
        }
        if (Character.isJavaIdentifierStart(s.charAt(0))) {
            if (s.equalsIgnoreCase("temp")) {
                return 1;
            }
            return 2;
        }
        if (path.length < 3) {
            return 1;
        }
        s = path[1];
        if (Character.isJavaIdentifierStart(s.charAt(0))) {
            return 4;
        }
        if (path.length < 4) {
            return 1;
        }
        s = path[2];
        if (Character.isJavaIdentifierStart(s.charAt(0))) {
            return 8;
        }
        return 1;
    }

    private static boolean isHashingPath(String path) {
        if (Strings.isVoid(path)) {
            return false;
        }
        return (BFS.whatAPath(path.split("/")) & 0xE) != 0;
    }

    private static void getBlobPath(StringBuilder path, double tableId, FieldDescriptor field, double recordId, String digestText) {
        if (digestText != null && digestText.length() > 4) {
            path.append(NumberConverter.doubleToString(tableId)).append('/').append(field.getId());
            switch (field.getBlobFSType()) {
                case 1: {
                    path.append("/sha1/");
                    break;
                }
                default: {
                    path.append("/unknown/");
                }
            }
            path.append(digestText, 0, 1).append('/').append(digestText, 1, 3);
        } else {
            int hashIndex = Hashing.hash(recordId) % 809;
            path.append(NumberConverter.doubleToString(tableId)).append('/').append(field.getId()).append('/').append(hashIndex);
        }
    }

    private static String getBlobFileName(double recordId, String digestText) {
        if (digestText == null) {
            return NumberConverter.doubleToString(recordId);
        }
        return digestText;
    }

    public static String getFullTempPath(TableDescriptor table, FieldDescriptor field, byte[] digest) {
        String name = BinFileName.binToString(digest);
        StringBuilder path = new StringBuilder();
        path.append("temp");
        String mountPoint = field.getBlobFS();
        File file = new File(Core.blobfs.resolvePath(mountPoint + ":/" + path));
        BFS.createFolders(file, mountPoint);
        path.append('/').append(name);
        return path.toString();
    }

    public static String digestToBlobPath(TableDescriptor table, FieldDescriptor field, byte[] digest) {
        String blobPoint = Strings.bytes2hex(digest);
        StringBuilder blobPointBuilder = new StringBuilder();
        BFS.getBlobPath(blobPointBuilder, table.getNodeId(), field, 0.0, blobPoint);
        blobPointBuilder.append('/').append(blobPoint).append(BFS_EXT);
        return blobPointBuilder.toString();
    }

    public static boolean isStorageContainsHashedBlob(ServerSideHost host, TableDescriptor table, FieldDescriptor field, byte[] digest) throws IOException {
        if (!field.isHashedBlobFs()) {
            return false;
        }
        String blobPoint = Strings.bytes2hex(digest);
        StringBuilder blobPointBuilder = new StringBuilder();
        BFS.getBlobPath(blobPointBuilder, table.getNodeId(), field, 0.0, blobPoint);
        String mountPoint = field.getBlobFS() + ":/" + blobPointBuilder;
        String filePath = Core.blobfs.resolvePath(mountPoint);
        File path = new File(filePath);
        File file = new File(path, blobPoint + BFS_EXT);
        if (!file.exists()) {
            return false;
        }
        try (RandomAccessFile stream = new RandomAccessFile(file, "r");){
            byte[] existingDigest = BFS.getDigest(host, stream);
            if (!Arrays.equals(digest, existingDigest)) {
                throw new BFSException("\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0430 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c \u0431\u043b\u043e\u0431-\u0444\u0430\u0439\u043b\u0430 \u0432 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435", filePath).detail(mountPoint);
            }
        }
        return true;
    }

    public static byte[] setTempBlob(ServerSideHost host, TableDescriptor table, FieldDescriptor field, byte[] content, int size) throws IOException {
        File file;
        MessageDigest md;
        if (content == null) {
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw InformException.wrap(e);
        }
        md.reset();
        md.update(content, 0, size);
        byte[] digest = md.digest();
        if (host != null) {
            host.idle();
        }
        if (BFS.isStorageContainsHashedBlob(host, table, field, digest)) {
            return digest;
        }
        String blobPath = field.getBlobFS() + ":/" + BFS.getFullTempPath(table, field, digest);
        String filePath = Core.blobfs.resolvePath(blobPath);
        if (field.isHashedBlobFs() && (file = new File(filePath)).exists()) {
            try (RandomAccessFile stream = new RandomAccessFile(file, "r");){
                byte[] existingDigest = BFS.getDigest(host, stream);
                if (Arrays.equals(digest, existingDigest)) {
                    byte[] byArray = digest;
                    return byArray;
                }
                Core.logger.warn("[BFS]\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0430 \u0446\u0435\u043b\u043e\u0441\u0442\u043d\u043e\u0441\u0442\u044c \u0431\u043b\u043e\u0431-\u0444\u0430\u0439\u043b\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u043c \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435: " + blobPath);
            }
        }
        try (RandomAccessFile stream = new RandomAccessFile(filePath, "rw");){
            if (host != null) {
                host.idle();
            }
            stream.write(content, 0, size);
            if (host != null) {
                host.idle();
            }
            if (stream.length() != (long)size) {
                if (host != null) {
                    host.idle();
                }
                Core.logger.warn("[BFS]\u041d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0444\u0430\u0439\u043b\u0430(" + stream.length() + ") \u0438 \u0434\u0430\u043d\u043d\u044b\u0445(" + size + ") \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0431\u043b\u043e\u0431-\u0444\u0430\u0439\u043b\u0430 " + blobPath);
                stream.setLength(size);
                if (host != null) {
                    host.idle();
                }
            }
        }
        return digest;
    }

    public static byte[] uploadBlobDigest(ServerSideHost host, RandomAccessFile content) throws IOException {
        MessageDigest md;
        if (content == null) {
            return null;
        }
        content.seek(0L);
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw InformException.wrap(e);
        }
        md.reset();
        byte[] chunk = new byte[0x100000];
        while (true) {
            int size;
            if (host != null) {
                host.idle();
            }
            if ((size = content.read(chunk)) < 0) break;
            if (size == 0) continue;
            md.update(chunk, 0, size);
        }
        return md.digest();
    }

    public static String uploadHashedBlob(ServerSideHost host, TableDescriptor table, FieldDescriptor field, byte[] digest, RandomAccessFile content) throws IOException {
        if (!field.isHashedBlobFs()) {
            return null;
        }
        String blobPoint = Strings.bytes2hex(digest);
        StringBuilder blobPointBuilder = new StringBuilder();
        BFS.getBlobPath(blobPointBuilder, table.getNodeId(), field, 0.0, blobPoint);
        String mountPoint = field.getBlobFS();
        File path = new File(Core.blobfs.resolvePath(mountPoint + ":/" + blobPointBuilder));
        File file = new File(path, blobPoint + BFS_EXT);
        if (!file.exists()) {
            BFS.createFolders(path, mountPoint);
            content.seek(0L);
            try (RandomAccessFile stream = new RandomAccessFile(file.getAbsolutePath(), "rw");){
                byte[] chunk = new byte[0x100000];
                stream.setLength(content.length());
                while (true) {
                    int size;
                    if (host != null) {
                        host.idle();
                    }
                    if ((size = content.read(chunk)) < 0) break;
                    if (size == 0) continue;
                    stream.write(chunk, 0, size);
                }
                if (host != null) {
                    host.idle();
                }
            }
        }
        blobPointBuilder.append('/').append(blobPoint).append(BFS_EXT);
        return blobPointBuilder.toString();
    }

    public static void uploadTempBlob(ServerSideHost host, TableDescriptor table, FieldDescriptor field, byte[] digest, RandomAccessFile content) throws IOException {
        content.seek(0L);
        if (host != null) {
            host.idle();
        }
        String blobPath = field.getBlobFS() + ":/" + BFS.getFullTempPath(table, field, digest);
        String filePath = Core.blobfs.resolvePath(blobPath);
        try (RandomAccessFile stream = new RandomAccessFile(filePath, "rw");){
            byte[] chunk = new byte[0x100000];
            stream.setLength(content.length());
            while (true) {
                int size;
                if (host != null) {
                    host.idle();
                }
                if ((size = content.read(chunk)) < 0) break;
                if (size == 0) continue;
                stream.write(chunk, 0, size);
            }
            if (host != null) {
                host.idle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] moveFile(ServerSideHost host, TableDescriptor table, FieldDescriptor field, String filePath) throws IOException {
        String blobPath;
        File file2;
        byte[] digest;
        File file = Core.mountfs.resolve(new File(filePath));
        try (RandomAccessFile content = new RandomAccessFile(file, "r");){
            digest = BFS.getDigest(host, content);
        }
        if (host != null) {
            host.idle();
        }
        if (!file.renameTo(file2 = Core.blobfs.resolve(new File(blobPath = field.getBlobFS() + ":/" + BFS.getFullTempPath(table, field, digest))))) {
            throw new InformException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u0444\u0430\u0439\u043b \"" + file.getPath() + "\" \u0432 \"" + file2.getPath() + "\"");
        }
        return digest;
    }

    public static byte[] getDigest(ServerSideHost host, RandomAccessFile content) throws IOException {
        MessageDigest md;
        if (content == null) {
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw InformException.wrap(e);
        }
        md.reset();
        byte[] chunk = new byte[0x100000];
        while (true) {
            int size;
            if (host != null) {
                host.idle();
            }
            if ((size = content.read(chunk)) < 0) break;
            if (size == 0) continue;
            md.update(chunk, 0, size);
        }
        return md.digest();
    }

    private static String createBlob(String mountPoint, double tableId, FieldDescriptor field, double recordId, byte[] content) throws IOException {
        MessageDigest md;
        if (content == null) {
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw InformException.wrap(e);
        }
        byte[] digest = md.digest(content);
        String digestText = field.isHashedBlobFs() ? Strings.bytes2hex(digest) : null;
        String name = BFS.getBlobFileName(recordId, digestText);
        StringBuilder blobPointBuilder = new StringBuilder();
        BFS.getBlobPath(blobPointBuilder, tableId, field, recordId, digestText);
        File path = new File(Core.blobfs.resolvePath(mountPoint + ":/" + blobPointBuilder));
        BFS.createFolders(path, mountPoint);
        Object blobPoint = name;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            File file = new File(path, (String)blobPoint + BFS_EXT);
            if (!file.exists()) {
                try (FileOutputStream stream = new FileOutputStream(file);){
                    stream.write(content);
                    stream.flush();
                }
                blobPointBuilder.append('/').append((String)blobPoint).append(BFS_EXT);
                return blobPointBuilder.toString();
            }
            if (field.isHashedBlobFs()) {
                blobPointBuilder.append('/').append((String)blobPoint).append(BFS_EXT);
                return blobPointBuilder.toString();
            }
            blobPoint = name + "_" + i;
        }
        return null;
    }

    private static void enumerateFiles(String blobPoint, String blobPath, HashMap<String, FileUse> files) {
        File blobfs = new File(Core.blobfs.resolvePath(blobPoint + ":/" + blobPath));
        if (!blobfs.exists() || !blobfs.isDirectory()) {
            return;
        }
        BFS.enumerateFolderFiles(blobfs, blobPath, files);
    }

    private static void enumerateFolderFiles(File folder, String folderName, HashMap<String, FileUse> files) {
        String[] children = folder.list();
        if (children == null) {
            return;
        }
        for (String childName : children) {
            File child = new File(folder, childName);
            if (!child.exists()) continue;
            if (child.isDirectory()) {
                BFS.enumerateFolderFiles(child, folderName + "/" + childName, files);
                continue;
            }
            if (!child.isFile()) continue;
            files.put(folderName + "/" + childName, new FileUse(child));
        }
    }

    public static boolean cleanupFile(File file, long obsoleteInterval) {
        if (!file.exists()) {
            return false;
        }
        long lifeTime = System.currentTimeMillis() - file.lastModified();
        if (lifeTime > obsoleteInterval) {
            return file.setWritable(true) && file.delete();
        }
        return false;
    }

    public static void cleanupTemp(ServerSideHost host) {
        String[] mountPoints;
        for (String mountPoint : mountPoints = Core.blobfs.getMountNames()) {
            String[] files;
            String blobfs;
            File tempFolder;
            if (host != null) {
                host.idle();
            }
            if (!(tempFolder = new File(blobfs = Core.blobfs.resolvePath(mountPoint + ":/temp"))).exists() || !tempFolder.isDirectory() || (files = tempFolder.list()) == null) continue;
            for (String name : files) {
                File file;
                String ext;
                int extIndex;
                if (host != null) {
                    host.idle();
                }
                if ((extIndex = name.lastIndexOf(46)) >= 0 && !(ext = name.substring(extIndex)).equalsIgnoreCase(BFS_EXT) || !(file = new File(tempFolder, name)).isFile()) continue;
                if (extIndex < 0) {
                    BFS.cleanupFile(file, 86400000L);
                    continue;
                }
                BFS.cleanupFile(file, 259200000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(SSContext ssContext, DatabaseConnection connection, TableDescriptor table, String fsName, ArrayList<FieldDescriptor> fields, boolean cleanup, boolean checkSum, boolean delWaste, boolean clearRefs, ServerSideHost host) throws Throwable {
        Idler idler = new Idler(host);
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select");
        char comma = ' ';
        FieldDescriptor pk = table.getRecordIdField();
        sql.append(comma).append(pk);
        comma = ',';
        for (FieldDescriptor field : fields) {
            sql.append(comma).append(field);
            if (!checkSum || field.isHashedBlobFs()) continue;
            checkSum = false;
        }
        sql.append(" from ").appendFull(table);
        ArrayList<FileRec> requiredFiles = new ArrayList<FileRec>();
        idler.text("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u043e\u0432");
        try (PreparedStatement statement = connection.prepareStatement("BFS.cleanup", sql.toString());
             ResultSet fetch = statement.executeQuery(ssContext);){
            while (fetch.next()) {
                idler.process();
                double recID = fetch.getDouble(1);
                for (int i = 1; i <= fields.size(); ++i) {
                    String blobPoint = fetch.getString(i + 1);
                    if (fetch.wasNull() || Strings.isVoid(blobPoint)) continue;
                    requiredFiles.add(new FileRec(blobPoint, recID, fields.get(i - 1).getId()));
                }
            }
        }
        String blobPath = NumberConverter.doubleToString(table.getNodeId());
        HashMap<String, FileUse> existingFiles = new HashMap<String, FileUse>();
        for (FieldDescriptor field : fields) {
            BFS.enumerateFiles(fsName, blobPath + "/" + field.getId(), existingFiles);
        }
        ArrayList<Integer> absent = new ArrayList<Integer>();
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (int i = 0; i < requiredFiles.size(); ++i) {
            FileRec fileRec = (FileRec)requiredFiles.get(i);
            String fileName = fileRec.fileName;
            FileUse fileUse = existingFiles.get(fileName);
            if (fileUse != null) {
                ++fileUse.useCount;
                continue;
            }
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                out.add(i);
                continue;
            }
            absent.add(i);
        }
        idler.text("\u041f\u043e\u0438\u0441\u043a \u0438\u0437\u0431\u044b\u0442\u043e\u0447\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432");
        ArrayList<String> waste = new ArrayList<String>();
        long usefulSize = 0L;
        int usefulCount = 0;
        long wasteSize = 0L;
        for (Map.Entry<String, FileUse> entry : existingFiles.entrySet()) {
            FileUse fileUse = entry.getValue();
            long fileSize = fileUse.file.length();
            if (fileUse.useCount > 0) {
                usefulSize += fileSize;
                ++usefulCount;
                continue;
            }
            waste.add(entry.getKey());
            wasteSize += fileSize;
        }
        ArrayList<Integer> checkSumErr = new ArrayList<Integer>();
        if (!cleanup && checkSum) {
            MessageDigest md;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw InformException.wrap(e);
            }
            idler.progressRange("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u044b\u0445 \u0441\u0443\u043c\u043c", 0, requiredFiles.size());
            for (int i = 0; i < requiredFiles.size(); ++i) {
                idler.progress(i);
                FileRec fileRec = (FileRec)requiredFiles.get(i);
                String fileName = fileRec.fileName;
                FileUse fileUse = existingFiles.get(fileName);
                if (fileUse == null || fileUse.useCount == 0) continue;
                try (RandomAccessFile file = new RandomAccessFile(fileUse.file, "r");){
                    int size;
                    md.reset();
                    byte[] chunk = new byte[0x100000];
                    while ((size = file.read(chunk)) >= 0) {
                        if (size == 0) continue;
                        md.update(chunk, 0, size);
                        idler.process();
                    }
                    byte[] uploadedDigest = md.digest();
                    String digestText = Strings.bytes2hex(uploadedDigest);
                    if (digestText.length() != 0 && fileName.contains(digestText)) continue;
                    checkSumErr.add(i);
                    continue;
                }
            }
        }
        ArrayList<String> deleted = new ArrayList<String>();
        long cleanupSize = 0L;
        if (cleanup && delWaste && !waste.isEmpty()) {
            idler.text("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0438\u0437\u0431\u044b\u0442\u043e\u0447\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432");
            for (String string : waste) {
                FileUse fileUse = existingFiles.get(string);
                long fileSize = fileUse.file.length();
                fileUse.file.setWritable(true);
                if (fileUse.file.delete()) {
                    cleanupSize += fileSize;
                    deleted.add(string);
                }
                idler.process();
            }
        }
        ArrayList clearedRefs = new ArrayList();
        if (cleanup && clearRefs && !absent.isEmpty()) {
            for (FieldDescriptor field : fields) {
                idler.progressRange("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0441\u0441\u044b\u043b\u043e\u043a \u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0444\u0430\u0439\u043b\u044b (\u043f\u043e\u043b\u0435 " + field.getCaption() + ")", 0, absent.size());
                ArrayList<Double> ids = new ArrayList<Double>();
                ArrayList<Integer> tmpCleared = new ArrayList<Integer>();
                for (int j = 0; j < absent.size(); ++j) {
                    idler.progress(j);
                    FileRec fileRec = (FileRec)requiredFiles.get((Integer)absent.get(j));
                    if (fileRec.fieldID != field.getId()) continue;
                    ids.add(fileRec.recordID);
                    tmpCleared.add(j);
                }
                if (ids.isEmpty() || !BFS.clearFileRefs(host, table, field, ids)) continue;
                clearedRefs.addAll(tmpCleared);
            }
        }
        idler.text("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0430\u0439\u043b\u043e\u0432\u043e\u0433\u043e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        String tab = "   ";
        String tab2 = tab + tab;
        int errCount = waste.size() + out.size() + absent.size() + checkSumErr.size();
        host.putRequestStateLog("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0430\u0439\u043b\u043e\u0432\u043e\u0433\u043e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430 \"" + fsName + "\"");
        arrayList.add((CallSite)((Object)(tab + "\u041a\u043e\u043b-\u0432\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432: " + usefulCount + " \u0448\u0442. (\u0440\u0430\u0437\u043c\u0435\u0440 " + usefulSize + " \u0431\u0430\u0439\u0442)")));
        host.putRequestStateLog((String)arrayList.get(arrayList.size() - 1));
        if (errCount > 0) {
            FileRec fileRec;
            int i;
            int count;
            String s;
            String pfx = Core.blobfs.resolvePath(fsName + ":/").replaceAll("\\\\|//", "/");
            if (!waste.isEmpty()) {
                s = tab + "\u041a\u043e\u043b-\u0432\u043e \u0438\u0437\u0431\u044b\u0442\u043e\u0447\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432: " + waste.size() + " \u0448\u0442. (\u0440\u0430\u0437\u043c\u0435\u0440 " + wasteSize + " \u0431\u0430\u0439\u0442)";
                host.putRequestStateLog(s);
                arrayList.add((CallSite)((Object)s));
                count = waste.size() <= 100000 ? waste.size() : 100000;
                for (i = 0; i < count; ++i) {
                    host.putRequestStateLog(tab2 + pfx + (String)waste.get(i));
                }
                if (count < waste.size()) {
                    host.putRequestStateLog(tab2 + "...");
                }
                idler.process();
            }
            if (!out.isEmpty()) {
                s = tab + "\u041a\u043e\u043b-\u0432\u043e \u0444\u0430\u0439\u043b\u043e\u0432 \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0445 \u0432\u043d\u0435 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430: " + out.size() + " \u0448\u0442.";
                host.putRequestStateLog(s);
                arrayList.add((CallSite)((Object)s));
                count = out.size() <= 100000 ? out.size() : 100000;
                for (i = 0; i < count; ++i) {
                    fileRec = (FileRec)requiredFiles.get((Integer)out.get(i));
                    host.putRequestStateLog(tab2 + pfx + fileRec.fileName + " (\u0437\u0430\u043f\u0438\u0441\u044c " + NumberConverter.doubleToString(fileRec.recordID) + ")");
                }
                if (count < out.size()) {
                    host.putRequestStateLog(tab2 + "...");
                }
                idler.process();
            }
            if (!absent.isEmpty()) {
                s = tab + "\u041a\u043e\u043b-\u0432\u043e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u0444\u0430\u0439\u043b\u043e\u0432: " + absent.size() + " \u0448\u0442.";
                host.putRequestStateLog(s);
                arrayList.add((CallSite)((Object)s));
                count = absent.size() <= 100000 ? absent.size() : 100000;
                for (i = 0; i < count; ++i) {
                    fileRec = (FileRec)requiredFiles.get((Integer)absent.get(i));
                    host.putRequestStateLog(tab2 + pfx + fileRec.fileName + " (\u0437\u0430\u043f\u0438\u0441\u044c " + NumberConverter.doubleToString(fileRec.recordID) + ")");
                }
                if (count < absent.size()) {
                    host.putRequestStateLog(tab2 + "...");
                }
                idler.process();
            }
            if (!checkSumErr.isEmpty()) {
                s = tab + "\u041a\u043e\u043b-\u0432\u043e \u0444\u0430\u0439\u043b\u043e\u0432 c \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0439 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0441\u0443\u043c\u043c\u043e\u0439: " + checkSumErr.size() + " \u0448\u0442.";
                host.putRequestStateLog(s);
                arrayList.add((CallSite)((Object)s));
                count = checkSumErr.size() <= 100000 ? checkSumErr.size() : 100000;
                for (i = 0; i < count; ++i) {
                    fileRec = (FileRec)requiredFiles.get((Integer)checkSumErr.get(i));
                    host.putRequestStateLog(tab2 + pfx + fileRec.fileName + " (\u0437\u0430\u043f\u0438\u0441\u044c " + NumberConverter.doubleToString(fileRec.recordID) + ")");
                }
                if (count < checkSumErr.size()) {
                    host.putRequestStateLog(tab2 + "...");
                }
                idler.process();
            }
            if (!deleted.isEmpty()) {
                s = tab + "\u041a\u043e\u043b-\u0432\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432: " + deleted.size() + " \u0448\u0442. (\u0440\u0430\u0437\u043c\u0435\u0440 " + cleanupSize + " \u0431\u0430\u0439\u0442)";
                host.putRequestStateLog(s);
                arrayList.add((CallSite)((Object)s));
                count = deleted.size() <= 100000 ? deleted.size() : 100000;
                for (i = 0; i < count; ++i) {
                    host.putRequestStateLog(tab2 + pfx + (String)deleted.get(i));
                }
                if (count < deleted.size()) {
                    host.putRequestStateLog(tab2 + "...");
                }
                idler.process();
            }
            if (!clearedRefs.isEmpty()) {
                s = tab + "\u041a\u043e\u043b-\u0432\u043e \u043e\u0447\u0438\u0449\u0435\u043d\u043d\u044b\u0445 \u0441\u0441\u044b\u043b\u043e\u043a \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u0444\u0430\u0439\u043b\u043e\u0432: " + clearedRefs.size() + " \u0448\u0442.";
                host.putRequestStateLog(s);
                arrayList.add((CallSite)((Object)s));
                count = clearedRefs.size() <= 100000 ? clearedRefs.size() : 100000;
                for (i = 0; i < count; ++i) {
                    fileRec = (FileRec)requiredFiles.get((Integer)clearedRefs.get(i));
                    host.putRequestStateLog(tab2 + pfx + fileRec.fileName + " (\u0437\u0430\u043f\u0438\u0441\u044c " + NumberConverter.doubleToString(fileRec.recordID) + ")");
                }
                if (count < clearedRefs.size()) {
                    host.putRequestStateLog(tab2 + "...");
                }
                idler.process();
            }
            host.putRequestStateLog("");
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                host.putRequestStateLog((String)arrayList.get(i2));
                idler.process();
            }
        } else {
            host.putRequestStateLog(tab + "\u041e\u0448\u0438\u0431\u043e\u043a \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean clearFileRefs(ServerSideHost ssHost, TableDescriptor tDesc, FieldDescriptor fDesc, ArrayList<Double> ids) throws Throwable {
        if (ids.isEmpty()) {
            return false;
        }
        String tName = tDesc.getRawName();
        if (tName == null) {
            return false;
        }
        FieldDescriptor pkDesc = tDesc.getRecordIdField();
        if (pkDesc == null || fDesc == null) {
            return false;
        }
        DatabaseDescriptor dbDesc = tDesc.getDatabaseDescriptor();
        try (DatabaseConnection conn = dbDesc.connect(ssHost, "rq:BlobFSDiagnostics");){
            TableDataAudit audit = new TableDataAudit(ssHost.getSSContext(), conn, ssHost.getUserID(), ssHost.getEffectiveUserID(), 0.0, 0.0, ssHost.getSessionID());
            audit.setBatchMode(true);
            StringBuilder SetStr = new StringBuilder();
            SetStr.append(fDesc.getRawName()).append("=");
            SetStr.append("NULL");
            StringBuilder WhereStr = new StringBuilder();
            WhereStr.append(pkDesc.getRawName());
            StringBuilder InStr = new StringBuilder();
            int counter = 0;
            int count = ids.size();
            for (Double recID : ids) {
                if (InStr.length() > 0) {
                    InStr.append(",");
                }
                InStr.append(recID);
                audit.registrateModification(tDesc, recID, AuditModification.MODIFY);
                if (++counter % 1000 != 0 && counter != count) continue;
                String sql = String.format("UPDATE %s.%s SET %s WHERE %s IN (%s)", dbDesc.getScheme(), tName, SetStr, WhereStr, InStr);
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.execute(ssHost.getSSContext());
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (Throwable e) {
                        Core.logger.error(null, e);
                    }
                }
                audit.flush();
                conn.commit();
                InStr.setLength(0);
            }
        }
        return true;
    }

    public static void deleteFileSilent(File file, String prefix, boolean log) {
        if (!file.exists()) {
            return;
        }
        if (!file.setWritable(true)) {
            Core.logger.error("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b \"" + file.getName() + "\"");
            return;
        }
        if (!file.delete()) {
            Core.logger.error("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b \"" + file.getName() + "\"");
        }
        if (log) {
            Core.logger.info("{}: delete {}", (Object)prefix, (Object)file.getPath());
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.setWritable(true)) {
            throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b \"" + file.getName() + "\"");
        }
        if (!file.delete()) {
            throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b \"" + file.getName() + "\"");
        }
    }

    public static class FileUse {
        final File file;
        int useCount = 0;

        public FileUse(File file) {
            this.file = file;
        }
    }

    public static class FileRec {
        final String fileName;
        final double recordID;
        final int fieldID;

        public FileRec(String fileName, double recordID, int fieldID) {
            this.fileName = fileName;
            this.recordID = recordID;
            this.fieldID = fieldID;
        }
    }

    public static class BlobRef {
        public final String ref;

        public BlobRef(String ref) {
            this.ref = ref;
        }
    }

    public static class BlobDigest {
        public final byte[] digest;

        public BlobDigest(byte[] digest) {
            this.digest = digest;
        }
    }

    public static class Replica {
        public final DoubleHash<ReplicationBlobFileTable> tables = new DoubleHash();

        public ReplicationBlobFile getFile(TableDescriptor tableInfo, int fieldId, double recordId) {
            ReplicationBlobFileTable table = this.tables.get(tableInfo.getNodeId());
            if (table != null) {
                for (ReplicationBlobFileRecords field : table.fields) {
                    if (field.field.getId() != fieldId) continue;
                    return field.records.get(recordId);
                }
            }
            return null;
        }

        public void commit() {
            for (ReplicationBlobFileTable table : this.tables) {
                for (ReplicationBlobFileRecords field : table.fields) {
                    for (ReplicationBlobFile file : field.records) {
                        try {
                            file.close();
                        }
                        catch (Throwable e) {
                            Core.logger.error(null, e);
                        }
                    }
                }
            }
        }

        public void rollback() {
            for (ReplicationBlobFileTable table : this.tables) {
                for (ReplicationBlobFileRecords field : table.fields) {
                    for (ReplicationBlobFile file : field.records) {
                        try {
                            file.rollback();
                        }
                        catch (Throwable e) {
                            Core.logger.error(null, e);
                        }
                    }
                }
            }
        }

        public ReplicationBlobFile addFile(TableDescriptor tableInfo, int fieldId, double recordId) throws NoSuchAlgorithmException {
            ReplicationBlobFile rbf;
            ReplicationBlobFileTable table = this.tables.get(tableInfo.getNodeId());
            if (table == null) {
                table = new ReplicationBlobFileTable(tableInfo);
                this.tables.add(table);
            }
            ReplicationBlobFileRecords field = null;
            for (ReplicationBlobFileRecords f : table.fields) {
                if (f.field.getId() != fieldId) continue;
                field = f;
                break;
            }
            if (field == null) {
                field = new ReplicationBlobFileRecords(tableInfo.getExistingFieldDescriptor(fieldId));
                table.fields.add(field);
            }
            if ((rbf = field.records.get(recordId)) != null) {
                throw new IllegalStateException();
            }
            rbf = new ReplicationBlobFile(tableInfo, tableInfo.getExistingFieldDescriptor(fieldId), recordId);
            field.records.add(rbf);
            return rbf;
        }
    }

    public static class ReplicationBlobFileTable
    implements DoubleHash.Entry {
        public final TableDescriptor table;
        public final ArrayList<ReplicationBlobFileRecords> fields = new ArrayList();

        public ReplicationBlobFileTable(TableDescriptor table) {
            this.table = table;
        }

        @Override
        public double key() {
            return this.table.getNodeId();
        }
    }

    public static class ReplicationBlobFileRecords {
        public final FieldDescriptor field;
        public final DoubleHash<ReplicationBlobFile> records = new DoubleHash();

        public ReplicationBlobFileRecords(FieldDescriptor field) {
            this.field = field;
        }
    }

    public static class ReplicationBlobFile
    implements DoubleHash.Entry {
        final TableDescriptor table;
        final FieldDescriptor field;
        final double recordId;
        File tempFile;
        String uploadedPoint = null;
        RandomAccessFile uploadedFile;
        final MessageDigest md;
        public byte[] digest = null;

        public ReplicationBlobFile(TableDescriptor table, FieldDescriptor field, double recordId) throws NoSuchAlgorithmException {
            this.field = field;
            this.table = table;
            this.recordId = recordId;
            this.md = MessageDigest.getInstance("SHA-1");
        }

        public String logInfo() {
            StringBuilder msg = new StringBuilder();
            msg.append("\u0422\u0430\u0431\u043b\u0438\u0446\u0430: ").append(this.table.toString()).append(" \u041f\u043e\u043b\u0435: ");
            this.field.toLogString(msg);
            msg.append(" \u0417\u0430\u043f\u0438\u0441\u044c: ").append(NumberConverter.doubleToString(this.recordId));
            return msg.toString();
        }

        private static boolean createTempBlobFile(File file) {
            try {
                return file.createNewFile();
            }
            catch (Exception e) {
                throw InformException.wrap(e, "createTempBlobFile: " + file.getAbsolutePath());
            }
        }

        public void writeFile(byte[] chunk) throws IOException {
            if (this.uploadedFile == null) {
                BFS.checkBlobFSField(this.table, this.field);
                String mountPoint = this.field.getBlobFS();
                String temp = Core.blobfs.resolvePath(mountPoint + ":/temp/");
                File tempFilePath = new File(temp);
                BFS.createFolders(tempFilePath, mountPoint);
                String middle = NumberConverter.doubleToString(this.table.getNodeId()) + "_" + this.field.getId() + "-" + NumberConverter.doubleToString(this.recordId) + "_";
                String prefix = temp + middle;
                for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                    String tempPath = prefix + i + BFS.BFS_EXT;
                    this.tempFile = new File(tempPath);
                    Core.logger.info("ReplicationBlobFile: try create {}", (Object)tempPath);
                    if (!ReplicationBlobFile.createTempBlobFile(this.tempFile)) continue;
                    this.uploadedFile = new RandomAccessFile(this.tempFile, "rw");
                    break;
                }
            }
            this.uploadedFile.write(chunk);
            this.md.update(chunk, 0, chunk.length);
        }

        public void endWrite() throws IOException {
            this.uploadedFile.setLength(this.uploadedFile.getFilePointer());
            this.digest = this.md.digest();
            Core.logger.info("ReplicationBlobFile: write {}", (Object)this.tempFile.getPath());
        }

        public String fixate(SSContext ssContext, ServerSideHost host, DatabaseConnection databaseConnection, BFS bfs, boolean modify) throws IOException, SQLException {
            if (this.uploadedFile == null || this.tempFile == null) {
                return null;
            }
            String digestText = this.field.isHashedBlobFs() ? Strings.bytes2hex(this.digest) : null;
            this.uploadedPoint = bfs.replicate(ssContext, host, databaseConnection, modify, this.recordId, this.table, this.field, this.tempFile, this.uploadedFile, digestText);
            Core.logger.info("ReplicationBlobFile: move {} to {}", (Object)this.tempFile.getPath(), (Object)this.uploadedPoint);
            this.uploadedFile.close();
            this.uploadedFile = null;
            BFS.deleteFileSilent(this.tempFile, "ReplicationBlobFile.fixate", Ini.TraceBlobFS);
            this.tempFile = null;
            return this.uploadedPoint;
        }

        public void rollback() throws IOException {
            if (this.uploadedFile == null) {
                if (this.tempFile != null) {
                    BFS.deleteFileSilent(this.tempFile, "ReplicationBlobFile.rollback n1", Ini.TraceBlobFS);
                }
                this.tempFile = null;
                return;
            }
            try {
                this.uploadedFile.close();
                this.uploadedFile = null;
            }
            finally {
                if (this.tempFile != null) {
                    BFS.deleteFileSilent(this.tempFile, "ReplicationBlobFile.rollback n2", Ini.TraceBlobFS);
                }
                this.tempFile = null;
                if (!Strings.isVoid(this.uploadedPoint) && !BFS.isHashingPath(this.uploadedPoint)) {
                    String bfs_path = this.field.getBlobFS() + ":/" + this.uploadedPoint;
                    File file = new File(Core.blobfs.resolvePath(bfs_path));
                    BFS.deleteFileSilent(file, "ReplicationBlobFile.rollback n3", Ini.TraceBlobFS);
                }
                this.uploadedPoint = null;
            }
        }

        public void close() throws IOException {
            if (this.uploadedFile == null) {
                if (this.tempFile != null) {
                    BFS.deleteFileSilent(this.tempFile, "ReplicationBlobFile.close n1", Ini.TraceBlobFS);
                }
                this.tempFile = null;
                return;
            }
            try {
                this.uploadedFile.close();
                this.uploadedFile = null;
            }
            finally {
                if (this.tempFile != null) {
                    BFS.deleteFileSilent(this.tempFile, "ReplicationBlobFile.close n2", Ini.TraceBlobFS);
                }
                this.tempFile = null;
                this.uploadedPoint = null;
            }
        }

        @Override
        public double key() {
            return this.recordId;
        }
    }

    private static class Idler {
        static final int TIMEOUT = 500;
        final ServerSideHost host;
        long checkTime = 0L;

        Idler(ServerSideHost host) {
            this.host = host;
        }

        void process(boolean force) {
            if (this.host != null) {
                long time = System.currentTimeMillis();
                if (this.checkTime == 0L || force || time - this.checkTime >= 500L) {
                    this.checkTime = time;
                    this.host.idle();
                }
            }
        }

        void process() {
            this.process(false);
        }

        void text(String text) throws Exception {
            if (this.host != null) {
                this.host.putRequestStateText(text);
                this.host.putRequestStateProgressMin(0);
                this.host.putRequestStateProgressMax(0);
                this.process(true);
            }
        }

        void progressRange(String text, int min, int max) throws Exception {
            if (this.host != null) {
                this.host.putRequestStateText(text);
                this.host.putRequestStateProgressMin(min);
                this.host.putRequestStateProgressMax(max);
                this.process(true);
            }
        }

        void progress(int value) throws Exception {
            if (this.host != null) {
                this.host.putRequestStateProgressPosition(value);
                this.process(false);
            }
        }
    }

    public static class BFSException
    extends InformException {
        private final String fullPath;

        public BFSException(String message, String fullPath) {
            super(message);
            this.fullPath = fullPath;
        }

        @Override
        public String toString() {
            if (Strings.isVoid(this.fullPath)) {
                return super.toString();
            }
            return super.toString() + "\n\u041f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443: " + this.fullPath + "\n";
        }
    }
}

